/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.executepicklist;

import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.cpp.executepicklist.ExecuteElementPanel;
import org.netbeans.modules.cpp.execution.BinaryExecSupport;
import org.netbeans.modules.cpp.makewizard.MakefileWizard;
import org.netbeans.modules.cpp.makewizard.MakefileWizardEvent;
import org.netbeans.modules.cpp.makewizard.MakefileWizardListener;
import org.netbeans.modules.cpp.picklist.ElementChangeEvent;
import org.netbeans.modules.cpp.picklist.PicklistUtils;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.netbeans.modules.cpp.utils.IpeUtils;
import org.openide.loaders.DataNode;
import org.openide.loaders.ExecutionSupport;
import org.openide.util.NbBundle;

public class ExecuteActionElementPanel
extends ExecuteElementPanel
implements MakefileWizardListener {
    private DataNode foundExecutable = null;
    private ResourceBundle bundle;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$executepicklist$ExecuteActionElementPanel;

    public ExecuteActionElementPanel() {
        MakefileWizard.addMakefileWizardListener(this);
    }

    public void validate() {
        String executablePath = this.getExecutable();
        if (executablePath == null || executablePath.length() == 0) {
            this.fireChanged(new ElementChangeEvent(this, 5));
            this.fireChanged(new ElementChangeEvent(this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundExecutable = null;
            return;
        }
        File executableFile = new File(executablePath);
        if (!executableFile.exists()) {
            this.fireChanged(new ElementChangeEvent(this, 4, this.getString("ERROR_DONTEXIST")));
            this.fireChanged(new ElementChangeEvent(this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundExecutable = null;
            return;
        }
        if (executableFile.isDirectory()) {
            this.fireChanged(new ElementChangeEvent(this, 4, this.getString("ERROR_NOTAEXEFILE")));
            this.fireChanged(new ElementChangeEvent(this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundExecutable = null;
            return;
        }
        DataNode executableNode = PicklistUtils.findExecutableNode(executablePath);
        this.initPanel(executableNode);
    }

    public void initPanelFromNode(DataNode executableNode) {
        if (executableNode != null && executableNode.getDataObject() != null) {
            this.setExecutable(CppUtils.getPath(executableNode.getDataObject().getPrimaryFile()));
        }
        this.initPanel(executableNode);
    }

    private void initPanel(DataNode executableNode) {
        String executablePath = this.getExecutable();
        ExecutionSupport bes = PicklistUtils.findExecutionSupport(executableNode);
        if (bes == null) {
            this.fireChanged(new ElementChangeEvent(this, 4, this.getString("ERROR_NOTAEXEFILE")));
            this.fireChanged(new ElementChangeEvent(this, 3));
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
            this.foundExecutable = null;
            return;
        }
        this.fireChanged(new ElementChangeEvent(this, 5));
        this.fireChanged(new ElementChangeEvent(this, 2));
        this.setAttrFieldsEnabled(true);
        if (executableNode != this.foundExecutable) {
            String args = "";
            if (bes.getArguments().length > 0) {
                args = PicklistUtils.quoteArgument(bes.getArguments()[0]);
            }
            for (int i = 1; i < bes.getArguments().length; ++i) {
                args = args + " " + PicklistUtils.quoteArgument(bes.getArguments()[i]);
            }
            this.setArguments(args);
            String runDirectory = IpeUtils.getDirName(executablePath);
            if (bes instanceof BinaryExecSupport) {
                runDirectory = PicklistUtils.toAbsolutePath(IpeUtils.getDirName(executablePath), ((BinaryExecSupport)bes).getRunDirectory());
            }
            this.setRunDirectory(runDirectory);
        }
        this.foundExecutable = executableNode;
    }

    public void makefileCreated(MakefileWizardEvent e) {
        String[] executables = e.getExecutables();
        if (executables != null && executables.length > 0) {
            this.setExecutable(executables[0]);
            this.blankAttrFields();
            this.setAttrFieldsEnabled(false);
        }
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$executepicklist$ExecuteActionElementPanel == null ? (class$org$netbeans$modules$cpp$executepicklist$ExecuteActionElementPanel = ExecuteActionElementPanel.class$("org.netbeans.modules.cpp.executepicklist.ExecuteActionElementPanel")) : class$org$netbeans$modules$cpp$executepicklist$ExecuteActionElementPanel));
        }
        return this.bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

