/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.editor.parser;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cpp.editor.parser.BlockDataNode;
import org.netbeans.modules.cpp.editor.parser.ClassStructUnionNode;
import org.netbeans.modules.cpp.editor.parser.CtagsParser;
import org.netbeans.modules.cpp.editor.parser.CtagsTokenEvent;
import org.netbeans.modules.cpp.editor.parser.CtagsTokenListener;
import org.netbeans.modules.cpp.editor.parser.EnumNode;
import org.netbeans.modules.cpp.editor.parser.FuncMethodNode;
import org.netbeans.modules.cpp.editor.parser.FuncSubNode;
import org.netbeans.modules.cpp.editor.parser.LabelNode;
import org.netbeans.modules.cpp.editor.parser.MacroNode;
import org.netbeans.modules.cpp.editor.parser.ModulesNode;
import org.netbeans.modules.cpp.editor.parser.NamespaceNode;
import org.netbeans.modules.cpp.editor.parser.OtherNode;
import org.netbeans.modules.cpp.editor.parser.ProgramNode;
import org.netbeans.modules.cpp.editor.parser.SourceFileNode;
import org.netbeans.modules.cpp.editor.parser.TypedefNode;
import org.netbeans.modules.cpp.editor.parser.TypesNode;
import org.netbeans.modules.cpp.editor.parser.VarMemNode;
import org.netbeans.modules.cpp.editor.parser.VarNode;
import org.netbeans.modules.cpp.editor.parser.ViewNode;
import org.netbeans.modules.cpp.loaders.CCFSrcObject;
import org.netbeans.modules.cpp.loaders.CppEditorSupport;
import org.netbeans.modules.cpp.loaders.FortranSrcObject;
import org.netbeans.modules.cpp.loaders.HDataObject;
import org.netbeans.modules.cpp.settings.CppSettings;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ChoiceView;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.Visualizer;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class NavigationView
extends ChoiceView {
    SelectionManager selManager;
    private DataObject sourceObject = null;
    private CppEditorSupport cppEditorSupport = null;
    ArrayList indexLineNumber = null;
    private Timer checkModifiedTimer = null;
    private long lastModified = 0L;
    private Timer checkCursorTimer = null;
    private int lastCursorPos = -1;
    private int lastCursorPosWhenChecked = 0;
    private static int CLUSTER_FILE = 0;
    private static int CLUSTER_CC_MACRO = 1;
    private static int CLUSTER_CC_TYPEDEF = 2;
    private static int CLUSTER_CC_ENUM = 3;
    private static int CLUSTER_CC_OTHER = 4;
    private static int CLUSTER_CC_VARMEM = 5;
    private static int CLUSTER_CC_FUNCMETHOD = 6;
    private static int CLUSTER_CC_CLASSSTRUCTUNION = 7;
    private static int CLUSTER_CC_NAMESPACE = 8;
    private static int CLUSTER_FORTRAN_PROGRAM = 1;
    private static int CLUSTER_FORTRAN_LABEL = 2;
    private static int CLUSTER_FORTRAN_TYPES = 3;
    private static int CLUSTER_FORTRAN_OTHER = 4;
    private static int CLUSTER_FORTRAN_VAR = 5;
    private static int CLUSTER_FORTRAN_FUNCSUB = 6;
    private static int CLUSTER_FORTRAN_MODULES = 7;
    private static int CLUSTER_FORTRAN_BLOCK_DATA = 8;
    ExplorerManager manager;
    TopComponent topComponent = null;
    static ResourceBundle bundle = null;
    private AbstractNode comboboxRootNode = null;
    private Node[] comboboxChildren = null;
    private static boolean isLinuxTestDone = false;
    private static boolean isLinux = false;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$loaders$CppEditorSupport;
    static /* synthetic */ Class class$org$netbeans$modules$cpp$editor$parser$NavigationView;

    public NavigationView() {
        this.initComponents();
    }

    private void initComponents() {
        ((NodeListModel)this.getModel()).setDepth(8);
        this.selManager = new SelectionManager();
        this.setKeySelectionManager(this.selManager);
        this.getAccessibleContext().setAccessibleDescription(NavigationView.getString("ACSD_NavigationView"));
        this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        if (CppSettings.getDefault().getParsingDelay() > 0) {
            this.checkModifiedTimer = new Timer(CppSettings.getDefault().getParsingDelay(), new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    NavigationView.this.checkModified();
                }
            });
            this.checkCursorTimer = new Timer(250, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    NavigationView.this.checkCursor();
                }
            });
        }
        this.setRenderer((ListCellRenderer)((Object)new MyNodeRenderer()));
    }

    private void checkCursor() {
        JEditorPane jEditorPane;
        if (this.sourceObject == null) {
            return;
        }
        if (this.isPopupVisible()) {
            return;
        }
        if (CppSettings.getDefault().getParsingDelay() <= 0) {
            return;
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.stop();
        }
        if ((jEditorPane = this.findCurrentJEditorPane()) != null) {
            Caret caret = jEditorPane.getCaret();
            if (caret.getDot() != this.lastCursorPos && caret.getDot() == this.lastCursorPosWhenChecked) {
                this.lastCursorPos = caret.getDot();
                this.lastCursorPosWhenChecked = caret.getDot();
                Document doc = jEditorPane.getDocument();
                int caretLineNo = 1;
                try {
                    caretLineNo = Utilities.getLineOffset((BaseDocument)((BaseDocument)doc), (int)caret.getDot()) + 1;
                }
                catch (Exception e) {
                    // empty catch block
                }
                int bestIndex = 0;
                int index = Collections.binarySearch(this.indexLineNumber, new IndexLineNumber(0, caretLineNo), new IndexLineNumberComparator());
                if (index < 0) {
                    index = -index - 2;
                }
                bestIndex = ((IndexLineNumber)this.indexLineNumber.get(index)).getIndex();
                this.setSelectedIndex(bestIndex);
            }
            this.lastCursorPosWhenChecked = caret.getDot();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.restart();
        }
    }

    private void checkModified() {
        if (this.sourceObject == null) {
            return;
        }
        if (this.isPopupVisible()) {
            return;
        }
        this.stopTimers();
        JEditorPane jEditorPane = this.findCurrentJEditorPane();
        if (jEditorPane != null) {
            this.updateNodesIfModified(this.getCppEditorSupport(), this.sourceObject, jEditorPane);
        }
        this.restartTimers();
    }

    private void updateNodesIfModified(CppEditorSupport cppEditorSupport, DataObject sourceObject, JEditorPane jEditorPane) {
        File tmpFile = null;
        if (cppEditorSupport.getLastModified() <= this.lastModified) {
            return;
        }
        long timeSinceLastModification = System.currentTimeMillis() - cppEditorSupport.getLastModified();
        if (timeSinceLastModification < (long)CppSettings.getDefault().getParsingDelay()) {
            return;
        }
        this.lastModified = cppEditorSupport.getLastModified();
        this.lastCursorPos = -1;
        this.lastCursorPosWhenChecked = 0;
        try {
            tmpFile = File.createTempFile(sourceObject.getPrimaryFile().getName() + "__", "." + sourceObject.getPrimaryFile().getExt());
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(tmpFile)));
            out.print(jEditorPane.getText());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, "Problems creating tmp file for " + sourceObject.getPrimaryFile().getPath());
            ErrorManager.getDefault().notify((Throwable)e);
            tmpFile.delete();
            return;
        }
        this.updateChildren(tmpFile.getPath());
        tmpFile.delete();
    }

    public void addNotify() {
        super.addNotify();
        this.topComponent = this.findParentTopComponent();
        this.setRoot(this.getActivatedNode());
        this.restartTimers();
    }

    public void removeNotify() {
        this.stopTimers();
        super.removeNotify();
    }

    private void restartTimers() {
        if (this.checkModifiedTimer != null) {
            this.checkModifiedTimer.restart();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.restart();
        }
    }

    private void stopTimers() {
        if (this.checkModifiedTimer != null) {
            this.checkModifiedTimer.stop();
        }
        if (this.checkCursorTimer != null) {
            this.checkCursorTimer.stop();
        }
    }

    private ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = ExplorerManager.find((Component)((Object)this));
        }
        return this.manager;
    }

    private TopComponent findParentTopComponent() {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof TopComponent); p = p.getParent()) {
        }
        return (TopComponent)p;
    }

    public void setPopupVisible(boolean show) {
        boolean wasVisible = this.isPopupVisible() && this.isVisible();
        super.setPopupVisible(show);
        if (!show && wasVisible) {
            this.choiceItemSelected(this.getExplorerManager().getSelectedNodes());
        }
    }

    private Node getActivatedNode() {
        Node[] actNodes = this.topComponent == null ? TopComponent.getRegistry().getActivatedNodes() : this.topComponent.getActivatedNodes();
        if (actNodes == null || actNodes.length == 0) {
            return null;
        }
        return actNodes[0];
    }

    private void setRoot(Node activeNode) {
        if (activeNode == null) {
            return;
        }
        DataObject dataObject = (DataObject)activeNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = NavigationView.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (dataObject == null) {
            return;
        }
        if (!(dataObject instanceof CCFSrcObject) && !(dataObject instanceof HDataObject)) {
            return;
        }
        if (this.sourceObject == null || this.sourceObject != dataObject) {
            this.sourceObject = dataObject;
            this.cppEditorSupport = null;
            this.updateChildren(CppUtils.getPath(this.sourceObject.getPrimaryFile()));
        }
    }

    private void updateChildren(String sname) {
        this.removeComboboxChildren();
        MyCtagsTokenListener myCtagsTokenListener = new MyCtagsTokenListener();
        if (CppSettings.getDefault().getParsingDelay() > 0) {
            CtagsParser ctagsParser = new CtagsParser(sname);
            ctagsParser.setCtagsTokenListener(myCtagsTokenListener);
            try {
                ctagsParser.parse();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        this.addComboboxChildren((Node[])myCtagsTokenListener.getNodes());
        this.indexLineNumber = myCtagsTokenListener.getIndexLineNumbers();
    }

    private void choiceItemSelected(Node[] sel) {
        if (sel == null || sel.length == 0) {
            sel = this.getExplorerManager().getSelectedNodes();
        }
        if (sel == null || sel.length == 0) {
            return;
        }
        Node n = sel[0];
        if (n instanceof ViewNode) {
            ViewNode sen = (ViewNode)n;
            JEditorPane currentJEditorPane = this.findCurrentJEditorPane();
            if (currentJEditorPane != null) {
                sen.goToOffset(currentJEditorPane);
            }
        }
    }

    private JEditorPane findCurrentJEditorPane() {
        JEditorPane currentJEditorPane = null;
        JEditorPane[] jEditorPanes = this.getCppEditorSupport().getOpenedPanes();
        if (jEditorPanes == null) {
            return null;
        }
        if (jEditorPanes.length == 1) {
            currentJEditorPane = jEditorPanes[0];
        } else if (jEditorPanes != null && this.topComponent != null) {
            for (int i = 0; i < jEditorPanes.length; ++i) {
                if (!this.topComponent.isAncestorOf((Component)jEditorPanes[i])) continue;
                currentJEditorPane = jEditorPanes[i];
                break;
            }
        }
        return currentJEditorPane;
    }

    private CppEditorSupport getCppEditorSupport() {
        if (this.cppEditorSupport == null) {
            this.cppEditorSupport = (CppEditorSupport)this.sourceObject.getCookie(class$org$netbeans$modules$cpp$loaders$CppEditorSupport == null ? (class$org$netbeans$modules$cpp$loaders$CppEditorSupport = NavigationView.class$("org.netbeans.modules.cpp.loaders.CppEditorSupport")) : class$org$netbeans$modules$cpp$loaders$CppEditorSupport);
        }
        return this.cppEditorSupport;
    }

    private AbstractNode newRootNode() {
        AbstractNode rn = new AbstractNode((Children)new Children.Array());
        rn.setIconBase("org/netbeans/modules/java/resources/class");
        rn.setDisplayName(NavigationView.getString("NAME_NothingSelected"));
        return rn;
    }

    private AbstractNode getComboboxRootNode() {
        if (this.comboboxRootNode == null) {
            this.comboboxRootNode = this.newRootNode();
            this.getExplorerManager().setRootContext((Node)this.comboboxRootNode);
            this.comboboxChildren = null;
        }
        return this.comboboxRootNode;
    }

    private Node[] getComboboxChildren() {
        if (this.comboboxChildren == null) {
            this.comboboxChildren = this.getComboboxRootNode().getChildren().getNodes();
        }
        return this.comboboxChildren;
    }

    private void removeComboboxChildren() {
        this.getComboboxRootNode().getChildren().remove(this.getComboboxRootNode().getChildren().getNodes());
        this.comboboxChildren = null;
    }

    private void addComboboxChildren(Node[] c) {
        this.getComboboxRootNode().getChildren().add(c);
        this.comboboxChildren = c;
    }

    private static boolean isLinux() {
        if (!isLinuxTestDone) {
            isLinux = System.getProperty("os.name", "").toLowerCase().indexOf("linux") >= 0;
            isLinuxTestDone = true;
        }
        return isLinux;
    }

    static String getString(String key) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$cpp$editor$parser$NavigationView == null ? (class$org$netbeans$modules$cpp$editor$parser$NavigationView = NavigationView.class$("org.netbeans.modules.cpp.editor.parser.NavigationView")) : class$org$netbeans$modules$cpp$editor$parser$NavigationView));
        }
        return bundle.getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SelectionManager
    extends KeyAdapter
    implements JComboBox.KeySelectionManager {
        private SelectionManager() {
        }

        public int selectionForKey(char key, ComboBoxModel comboBoxModel) {
            Node[] children = NavigationView.this.getComboboxChildren();
            boolean gotOne = false;
            int index = 0;
            if (NavigationView.this.getSelectedIndex() >= 0) {
                index = NavigationView.this.getSelectedIndex() + 1;
                if (index >= children.length) {
                    index = 1;
                }
            } else {
                index = 1;
            }
            int startIndex = index;
            while (!gotOne && index < children.length) {
                ViewNode n = (ViewNode)children[index];
                if (key == n.getName().charAt(0) || key == n.getDisplayName().charAt(0)) {
                    gotOne = true;
                    break;
                }
                if (++index == startIndex) {
                    gotOne = false;
                    break;
                }
                if (index != children.length) continue;
                index = 1;
            }
            if (!gotOne) {
                index = -1;
            }
            return index;
        }
    }

    class MyCtagsTokenListener
    implements CtagsTokenListener {
        private ArrayList nodes = null;
        private ArrayList lineNumberIndex = null;
        private Vector scopeList = new Vector(0);

        MyCtagsTokenListener() {
            this.nodes = new ArrayList(5);
            this.nodes.add(new SourceFileNode(NavigationView.this.sourceObject, NavigationView.getString("NAME_StartOfFile"), 1, ' ', null, 0, CLUSTER_FILE));
        }

        private int findCCScopeCluster(String scope, int scopeKind) {
            int cluster = 0;
            if (scope != null) {
                if (scopeKind == 3) {
                    cluster = CLUSTER_CC_NAMESPACE;
                } else if (scopeKind == 0) {
                    cluster = CLUSTER_CC_CLASSSTRUCTUNION;
                } else if (scopeKind == 1) {
                    cluster = CLUSTER_CC_CLASSSTRUCTUNION;
                } else if (scopeKind == 2) {
                    cluster = CLUSTER_CC_CLASSSTRUCTUNION;
                } else {
                    System.err.println("Illegal scopeKind " + scopeKind);
                }
            }
            return cluster;
        }

        private int findFortranScopeCluster(String scope, int scopeKind) {
            int cluster = 0;
            if (scope != null) {
                if (scopeKind == 4) {
                    cluster = CLUSTER_FORTRAN_MODULES;
                } else if (scopeKind == 5) {
                    cluster = CLUSTER_FORTRAN_TYPES;
                } else if (scopeKind == 6) {
                    cluster = CLUSTER_FORTRAN_FUNCSUB;
                } else if (scopeKind == 7) {
                    cluster = CLUSTER_FORTRAN_BLOCK_DATA;
                } else {
                    System.err.println("Illegal scopeKind " + scopeKind);
                }
            }
            return cluster;
        }

        private boolean checkInScopeList(String scope) {
            if (scope != null) {
                Enumeration e = this.scopeList.elements();
                while (e.hasMoreElements()) {
                    String s = (String)e.nextElement();
                    if (!s.equals(scope)) continue;
                    return true;
                }
            }
            return false;
        }

        public void gotToken(CtagsTokenEvent ctagsTokenEvent) {
            String name = ctagsTokenEvent.getToken();
            int lineno = ctagsTokenEvent.getLineNo();
            char kind = ctagsTokenEvent.getKind();
            String scope = ctagsTokenEvent.getScope();
            int scopeKind = ctagsTokenEvent.getScopeKind();
            if (NavigationView.this.sourceObject instanceof FortranSrcObject) {
                ViewNode node;
                int scopeCluster = this.findFortranScopeCluster(scope, scopeKind);
                switch (ctagsTokenEvent.getKind()) {
                    case 'l': {
                        node = new LabelNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_FORTRAN_LABEL);
                        break;
                    }
                    case 'f': 
                    case 's': {
                        node = new FuncSubNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_FORTRAN_FUNCSUB);
                        break;
                    }
                    case 'L': 
                    case 'v': {
                        node = new VarNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_FORTRAN_VAR);
                        break;
                    }
                    case 'm': {
                        node = new ModulesNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_FORTRAN_MODULES);
                        break;
                    }
                    case 't': {
                        node = new TypesNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_FORTRAN_TYPES);
                        break;
                    }
                    case 'p': {
                        node = new ProgramNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_FORTRAN_PROGRAM);
                        break;
                    }
                    case 'b': {
                        node = new BlockDataNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_FORTRAN_BLOCK_DATA);
                        break;
                    }
                    default: {
                        node = new OtherNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_FORTRAN_OTHER);
                    }
                }
                this.nodes.add(node);
            } else {
                ViewNode node;
                int scopeCluster = this.findCCScopeCluster(scope, scopeKind);
                switch (ctagsTokenEvent.getKind()) {
                    case 'c': 
                    case 's': 
                    case 'u': {
                        node = new ClassStructUnionNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_CC_CLASSSTRUCTUNION);
                        this.scopeList.add(scope != null ? scope + "::" + name : name);
                        break;
                    }
                    case 'n': {
                        node = new NamespaceNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_CC_NAMESPACE);
                        this.scopeList.add(scope != null ? scope + "::" + name : name);
                        break;
                    }
                    case 'f': {
                        node = new FuncMethodNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_CC_FUNCMETHOD);
                        break;
                    }
                    case 'd': {
                        node = new MacroNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_CC_MACRO);
                        break;
                    }
                    case 't': {
                        node = new TypedefNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_CC_TYPEDEF);
                        break;
                    }
                    case 'm': 
                    case 'v': {
                        node = new VarMemNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_CC_VARMEM);
                        break;
                    }
                    case 'e': 
                    case 'g': {
                        node = new EnumNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_CC_ENUM);
                        break;
                    }
                    default: {
                        node = new OtherNode(NavigationView.this.sourceObject, name, lineno, kind, scope, scopeCluster, CLUSTER_CC_OTHER);
                    }
                }
                this.nodes.add(node);
            }
        }

        ViewNode[] getNodes() {
            if (!(NavigationView.this.sourceObject instanceof FortranSrcObject)) {
                this.fixupMissingScopes();
            }
            Collections.sort(this.nodes, new NodesComparator());
            return this.nodes.toArray(new ViewNode[this.nodes.size()]);
        }

        private ArrayList getIndexLineNumbers() {
            this.lineNumberIndex = new ArrayList(5);
            for (int i = 0; i < this.nodes.size(); ++i) {
                this.lineNumberIndex.add(new IndexLineNumber(i, ((ViewNode)((Object)this.nodes.get(i))).getLineNo()));
            }
            Collections.sort(this.lineNumberIndex, new IndexLineNumberComparator());
            return this.lineNumberIndex;
        }

        private void fixupMissingScopes() {
            ViewNode[] nodesSoFar = this.nodes.toArray(new ViewNode[this.nodes.size()]);
            for (int i = 0; i < nodesSoFar.length; ++i) {
                String scope;
                ViewNode vn = nodesSoFar[i];
                if (vn.getCluster() == CLUSTER_CC_CLASSSTRUCTUNION || vn.getCluster() == CLUSTER_CC_NAMESPACE || (scope = vn.getScope()) == null || this.checkInScopeList(scope)) continue;
                StringTokenizer st = new StringTokenizer(scope, "::");
                String nameScope = null;
                while (st.hasMoreTokens()) {
                    String className = st.nextToken();
                    if (this.checkInScopeList(className)) continue;
                    if (vn.getScopeCluster() == 3) {
                        this.nodes.add(new NamespaceNode(vn.getDataObject(), className, vn.getLineNo(), vn.getKind(), nameScope, vn.getScopeCluster(), CLUSTER_CC_NAMESPACE));
                    } else {
                        this.nodes.add(new ClassStructUnionNode(vn.getDataObject(), className, vn.getLineNo(), vn.getKind(), nameScope, vn.getScopeCluster(), CLUSTER_CC_CLASSSTRUCTUNION));
                    }
                    nameScope = nameScope != null ? nameScope + "::" + className : className;
                    this.scopeList.add(nameScope);
                }
                this.scopeList.add(scope);
            }
        }
    }

    class NodesComparator
    implements Comparator {
        NodesComparator() {
        }

        public int compare(Object o1, Object o2) {
            ViewNode iln1 = (ViewNode)((Object)o1);
            ViewNode iln2 = (ViewNode)((Object)o2);
            return iln1.getSortName().compareTo(iln2.getSortName());
        }
    }

    class IndexLineNumberComparator
    implements Comparator {
        IndexLineNumberComparator() {
        }

        public int compare(Object o1, Object o2) {
            IndexLineNumber iln1 = (IndexLineNumber)o1;
            IndexLineNumber iln2 = (IndexLineNumber)o2;
            if (iln1.getLineNumber() < iln2.getLineNumber()) {
                return -1;
            }
            if (iln1.getLineNumber() > iln2.getLineNumber()) {
                return 1;
            }
            return 0;
        }
    }

    class IndexLineNumber {
        private int index;
        private int lineNumber;

        public IndexLineNumber(int index, int lineNumber) {
            this.index = index;
            this.lineNumber = lineNumber;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    class MyNodeRenderer
    extends NodeRenderer {
        Border focusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        Border emptyBorder = new EmptyBorder(1, 1, 1, 1);

        MyNodeRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Border border = cellHasFocus ? this.focusBorder : this.emptyBorder;
            ViewNode vn = (ViewNode)Visualizer.findNode((Object)NavigationView.this.getItemAt(index));
            if (vn.getScopeLevel() > 0) {
                border = new CompoundBorder(new EmptyBorder(0, label.getIcon().getIconWidth() * vn.getScopeLevel(), 0, 0), border);
            }
            label.setBorder(border);
            return label;
        }
    }
}

