/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.editor.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.netbeans.modules.cpp.editor.parser.CtagsTokenEvent;
import org.netbeans.modules.cpp.editor.parser.CtagsTokenListener;

public class CtagsParser {
    private static boolean exuberantCtags = false;
    private static final String PROD_CTAGS_COMMAND = "sfw/bin/ctags";
    private static final String CCD_CTAGS_COMMAND = "/opt/sfw/bin/ctags";
    private static final String CTAGS_COMMAND_LINUX = "/usr/bin/ctags";
    private static final String CTAGS_COMMAND_SOLARIS = "/usr/bin/ctags";
    private static final String CTAGS_OPTIONS_EX_CTAGS = "-f - --fields=+nz";
    private static final String CTAGS_OPTIONS_SO_CTAGS = "-x";
    private static String ctagsCommandPlusOptions = null;
    private String inputFileName = null;
    private CtagsTokenListener ctagsTokenListener = null;

    public CtagsParser(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public void setCtagsTokenListener(CtagsTokenListener ctagsTokenListener) {
        this.ctagsTokenListener = ctagsTokenListener;
    }

    private void parseLineExuberantCtags(String line) {
        StringTokenizer st = new StringTokenizer(line, " \t");
        int tokenNo = 0;
        String name = null;
        String scope = null;
        int scopeKind = -1;
        char kind = ' ';
        int lineno = -1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int tokenLength = token.length();
            String tokenKey = null;
            int tokenKeyLength = 0;
            tokenKeyLength = token.indexOf(58);
            if (tokenKeyLength > 0) {
                tokenKey = token.substring(0, ++tokenKeyLength);
            }
            if (tokenNo == 0) {
                name = token;
            } else if (tokenKeyLength == 5) {
                if (tokenKey.equals("kind:")) {
                    if (tokenLength > 5) {
                        kind = token.charAt(5);
                    }
                } else if (tokenKey.equals("type:")) {
                    if (tokenLength > 5) {
                        scope = token.substring(5);
                        scopeKind = 5;
                    }
                } else if (tokenKey.equals("data:")) {
                    if (tokenLength > 5) {
                        scope = token.substring(5);
                        scopeKind = 7;
                    }
                } else if (tokenKey.equals("line:")) {
                    try {
                        Integer i = new Integer(token.substring(5));
                        lineno = i;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
            } else if (tokenKeyLength == 6) {
                if (tokenKey.equals("class:")) {
                    if (tokenLength > 6) {
                        scope = token.substring(6);
                        scopeKind = 0;
                    }
                } else if (tokenKey.equals("union:") && tokenLength > 6) {
                    scope = token.substring(6);
                    scopeKind = 2;
                }
            } else if (tokenKeyLength == 7) {
                if (tokenKey.equals("struct:")) {
                    if (tokenLength > 7) {
                        scope = token.substring(7);
                        scopeKind = 1;
                    }
                } else if (tokenKey.equals("module:") && tokenLength > 7) {
                    scope = token.substring(7);
                    scopeKind = 4;
                }
            } else if (tokenKeyLength == 10) {
                if (tokenKey.equals("namespace:") && tokenLength > 10) {
                    scope = token.substring(10);
                    scopeKind = 3;
                }
            } else if (tokenKeyLength == 11 && tokenKey.equals("subroutine:") && tokenLength > 11) {
                scope = token.substring(11);
                scopeKind = 6;
            }
            ++tokenNo;
        }
        if (this.ctagsTokenListener != null) {
            this.ctagsTokenListener.gotToken(new CtagsTokenEvent(name, kind, scope, scopeKind, lineno));
        } else {
            System.err.println("gotToken: " + name + ":" + lineno);
        }
    }

    private void parseLineSolarisCtags(String line) {
        StringTokenizer st = new StringTokenizer(line);
        int tokenNo = 0;
        String name = null;
        int lineno = -1;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (tokenNo == 0) {
                name = token;
            } else if (tokenNo == 1) {
                try {
                    Integer i = new Integer(token);
                    lineno = i;
                }
                catch (Exception e) {
                    return;
                }
            }
            if (++tokenNo <= 1) continue;
            break;
        }
        if (this.ctagsTokenListener != null) {
            this.ctagsTokenListener.gotToken(new CtagsTokenEvent(name, lineno));
        } else {
            System.err.println("gotToken: " + name + ":" + lineno);
        }
    }

    private String getCtagsCommand() {
        if (ctagsCommandPlusOptions == null) {
            if (System.getProperty("os.name", "").toLowerCase().indexOf("linux") >= 0) {
                if (new File("/usr/bin/ctags").exists()) {
                    exuberantCtags = true;
                    ctagsCommandPlusOptions = "/usr/bin/ctags -f - --fields=+nz";
                }
            } else {
                String binPath = System.getProperty("spro.home") + File.separator + PROD_CTAGS_COMMAND;
                if (new File(binPath).exists()) {
                    exuberantCtags = true;
                    ctagsCommandPlusOptions = binPath + " " + CTAGS_OPTIONS_EX_CTAGS;
                } else if (new File(CCD_CTAGS_COMMAND).exists()) {
                    exuberantCtags = true;
                    ctagsCommandPlusOptions = "/opt/sfw/bin/ctags -f - --fields=+nz";
                } else if (new File("/usr/bin/ctags").exists()) {
                    exuberantCtags = false;
                    ctagsCommandPlusOptions = "/usr/bin/ctags -x";
                }
            }
        }
        if (ctagsCommandPlusOptions == null) {
            System.err.println("cpp - cannot locate ctags utility...");
        }
        return ctagsCommandPlusOptions;
    }

    public int parse() throws IOException, InterruptedException {
        int exit = 0;
        String ctagsCommand = this.getCtagsCommand();
        if (ctagsCommand == null) {
            return -1;
        }
        Process proc = Runtime.getRuntime().exec(ctagsCommand + " " + this.inputFileName);
        OutputMonitor emonitor = new OutputMonitor(new InputStreamReader(proc.getErrorStream()), true);
        emonitor.start();
        OutputMonitor imonitor = new OutputMonitor(new InputStreamReader(proc.getInputStream()), false);
        imonitor.start();
        emonitor.join();
        imonitor.join();
        exit = proc.waitFor();
        proc.destroy();
        return exit;
    }

    public class OutputMonitor
    extends Thread {
        private BufferedReader in;
        private boolean skipAll;

        public OutputMonitor(InputStreamReader reader, boolean skipAll) {
            this.in = new BufferedReader(reader);
            this.skipAll = skipAll;
        }

        public void run() {
            try {
                String line;
                while ((line = this.in.readLine()) != null) {
                    if (this.skipAll) continue;
                    if (exuberantCtags) {
                        CtagsParser.this.parseLineExuberantCtags(line);
                        continue;
                    }
                    CtagsParser.this.parseLineSolarisCtags(line);
                }
                this.in.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

