/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.editor.makefile;

import java.util.Stack;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.cpp.editor.makefile.MakefileTokenContext;

public class MakefileSyntax
extends Syntax {
    private static final int AFTER_COLON = 1;
    private static final int AFTER_DOLLAR = 2;
    private static final int AFTER_BSLASH = 3;
    private static final int AFTER_PLUS = 4;
    private static final int IN_STRING = 5;
    private static final int IN_STRING_AFTER_BSLASH = 6;
    private static final int IN_MACRO = 7;
    private static final int IN_MACRO_AFTER_DELIM = 8;
    private static final int IN_WHITESPACE = 9;
    private static final int IN_LINE_COMMENT = 10;
    private static final int IN_IDENTIFIER = 11;
    private static final int IN_DOT_IDENTIFIER = 12;
    private static final int IN_COLON_IDENTIFIER = 13;
    private static boolean STRING_IN_DOUBLE_QUOTE = true;
    private static Integer BRACE_DELIM = new Integer(1);
    private static Integer PARAN_DELIM = new Integer(2);
    private Stack macroDelimStack = new Stack();

    public MakefileSyntax() {
        this.tokenContextPath = MakefileTokenContext.contextPath;
    }

    protected TokenID parseToken() {
        while (this.offset < this.stopOffset) {
            char actChar = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    switch (actChar) {
                        case '#': {
                            this.state = 10;
                            break block0;
                        }
                        case ':': {
                            this.state = 1;
                            break block0;
                        }
                        case '.': {
                            this.state = 12;
                            break block0;
                        }
                        case '$': {
                            this.state = 2;
                            break block0;
                        }
                        case '\\': {
                            this.state = 3;
                            break block0;
                        }
                        case '\"': {
                            this.state = 5;
                            STRING_IN_DOUBLE_QUOTE = true;
                            break block0;
                        }
                        case '\'': {
                            this.state = 5;
                            STRING_IN_DOUBLE_QUOTE = false;
                            break block0;
                        }
                        case '+': {
                            this.state = 4;
                            break block0;
                        }
                        case '-': {
                            ++this.offset;
                            return MakefileTokenContext.RULES_MINUS;
                        }
                        case '@': {
                            ++this.offset;
                            return MakefileTokenContext.RULES_AT;
                        }
                        case '?': {
                            ++this.offset;
                            return MakefileTokenContext.RULES_QUESTION_MARK;
                        }
                        case '!': {
                            ++this.offset;
                            return MakefileTokenContext.RULES_EXCLAMATION;
                        }
                        case '%': {
                            ++this.offset;
                            return MakefileTokenContext.TARGET_PERCENT;
                        }
                        case '=': {
                            ++this.offset;
                            return MakefileTokenContext.MACRO_OP_EQUALS;
                        }
                        case '(': {
                            ++this.offset;
                            return MakefileTokenContext.MACRO_LPAREN;
                        }
                        case ')': {
                            ++this.offset;
                            return MakefileTokenContext.MACRO_RPAREN;
                        }
                        case '{': {
                            ++this.offset;
                            return MakefileTokenContext.MACRO_LBRACE;
                        }
                        case '}': {
                            ++this.offset;
                            return MakefileTokenContext.MACRO_RBRACE;
                        }
                    }
                    if (Character.isWhitespace(actChar)) {
                        this.state = 9;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(actChar)) {
                        this.state = 11;
                        break;
                    }
                    ++this.offset;
                    return MakefileTokenContext.IDENTIFIER;
                }
                case 9: {
                    if (Character.isWhitespace(actChar)) break;
                    this.state = -1;
                    return MakefileTokenContext.WHITESPACE;
                }
                case 10: {
                    switch (actChar) {
                        case '\n': {
                            this.state = -1;
                            ++this.offset;
                            return MakefileTokenContext.LINE_COMMENT;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (actChar) {
                        case '$': {
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.MACRO_ESCAPED_DOLLAR;
                        }
                    }
                    this.state = 11;
                    --this.offset;
                    break;
                }
                case 2: {
                    switch (actChar) {
                        case '$': {
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.MACRO_DOLAR_REFERENCE;
                        }
                        case '*': {
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.MACRO_DYN_TARGET_BASENAME;
                        }
                        case '<': {
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.MACRO_DYN_DEPENDENCY_FILENAME;
                        }
                        case '@': {
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.MACRO_DYN_CURRENTTARGET;
                        }
                        case '?': {
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.MACRO_DYN_DEPENDENCY_LIST;
                        }
                        case '%': {
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.MACRO_DYN_LIBRARYNAME;
                        }
                        case '(': 
                        case '{': {
                            --this.offset;
                            this.state = 8;
                            break block0;
                        }
                    }
                    this.state = 7;
                    break;
                }
                case 7: {
                    if (Character.isJavaIdentifierPart(actChar)) break;
                    switch (actChar) {
                        case '-': 
                        case '.': {
                            break block0;
                        }
                    }
                    this.state = -1;
                    return MakefileTokenContext.MACRO_LITERAL;
                }
                case 8: {
                    if (Character.isJavaIdentifierPart(actChar)) break;
                    switch (actChar) {
                        case '-': 
                        case '.': {
                            break block0;
                        }
                        case '(': {
                            this.macroDelimStack.push(PARAN_DELIM);
                            break block0;
                        }
                        case '{': {
                            this.macroDelimStack.push(BRACE_DELIM);
                            break block0;
                        }
                        case ')': 
                        case '}': {
                            Integer delim;
                            Integer n = delim = actChar == ')' ? PARAN_DELIM : BRACE_DELIM;
                            if (!this.macroDelimStack.empty() && (Integer)this.macroDelimStack.pop() == delim) {
                                if (!this.macroDelimStack.empty()) break block0;
                                this.state = -1;
                                ++this.offset;
                                return MakefileTokenContext.MACRO_LITERAL;
                            }
                            this.state = -1;
                            ++this.offset;
                            this.macroDelimStack = new Stack();
                            return MakefileTokenContext.ERR_INCOMPLETE_MACRO_LITERAL;
                        }
                    }
                    if (this.macroDelimStack.empty()) {
                        this.state = -1;
                        return MakefileTokenContext.MACRO_LITERAL;
                    }
                    this.state = -1;
                    this.macroDelimStack = new Stack();
                    return MakefileTokenContext.ERR_INCOMPLETE_MACRO_LITERAL;
                }
                case 4: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.MACRO_OP_APPEND;
                        }
                    }
                    this.state = -1;
                    ++this.offset;
                    return MakefileTokenContext.RULES_PLUS;
                }
                case 1: {
                    switch (actChar) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.MACRO_OP_CONDITIONAL;
                        }
                        case ':': {
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.TARGET_DOUBLE_COLON;
                        }
                        case 'S': 
                        case 's': {
                            this.state = 13;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return MakefileTokenContext.TARGET_COLON;
                }
                case 13: {
                    if (Character.isJavaIdentifierPart(actChar)) break;
                    this.state = -1;
                    TokenID tid = MakefileSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (tid != null) {
                        return tid;
                    }
                    this.offset = this.tokenOffset + 1;
                    return MakefileTokenContext.TARGET_COLON;
                }
                case 12: {
                    if (Character.isJavaIdentifierPart(actChar)) break;
                    this.state = -1;
                    TokenID tid = MakefileSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    if (tid != null) {
                        return tid;
                    }
                    this.offset = this.tokenOffset + 1;
                    this.state = -1;
                    return MakefileTokenContext.IDENTIFIER;
                }
                case 11: {
                    if (Character.isJavaIdentifierPart(actChar)) break;
                    this.state = -1;
                    TokenID tid = MakefileSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return tid != null ? tid : MakefileTokenContext.IDENTIFIER;
                }
                case 5: {
                    switch (actChar) {
                        case '\\': {
                            this.state = 6;
                            break;
                        }
                        case '\n': {
                            this.state = -1;
                            ++this.offset;
                            this.supposedTokenID = MakefileTokenContext.STRING_LITERAL;
                            return this.supposedTokenID;
                        }
                        case '\"': {
                            if (!STRING_IN_DOUBLE_QUOTE) break;
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.STRING_LITERAL;
                        }
                        case '\'': {
                            if (STRING_IN_DOUBLE_QUOTE) break;
                            ++this.offset;
                            this.state = -1;
                            return MakefileTokenContext.STRING_LITERAL;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (actChar) {
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            break;
                        }
                        default: {
                            --this.offset;
                        }
                    }
                    this.state = 5;
                }
            }
            ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 9: {
                    this.state = -1;
                    return MakefileTokenContext.WHITESPACE;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.state = -1;
                    TokenID kwd = MakefileSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return kwd != null ? kwd : MakefileTokenContext.IDENTIFIER;
                }
                case 5: 
                case 6: {
                    return MakefileTokenContext.STRING_LITERAL;
                }
                case 7: 
                case 8: {
                    this.state = -1;
                    return MakefileTokenContext.MACRO_LITERAL;
                }
                case 3: {
                    this.state = -1;
                    return MakefileTokenContext.IDENTIFIER;
                }
                case 4: {
                    this.state = -1;
                    return MakefileTokenContext.RULES_PLUS;
                }
                case 2: {
                    this.state = -1;
                    return MakefileTokenContext.MACRO_DOLLAR;
                }
                case 1: {
                    this.state = -1;
                    return MakefileTokenContext.TARGET_COLON;
                }
                case 10: {
                    return MakefileTokenContext.LINE_COMMENT;
                }
            }
        }
        switch (this.state) {
            case 9: {
                return MakefileTokenContext.WHITESPACE;
            }
        }
        return null;
    }

    public String getStateName(int stateNumber) {
        switch (stateNumber) {
            case 1: {
                return "AFTER_COLON";
            }
            case 2: {
                return "AFTER_DOLLAR";
            }
            case 3: {
                return "AFTER_BSLASH";
            }
            case 4: {
                return "AFTER_PLUS";
            }
            case 5: {
                return "IN_STRING";
            }
            case 6: {
                return "IN_STRING_AFTER_BSLASH";
            }
            case 7: {
                return "IN_MACRO";
            }
            case 8: {
                return "IN_MACRO_AFTER_DELIM";
            }
            case 10: {
                return "IN_LINE_COMMENT";
            }
            case 11: {
                return "IN_IDENTIFIER";
            }
            case 12: {
                return "IN_DOT_IDENTIFIER";
            }
            case 13: {
                return "IN_COLON_IDENTIFIER";
            }
            case 9: {
                return "IN_WHITESPACE";
            }
        }
        return super.getStateName(stateNumber);
    }

    public static TokenID matchKeyword(char[] buffer, int offset, int len) {
        if (len <= 1 || len > 17) {
            return null;
        }
        switch (Character.toLowerCase(buffer[offset++])) {
            case '.': {
                if (len < 5 || len > 16) {
                    return null;
                }
                switch (Character.toLowerCase(buffer[offset++])) {
                    case 'd': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'e': {
                                return len == 8 && Character.toLowerCase(buffer[offset++]) == 'f' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 't' ? MakefileTokenContext.TARGET_DEFAULT : null;
                            }
                            case 'o': {
                                return len == 5 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'e' ? MakefileTokenContext.TARGET_DONE : null;
                            }
                        }
                        return null;
                    }
                    case 'f': {
                        return len == 7 && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'd' ? MakefileTokenContext.TARGET_FAILED : null;
                    }
                    case 'g': {
                        return len == 10 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == '_' && Character.toLowerCase(buffer[offset++]) == 'p' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'x' ? MakefileTokenContext.TARGET_GETPOSIX : null;
                    }
                    case 'i': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'g': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'e' ? MakefileTokenContext.TARGET_IGNORE : null;
                            }
                            case 'n': {
                                return len == 5 && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 't' ? MakefileTokenContext.TARGET_INIT : null;
                            }
                        }
                        return null;
                    }
                    case 'k': {
                        if (len >= 11 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'p' && Character.toLowerCase(buffer[offset++]) == '_' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 't' && Character.toLowerCase(buffer[offset++]) == 'e') {
                            if (len == 11) {
                                return MakefileTokenContext.TARGET_KEEPSTATE;
                            }
                            switch (Character.toLowerCase(buffer[offset++])) {
                                case '_': {
                                    return len == 16 && Character.toLowerCase(buffer[offset++]) == 'f' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' ? MakefileTokenContext.TARGET_KEEPSTATEFILE : null;
                                }
                            }
                            return null;
                        }
                        return null;
                    }
                    case 'm': {
                        return len == 13 && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'k' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == '_' && Character.toLowerCase(buffer[offset++]) == 'v' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'n' ? MakefileTokenContext.TARGET_MAKEVERSION : null;
                    }
                    case 'n': {
                        return len == 12 && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == '_' && Character.toLowerCase(buffer[offset++]) == 'p' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'l' ? MakefileTokenContext.TARGET_NOPARALLEL : null;
                    }
                    case 'p': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'a': {
                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'r' && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'l' ? MakefileTokenContext.TARGET_PARALLEL : null;
                            }
                            case 'o': {
                                return len == 6 && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'x' ? MakefileTokenContext.TARGET_POSIX : null;
                            }
                            case 'r': {
                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 's' ? MakefileTokenContext.TARGET_PRECIOUS : null;
                            }
                        }
                        return null;
                    }
                    case 's': {
                        switch (Character.toLowerCase(buffer[offset++])) {
                            case 'c': {
                                if (len >= 9 && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == '_' && Character.toLowerCase(buffer[offset++]) == 'g' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 't') {
                                    if (len == 9) {
                                        return MakefileTokenContext.TARGET_SCCSGET;
                                    }
                                    switch (Character.toLowerCase(buffer[offset++])) {
                                        case '_': {
                                            return len == 15 && Character.toLowerCase(buffer[offset++]) == 'p' && Character.toLowerCase(buffer[offset++]) == 'o' && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'x' ? MakefileTokenContext.TARGET_SCCSGETPOSIX : null;
                                        }
                                    }
                                    return null;
                                }
                                return null;
                            }
                            case 'i': {
                                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 't' ? MakefileTokenContext.TARGET_SILENT : null;
                            }
                            case 'u': {
                                return len == 9 && Character.toLowerCase(buffer[offset++]) == 'f' && Character.toLowerCase(buffer[offset++]) == 'f' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 'x' && Character.toLowerCase(buffer[offset++]) == 'e' && Character.toLowerCase(buffer[offset++]) == 's' ? MakefileTokenContext.TARGET_SUFFIXES : null;
                            }
                        }
                        return null;
                    }
                    case 'w': {
                        return len == 5 && Character.toLowerCase(buffer[offset++]) == 'a' && Character.toLowerCase(buffer[offset++]) == 'i' && Character.toLowerCase(buffer[offset++]) == 't' ? MakefileTokenContext.TARGET_WAIT : null;
                    }
                }
                return null;
            }
            case ':': {
                return len == 3 && Character.toLowerCase(buffer[offset++]) == 's' && Character.toLowerCase(buffer[offset++]) == 'h' ? MakefileTokenContext.MACRO_COMMAND_SUBSTITUTE : null;
            }
            case 'i': {
                return len == 7 && Character.toLowerCase(buffer[offset++]) == 'n' && Character.toLowerCase(buffer[offset++]) == 'c' && Character.toLowerCase(buffer[offset++]) == 'l' && Character.toLowerCase(buffer[offset++]) == 'u' && Character.toLowerCase(buffer[offset++]) == 'd' && Character.toLowerCase(buffer[offset++]) == 'e' ? MakefileTokenContext.GLOBAL_INCLUDE : null;
            }
        }
        return null;
    }
}

