/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.editor.fortran;

import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtFormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.cpp.editor.fortran.FTokenContext;
import org.netbeans.modules.cpp.settings.CppSettings;

public class FFormatSupport
extends ExtFormatSupport {
    private TokenContextPath tokenContextPath;

    public FFormatSupport(FormatWriter formatWriter) {
        this(formatWriter, FTokenContext.contextPath);
    }

    public FFormatSupport(FormatWriter formatWriter, TokenContextPath tokenContextPath) {
        super(formatWriter);
        this.tokenContextPath = tokenContextPath;
    }

    public TokenContextPath getTokenContextPath() {
        return this.tokenContextPath;
    }

    public boolean isComment(TokenItem token, int offset) {
        TokenID tokenID = token.getTokenID();
        return token.getTokenContextPath() == this.tokenContextPath && tokenID == FTokenContext.LINE_COMMENT;
    }

    public boolean isFreeFormatComment(TokenItem token) {
        return token != null && token.getImage().startsWith("!");
    }

    public boolean isFixedFormatComment(TokenItem token) {
        return token != null && (token.getImage().startsWith("C") || token.getImage().startsWith("c")) && this.getTokenIndent(token) == 0 && !this.getFreeFormat();
    }

    public boolean isPreprocessor(TokenItem token) {
        return token != null && token.getImage().startsWith("#") && this.getVisualColumnOffset(this.getPosition(token, 0)) == 0;
    }

    public boolean isFixedFormatLabel(TokenItem token) {
        FormatTokenPosition tp;
        return token != null && token.getTokenID() == FTokenContext.NUM_LITERAL_INT && !this.getFreeFormat() && this.getVisualColumnOffset(tp = this.getPosition(token, 0)) + token.getImage().length() <= 5;
    }

    public boolean isFixedFormatLineContinuation(TokenItem token) {
        return token != null && (token.getTokenID() == FTokenContext.OP_PLUS || token.getTokenID() == FTokenContext.OP_MINUS) && !this.getFreeFormat() && this.getVisualColumnOffset(this.getPosition(token, 0)) == 5;
    }

    public TokenID getWhitespaceTokenID() {
        return FTokenContext.WHITESPACE;
    }

    public TokenContextPath getWhitespaceTokenContextPath() {
        return this.tokenContextPath;
    }

    public boolean canModifyWhitespace(TokenItem inToken) {
        if (inToken.getTokenContextPath() == FTokenContext.contextPath) {
            switch (inToken.getTokenID().getNumericID()) {
                case 14: {
                    return true;
                }
            }
        }
        return false;
    }

    public TokenItem findLineStartToken(TokenItem token) {
        if (token != null) {
            FormatTokenPosition pos = this.getPosition(token, 0);
            pos = this.findLineStart(pos);
            token = pos.getToken();
            while (token.getTokenID() == FTokenContext.WHITESPACE) {
                token = token.getNext();
            }
        }
        return token;
    }

    public boolean isIfThenStatement(TokenItem startToken) {
        FormatTokenPosition pos = this.getPosition(startToken, 0);
        pos = this.findLineEnd(pos);
        TokenItem lastToken = pos.getToken();
        lastToken = lastToken.getPrevious();
        while (lastToken.getTokenID() == FTokenContext.WHITESPACE) {
            lastToken = lastToken.getPrevious();
        }
        return lastToken.getTokenID() == FTokenContext.KW_THEN;
    }

    public TokenItem findMatchingToken(TokenItem token, int matchTokenID, int matchEndKeywordID) {
        int depth = 0;
        while (true) {
            int tokenNumericID;
            TokenItem impToken = this.findImportantToken(token, null, true);
            TokenItem startToken = token = this.findLineStartToken(impToken);
            if (token == null) {
                return null;
            }
            if (this.isFixedFormatLabel(startToken)) {
                while ((startToken = startToken.getNext()).getTokenID() == FTokenContext.WHITESPACE) {
                }
            }
            if ((tokenNumericID = startToken.getTokenID().getNumericID()) == 89) {
                TokenItem tokenAfterEnd = startToken.getNext();
                while (tokenAfterEnd.getTokenID() == FTokenContext.WHITESPACE) {
                    tokenAfterEnd = tokenAfterEnd.getNext();
                }
                if (tokenAfterEnd == null) {
                    return null;
                }
                if (tokenAfterEnd.getTokenID().getNumericID() != matchTokenID) continue;
                ++depth;
                continue;
            }
            if (tokenNumericID == matchEndKeywordID) {
                ++depth;
                continue;
            }
            if (tokenNumericID != matchTokenID) continue;
            if (matchTokenID == 124 && matchEndKeywordID == 97) {
                TokenItem t;
                TokenItem nextToken = startToken;
                do {
                    if ((nextToken = nextToken.getNext()) != null) continue;
                    return null;
                } while ((nextToken.getImage().indexOf(10) <= -1 || this.isFixedFormatLineContinuation(this.findLineStartToken(t = nextToken.getNext()))) && nextToken.getTokenID() != FTokenContext.KW_THEN);
                if (nextToken.getImage().indexOf(10) > -1) continue;
            }
            if (depth-- == 0) break;
        }
        return token;
    }

    public int getTokenIndent(TokenItem token) {
        FormatTokenPosition tp = this.getPosition(token, 0);
        FormatTokenPosition fnw = this.findLineFirstNonWhitespace(tp);
        if (fnw != null) {
            TokenItem t = fnw.getToken();
            if (this.isFixedFormatLabel(t) || this.isFixedFormatLineContinuation(t)) {
                while ((t = t.getNext()) != null && t.getTokenID() == this.getWhitespaceTokenID()) {
                }
                Object object = fnw = t == null && t.getImage().length() > 0 ? null : this.getPosition(t, 0);
            }
            if (fnw != null) {
                tp = fnw;
            }
        }
        return this.getVisualColumnOffset(tp);
    }

    public int findIndent(TokenItem token) {
        int indent = -1;
        if (token == null) {
            return 0;
        }
        TokenItem matchToken = null;
        switch (token.getTokenID().getNumericID()) {
            case 68: 
            case 78: {
                matchToken = this.findMatchingToken(token, 177, 102);
                if (matchToken == null) break;
                indent = this.getTokenIndent(matchToken) + this.getShiftWidth();
                break;
            }
            case 101: 
            case 162: {
                indent = 0;
                break;
            }
            case 89: {
                Object lookupToken = null;
                TokenItem nextToken = token.getNext();
                if (nextToken == null) {
                    if (this.getFreeFormat()) {
                        indent = 0;
                        break;
                    }
                    indent = 6;
                    break;
                }
                if (nextToken.getTokenID() == FTokenContext.WHITESPACE) {
                    nextToken = nextToken.getNext();
                }
                if (nextToken == null) {
                    indent = 0;
                    break;
                }
                if (nextToken.getImage().compareTo("\n") == 0) {
                    indent = 0;
                    break;
                }
                switch (nextToken.getTokenID().getNumericID()) {
                    case 86: 
                    case 124: {
                        matchToken = this.findMatchingToken(token, 124, 97);
                        break;
                    }
                    case 65: {
                        matchToken = this.findMatchingToken(token, 65, 90);
                        break;
                    }
                    case 66: {
                        matchToken = this.findMatchingToken(token, 66, 91);
                        break;
                    }
                    case 82: {
                        matchToken = this.findMatchingToken(token, 82, 92);
                        break;
                    }
                    case 117: {
                        matchToken = this.findMatchingToken(token, 117, 95);
                        break;
                    }
                    case 121: {
                        matchToken = this.findMatchingToken(token, 121, 96);
                        break;
                    }
                    case 132: {
                        matchToken = this.findMatchingToken(token, 132, 98);
                        break;
                    }
                    case 138: {
                        matchToken = this.findMatchingToken(token, 138, 99);
                        break;
                    }
                    case 139: {
                        matchToken = this.findMatchingToken(token, 139, 100);
                        break;
                    }
                    case 177: {
                        matchToken = this.findMatchingToken(token, 177, 102);
                        break;
                    }
                    case 186: {
                        matchToken = this.findMatchingToken(token, 186, 103);
                        break;
                    }
                    case 104: {
                        matchToken = this.findMatchingToken(token, 187, 104);
                        break;
                    }
                    case 191: {
                        matchToken = this.findMatchingToken(token, 191, 105);
                        break;
                    }
                    case 193: {
                        matchToken = this.findMatchingToken(token, 193, 106);
                        break;
                    }
                    case 195: {
                        matchToken = this.findMatchingToken(token, 195, 107);
                    }
                }
                if (matchToken == null) break;
                indent = this.getTokenIndent(matchToken);
                break;
            }
            default: {
                switch (token.getTokenID().getNumericID()) {
                    case 86: 
                    case 87: 
                    case 97: {
                        matchToken = this.findMatchingToken(token, 124, 97);
                        break;
                    }
                    case 90: {
                        matchToken = this.findMatchingToken(token, 65, 90);
                        break;
                    }
                    case 91: {
                        matchToken = this.findMatchingToken(token, 66, 91);
                        break;
                    }
                    case 92: {
                        matchToken = this.findMatchingToken(token, 82, 92);
                        break;
                    }
                    case 95: {
                        matchToken = this.findMatchingToken(token, 117, 95);
                        break;
                    }
                    case 96: {
                        matchToken = this.findMatchingToken(token, 121, 96);
                        break;
                    }
                    case 98: {
                        matchToken = this.findMatchingToken(token, 132, 98);
                        break;
                    }
                    case 99: {
                        matchToken = this.findMatchingToken(token, 138, 99);
                        break;
                    }
                    case 100: {
                        matchToken = this.findMatchingToken(token, 139, 100);
                        break;
                    }
                    case 102: {
                        matchToken = this.findMatchingToken(token, 177, 102);
                        break;
                    }
                    case 103: {
                        matchToken = this.findMatchingToken(token, 186, 103);
                        break;
                    }
                    case 104: {
                        matchToken = this.findMatchingToken(token, 187, 104);
                        break;
                    }
                    case 105: {
                        matchToken = this.findMatchingToken(token, 191, 105);
                        break;
                    }
                    case 106: {
                        matchToken = this.findMatchingToken(token, 193, 106);
                        break;
                    }
                    case 88: 
                    case 107: {
                        matchToken = this.findMatchingToken(token, 195, 107);
                    }
                }
                if (matchToken == null) break;
                indent = this.getTokenIndent(matchToken);
            }
        }
        if (indent < 0) {
            if (token == null) {
                return 0;
            }
            TokenItem impToken = this.findImportantToken(token, null, true);
            TokenItem startToken = this.findLineStartToken(impToken);
            if (startToken == null) {
                return 0;
            }
            while (this.isFixedFormatLineContinuation(startToken) || this.isPreprocessor(startToken) || startToken.getTokenID() == FTokenContext.KW_ENTRY) {
                impToken = this.findImportantToken(startToken, null, true);
                if ((startToken = this.findLineStartToken(impToken)) != null) continue;
                return 0;
            }
            if (impToken != null) {
                while (this.isFixedFormatLabel(startToken) || startToken.getTokenID() == FTokenContext.WHITESPACE) {
                    if ((startToken = startToken.getNext()) != null) continue;
                    return 0;
                }
                switch (startToken.getTokenID().getNumericID()) {
                    case 82: {
                        if (!this.getFreeFormat()) {
                            TokenItem nexToken = startToken.getNext();
                            while (nexToken.getTokenID() == FTokenContext.WHITESPACE) {
                                nexToken = nexToken.getNext();
                            }
                            if (nexToken.getTokenID() == FTokenContext.NUM_LITERAL_INT) {
                                indent = this.getTokenIndent(startToken);
                                break;
                            }
                        }
                        indent = this.getTokenIndent(startToken) + this.getShiftWidth();
                        break;
                    }
                    case 65: 
                    case 66: 
                    case 68: 
                    case 86: 
                    case 88: 
                    case 121: 
                    case 132: 
                    case 138: 
                    case 139: 
                    case 162: 
                    case 177: 
                    case 178: 
                    case 186: 
                    case 187: 
                    case 191: 
                    case 193: 
                    case 195: {
                        indent = this.getTokenIndent(startToken) + this.getShiftWidth();
                        break;
                    }
                    case 87: 
                    case 124: {
                        if (this.isIfThenStatement(startToken)) {
                            indent = this.getTokenIndent(startToken) + this.getShiftWidth();
                            break;
                        }
                        indent = this.getTokenIndent(startToken);
                        break;
                    }
                    default: {
                        indent = this.getTokenIndent(startToken);
                    }
                }
                if (indent < 0) {
                    indent = this.getTokenIndent(impToken);
                }
            }
        }
        if (indent < 0) {
            indent = 0;
        }
        return indent;
    }

    public int findInlineSpacing(TokenItem token) {
        int additionalIndent = 0;
        TokenItem startToken = this.findLineStartToken(token);
        if (this.isFixedFormatLabel(startToken)) {
            additionalIndent = 4 - token.getImage().length();
            startToken = startToken.getNext();
        }
        TokenItem indentToken = this.findImportantToken(token, null, true);
        startToken = this.findLineStartToken(indentToken);
        while (this.isFixedFormatLineContinuation(startToken) || this.isPreprocessor(startToken) || startToken.getTokenID() == FTokenContext.KW_ENTRY) {
            indentToken = this.findImportantToken(startToken, null, true);
            startToken = this.findLineStartToken(indentToken);
        }
        while (this.isFixedFormatLabel(startToken) || startToken.getTokenID() == FTokenContext.WHITESPACE) {
            startToken = startToken.getNext();
        }
        while (this.isFixedFormatLineContinuation(token) || this.isFixedFormatLabel(token) || token.getTokenID() == FTokenContext.WHITESPACE) {
            token = token.getNext();
        }
        if (token.getTokenID() == FTokenContext.KW_SUBROUTINE || token.getTokenID() == FTokenContext.KW_ENTRY || token.getTokenID() == FTokenContext.KW_FUNCTION) {
            return 6;
        }
        if (token.getImage().length() > 2 && token.getImage().substring(0, 3).equalsIgnoreCase("end") || token.getTokenID() == FTokenContext.KW_ELSE || token.getTokenID() == FTokenContext.KW_ELSEIF) {
            additionalIndent -= this.getShiftWidth();
        }
        FormatTokenPosition tp1 = this.getPosition(startToken, 0);
        return Math.max(6, this.getVisualColumnOffset(tp1) + additionalIndent);
    }

    public FormatTokenPosition indentLine(FormatTokenPosition pos) {
        int indent = 0;
        FormatTokenPosition firstNWS = this.findLineFirstNonWhitespace(pos);
        if (firstNWS != null) {
            if (!this.isFixedFormatComment(firstNWS.getToken()) && !this.isPreprocessor(firstNWS.getToken())) {
                if (this.isFreeFormatComment(firstNWS.getToken())) {
                    indent = this.findIndent(firstNWS.getToken());
                } else if (this.isFixedFormatLabel(firstNWS.getToken())) {
                    TokenItem nexToken = firstNWS.getToken().getNext();
                    while (nexToken.getTokenID() == this.getWhitespaceTokenID()) {
                        TokenItem nt = nexToken.getNext();
                        this.removeToken(nexToken);
                        nexToken = nt;
                    }
                    indent = this.findInlineSpacing(firstNWS.getToken());
                    for (int i = 0; i < indent - 5; ++i) {
                        this.insertToken(nexToken, this.getValidWhitespaceTokenID(), this.getValidWhitespaceTokenContextPath(), " ");
                    }
                    indent = 1;
                } else if (this.isFixedFormatLineContinuation(firstNWS.getToken())) {
                    TokenItem nexToken = firstNWS.getToken().getNext();
                    while (nexToken.getTokenID() == this.getWhitespaceTokenID()) {
                        TokenItem nt = nexToken.getNext();
                        this.removeToken(nexToken);
                        nexToken = nt;
                    }
                    indent = this.findInlineSpacing(firstNWS.getToken());
                    for (int i = 0; i < indent - 5; ++i) {
                        this.insertToken(nexToken, this.getValidWhitespaceTokenID(), this.getValidWhitespaceTokenContextPath(), " ");
                    }
                    indent = 5;
                } else if (!this.getFreeFormat() && pos.getToken().getTokenID() == FTokenContext.KW_SUBROUTINE || pos.getToken().getTokenID() == FTokenContext.KW_ENTRY || pos.getToken().getTokenID() == FTokenContext.KW_FUNCTION) {
                    indent = 6;
                } else {
                    indent = this.findIndent(firstNWS.getToken());
                    if (!this.getFreeFormat() && indent < 6) {
                        indent = 6;
                    }
                }
            }
        } else {
            TokenItem token = pos.getToken();
            if (token == null && (token = this.findLineStart(pos).getToken()) == null) {
                token = this.getLastToken();
            }
            indent = this.findIndent(pos.getToken());
        }
        return this.changeLineIndent(pos, indent);
    }

    public boolean getFreeFormat() {
        return CppSettings.getDefault().isFreeFormatFortran();
    }
}

