/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpp.builds;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.windows.WindowManager;

public class TargetEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private JList targetList = null;
    private Vector listData = new Vector();
    private Timer isVisibleTimer;
    private JDialog dialog = null;
    private JButton okButton;
    private JButton cancelButton;
    private int returnValue = 0;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private JButton addButton;
    private JPanel controlsPanel;
    private JPanel dataPanel;
    private JButton downButton;
    private JButton editButton;
    private JLabel listLabel;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JButton upButton;

    public TargetEditor(String[] targets) {
        this.initComponents();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle");
        this.addButton.setMnemonic(bundle.getString("TARGET_EDITOR_ADD_BUTTON_MNEMONIC").toCharArray()[0]);
        this.editButton.setMnemonic(bundle.getString("TARGET_EDITOR_CHANGE_BUTTON_MNEMONIC").toCharArray()[0]);
        this.removeButton.setMnemonic(bundle.getString("TARGET_EDITOR_REMOVE_BUTTON_MNEMONIC").toCharArray()[0]);
        this.upButton.setMnemonic(bundle.getString("TARGET_EDITOR_UP_BUTTON_MNEMONIC").toCharArray()[0]);
        this.downButton.setMnemonic(bundle.getString("TARGET_EDITOR_DOWN_BUTTON_MNEMONIC").toCharArray()[0]);
        for (int i = 0; i < targets.length; ++i) {
            this.listData.add(targets[i]);
        }
        this.targetList = new JList();
        this.targetList.setListData(this.listData);
        this.targetList.addListSelectionListener(new TargetSelectionListener());
        this.targetList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                TargetEditor.this.targetListKeyPressed(evt);
            }
        });
        this.scrollPane.setViewportView(this.targetList);
        this.listLabel.setLabelFor(this.targetList);
        this.checkSelection();
        this.initAccessibility();
        this.isVisibleTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (TargetEditor.this.addButton.isVisible()) {
                    if (TargetEditor.this.targetList.getModel().getSize() > 0) {
                        TargetEditor.this.targetList.setSelectedIndex(0);
                        TargetEditor.this.targetList.requestFocus();
                    } else {
                        TargetEditor.this.addButton.requestFocus();
                    }
                    TargetEditor.this.isVisibleTimer.stop();
                }
            }
        });
        this.isVisibleTimer.start();
    }

    private void initAccessibility() {
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle");
        AccessibleContext context = this.getAccessibleContext();
        context.setAccessibleName(bundle.getString("ACSN_TARGET_EDITOR"));
        context.setAccessibleDescription(bundle.getString("ACSD_TARGET_EDITOR"));
        context = this.targetList.getAccessibleContext();
        context.setAccessibleName(bundle.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(bundle.getString("ACSD_TARGET_LIST"));
        context = this.scrollPane.getAccessibleContext();
        context.setAccessibleName(bundle.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(bundle.getString("ACSD_TARGET_LIST"));
        context = this.scrollPane.getHorizontalScrollBar().getAccessibleContext();
        context.setAccessibleName(bundle.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(bundle.getString("ACSD_TARGET_LIST"));
        context = this.scrollPane.getVerticalScrollBar().getAccessibleContext();
        context.setAccessibleName(bundle.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(bundle.getString("ACSD_TARGET_LIST"));
        this.addButton.getAccessibleContext().setAccessibleDescription(this.addButton.getText());
        this.editButton.getAccessibleContext().setAccessibleDescription(this.editButton.getText());
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.removeButton.getText());
        this.upButton.getAccessibleContext().setAccessibleDescription(this.upButton.getText());
        this.downButton.getAccessibleContext().setAccessibleDescription(this.downButton.getText());
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.listLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.controlsPanel = new JPanel();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new BorderLayout());
        this.setRequestFocusEnabled(false);
        this.dataPanel.setLayout(new GridBagLayout());
        this.dataPanel.setRequestFocusEnabled(false);
        this.listLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle").getString("TARGET_EDITOR_LIST_MNEMONIC").charAt(0));
        this.listLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle").getString("TARGET_EDITOR_LIST_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 10, 0, 0);
        this.dataPanel.add((Component)this.listLabel, gridBagConstraints);
        this.scrollPane.setBackground(new Color(255, 255, 255));
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.dataPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.controlsPanel.setLayout(new GridBagLayout());
        this.controlsPanel.setRequestFocusEnabled(false);
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle").getString("TARGET_EDITOR_ADD_BUTTON_LBL"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetEditor.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.controlsPanel.add((Component)this.addButton, gridBagConstraints);
        this.editButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle").getString("TARGET_EDITOR_CHANGE_BUTTON_LBL"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetEditor.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.controlsPanel.add((Component)this.editButton, gridBagConstraints);
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle").getString("TARGET_EDITOR_REMOVE_BUTTON_LBL"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.controlsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.upButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle").getString("TARGET_EDITOR_UP_BUTTON_LBL"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetEditor.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.controlsPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle").getString("TARGET_EDITOR_DOWN_BUTTON_LBL"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetEditor.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.controlsPanel.add((Component)this.downButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.dataPanel.add((Component)this.controlsPanel, gridBagConstraints);
        this.add((Component)this.dataPanel, "Center");
    }

    private void targetListKeyPressed(KeyEvent evt) {
        this.processKeyEvent(evt);
    }

    private void handleEscape(KeyEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        if (evt.getKeyChar() == '\u001b') {
            evt.consume();
            this.closeAction(this.dialog, 1);
        }
    }

    private void editAction() {
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle");
        NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine("", bundle.getString("TARGET_DIALOG_TITLE"));
        int selectedIndex = this.targetList.getSelectedIndex();
        notifyDescriptor.setInputText((String)this.listData.elementAt(selectedIndex));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
        if (notifyDescriptor.getValue() == NotifyDescriptor.OK_OPTION && notifyDescriptor.getInputText().length() > 0) {
            Object tmp = this.listData.elementAt(selectedIndex);
            this.listData.removeElementAt(selectedIndex);
            this.listData.add(selectedIndex, notifyDescriptor.getInputText());
            this.targetList.setListData(this.listData);
            this.targetList.setSelectedIndex(selectedIndex);
        }
        this.checkSelection();
        if (this.dialog != null) {
            this.dialog.show();
        }
        this.editButton.requestFocus();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.editAction();
    }

    private void downAction() {
        int selectedIndex = this.targetList.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        if (selectedIndex >= this.listData.size() - 1) {
            return;
        }
        Object tmp = this.listData.elementAt(selectedIndex);
        this.listData.removeElementAt(selectedIndex);
        this.listData.add(++selectedIndex, tmp);
        this.targetList.setListData(this.listData);
        if (selectedIndex >= 0) {
            this.targetList.ensureIndexIsVisible(selectedIndex);
            this.targetList.setSelectedIndex(selectedIndex);
        }
        this.checkSelection();
        if (this.dialog != null) {
            this.dialog.show();
        }
        if (this.downButton.isEnabled()) {
            this.downButton.requestFocus();
        } else {
            this.upButton.requestFocus();
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.downAction();
    }

    private void upAction() {
        int selectedIndex = this.targetList.getSelectedIndex();
        if (selectedIndex <= 0) {
            return;
        }
        Object tmp = this.listData.elementAt(selectedIndex);
        this.listData.removeElementAt(selectedIndex);
        this.listData.add(--selectedIndex, tmp);
        this.targetList.setListData(this.listData);
        if (selectedIndex >= 0) {
            this.targetList.ensureIndexIsVisible(selectedIndex);
            this.targetList.setSelectedIndex(selectedIndex);
        }
        this.checkSelection();
        if (this.dialog != null) {
            this.dialog.show();
        }
        if (this.upButton.isEnabled()) {
            this.upButton.requestFocus();
        } else {
            this.downButton.requestFocus();
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.upAction();
    }

    private void removeAction() {
        int selectedIndex = this.targetList.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.listData.removeElementAt(selectedIndex);
        this.targetList.setListData(this.listData);
        int n = selectedIndex = selectedIndex >= this.listData.size() ? selectedIndex - 1 : selectedIndex;
        if (selectedIndex >= 0) {
            this.targetList.ensureIndexIsVisible(selectedIndex);
            this.targetList.setSelectedIndex(selectedIndex);
        }
        this.checkSelection();
        if (this.dialog != null) {
            this.dialog.show();
        }
        if (this.removeButton.isEnabled()) {
            this.removeButton.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeAction();
    }

    private void addAction() {
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle");
        NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine("", bundle.getString("TARGET_DIALOG_TITLE"));
        int addAtIndex = 0;
        int selectedIndex = this.targetList.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex <= this.listData.size() - 1) {
            addAtIndex = selectedIndex + 1;
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
        if (notifyDescriptor.getValue() == NotifyDescriptor.OK_OPTION && notifyDescriptor.getInputText() != null && notifyDescriptor.getInputText().length() > 0) {
            this.listData.add(addAtIndex, notifyDescriptor.getInputText());
            this.targetList.setListData(this.listData);
            this.targetList.setSelectedIndex(addAtIndex);
        }
        this.addButton.requestFocus();
        this.checkSelection();
        if (this.dialog != null) {
            this.dialog.show();
        }
        this.addButton.requestFocus();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addAction();
    }

    private void checkSelection() {
        int i = this.targetList.getSelectedIndex();
        if (i >= 0) {
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
            if (i == 0) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
            if (i >= this.listData.size() - 1) {
                this.downButton.setEnabled(false);
            } else {
                this.downButton.setEnabled(true);
            }
        } else {
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public String getTargets() {
        String targets = null;
        for (int i = 0; i < this.targetList.getModel().getSize(); ++i) {
            targets = i == 0 ? (String)this.targetList.getModel().getElementAt(0) : targets + ", " + this.targetList.getModel().getElementAt(i);
        }
        return targets;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getTargets();
    }

    private void closeAction(JDialog dialog, int ret) {
        if (dialog != null) {
            dialog.setVisible(false);
            dialog.dispose();
            this.returnValue = ret;
        }
    }

    public int showOpenDialog(JFrame parent) {
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cpp/builds/Bundle");
        this.dialog = new JDialog((Frame)parent, true);
        this.dialog.getContentPane().add(this);
        this.dialog.setTitle(bundle.getString("TARGET_EDITOR_TITLE"));
        AccessibleContext context = this.dialog.getAccessibleContext();
        context.setAccessibleName(bundle.getString("ACSN_TARGET_EDITOR"));
        context.setAccessibleDescription(bundle.getString("ACSD_TARGET_EDITOR"));
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                TargetEditor.this.handleEscape(evt);
            }
        };
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.okButton.setText(bundle.getString("TARGET_EDITOR_OK_BUTTON_LBL"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetEditor.this.closeAction(TargetEditor.this.dialog, 0);
            }
        });
        this.okButton.getAccessibleContext().setAccessibleDescription(this.okButton.getText());
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.setText(bundle.getString("TARGET_EDITOR_CANCEL_BUTTON_LBL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetEditor.this.closeAction(TargetEditor.this.dialog, 1);
            }
        });
        this.cancelButton.getAccessibleContext().setAccessibleDescription(this.cancelButton.getText());
        this.okButton.addKeyListener(keyListener);
        this.cancelButton.addKeyListener(keyListener);
        this.addButton.addKeyListener(keyListener);
        this.editButton.addKeyListener(keyListener);
        this.removeButton.addKeyListener(keyListener);
        this.upButton.addKeyListener(keyListener);
        this.downButton.addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        buttonPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 0, 10, 10);
        gridBagConstraints.anchor = 13;
        this.dataPanel.add((Component)buttonPanel, gridBagConstraints);
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.dialog.pack();
        this.dialog.setLocation(this.findScreenCenter(this.dialog));
        this.dialog.show();
        return this.returnValue;
    }

    private Point findScreenCenter(JDialog dialog) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int x = toolkit.getScreenSize().width / 2 - dialog.getHeight() / 2;
        int y = toolkit.getScreenSize().height / 2 - dialog.getWidth() / 2;
        return new Point(x, y);
    }

    public static void main(String[] args) {
        String[] targets = new String[]{"111", "222", "333"};
        TargetEditor targetFileEditor = new TargetEditor(targets);
        int ret = targetFileEditor.showOpenDialog((JFrame)WindowManager.getDefault().getMainWindow());
        System.out.println("ret = " + ret);
        System.out.println(targetFileEditor.getTargets());
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            TargetEditor.this.checkSelection();
        }
    }
}

