/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.utils;

import com.sun.tools.swdev.common.base.PasswordEntry;
import com.sun.tools.swdev.common.base.Stat;
import com.sun.tools.swdev.common.base.UnixEnv;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class IpeUtils {
    private static WeakReference wrEnv;
    private static final int TRACEFUNC = 1;
    private static final int ASSERTS = 2;
    private static final int STATUSMSG = 4;
    private static final int TMPMSG = 8;
    private static final int debugstate = 0;
    public static final boolean debugmsg = false;
    public static final boolean tmpmsg = false;
    public static final boolean trace = false;
    public static final boolean asserts = false;
    public static final boolean IfdefDebug;
    public static final boolean IfdefDiagnostics;
    private static String prevfilename;
    private static FileObject prevfo;
    private static FileChangeAdapter fcl;
    private static HashMap fstab;
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$utils$IpeUtils;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$util$HelpCtx;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;

    public static final Line lineNumberToLine(DataObject dao, int lineNumber) throws Exception {
        Line l;
        Line.Set ls;
        LineCookie lc = (LineCookie)dao.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = IpeUtils.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
        if (lc != null && (ls = lc.getLineSet()) != null && (l = ls.getOriginal(lineNumber - 1)) != null) {
            return l;
        }
        throw new Exception();
    }

    public static final boolean isLinux() {
        return System.getProperty("os.name", "").toLowerCase().indexOf("linux") >= 0;
    }

    public static final void ensure(boolean condition) {
        if (!condition) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                ErrorManager.getDefault().log("Assertion Failed.");
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public static final String normalizePath(String path) {
        try {
            File file = new File(path);
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static final String getDirName(String path) {
        int sep = path.lastIndexOf(File.separatorChar);
        if (sep != -1) {
            return path.substring(0, sep);
        }
        return null;
    }

    public static final String getBaseName(String path) {
        int sep = path.lastIndexOf(File.separatorChar);
        if (sep != -1) {
            return path.substring(sep + 1);
        }
        return path;
    }

    public static final String getRelativePath(String base, String path) {
        String pstring;
        String bstring;
        if (path.equals(base)) {
            return new String(path);
        }
        if (path.startsWith(base + File.separator)) {
            return new String(path.substring(base.length() + 1));
        }
        if (!path.startsWith(File.separator)) {
            return new String(path);
        }
        Object[] bnames = IpeUtils.getPathNameArray(base);
        Object[] pnames = IpeUtils.getPathNameArray(path);
        int match = 0;
        for (int i = 0; i < bnames.length && (bstring = new String(bnames[i].toString())).equals(pstring = new String(pnames[i].toString())); ++i) {
            ++match;
        }
        if (match > 2) {
            StringBuffer s = new StringBuffer();
            for (int cnt = bnames.length - match; cnt > 0; --cnt) {
                s.append("../");
            }
            for (int i = match; i < pnames.length; ++i) {
                s.append(File.separator);
                s.append(pnames[i].toString());
            }
            return s.toString();
        }
        return new String(path);
    }

    private static final Object[] getPathNameArray(String path) {
        int pos = 1;
        ArrayList<String> l = new ArrayList<String>();
        if (path.startsWith(File.separator)) {
            while (pos > 0) {
                int next = path.indexOf(File.separatorChar, pos);
                if (next > 0) {
                    l.add(path.substring(pos, next));
                    pos = next + 1;
                    continue;
                }
                l.add(path.substring(pos));
                pos = -1;
            }
        }
        return l.toArray();
    }

    public static final String quoteIfNecessary(String s) {
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.charAt(0) == '\"' || s.charAt(n - 1) == '\"') {
            return s;
        }
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c != ' ' && c != '\t' && c != '*' && c != '[' && c != ']' && c != '.' && c != '(' && c != ')') continue;
            return '\"' + s + '\"';
        }
        return s;
    }

    public static String expandPath(String filename) {
        int beginIndex;
        int si;
        int max = filename.length();
        StringBuffer dp = new StringBuffer(256);
        for (si = 0; si < max && Character.isSpaceChar(filename.charAt(si)); ++si) {
        }
        if (si < max && filename.charAt(si) == '~') {
            if (si++ < max && (si == max || filename.charAt(si) == '/')) {
                dp.append(System.getProperty("user.home"));
            } else {
                PasswordEntry pent = new PasswordEntry();
                beginIndex = si;
                while (si < max && filename.charAt(si) != '/') {
                    ++si;
                }
                if (pent.fillFor(filename.substring(beginIndex, si))) {
                    dp.append(pent.getHomeDirectory());
                } else {
                    dp.append(filename.substring(beginIndex, si));
                }
            }
        }
        while (si < max) {
            int endIndex;
            char c;
            if ((c = filename.charAt(si++)) == '\\' && si < max) {
                if (filename.charAt(si) == '$') {
                    dp.append('\\');
                    dp.append('$');
                    ++si;
                    continue;
                }
                dp.append(c);
                continue;
            }
            if (c == '$' && si < max && filename.charAt(si) == '(') {
                endIndex = filename.indexOf(41, si);
                dp.append('$');
                if (endIndex > -1) {
                    dp.append(filename.substring(si, endIndex));
                    si = endIndex;
                    continue;
                }
                dp.append(filename.substring(si));
                si = max;
                continue;
            }
            if (c == '$' && si < max) {
                boolean braces;
                boolean bl = braces = filename.charAt(si) == '{';
                if (braces) {
                    // empty if block
                }
                beginIndex = ++si;
                while (si < max) {
                    char c2 = filename.charAt(si);
                    if (braces && c2 == '}' || !Character.isLetterOrDigit(c2) && c2 != '_') break;
                    ++si;
                }
                endIndex = si;
                if (si < max && braces) {
                    ++si;
                }
                if (endIndex > beginIndex) {
                    String value = IpeUtils.getenv(filename.substring(beginIndex, endIndex));
                    if (value != null) {
                        dp.append(value);
                        continue;
                    }
                    dp.append('$');
                    if (braces) {
                        dp.append('{');
                    }
                    dp.append(filename.substring(beginIndex, endIndex));
                    if (!braces) continue;
                    dp.append('}');
                    continue;
                }
                dp.append('$');
                if (!braces) continue;
                dp.append("{}");
                continue;
            }
            dp.append(c);
        }
        return dp.toString();
    }

    public static String getenv(String name) {
        return IpeUtils.getUnixEnv().getenv(name);
    }

    public static String valueOf(String name) {
        return IpeUtils.getenv(name);
    }

    public static String entryFor(String name) {
        return IpeUtils.getUnixEnv().entryFor(name);
    }

    public static void putenv(String entry) {
        IpeUtils.getUnixEnv().putenv(entry);
    }

    public static void setValueOf(String name, String value) {
        IpeUtils.getUnixEnv().setValueOf(name, value);
    }

    public static String[] environ() {
        return IpeUtils.getUnixEnv().environ();
    }

    public static void envDump() {
        IpeUtils.getUnixEnv().dump();
    }

    private static UnixEnv getUnixEnv() {
        UnixEnv env = wrEnv == null ? null : (UnixEnv)wrEnv.get();
        if (env == null) {
            env = new UnixEnv();
            wrEnv = new WeakReference<UnixEnv>(env);
        }
        return env;
    }

    public static final FileObject findFileObject(String fileName, boolean mount) {
        if (prevfilename != null && fileName.equals(prevfilename)) {
            return prevfo;
        }
        FileObject fo = CppUtils.findFileObject((String)fileName, (boolean)false);
        if (fo != null) {
            return fo;
        }
        int sep = fileName.lastIndexOf(File.separatorChar);
        if (sep == -1) {
            ErrorManager.getDefault().log("IpeUtils.findFileObject(\"" + fileName + "\"): you have to supply a full pathname!");
            return null;
        }
        String dir = fileName.substring(0, sep);
        String base = fileName.substring(sep + 1);
        int arraySize = 3;
        long[] devices = new long[arraySize];
        long[] inodes = new long[arraySize];
        File[] files = new File[arraySize];
        int used = 0;
        for (File path = new File(fileName); path != null; path = path.getParentFile()) {
            try {
                Stat s = new Stat(path.getPath());
                devices[used] = s.device();
                inodes[used] = s.inode();
                files[used] = path;
            }
            catch (IOException e) {
                break;
            }
            if (++used != arraySize) continue;
            int newSize = arraySize * 2;
            long[] newDevices = new long[newSize];
            long[] newInodes = new long[newSize];
            File[] newFiles = new File[newSize];
            for (int ij = 0; ij < arraySize; ++ij) {
                newDevices[ij] = devices[ij];
                newInodes[ij] = inodes[ij];
                newFiles[ij] = files[ij];
            }
            devices = newDevices;
            inodes = newInodes;
            files = newFiles;
            arraySize = newSize;
        }
        Enumeration enumeration = Repository.getDefault().fileSystems();
        boolean dirFound = false;
        block6: while (enumeration.hasMoreElements()) {
            String fsdir;
            FileSystem fs = (FileSystem)enumeration.nextElement();
            if (fs.isHidden() || (fsdir = CppUtils.getRootDirectory((FileSystem)fs)) == null) continue;
            Stat s = null;
            try {
                s = new Stat(fsdir);
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            long device = s.device();
            long inode = s.inode();
            for (int k = 0; k < used; ++k) {
                if (inode != inodes[k] || device != devices[k]) continue;
                dirFound = true;
                int full = files[0].getPath().length();
                int partial = files[k].getPath().length();
                String name = fileName.substring(partial + 1);
                fo = fs.findResource(name);
                continue block6;
            }
        }
        if (fo == null) {
            if (mount) {
                fo = CppUtils.findFileObject((String)fileName, (boolean)true);
            } else {
                return null;
            }
        }
        if (fo != null) {
            prevfilename = fileName;
            if (fcl != null) {
                prevfo.removeFileChangeListener((FileChangeListener)fcl);
            } else {
                fcl = new FileChangeAdapter(){

                    public void fileDeleted(FileEvent ev) {
                        prevfilename = null;
                        prevfo = null;
                        fcl = null;
                    }
                };
            }
            prevfo = fo;
            fo.addFileChangeListener((FileChangeListener)fcl);
        }
        return fo;
    }

    public static void showHelp(String id) {
        HelpCtx help = new HelpCtx(id);
        StatusDisplayer sd = StatusDisplayer.getDefault();
        sd.setStatusText(IpeUtils.getString(NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$utils$IpeUtils == null ? (class$com$sun$tools$debugger$dbxgui$utils$IpeUtils = IpeUtils.class$("com.sun.tools.debugger.dbxgui.utils.IpeUtils")) : class$com$sun$tools$debugger$dbxgui$utils$IpeUtils), (String)"CTL_OpeningHelp")));
        IpeUtils.showHelp(help);
        sd.setStatusText("");
    }

    private static void showHelp(HelpCtx help) {
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = IpeUtils.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        try {
            Class<?> c = cl.loadClass("org.netbeans.api.javahelp.Help");
            Object o = Lookup.getDefault().lookup(c);
            if (o != null) {
                Method m = c.getMethod("showHelp", class$org$openide$util$HelpCtx == null ? (class$org$openide$util$HelpCtx = IpeUtils.class$("org.openide.util.HelpCtx")) : class$org$openide$util$HelpCtx);
                m.invoke(o, help);
                return;
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        Toolkit.getDefaultToolkit().beep();
    }

    public static final String stringToXML(String s) {
        try {
            return XMLUtil.toAttributeValue((String)s);
        }
        catch (CharConversionException e) {
            e.printStackTrace();
            return s;
        }
    }

    public static void setLabelText(JLabel item, String text, boolean useMnemonic) {
        int i = text.indexOf(38);
        String newText = text;
        if (i < 0) {
            item.setText(text);
            if (useMnemonic) {
                item.setDisplayedMnemonic(0);
            }
        } else if (i == text.length() - 1) {
            item.setText(text.substring(0, i));
            if (useMnemonic) {
                item.setDisplayedMnemonic(0);
            }
        } else {
            item.setText(text.substring(0, i) + text.substring(i + 1));
            if (useMnemonic) {
                item.setDisplayedMnemonic(text.charAt(i + 1));
            }
        }
    }

    public static void addFocusSelector(JTextComponent jt) {
        jt.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                if (!evt.isTemporary()) {
                    ((JTextComponent)evt.getComponent()).selectAll();
                }
            }
        });
    }

    public static void removeFocusSelector(JTextComponent jt) {
        jt.removeFocusListener(new FocusAdapter(){});
    }

    public static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = IpeUtils.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    public static String trimpath(String dir) {
        int trim = 0;
        dir = dir.trim();
        for (int i = dir.length(); i > 0 && dir.charAt(i - 1) == File.separatorChar; --i) {
            ++trim;
        }
        if (trim > 0) {
            return dir.substring(0, dir.length() - trim);
        }
        return dir;
    }

    public static int boolCompare(boolean x, boolean y) {
        if (x == y) {
            return 0;
        }
        if (x) {
            return 1;
        }
        return -1;
    }

    public static boolean sameString(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static void requestFocus(final Component c) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (c != null && c.getParent() != null) {
                    try {
                        c.requestFocus();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void correctJTableActionMap(final JTable table) {
        InputMap map = table.getInputMap(1);
        ActionMap am = table.getActionMap();
        if (map != null && am != null) {
            Action action;
            Object binding = map.get(KeyStroke.getKeyStroke(27, 0));
            Action action2 = action = binding == null ? null : am.get(binding);
            if (action != null) {
                AbstractAction aa = new AbstractAction(){

                    public void actionPerformed(ActionEvent event) {
                        action.actionPerformed(event);
                    }

                    public boolean isEnabled() {
                        return table.isEditing();
                    }
                };
                am.put(binding, aa);
            }
        }
    }

    public static String getString(String key) {
        return NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$utils$IpeUtils == null ? (class$com$sun$tools$debugger$dbxgui$utils$IpeUtils = IpeUtils.class$("com.sun.tools.debugger.dbxgui.utils.IpeUtils")) : class$com$sun$tools$debugger$dbxgui$utils$IpeUtils), (String)key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IfdefDebug = Boolean.getBoolean("ifdef.debug");
        IfdefDiagnostics = Boolean.getBoolean("ifdef.debug.diagnostics");
        prevfilename = null;
        prevfo = null;
        fcl = null;
        fstab = new HashMap();
    }
}

