/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.utils;

import com.sun.tools.debugger.dbxgui.utils.FortranReader;
import com.sun.tools.debugger.dbxgui.utils.UnexpectedEOFException;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class FortranParser {
    private FortranReader in;
    private boolean verbose = false;

    public FortranParser(String file, String options, boolean verbose, boolean verboseReader) {
        this.verbose = verbose;
        try {
            this.in = new FortranReader(file, options, verboseReader);
        }
        catch (FileNotFoundException ex) {
            this.in = null;
        }
    }

    public FortranParser(String file, String options) {
        this(file, options, false, false);
    }

    public ArrayList parser() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.in == null) {
            return null;
        }
        try {
            String line;
            while ((line = this.in.getStatement()) != null) {
                String arg;
                if (line.length() >= 15 && line.substring(0, 15).equalsIgnoreCase("moduleprocedure")) continue;
                if (line.length() >= 6 && line.substring(0, 6).equalsIgnoreCase("module")) {
                    arg = this.getName(line.substring(6));
                    list.add("M" + arg);
                    continue;
                }
                if (line.length() < 3 || !line.substring(0, 3).equalsIgnoreCase("use")) continue;
                arg = this.getName(line.substring(3));
                list.add("U" + arg);
            }
        }
        catch (UnexpectedEOFException ex) {
            if (this.verbose) {
                System.err.println("Error: Unexpected EOF");
                ex.printStackTrace();
            }
            return null;
        }
        return list;
    }

    private String getName(String arg) {
        char c;
        StringBuffer buf = new StringBuffer();
        String arg2 = arg.trim();
        for (int i = 0; i < arg2.length() && ((c = arg2.charAt(i)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_'); ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        FortranParser parser = null;
        boolean verbose = false;
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            file = args[i];
        }
        parser = new FortranParser(file, null);
        parser.verbose = verbose;
        ArrayList list = parser.parser();
        System.out.println("FortranParser: list has " + list.size() + " elements");
        for (int i = 0; i < list.size(); ++i) {
            String stmnt = list.get(i).toString();
            if (stmnt.charAt(0) == 'M') {
                System.out.println("\tModule " + stmnt.substring(1));
                continue;
            }
            System.out.println("\tUse " + stmnt.substring(1));
        }
    }
}

