/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.props;

import com.sun.tools.debugger.dbxgui.debugger.breakpoints.SystemInfo;
import com.sun.tools.debugger.dbxgui.props.EnhancedAsyncEditor;
import com.sun.tools.debugger.dbxgui.props.PropFactory;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import java.beans.FeatureDescriptor;
import java.util.Vector;
import org.openide.explorer.propertysheet.PropertyEnv;

public class SystemEditor
extends EnhancedAsyncEditor {
    protected Vector items;
    protected SystemInfo si;
    private String[] tags;

    protected String[] makeTags(Vector items) {
        if (items == null) {
            return new String[0];
        }
        String[] tags = new String[items.size()];
        for (int tx = 0; tx < items.size(); ++tx) {
            tags[tx] = (String)items.elementAt(tx);
        }
        return tags;
    }

    public String[] getTags() {
        if (this.tags == null) {
            this.si.fill();
            this.tags = this.makeTags(this.items);
        }
        return this.tags;
    }

    public void setAsText(String newText) {
        newText = newText.trim();
        this.notePending(newText);
        if (IpeUtils.sameString(newText, this.si.all())) {
            newText = null;
        }
        this.setValue(newText);
    }

    public String getAsText() {
        String text = super.getAsText();
        if (text == null || text.length() == 0) {
            text = this.si.all();
        }
        return text;
    }

    public static class Subcodes
    extends SystemEditor {
        private Vector actual;
        private SystemInfo.Subcodes si_subcodes;

        public Subcodes() {
            this.items = new Vector(20);
            this.si_subcodes = new SystemInfo.Subcodes(this.items);
            this.si = this.si_subcodes;
            this.si.fill();
        }

        public void subcodesFor(String sig) {
            this.actual = this.si_subcodes.subcodesFor(sig);
        }

        public String[] getTags() {
            String[] tags = this.makeTags(this.actual);
            return tags;
        }

        public void attachEnv(PropertyEnv env) {
            super.attachEnv(env);
            FeatureDescriptor desc = env.getFeatureDescriptor();
            if (desc instanceof PropFactory.Reflection) {
                PropFactory.Reflection prop = (PropFactory.Reflection)((Object)desc);
                this.subcodesFor(prop.getParam());
            }
        }
    }

    public static class Signals
    extends SystemEditor {
        public Signals() {
            this.items = new Vector(20);
            this.si = new SystemInfo.Signals(this.items);
        }
    }

    public static class Syscalls
    extends SystemEditor {
        public Syscalls() {
            this.items = new Vector(250);
            this.si = new SystemInfo.Syscalls(this.items);
        }
    }

    public static class Faults
    extends SystemEditor {
        public Faults() {
            this.items = new Vector(20);
            this.si = new SystemInfo.Faults(this.items);
        }
    }
}

