/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.props;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import org.openide.ErrorManager;

public class AsyncEditor
extends PropertyEditorSupport {
    private String pending = null;

    public AsyncEditor() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AsyncEditor.this.clearPending();
            }
        });
    }

    private void clearPending() {
        this.pending = null;
    }

    protected void notePending(String newText) {
        this.pending = newText;
    }

    protected void badValue(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 256, "The other message", null, null, null);
        throw iae;
    }

    public void setAsText(String newText) {
        this.setValue(newText);
        this.notePending(newText);
    }

    public String getAsText() {
        String str;
        if (this.pending != null) {
            return this.pending;
        }
        Object o = this.getValue();
        if (o != null && (str = o.toString()) != null) {
            return str;
        }
        return "";
    }
}

