/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.nodes;

import com.sun.tools.debugger.dbxgui.debugger.DbxVariable;
import com.sun.tools.debugger.dbxgui.debugger.Variable;
import com.sun.tools.debugger.dbxgui.nodes.DbxTreeView;
import com.sun.tools.debugger.dbxgui.props.PropFactory;
import com.sun.tools.debugger.dbxgui.props.VariableValue;
import com.sun.tools.debugger.dbxgui.utils.Log;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.support.nodes.TreeTableExplorerViewSupport;
import org.openide.debugger.DebuggerException;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class DbxVariableNode
extends AbstractNode {
    private Variable var;
    private Listener listener;
    private static Children childrenP;
    private TreeTableExplorerViewSupport view;
    protected ChildrenPromise children;
    private static String ICON_PATH;

    private static Children leaves(Variable var, TreeTableExplorerViewSupport view) {
        if (var.isLeaf()) {
            return Children.LEAF;
        }
        return new ChildrenPromise(var, view);
    }

    public DbxVariableNode(AbstractVariable var, TreeTableExplorerViewSupport view) {
        childrenP = DbxVariableNode.leaves((Variable)var, view);
        super(childrenP);
        this.children = null;
        this.children = childrenP == Children.LEAF ? null : (ChildrenPromise)childrenP;
        this.var = (Variable)var;
        this.view = view;
        this.listener = new Listener(this);
        this.createProperties();
        this.updateProps();
        if (view != null) {
            new DbxTreeView((TreeView)view.myTreeTable);
        }
        this.expandTree();
    }

    private void expandTree() {
        if (((DbxVariable)this.var).isExpanded() && ((DbxVariable)this.var).isPtr()) {
            ((DbxVariable)this.var).requestChildren();
        }
    }

    private void updateProps() {
        Log.prf(1);
        this.setName(this.var.getVariableName());
        if (this.var.isLeaf()) {
            this.setIconBase(ICON_PATH + "Primitive");
        } else {
            this.setIconBase(ICON_PATH + "Pointers");
        }
        this.firePropertyChange(null, null, null);
    }

    private void updateChildren() {
        Log.prf(1);
        LinkedList<AbstractVariable> list = new LinkedList<AbstractVariable>();
        for (int vx = 0; vx < this.var.getVariables().length; ++vx) {
            list.add(this.var.getVariables()[vx]);
        }
        if (this.children != null) {
            this.children.mySetKeys(list);
        }
    }

    private void createProperties() {
        PropFactory pf = new PropFactory((Object)this, null);
        DbxVariable v = (DbxVariable)this.var;
        String assign_str = v.getAssignStr();
        boolean isptr = v.isPtr();
        pf.addString("variableName", "PROP_watch_name", "HINT_watch_name", "getVariableName", null);
        pf.addString("declaredType", "PROP_watch_type", "HINT_watch_type", "getVariableType", null);
        pf.addString("type", "PROP_watch_type", "HINT_watch_type", "getVariableAType", null);
        pf.addVariableValue("asText", "PROP_watch_value", "HINT_watch_value", "getVariableValue", assign_str != null || isptr ? "setVariableValue" : null);
        this.setSheet(pf.getSheet());
    }

    public TreeTableExplorerViewSupport getView() {
        return this.view;
    }

    public Variable getVariable() {
        return this.var;
    }

    public void setVariableValue(Object o) {
        String newValue = null;
        if (o instanceof VariableValue) {
            VariableValue vv = (VariableValue)o;
            newValue = vv.text;
        } else {
            newValue = o.toString();
        }
        try {
            this.var.setAsText(newValue);
            ((DbxVariable)this.var).setVariableValue(newValue);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    public String getVariableName() {
        return this.var.getVariableName();
    }

    public Object getVariableValue() {
        return new VariableValue(this.var.getAsText(), ((DbxVariable)this.var).getDelta());
    }

    public String getVariableType() {
        return this.var.getType();
    }

    public String getVariableAType() {
        return ((DbxVariable)this.var).getAType();
    }

    static {
        ICON_PATH = "com/sun/tools/debugger/dbxgui/icons/";
    }

    private static final class ChildrenPromise
    extends Children.Keys
    implements PropertyChangeListener {
        private Variable var;
        private TreeTableExplorerViewSupport view;

        ChildrenPromise(Variable var, TreeTableExplorerViewSupport view) {
            this.var = var;
            this.view = view;
        }

        protected Node[] createNodes(Object key) {
            Log.prf(1, "NOT IMPLEMENTED");
            Variable v = (Variable)key;
            return new Node[]{new DbxVariableNode(v, this.view)};
        }

        protected void addNotify() {
            Log.prf(1, "NOT IMPLEMENTED");
            this.var.requestChildren();
        }

        protected void removeNotify() {
            Log.prf(1, "NOT IMPLEMENTED");
        }

        void mySetKeys(Collection keys) {
            this.setKeys(keys);
        }

        void removeAllVariables() {
            AbstractVariable[] variables = this.var.getVariables();
            if (variables.length < 1) {
                return;
            }
            Node[] nn = new Node[variables.length];
            nn = (Node[])variables;
            this.remove(nn);
        }

        public void propertyChange(PropertyChangeEvent ev) {
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private DbxVariableNode node;

        Listener(DbxVariableNode n) {
            this.node = n;
            Variable var = n.var;
            var.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "variables") {
                this.node.updateChildren();
                TreeTableExplorerViewSupport tview = this.node.getView();
                if (tview != null && ((DbxVariable)this.node.var).isExpanded()) {
                    tview.myTreeTable.expandNode((Node)this.node);
                }
            } else {
                this.node.updateProps();
            }
        }
    }
}

