/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.nodes;

import com.sun.tools.debugger.dbxgui.debugger.IpeThread;
import com.sun.tools.debugger.dbxgui.props.PropFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.NodesRegistry;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.actions.SwitchOnCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class DbxThreadNode
extends AbstractNode
implements SwitchOnCookie {
    private CoreDebugger coreDebugger;
    private AbstractDebugger debugger;
    private final IpeThread thread;
    private ThreadListener threadListener;
    private int state = 4;
    private boolean oldSuspended = false;
    protected static String ICON_PATH = "org/netbeans/modules/debugger/resources";
    protected static String ICON_CURRENT = ICON_PATH + "/threadsView/CurrentThread";
    protected static String ICON_RUNNING = ICON_PATH + "/threadsView/RunningThread";
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$nodes$DbxThreadNode;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$SwitchOnAction;

    public DbxThreadNode(AbstractThread thread, AbstractDebugger debugger) {
        this(thread, debugger, true);
    }

    public DbxThreadNode(AbstractThread thread, AbstractDebugger debugger, boolean showSubNodes) {
        super((Children)(showSubNodes ? new DbxThreadChildren() : Children.LEAF));
        this.thread = (IpeThread)thread;
        this.debugger = debugger;
        this.coreDebugger = Register.getCoreDebugger();
        this.setName();
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
        this.threadListener = new ThreadListener(this);
    }

    static String getLocalizedString(String s) {
        return NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$nodes$DbxThreadNode == null ? (class$com$sun$tools$debugger$dbxgui$nodes$DbxThreadNode = DbxThreadNode.class$("com.sun.tools.debugger.dbxgui.nodes.DbxThreadNode")) : class$com$sun$tools$debugger$dbxgui$nodes$DbxThreadNode), (String)s);
    }

    private void createProperties() {
        PropFactory pf = new PropFactory((Object)this, (Object)this.thread);
        pf.addString("threadState", "PROP_thread_state", "HINT_thread_state", "getState", null);
        pf.addBoolean("threadSuspended", "PROP_thread_suspended", "HINT_thread_suspended", "getSuspended", null);
        pf.addIntegerClass("priority", "PROP_priority", "HINT_priority", "getPriority", null);
        pf.addObject("LWP", "PROP_lwp", "HINT_lwp", "getLWP", null);
        pf.addString("startupFlags", "PROP_startup_flags", "HINT_startup_flags", "getStartupFlags", null);
        pf.addString("executingFunction", "PROP_executing_function", "HINT_executing_function", "getCurrentFunction", null);
        pf.addString("startFunction", "PROP_start_function", "HINT_start_function", "getStartFunction", null);
        pf.addObject("address", "PROP_address", "HINT_address", "getAddress", null);
        pf.addIntegerClass("size", "PROP_size", "HINT_size", "getStackSize", null);
        this.setSheet(pf.getSheet());
    }

    void changeProperties() {
        this.setName();
        this.firePropertyChange(null, null, null);
    }

    void setName() {
        String s = this.thread.getName();
        this.setDisplayName(s);
        this.setName(s);
        if (this.thread.isCurrent()) {
            this.setIconBase(ICON_CURRENT);
        } else {
            this.setIconBase(ICON_RUNNING);
        }
    }

    AbstractThread getDebuggerThread() {
        return this.thread;
    }

    public boolean canSetCurrent() {
        return !this.thread.isCurrent();
    }

    public void setCurrent() {
        this.thread.setCurrent(true);
    }

    public SystemAction[] getActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnAction = DbxThreadNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnAction))};
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchOnAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchOnAction = DbxThreadNode.class$("org.netbeans.modules.debugger.support.actions.SwitchOnAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchOnAction));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Refreshable {
        public void refresh();
    }

    private static final class DbxThreadChildren
    extends Children.Keys {
        private boolean initialized = false;

        private DbxThreadChildren() {
        }

        protected void addNotify() {
            this.initialized = true;
            IpeThread thread = ((DbxThreadNode)this.getNode()).thread;
            LinkedList<String> l = new LinkedList<String>();
            if (thread instanceof VariablesProducer) {
                l.add("localsNode");
            }
            if (thread instanceof CallStackProducer) {
                l.add("callStackNode");
            }
            this.setKeys(l);
        }

        protected void removeNotify() {
            this.initialized = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            IpeThread thread = ((DbxThreadNode)this.getNode()).thread;
            Node node = NodesRegistry.getNode((Object)key, (Object[])new Object[]{thread});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        void refreshAll() {
            if (!this.initialized) {
                return;
            }
            Node[] ns = this.getNodes();
            int k = ns.length;
            for (int i = 0; i < k; ++i) {
                if (!(ns[i] instanceof Refreshable)) continue;
                ((Refreshable)ns[i]).refresh();
            }
        }
    }

    private static class ThreadListener
    implements PropertyChangeListener {
        private WeakReference node;
        private CoreDebugger coreDebugger;
        private AbstractThread thread;

        ThreadListener(DbxThreadNode n) {
            this.node = new WeakReference<DbxThreadNode>(n);
            this.coreDebugger = n.coreDebugger;
            this.thread = n.thread;
            this.thread.addPropertyChangeListener((PropertyChangeListener)this);
            this.coreDebugger.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            DbxThreadNode tn = (DbxThreadNode)((Object)this.node.get());
            if (tn == null) {
                this.coreDebugger.removePropertyChangeListener((PropertyChangeListener)this);
                this.thread.removePropertyChangeListener((PropertyChangeListener)this);
                return;
            }
            if (e.getSource() == this.coreDebugger && e.getPropertyName() != "currentDebugger") {
                return;
            }
            tn.changeProperties();
        }
    }
}

