/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.options;

import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.options.BaseOptionUI;
import com.sun.tools.debugger.dbxgui.debugger.options.CheckBoxOptionUI;
import com.sun.tools.debugger.dbxgui.debugger.options.ComboBoxOptionUI;
import com.sun.tools.debugger.dbxgui.debugger.options.DebuggingOption;
import com.sun.tools.debugger.dbxgui.debugger.options.RadioButtonOptionUI;
import com.sun.tools.debugger.dbxgui.debugger.options.SubcategoryOptionUI;
import com.sun.tools.debugger.dbxgui.debugger.options.TextFieldOptionUI;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.swdev.common.utils.UsageTracking;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class OptionsDialog
extends JPanel {
    private DbxDebugger debugger = null;
    protected String dialogTitle = bundle.getString("PROP_title");
    protected JTabbedPane tabPane = new JTabbedPane(4);
    static final boolean DEBUG = false;
    private static ResourceBundle bundle = null;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$options$OptionsDialog;

    public OptionsDialog(DbxDebugger debugger) {
        if (debugger != null) {
            this.debugger = debugger;
        }
        DebuggingOption.open();
        this.init();
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_PROP_title"));
        this.tabPane.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_PROP_tabbed"));
        this.tabPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_PROP_tabbed"));
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.initTabbedPane();
    }

    protected void cancelChanges() {
    }

    protected void applyChanges() {
        Enumeration options = DebuggingOption.elements();
        while (options.hasMoreElements()) {
            DebuggingOption opt = (DebuggingOption)options.nextElement();
            if (opt.getUI() == null || opt.isSubOption()) continue;
            opt.getUI().applyChanges();
        }
        DebuggingOption.save();
    }

    protected void initTabbedPane() {
        this.initDbgOutputPage();
        this.initDbgBehaviorPage();
        this.initWindowPropertiesPage();
        this.initMiscPropertiesPage();
        this.initLanguageAndScopingPage();
        if (!IpeUtils.isLinux()) {
            this.initRuntimeCheckingPage();
        }
        this.initDbgPerformancePage();
        this.initForksAndThreadsPage();
        this.initCommandLineOnlyPage();
        this.initAdvancedPage();
        this.add((Component)this.tabPane, "Center");
        JTextArea header = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        header.setRequestFocusEnabled(false);
        header.setWrapStyleWord(true);
        header.setLineWrap(true);
        header.setEditable(false);
        header.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        header.setText(bundle.getString("DialogDescription"));
        header.setBackground((Color)UIManager.getDefaults().get("Label.background"));
        this.add((Component)header, "North");
    }

    protected void addTabbedPage(String titleResource, BaseOptionUI[] optionPanels) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        for (int i = 0; i < optionPanels.length; ++i) {
            optionPanels[i].addOption(panel);
        }
        JPanel yAbsorber = new JPanel();
        yAbsorber.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        panel.add((Component)yAbsorber, gridBagConstraints);
        this.tabPane.add(bundle.getString("TPL_" + titleResource), panel);
    }

    protected BaseOptionUI createOptionPanel(DebuggingOption option) {
        BaseOptionUI panel = null;
        switch (option.getType()) {
            case 1: {
                panel = new TextFieldOptionUI(option, this);
                break;
            }
            case 2: {
                panel = new RadioButtonOptionUI(option, this);
                break;
            }
            case 3: {
                panel = new ComboBoxOptionUI(option, this);
                break;
            }
            case 4: {
                panel = new CheckBoxOptionUI(option, this);
                break;
            }
        }
        return panel;
    }

    protected void initDbgOutputPage() {
        BaseOptionUI[] panels = new BaseOptionUI[]{this.createOptionPanel(DebuggingOption.OUTPUT_SHORT_FILE_NAME), this.createOptionPanel(DebuggingOption.OUTPUT_MAX_STRING_LENGTH), this.createOptionPanel(DebuggingOption.OUTPUT_BASE), this.createOptionPanel(DebuggingOption.FIX_VERBOSE), this.createOptionPanel(DebuggingOption.STACK_VERBOSE), this.createSubPanel(new DebuggingOption[]{DebuggingOption.RUN_IO}, new FlowLayout(0), "programIO"), this.createSubPanel(new DebuggingOption[]{DebuggingOption.OUTPUT_DYNAMIC_TYPE, DebuggingOption.OUTPUT_INHERITED_MEMBERS}, new FlowLayout(0), "variableEvaluation")};
        this.addTabbedPage("dbgOutputPage", panels);
    }

    protected void initDbgBehaviorPage() {
        BaseOptionUI[] panels = new BaseOptionUI[]{this.createOptionPanel(DebuggingOption.TRACE_SPEED), this.createOptionPanel(DebuggingOption.STEP_GRANULARITY), this.createOptionPanel(DebuggingOption.POP_AUTO_DESTRUCT), this.createOptionPanel(DebuggingOption.ARRAY_BOUNDS_CHECK), this.createSubPanel(new DebuggingOption[]{DebuggingOption.RUN_AUTOSTART, DebuggingOption.STEP_EVENTS, DebuggingOption.STACK_FIND_SOURCE}, new FlowLayout(0), "stepping")};
        this.addTabbedPage("dbgBehaviorPage", panels);
    }

    protected void initLanguageAndScopingPage() {
        BaseOptionUI[] panels = new BaseOptionUI[]{this.createOptionPanel(DebuggingOption.LANGUAGE_MODE), this.createOptionPanel(DebuggingOption.INPUT_CASE_SENSITIVE), this.createSubPanel(new DebuggingOption[]{DebuggingOption.OVERLOAD_FUNCTION, DebuggingOption.OVERLOAD_OPERATOR}, new FlowLayout(0), "automaticEvaluation"), this.createSubPanel(new DebuggingOption[]{DebuggingOption.SCOPE_LOOK_ASIDE, DebuggingOption.SCOPE_GLOBAL_ENUMS}, new FlowLayout(0), "scoping")};
        this.addTabbedPage("languageAndScopingPage", panels);
    }

    protected void initWindowPropertiesPage() {
        BaseOptionUI[] panels = new BaseOptionUI[]{this.createOptionPanel(DebuggingOption.MAIN_FUNC_WARNING), this.createOptionPanel(DebuggingOption.FRONT_DBGWIN), this.createOptionPanel(DebuggingOption.FRONT_PIO), this.createOptionPanel(DebuggingOption.FRONT_DBX), this.createOptionPanel(DebuggingOption.FRONT_ACCESS), this.createOptionPanel(DebuggingOption.FRONT_MEMUSE), this.createOptionPanel(DebuggingOption.OPEN_THREADS), this.createOptionPanel(DebuggingOption.OPEN_SESSIONS)};
        this.addTabbedPage("windowPropertiesPage", panels);
    }

    protected void initMiscPropertiesPage() {
        BaseOptionUI[] panels = new BaseOptionUI[]{this.createOptionPanel(DebuggingOption.SAVE_BREAKPOINTS), this.createOptionPanel(DebuggingOption.BALLOON_EVAL)};
        this.addTabbedPage("miscPage", panels);
    }

    protected void initRuntimeCheckingPage() {
        BaseOptionUI[] panels = new BaseOptionUI[]{this.createOptionPanel(DebuggingOption.RTC_BIU_AT_EXIT), this.createOptionPanel(DebuggingOption.RTC_MEL_AT_EXIT), this.createSubPanel(new DebuggingOption[]{DebuggingOption.RTC_ERROR_LIMIT, DebuggingOption.RTC_AUTO_CONTINUE, DebuggingOption.RTC_AUTO_SUPPRESS}, null, "errorReporting")};
        this.addTabbedPage("runtimeCheckingPage", panels);
    }

    protected void initDbgPerformancePage() {
        BaseOptionUI[] panels = new BaseOptionUI[]{this.createOptionPanel(DebuggingOption.SYMBOL_INFO_COMPRESSION), this.createOptionPanel(DebuggingOption.RUN_QUICK)};
        this.addTabbedPage("dbgPerformancePage", panels);
    }

    protected void initForksAndThreadsPage() {
        BaseOptionUI[] panels = new BaseOptionUI[]{this.createOptionPanel(DebuggingOption.FOLLOW_FORK_MODE), this.createOptionPanel(DebuggingOption.FOLLOW_FORK_INHERIT), this.createOptionPanel(DebuggingOption.MT_SCALABLE)};
        this.addTabbedPage("forksAndThreadsPage", panels);
    }

    protected void initCommandLineOnlyPage() {
        BaseOptionUI[] panels = new BaseOptionUI[]{this.createOptionPanel(DebuggingOption.OUTPUT_PRETTY_PRINT), this.createOptionPanel(DebuggingOption.OUTPUT_AUTO_FLUSH), this.createOptionPanel(DebuggingOption.OUTPUT_LIST_SIZE), this.createOptionPanel(DebuggingOption.SUPPRESS_STARTUP_MESSAGE), this.createOptionPanel(DebuggingOption.STACK_MAX_SIZE)};
        this.addTabbedPage("commandLineOnlyPage", panels);
    }

    protected void initAdvancedPage() {
        BaseOptionUI[] panels = new BaseOptionUI[]{this.createOptionPanel(DebuggingOption.DISSASSEMLER_VERSION), this.createOptionPanel(DebuggingOption.PROC_EXCLUSIVE_ATTACH), this.createSubPanel(new DebuggingOption[]{DebuggingOption.RUN_SAVETTY, DebuggingOption.RUN_SETPGRP}, new FlowLayout(0), "shellProgramming")};
        this.addTabbedPage("advancedPage", panels);
    }

    protected SubcategoryOptionUI createSubPanel(DebuggingOption[] options, LayoutManager layout, String titleResource) {
        String title = bundle.getString("SPT_" + titleResource);
        return new SubcategoryOptionUI(options, title, this);
    }

    public void applyDbxOption(String name, String value) {
        if (this.debugger != null) {
            this.debugger.setOption("DBX_" + name, value);
        }
    }

    public static void showWindow(DbxDebugger debugger) {
        Dbx dbx;
        OptionsDialog optPanel = new OptionsDialog(debugger);
        String title = bundle.getString("PROP_title");
        if (debugger != null && (dbx = debugger.getEngine()) != null) {
            if (DebuggingOption.RUN_IO.getCurrValue().equals("window")) {
                DebuggingOption.RUN_PTY.setCurrValue(dbx.getPioPty().getSlaveName());
            } else if (DebuggingOption.RUN_IO.getCurrValue().equals("stdio")) {
                DebuggingOption.RUN_PTY.setCurrValue(dbx.getDbxPty().getSlaveName());
            }
        }
        DialogDescriptor dlg = new DialogDescriptor((Object)optPanel, title, true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx("Debugging_options"), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dialog.show();
        if (dlg.getValue().equals(DialogDescriptor.OK_OPTION)) {
            optPanel.applyChanges();
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"DebuggingOptionsDialog: OK", null);
            }
        } else {
            optPanel.cancelChanges();
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"DebuggingOptionsDialog: Cancel", null);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            bundle = NbBundle.getBundle((Class)(class$com$sun$tools$debugger$dbxgui$debugger$options$OptionsDialog == null ? (class$com$sun$tools$debugger$dbxgui$debugger$options$OptionsDialog = OptionsDialog.class$("com.sun.tools.debugger.dbxgui.debugger.options.OptionsDialog")) : class$com$sun$tools$debugger$dbxgui$debugger$options$OptionsDialog));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

