/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.openide.util.RequestProcessor;

public abstract class SystemInfo {
    protected Vector items;
    protected String cmd;
    protected String ignore;

    protected SystemInfo(Vector items, String cmd, String ignore) {
        this.items = items;
        this.cmd = cmd;
        this.ignore = ignore;
    }

    public abstract String all();

    public void stuffIntoAsync(final JComboBox combo) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                SystemInfo.this.stuffInto(combo);
            }
        }, 100);
    }

    public void stuffInto(final JComboBox combo) {
        this.fill();
        if (this.items.size() == 0) {
            return;
        }
        final DefaultComboBoxModel model = new DefaultComboBoxModel((Vector)this.items.clone());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                combo.setModel(model);
            }
        });
    }

    public void fill() {
        Runtime rt = Runtime.getRuntime();
        try {
            String moreoutput;
            String[] args = new String[]{"/bin/sh", "-c", this.cmd};
            Process proc = rt.exec(args);
            InputStream procIn = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(procIn));
            while ((moreoutput = br.readLine()) != null) {
                if (moreoutput.endsWith("_H") || moreoutput.startsWith("reserved_") || this.ignore != null && this.ignore.equals(moreoutput)) continue;
                this.items.add(moreoutput);
            }
            br.close();
            proc.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Syscalls
    extends SystemInfo {
        public Syscalls(Vector items) {
            super(items, null, "syscall");
            items.add(this.all());
            this.cmd = "LC_ALL=C /usr/bin/grep \"#define\" /usr/include/sys/syscall.h | /usr/bin/nawk '{print $2}' | /usr/bin/cut -c 5-";
        }

        public String all() {
            return IpeBreakpointEvent.getText("SysCall_All");
        }
    }

    public static class Faults
    extends SystemInfo {
        public Faults(Vector items) {
            super(items, null, "_SYS_FAULT_H");
            this.cmd = "LC_ALL=C /usr/bin/grep \"#define\" /usr/include/sys/fault.h | /usr/bin/nawk '{print $2}'";
        }

        public String all() {
            return "";
        }
    }

    public static class Subcodes
    extends SystemInfo {
        public Subcodes(Vector items) {
            super(items, null, null);
            items.add(this.all());
            this.cmd = new File("/usr/include/bits/siginfo.h").exists() ? "LC_ALL=C /bin/grep \"# define.*\" /usr/include/bits/siginfo.h | /bin/awk '{print $3}'" : "LC_ALL=C /usr/bin/grep \"#define.*/\" /usr/include/sys/machsig.h | /usr/bin/nawk '{print $2}'";
        }

        public String all() {
            return IpeBreakpointEvent.getText("Signal_AllCodes");
        }

        public Vector subcodesFor(String sig) {
            if (sig == null) {
                return null;
            }
            if ((sig = sig.trim()).length() == 0) {
                return null;
            }
            if (this.items == null || this.items.size() == 0) {
                return null;
            }
            if ((sig = sig + "_").startsWith("SIG")) {
                sig = sig.substring(3);
            }
            Vector<String> actual = new Vector<String>(10);
            actual.add(this.all());
            for (int scx = 0; scx < this.items.size(); ++scx) {
                if (!this.items.get(scx).toString().startsWith(sig)) continue;
                actual.add((String)this.items.get(scx));
            }
            return actual;
        }
    }

    public static class Signals
    extends SystemInfo {
        public Signals(Vector items) {
            super(items, null, null);
            this.cmd = new File("/usr/include/sys/iso/signal_iso.h").exists() ? "LC_ALL=C /usr/bin/grep \"#define\tSIG.*[0-9].*/\" /usr/include/sys/iso/signal_iso.h | /usr/bin/nawk '{print $2}'" : (new File("/usr/include/asm/signal.h").exists() ? "LC_ALL=C /bin/grep \"#define SIG.*[0-9]\" /usr/include/asm/signal.h | /bin/awk '{print $2}'" : "LC_ALL=C /usr/bin/grep \"#define\tSIG.*[0-9].*/\" /usr/include/sys/signal.h | /usr/bin/nawk '{print $2}'");
        }

        public String all() {
            return IpeBreakpointEvent.getText("Signal_AllCodes");
        }
    }
}

