/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.breakpoints.BreakpointPanel;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.SysCallBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.SystemInfo;
import com.sun.tools.debugger.dbxgui.props.SysCallEE;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.debugger.Controller;

public class SysCallBreakpointPanel
extends BreakpointPanel
implements Controller {
    private SysCallBreakpoint fb;
    private SystemInfo si_syscalls;
    private ButtonGroup buttonGroup1;
    private JLabel sysCallLabel;
    private JComboBox sysCallCombo;
    private JRadioButton entranceToggle;
    private JRadioButton exitToggle;

    public SysCallBreakpointPanel(SysCallBreakpoint event) {
        super(event);
        this.fb = event;
        this.initComponents();
        this.addCommonComponents(3);
        this.entranceToggle.setSelected(true);
        this.sysCallCombo.setEditable(true);
        Component c = this.sysCallCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            Document d = ((JTextComponent)c).getDocument();
            d.addDocumentListener(this);
        }
        Vector comboValues = new Vector(250);
        this.si_syscalls = new SystemInfo.Syscalls(comboValues);
        this.si_syscalls.stuffInto(this.sysCallCombo);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.sysCallLabel = new JLabel();
        this.sysCallCombo = new JComboBox();
        this.entranceToggle = new JRadioButton();
        this.exitToggle = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.sysCallLabel.setText(IpeBreakpointEvent.getText("SystemCall"));
        this.sysCallLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("SystemCallMnemonic").charAt(0));
        this.sysCallLabel.setLabelFor(this.sysCallCombo);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.sysCallLabel, gridBagConstraints1);
        this.sysCallCombo.setEditable(true);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.sysCallCombo, gridBagConstraints1);
        this.entranceToggle.setText(IpeBreakpointEvent.getText("OnEntrance"));
        this.entranceToggle.setMnemonic(IpeBreakpointEvent.getText("OnEntranceMnemonic").charAt(0));
        this.buttonGroup1.add(this.entranceToggle);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridwidth = 4;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.entranceToggle, gridBagConstraints1);
        this.exitToggle.setText(IpeBreakpointEvent.getText("OnExit"));
        this.exitToggle.setMnemonic(IpeBreakpointEvent.getText("OnExitMnemonic").charAt(0));
        this.buttonGroup1.add(this.exitToggle);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridwidth = 4;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.exitToggle, gridBagConstraints1);
        this.sysCallCombo.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_SystemCall"));
        this.entranceToggle.getAccessibleContext().setAccessibleDescription(this.entranceToggle.getText());
        this.exitToggle.getAccessibleContext().setAccessibleDescription(this.exitToggle.getText());
    }

    public boolean ok() {
        if (!super.ok()) {
            return false;
        }
        if (!this.isValid()) {
            return false;
        }
        String syscall = this.sysCallCombo.getSelectedItem().toString();
        if (syscall.equals(this.si_syscalls.all())) {
            this.fb.setSysCall(null);
        } else {
            this.fb.setSysCall(syscall);
        }
        if (this.exitToggle.isSelected()) {
            this.fb.setEntryExit(SysCallEE.EXIT);
        } else {
            this.fb.setEntryExit(SysCallEE.ENTRY);
        }
        this.post();
        return true;
    }

    public boolean isValid() {
        Component c = this.sysCallCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            String text = ((JTextComponent)c).getText();
            return text != null && text.trim().length() != 0;
        }
        return this.sysCallCombo.getSelectedItem().toString().trim().length() != 0;
    }
}

