/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.BreakpointAnnotation;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerEngine;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerImpl;
import com.sun.tools.debugger.dbxgui.debugger.IpeHandler;
import com.sun.tools.debugger.dbxgui.debugger.RoutingToken;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeStopAction;
import com.sun.tools.debugger.dbxgui.props.Action;
import com.sun.tools.debugger.dbxgui.props.CountLimit;
import com.sun.tools.debugger.dbxgui.props.Enum;
import com.sun.tools.debugger.dbxgui.props.EnumEditor;
import com.sun.tools.debugger.dbxgui.props.PropFactory;
import com.sun.tools.debugger.dbxgui.props.PropUndo;
import com.sun.tools.debugger.dbxgui.props.PropUndoable;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.StopEvent;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public abstract class IpeBreakpointEvent
extends CoreBreakpoint.Event
implements StopEvent,
PropUndoable {
    protected transient IpeHandler handler = null;
    private transient CoreBreakpoint.Action[] actions;
    private PropFactory.Reflection propAction;
    private PropFactory.Reflection propScript;
    private boolean hasBeenSet = false;
    private Action actionType = Action.STOP;
    protected int id = 0;
    protected String whileIn = null;
    protected String qwhileIn = null;
    protected String condition = null;
    protected String qcondition = null;
    protected String lwp = null;
    protected String thread = null;
    protected int count = 0;
    protected boolean temp;
    protected boolean persistent;
    protected boolean hasCountLimit = false;
    protected long countLimit = -1L;
    protected Action action = Action.STOP;
    protected String script = null;
    protected String java = null;
    private int routingToken = 0;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$IpeBreakpointEvent$ActionEditor;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$props$ThreadIdEditor;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$props$LwpIdEditor;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$IpeBreakpointEvent;

    public void undo(String property) {
        this.firePropertyChange("event", null, null);
    }

    public void refresh() {
        this.firePropertyChange("event", null, null);
    }

    public boolean set() {
        return this.set(null);
    }

    public boolean set(DbxDebuggerEngine engine) {
        DbxDebugger debugger;
        if (this.hasBeenSet) {
            return true;
        }
        if (this.handler != null) {
            this.handler.removeAnnotations();
        }
        if ((debugger = DbxDebuggerImpl.getCurrentDebugger()) != null && debugger.getState() != 1) {
            this.routingToken = RoutingToken.BREAKPOINTS.getUniqueRoutingTokenInt();
            if (engine == null) {
                this.hasBeenSet = debugger.createHandler(this, this.routingToken);
            } else {
                engine.createHandler(this, this.routingToken);
                this.hasBeenSet = true;
            }
        }
        return true;
    }

    public void remove() {
        if (this.handler != null) {
            this.handler.postEnabled(false);
        }
    }

    public void dispose() {
        if (this.handler != null) {
            DbxDebugger debugger = this.handler.getDebugger();
            if (debugger != null && debugger.getState() != 1 && this.handler.getHandler() != null) {
                if (!debugger.ignoreUpdates()) {
                    debugger.removeBreakpoint(this.handler.getHid());
                }
            } else {
                this.handler.removeAnnotations();
            }
        }
        super.dispose();
    }

    public void stop(boolean stop) {
    }

    public boolean supportsMIMEType(String MIMEType) {
        return MIMEType.equals("text/x-c++") || MIMEType.equals("text/x-c") || MIMEType.equals("text/x-fortran") || MIMEType.equals("text/x-java");
    }

    public final boolean isEnabled() {
        CoreBreakpoint enclosing = this.getBreakpoint();
        if (enclosing == null) {
            return true;
        }
        return enclosing.isEnabled();
    }

    public boolean isPropEnabled() {
        return this.isEnabled();
    }

    public final void setEnabled(boolean enabled) {
        CoreBreakpoint enclosing = this.getBreakpoint();
        boolean old = enclosing.isEnabled();
        enclosing.setEnabled(enabled);
        if (this.handler != null) {
            this.handler.updateAnnotations();
        }
    }

    public void setPropEnabled(boolean b) {
        if (this.handler != null) {
            this.handler.postEnabled(b);
        }
    }

    public final int getId() {
        return this.id;
    }

    public final int getPropId() {
        return this.getId();
    }

    public final void setId(int newId) {
        int old = this.id;
        this.id = newId;
        this.firePropertyChange("ID", new Integer(old), new Integer(this.id));
    }

    public final String getWhileIn() {
        return this.whileIn;
    }

    public final String getQwhileIn() {
        return this.qwhileIn;
    }

    public final String getPropWhileIn() {
        return this.getWhileIn();
    }

    public final void setQwhileIn(String whileIn) {
        this.qwhileIn = whileIn;
    }

    public final void setWhileIn(String whileIn) {
        String old = this.whileIn;
        this.whileIn = whileIn;
    }

    public final void setPropWhileIn(String whileIn) {
        System.out.println("setWhileIn(" + whileIn + ")");
    }

    public final String getCondition() {
        return this.condition;
    }

    public final String getPropCondition() {
        String c = this.getCondition();
        return c;
    }

    public final void setCondition(String newCond) {
        String old = this.condition;
        this.condition = newCond;
        if (this.handler != null) {
            this.handler.updateAnnotations();
        }
        this.firePropertyChange("condition", old, this.condition);
    }

    public final String getQcondition() {
        return this.qcondition;
    }

    public final void setQcondition(String newCond) {
        String old = this.qcondition;
        this.qcondition = newCond;
        if (this.handler != null) {
            this.handler.updateAnnotations();
        }
    }

    public final void setPropCondition(String condition) {
        if (this.handler != null) {
            new PropUndo(this, "condition");
            this.handler.changeCondition(condition);
        }
    }

    public final String getLwp() {
        return this.lwp;
    }

    public final String getPropLwp() {
        return this.getLwp();
    }

    public final void setLwp(String newLwp) {
        String old = this.lwp;
        this.lwp = newLwp;
        this.firePropertyChange("LWP", old, this.lwp);
    }

    public final void setPropLwp(String lwp) {
        new PropUndo(this, "LWP");
        this.handler.changeLwp(lwp);
    }

    public final String getThread() {
        return this.thread;
    }

    public final String getPropThread() {
        return this.getThread();
    }

    public final void setThread(String newThread) {
        String old = this.thread;
        this.thread = newThread;
        this.firePropertyChange("thread", old, this.thread);
    }

    public final void setPropThread(String thread) {
        new PropUndo(this, "thread");
        this.handler.changeThread(thread);
    }

    public final void setCount(int newCount) {
        int old = this.count;
        this.count = newCount;
        this.firePropertyChange("count", new Integer(old), new Integer(this.count));
    }

    public final int getCount() {
        return this.count;
    }

    public final String getPropCount() {
        if (this.hasCountLimit) {
            return "" + this.getCount();
        }
        return null;
    }

    public final long getCountLimit() {
        return this.countLimit;
    }

    public final boolean hasCountLimit() {
        return this.hasCountLimit;
    }

    public final Object getPropCountLimit() {
        if (this.hasCountLimit) {
            if (this.countLimit == -1L) {
                return CountLimit.Keyword_INFINITY;
            }
            return "" + this.countLimit;
        }
        return null;
    }

    public final void setCountLimit(long newCountLimit, boolean hasLimit) {
        this.hasCountLimit = hasLimit;
        this.countLimit = newCountLimit;
        this.firePropertyChange("countLimit", null, null);
        this.firePropertyChange("count", null, null);
    }

    public final void setPropCountLimit(Object o) {
        CountLimit cl = (CountLimit)o;
        new PropUndo(this, "countLimit");
        cl.possiblySetToCurrentCount(this.getCount());
        this.handler.changeCountLimit(cl.enable, cl.count);
    }

    public final boolean getTemp() {
        return this.temp;
    }

    public final boolean getPropTemp() {
        return this.getTemp();
    }

    public final void setTemp(boolean newTemp) {
        boolean old = this.temp;
        this.temp = newTemp;
        this.firePropertyChange("temp", new Boolean(old), new Boolean(this.temp));
    }

    public final void setPropTemp(boolean temp) {
        new PropUndo(this, "temp");
        this.handler.changeTemp(temp);
    }

    public final boolean getPropPersistent() {
        return this.persistent;
    }

    public final void setPersistent(boolean newPersistent) {
        boolean old = this.persistent;
        this.persistent = newPersistent;
        this.firePropertyChange("persistent", new Boolean(old), new Boolean(this.persistent));
    }

    public final void setPropPersistent(boolean perm) {
    }

    public final String getPropJava() {
        return "<Java placeholder>";
    }

    public final void setJava(String java) {
        String old = this.java;
        this.java = java;
    }

    public final void setPropJava(String java) {
        System.out.println("setJava(" + java + ")");
    }

    public final Action getAction() {
        return this.action;
    }

    public final Object getPropAction() {
        return this.getAction();
    }

    public final void setAction(Action newAction) {
        Action old = this.action;
        this.action = newAction;
        if (this.handler != null) {
            this.handler.updateAnnotations();
        }
        this.adjustScript();
        this.firePropertyChange("action", old.toString(), this.action.toString());
    }

    public final void setPropAction(Object o) {
        Action a = (Action)o;
        new PropUndo(this, "action");
        this.handler.changeAction(a);
    }

    public final void setScript(String newScript) {
        String old = this.script;
        this.script = newScript;
        this.firePropertyChange("script", old, this.script);
    }

    public final void setPropScript(String script) {
        if (this.handler != null) {
            new PropUndo(this, "script");
            this.handler.changeScript(script);
        }
    }

    public final String getScript() {
        return this.script;
    }

    public final String getPropScript() {
        return this.getScript();
    }

    private void adjustScript() {
        if (this.propScript == null) {
            return;
        }
        if (this.action == Action.WHEN || this.action == Action.WHENINSTR) {
            this.propScript.setWritable(true);
        } else {
            this.propScript.setWritable(false);
        }
    }

    protected void fillPropertiesPre(PropFactory pf) {
        pf.addInteger("ID", "PROP_id", "HINT_id", "getPropId", null);
        pf.addBoolean("enabled", "PROP_enabled", "HINT_enabled", "isPropEnabled", "setPropEnabled");
    }

    protected void fillPropertiesPost(PropFactory pf) {
        this.propAction = pf.addObject("action", "PROP_action", "HINT_action", "getPropAction", "setPropAction");
        this.propAction.setPropertyEditorClass(class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$IpeBreakpointEvent$ActionEditor == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$IpeBreakpointEvent$ActionEditor = IpeBreakpointEvent.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent$ActionEditor")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$IpeBreakpointEvent$ActionEditor);
        this.propScript = pf.addDefaultString("script", "PROP_script", "HINT_script", "getPropScript", "setPropScript");
        this.adjustScript();
        pf.addString("count", "PROP_count", "HINT_count", "getPropCount", null);
        pf.addCountLimit("countLimit", "PROP_count_limit", "HINT_count_limit", "getPropCountLimit", "setPropCountLimit");
        pf.addString("condition", "PROP_condition", "HINT_condition", "getPropCondition", "setPropCondition");
        PropFactory.Reflection propThread = pf.addString("thread", "PROP_thread", "HINT_thread", "getPropThread", "setPropThread");
        propThread.setPropertyEditorClass(class$com$sun$tools$debugger$dbxgui$props$ThreadIdEditor == null ? (class$com$sun$tools$debugger$dbxgui$props$ThreadIdEditor = IpeBreakpointEvent.class$("com.sun.tools.debugger.dbxgui.props.ThreadIdEditor")) : class$com$sun$tools$debugger$dbxgui$props$ThreadIdEditor);
        PropFactory.Reflection propLwp = pf.addString("LWP", "PROP_lwp", "HINT_lwp", "getPropLwp", "setPropLwp");
        propLwp.setPropertyEditorClass(class$com$sun$tools$debugger$dbxgui$props$LwpIdEditor == null ? (class$com$sun$tools$debugger$dbxgui$props$LwpIdEditor = IpeBreakpointEvent.class$("com.sun.tools.debugger.dbxgui.props.LwpIdEditor")) : class$com$sun$tools$debugger$dbxgui$props$LwpIdEditor);
        pf.addBoolean("temp", "PROP_temp", "HINT_temp", "getPropTemp", "setPropTemp");
        pf.addBoolean("persistent", "PROP_persistent", "HINT_persistent", "getPropPersistent", null);
    }

    public static String getText(String key) {
        return NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$IpeBreakpointEvent == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$IpeBreakpointEvent = IpeBreakpointEvent.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$IpeBreakpointEvent), (String)key);
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            this.actions = new CoreBreakpoint.Action[]{new IpeStopAction()};
            CoreBreakpoint.Action[] parentActions = super.getActions();
            if (parentActions.length != 0) {
                CoreBreakpoint.Action[] myActions = this.actions;
                this.actions = new CoreBreakpoint.Action[parentActions.length + myActions.length];
                System.arraycopy(parentActions, 0, this.actions, 0, parentActions.length);
                System.arraycopy(myActions, 0, this.actions, parentActions.length, myActions.length);
            }
        }
        return this.actions;
    }

    protected void perform() {
        super.perform();
        CoreBreakpoint.Action[] actions = this.getBreakpoint().getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (!(actions[i] instanceof IpeStopAction)) continue;
            ((IpeStopAction)actions[i]).performStopAction(this);
        }
    }

    public String getCategoryDisplayName() {
        return IpeBreakpointEvent.getText("CTL_CC_breakpoint_events_category_name");
    }

    public String getCathegoryDisplayName() {
        return IpeBreakpointEvent.getText("CTL_CC_breakpoint_events_category_name");
    }

    public void setHandler(IpeHandler newHandler) {
        this.handler = newHandler;
        if (this.handler != null) {
            this.handler.updateAnnotations();
        }
    }

    public IpeHandler getHandler() {
        return this.handler;
    }

    public String getDisplayName() {
        IpeHandler h = this.getHandler();
        if (h == null || h.isInProgress()) {
            return IpeBreakpointEvent.getText("AddingBreakpoint");
        }
        return h.toString();
    }

    public String getIconBase() {
        IpeHandler h = this.getHandler();
        if (h != null) {
            return h.getIconBase();
        }
        return super.getIconBase();
    }

    public int getRoutingToken() {
        return this.routingToken;
    }

    public Line[] getLines() {
        return null;
    }

    public Line getLine() {
        BreakpointAnnotation annotation = this.handler.getNextAnnotation();
        if (annotation != null) {
            annotation.show();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ActionEditor
    extends EnumEditor {
        public String[] getTags() {
            return Action.getTags();
        }

        protected Enum byTag(String s) {
            return Action.byTag(s);
        }
    }
}

