/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.breakpoints.BreakpointPanel;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.FunctionBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.props.FunctionSubEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.modules.debugger.Controller;

public class FunctionBreakpointPanel
extends BreakpointPanel
implements Controller {
    private FunctionBreakpoint fb;
    private JLabel functionLabel;
    private JTextField functionText;
    private ButtonGroup buttonGroup1;
    private JRadioButton functionToggle;
    private JRadioButton functionsToggle;
    private JRadioButton returnToggle;

    private String getSelection() {
        Clipboard clipboard = this.getToolkit().getSystemSelection();
        if (clipboard == null) {
            return null;
        }
        Transferable contents = clipboard.getContents(this);
        if (contents == null) {
            return null;
        }
        if (!contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return null;
        }
        String string = null;
        try {
            string = (String)contents.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("Selection=" + string);
        if (string != null) {
            char c = string.charAt(0);
            if (Character.isJavaIdentifierStart(c) || c == '`') {
                return string;
            }
            return null;
        }
        return string;
    }

    public FunctionBreakpointPanel(FunctionBreakpoint event) {
        super(event);
        this.fb = event;
        this.initComponents();
        this.initA11y();
        this.addCommonComponents(4);
        String function = event.getFunction();
        if (function != null) {
            this.functionText.setText(function);
        }
        this.functionText.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.functionLabel = new JLabel();
        this.functionText = new JTextField();
        this.functionToggle = new JRadioButton();
        this.functionsToggle = new JRadioButton();
        this.returnToggle = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.functionLabel.setText(IpeBreakpointEvent.getText("Function"));
        this.functionLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("FunctionMnemonic").charAt(0));
        this.functionLabel.setLabelFor(this.functionText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.functionLabel, gridBagConstraints);
        this.functionText.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.functionText, gridBagConstraints);
        this.functionToggle.setMnemonic(IpeBreakpointEvent.getText("FuncMnemonic").charAt(0));
        this.functionToggle.setText(FunctionSubEvent.IN.toString());
        this.functionToggle.setSelected(true);
        this.buttonGroup1.add(this.functionToggle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.functionToggle, gridBagConstraints);
        this.functionsToggle.setMnemonic(IpeBreakpointEvent.getText("AllFuncsMnemonic").charAt(0));
        this.functionsToggle.setText(FunctionSubEvent.INFUNCTION.toString());
        this.buttonGroup1.add(this.functionsToggle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.functionsToggle, gridBagConstraints);
        this.returnToggle.setMnemonic(IpeBreakpointEvent.getText("OnReturnMnemonic").charAt(0));
        this.returnToggle.setText(FunctionSubEvent.RETURNS.toString());
        this.buttonGroup1.add(this.returnToggle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.returnToggle, gridBagConstraints);
    }

    private void initA11y() {
        this.functionToggle.getAccessibleContext().setAccessibleDescription(this.functionToggle.getText());
        this.functionsToggle.getAccessibleContext().setAccessibleDescription(this.functionsToggle.getText());
        this.returnToggle.getAccessibleContext().setAccessibleDescription(this.returnToggle.getText());
        this.functionText.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Function"));
    }

    public boolean ok() {
        if (!super.ok()) {
            return false;
        }
        FunctionSubEvent fbe = null;
        if (this.functionToggle.isSelected()) {
            fbe = FunctionSubEvent.IN;
        } else if (this.functionsToggle.isSelected()) {
            fbe = FunctionSubEvent.INFUNCTION;
        } else if (this.returnToggle.isSelected()) {
            fbe = FunctionSubEvent.RETURNS;
        }
        this.fb.setFunction(this.functionText.getText());
        this.fb.setSubEvent(fbe);
        this.post();
        return true;
    }

    public boolean isValid() {
        String text = this.functionText.getText();
        return text != null && text.trim().length() != 0;
    }
}

