/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.breakpoints.BreakpointPanel;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.ExceptionBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.props.ExceptionSpec;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.debugger.Controller;

public class ExceptionBreakpointPanel
extends BreakpointPanel
implements Controller {
    private ExceptionBreakpoint fb;
    private ButtonGroup buttonGroup1;
    private JLabel exceptionLabel;
    private JComboBox exceptionCombo;

    public ExceptionBreakpointPanel(ExceptionBreakpoint event) {
        super(event);
        this.fb = event;
        this.initComponents();
        this.addCommonComponents(1);
        String[] comboValues = ExceptionSpec.getTags();
        this.exceptionCombo.setModel(new DefaultComboBoxModel<String>(comboValues));
        this.exceptionCombo.setEditable(true);
        Component c = this.exceptionCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            Document d = ((JTextComponent)c).getDocument();
            d.addDocumentListener(this);
        }
        this.exceptionCombo.setSelectedIndex(0);
    }

    private void initComponents() {
        this.exceptionLabel = new JLabel();
        this.exceptionCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.exceptionLabel.setText(IpeBreakpointEvent.getText("Type"));
        this.exceptionLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("TypeMnemonic").charAt(0));
        this.exceptionLabel.setLabelFor(this.exceptionCombo);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.exceptionLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.exceptionCombo, gridBagConstraints1);
        this.exceptionCombo.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Type"));
    }

    public boolean ok() {
        if (!super.ok()) {
            return false;
        }
        String xs = this.exceptionCombo.getSelectedItem().toString();
        ExceptionSpec x = ExceptionSpec.byTag(xs);
        this.fb.setException(x);
        this.post();
        return true;
    }

    public boolean isValid() {
        String xs = this.exceptionCombo.getSelectedItem().toString().trim();
        return xs.length() > 0;
    }
}

