/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.breakpoints.BreakpointPanel;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.ClassMethodBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.debugger.Controller;

public class ClassMethodBreakpointPanel
extends BreakpointPanel
implements Controller {
    private ClassMethodBreakpoint fb;
    private ButtonGroup buttonGroup1;
    private JLabel classMethodLabel;
    private JComboBox classNameCombo;
    private JLabel methodLabel;
    private JComboBox methodNameCombo;
    private JCheckBox baseToggle;
    private static final String AllClasses = IpeBreakpointEvent.getText("ClassMethod_AllClass");
    private static final String AllMethods = IpeBreakpointEvent.getText("ClassMethod_AllMethod");

    public ClassMethodBreakpointPanel(ClassMethodBreakpoint event) {
        super(event);
        this.fb = event;
        this.initComponents();
        this.addCommonComponents(3);
        String[] comboValues1 = new String[]{IpeBreakpointEvent.getText("ClassMethod_AllClass")};
        this.classNameCombo.setModel(new DefaultComboBoxModel<String>(comboValues1));
        Component c = this.classNameCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            Document d = ((JTextComponent)c).getDocument();
            d.addDocumentListener(this);
        }
        this.classNameCombo.setEditable(true);
        c.requestFocus();
        String className = event.getClassName();
        if (className != null) {
            this.classNameCombo.setSelectedItem(className);
        }
        String[] comboValues2 = new String[]{IpeBreakpointEvent.getText("ClassMethod_AllMethod")};
        this.methodNameCombo.setModel(new DefaultComboBoxModel<String>(comboValues2));
        c = this.methodNameCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            Document d = ((JTextComponent)c).getDocument();
            d.addDocumentListener(this);
        }
        this.methodNameCombo.setEditable(true);
        this.methodNameCombo.setSelectedIndex(0);
        this.isValid();
    }

    private void initComponents() {
        this.classMethodLabel = new JLabel();
        this.classNameCombo = new JComboBox();
        this.methodLabel = new JLabel();
        this.methodNameCombo = new JComboBox();
        this.baseToggle = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.classMethodLabel.setText(IpeBreakpointEvent.getText("Class"));
        this.classMethodLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("ClassMnemonic").charAt(0));
        this.classMethodLabel.setLabelFor(this.classNameCombo);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.classMethodLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.classNameCombo, gridBagConstraints1);
        this.baseToggle.setText(IpeBreakpointEvent.getText("IncludeParentMethods"));
        this.baseToggle.setMnemonic(IpeBreakpointEvent.getText("IncludeParentMethodsMnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 4;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.baseToggle, gridBagConstraints1);
        this.methodLabel.setText(IpeBreakpointEvent.getText("Method"));
        this.methodLabel.setDisplayedMnemonic(IpeBreakpointEvent.getText("MethodMnemonic").charAt(0));
        this.methodLabel.setLabelFor(this.methodNameCombo);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.methodLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.methodNameCombo, gridBagConstraints1);
        this.classNameCombo.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Class"));
        this.methodNameCombo.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_Method"));
        this.baseToggle.getAccessibleContext().setAccessibleDescription(IpeBreakpointEvent.getText("ACSD_IncludeParentMethods"));
    }

    public boolean ok() {
        if (!super.ok()) {
            return false;
        }
        if (!this.isValid()) {
            return false;
        }
        String cls = this.classNameCombo.getSelectedItem().toString().trim();
        String mtd = this.methodNameCombo.getSelectedItem().toString().trim();
        if (cls.equals(IpeBreakpointEvent.getText("ClassMethod_AllClass"))) {
            cls = null;
        }
        this.fb.setClassName(cls);
        if (mtd.equals(IpeBreakpointEvent.getText("ClassMethod_AllMethod"))) {
            mtd = null;
        }
        this.fb.setMethodName(mtd);
        this.fb.setRecurse(this.baseToggle.isSelected());
        this.post();
        return true;
    }

    public boolean isValid() {
        boolean methodEmpty;
        String cls = null;
        String mtd = null;
        Component c = this.classNameCombo.getEditor().getEditorComponent();
        cls = c instanceof JTextComponent ? ((JTextComponent)c).getText() : this.classNameCombo.getSelectedItem().toString().trim();
        c = this.methodNameCombo.getEditor().getEditorComponent();
        mtd = c instanceof JTextComponent ? ((JTextComponent)c).getText() : this.methodNameCombo.getSelectedItem().toString().trim();
        boolean classEmpty = cls == null || cls.length() == 0 || cls.equals(AllClasses);
        boolean bl = methodEmpty = mtd == null || mtd.length() == 0 || mtd.equals(AllMethods);
        if (!classEmpty && methodEmpty) {
            this.baseToggle.setEnabled(true);
        } else {
            this.baseToggle.setEnabled(false);
        }
        return !classEmpty || !methodEmpty;
    }
}

