/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.breakpoints;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerImpl;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.ClassMethodBreakpointPanel;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.props.PropFactory;
import com.sun.tools.debugger.dbxgui.props.PropUndo;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.StopEvent;
import org.openide.nodes.Node;
import org.openide.text.Line;

public class ClassMethodBreakpoint
extends IpeBreakpointEvent
implements StopEvent {
    private String className = null;
    private String qclassName = null;
    private String method = null;
    private String qmethod = null;
    private boolean recurse;
    static final long serialVersionUID = 1444281317183220550L;
    public static final String PROP_CLASS = "class";
    public static final String PROP_METHOD = "method";
    public static final String PROP_RECURSE = "recurse";
    PropFactory.Reflection propRecurse;

    public CoreBreakpoint.Event getNewInstance() {
        return new ClassMethodBreakpoint();
    }

    public String getTypeName() {
        return "FDCls";
    }

    public void setClassName(String cls) {
        if (cls == this.className || cls != null && this.className != null && this.className.equals(cls)) {
            return;
        }
        String old = this.className;
        this.className = cls;
        this.adjustRecurse();
        this.firePropertyChange(PROP_CLASS, old, this.className);
    }

    public void setQclassName(String cls) {
        if (cls == this.qclassName || cls != null && this.qclassName != null && this.qclassName.equals(cls)) {
            return;
        }
        this.qclassName = cls;
    }

    public void setPropClassName(String cls) {
        new PropUndo(this, PROP_CLASS);
        this.handler.changeClass(cls);
    }

    public String getPropClassName() {
        return this.getClassName();
    }

    public String getClassName() {
        DbxDebugger debugger;
        if (this.className == null && (debugger = DbxDebuggerImpl.getCurrentDebugger()) != null) {
            this.className = debugger.getCurrentClass();
        }
        return this.className;
    }

    public String getQclassName() {
        DbxDebugger debugger;
        if (this.className == null && (debugger = DbxDebuggerImpl.getCurrentDebugger()) != null) {
            this.qclassName = debugger.getCurrentClass();
        }
        return this.qclassName;
    }

    public void setMethodName(String sc) {
        if (sc == this.method || sc != null && this.method != null && this.method.equals(sc)) {
            return;
        }
        String old = this.method;
        this.method = sc;
        this.adjustRecurse();
        this.firePropertyChange(PROP_METHOD, old, this.method);
    }

    public void setQmethodName(String sc) {
        if (sc == this.qmethod || sc != null && this.qmethod != null && this.qmethod.equals(sc)) {
            return;
        }
        this.qmethod = sc;
    }

    private void adjustRecurse() {
        if (this.propRecurse == null) {
            return;
        }
        if (this.className != null && this.method == null) {
            this.propRecurse.setWritable(true);
        } else {
            this.propRecurse.setWritable(false);
        }
    }

    public void setPropMethodName(String method) {
        new PropUndo(this, PROP_METHOD);
        this.handler.changeMethod(method);
    }

    public String getPropMethodName() {
        return this.getMethodName();
    }

    public String getMethodName() {
        return this.method;
    }

    public String getQmethodName() {
        return this.qmethod;
    }

    public void setRecurse(boolean r) {
        this.recurse = r;
        this.firePropertyChange(PROP_RECURSE, null, null);
    }

    public void setPropRecurse(boolean b) {
        new PropUndo(this, PROP_RECURSE);
        this.handler.changeRecurse(b);
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public boolean isPropRecurse() {
        return this.recurse;
    }

    public JComponent getCustomizer() {
        return new ClassMethodBreakpointPanel(this);
    }

    public Node.Property[] getProperties() {
        PropFactory pf = new PropFactory(this, null);
        super.fillPropertiesPre(pf);
        pf.addString(PROP_CLASS, "PROP_breakpoint_classMethod_class", "HINT_breakpoint_classMethod_class", "getPropClassName", "setPropClassName");
        pf.addString(PROP_METHOD, "PROP_breakpoint_classMethod_method", "HINT_breakpoint_classMethod_method", "getPropMethodName", "setPropMethodName");
        this.propRecurse = pf.addBoolean(PROP_RECURSE, "PROP_breakpoint_classMethod_recurse", "HINT_breakpoint_classMethod_recurse", "isPropRecurse", "setPropRecurse");
        this.adjustRecurse();
        super.fillPropertiesPost(pf);
        return pf.getProperties();
    }

    public Line[] getLines() {
        return null;
    }

    public String getTypeDisplayName() {
        return IpeBreakpointEvent.getText("CTL_ClassMethod_event_type_name");
    }
}

