/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.actions;

import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerImpl;
import com.sun.tools.swdev.common.utils.UsageTracking;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public final class ToggleAccessChecksAction
extends CallableSystemAction {
    private static final long serialVersionUID = -6814567172958445516L;

    public void performAction() {
        Dbx dbx;
        DbxDebugger debugger;
        if (UsageTracking.enabled) {
            if (this.isAccessCheckingEnabled()) {
                UsageTracking.sendAction((String)"Disable Access Checking", null);
            } else {
                UsageTracking.sendAction((String)"Enable Access Checking", null);
            }
        }
        if ((debugger = DbxDebuggerImpl.getCurrentDebugger()) != null && (dbx = debugger.getEngine()) != null) {
            dbx.setAccessChecking(!dbx.isAccessCheckingEnabled());
            return;
        }
    }

    public String getName() {
        if (this.isAccessCheckingEnabled()) {
            return DbxDebugger.getText("CTL_DisableAccessChecks");
        }
        return DbxDebugger.getText("CTL_EnableAccessChecks");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Debugging_CheckingMemoryAccess");
    }

    protected String iconResource() {
        return "com/sun/tools/debugger/dbxgui/icons/access.gif";
    }

    public boolean isAccessCheckingEnabled() {
        Dbx dbx;
        DbxDebugger debugger = DbxDebuggerImpl.getCurrentDebugger();
        if (debugger != null && (dbx = debugger.getEngine()) != null) {
            return dbx.isAccessCheckingEnabled();
        }
        return false;
    }

    protected void initialize() {
        super.initialize();
        this.setEnabled(false);
    }
}

