/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.actions;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerInfo;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerType;
import com.sun.tools.debugger.dbxgui.utils.ExecutableFileFilter;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.debugger.dbxgui.utils.UnixFileSystemView;
import com.sun.tools.swdev.common.utils.UsageTracking;
import java.awt.Toolkit;
import java.io.File;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.netbeans.modules.cpp.loaders.CCFSrcObject;
import org.netbeans.modules.cpp.loaders.CoreElfObject;
import org.netbeans.modules.debugger.AbstractDebuggerType;
import org.netbeans.modules.debugger.support.DebuggerModule;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.cookies.DebuggerCookie;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.DebuggerType;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public class LoadProgramAction
extends NodeAction {
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$AbstractDebuggerType;
    static /* synthetic */ Class class$org$openide$debugger$DebuggerType;

    public String getName() {
        return DbxDebugger.getText("LBL_LoadProgram");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Debugging_load");
    }

    protected String iconResource() {
        return "com/sun/tools/debugger/dbxgui/icons/loadProgram.gif";
    }

    protected boolean enable(Node[] activatedNodes) {
        DataObject dataObject = null;
        if (activatedNodes.length == 1) {
            dataObject = (DataObject)activatedNodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = LoadProgramAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (activatedNodes[0].getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = LoadProgramAction.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie) != null && !(dataObject instanceof CoreElfObject)) {
                return true;
            }
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        if (UsageTracking.enabled) {
            UsageTracking.sendAction((String)"Load Program", null);
        }
        if (!this.enable(activatedNodes)) {
            return;
        }
        DataObject dao = null;
        Node node = null;
        boolean okName = true;
        if (activatedNodes == null || activatedNodes.length == 0) {
            okName = false;
        } else {
            DebuggerCookie ex = (DebuggerCookie)activatedNodes[0].getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = LoadProgramAction.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie);
            if (ex == null) {
                okName = false;
            } else {
                node = activatedNodes[0];
            }
        }
        if (activatedNodes != null && activatedNodes.length > 0 && (dao = (DataObject)activatedNodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = LoadProgramAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null && dao instanceof CCFSrcObject) {
            node = null;
            okName = false;
        }
        if (!okName) {
            final JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(DbxDebugger.getText("CoreExeChooser"));
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileFilter(new ExecutableFileFilter());
            chooser.setFileSystemView(new UnixFileSystemView(chooser.getFileSystemView()));
            chooser.setFileHidingEnabled(false);
            if (activatedNodes != null && activatedNodes.length > 0 && (dao = (DataObject)activatedNodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = LoadProgramAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null) {
                FileObject fo;
                File f;
                if (!(dao instanceof DataFolder)) {
                    dao = dao.getFolder();
                }
                if (dao != null && (f = NbClassPath.toFile((FileObject)(fo = dao.getPrimaryFile()))) != null) {
                    chooser.setCurrentDirectory(f);
                }
            }
            final Node finalNode = node;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run() {
                    DataObject dao;
                    int returnVal = chooser.showDialog(null, DbxDebugger.getText("SelectExecutable"));
                    if (returnVal != 0) return;
                    File f = chooser.getSelectedFile();
                    String executable = null;
                    if (f != null) {
                        executable = f.getAbsolutePath();
                    } else if (chooser.getUI() instanceof BasicFileChooserUI) {
                        BasicFileChooserUI ui = (BasicFileChooserUI)chooser.getUI();
                        executable = ui.getFileName();
                    }
                    if (executable != null) {
                        FileObject fo = IpeUtils.findFileObject(executable, true);
                        if (fo == null) {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                        dao = null;
                        try {
                            dao = DataObject.find((FileObject)fo);
                        }
                        catch (DataObjectNotFoundException e) {
                            return;
                        }
                    } else {
                        Thread.dumpStack();
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    LoadProgramAction.this.debug(dao, finalNode);
                }
            });
        } else {
            dao = (DataObject)activatedNodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = LoadProgramAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dao == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.debug(dao, node);
        }
    }

    public void performAction(Node node) {
        this.performAction(new Node[]{node});
    }

    private void debug(DataObject dao, Node node) {
        DebuggerType dt = LoadProgramAction.getDebuggerType(node, dao);
        if (!(dt instanceof DbxDebuggerType)) {
            if (dao instanceof DataShadow) {
                dao = ((DataShadow)dao).getOriginal();
            }
            try {
                dt.startDebugger(dao, true);
            }
            catch (DebuggerException e) {
                // empty catch block
            }
            return;
        }
        DbxDebuggerType idt = (DbxDebuggerType)dt;
        DbxDebuggerInfo info = idt.getDbxDebuggerInfo(dao, 0);
        if (info == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (UsageTracking.enabled) {
            UsageTracking.startTiming((String)"loadprogram");
        }
        DebuggerModule.changeWorkspace();
        Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = LoadProgramAction.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        try {
            d.startDebugger((DebuggerInfo)info);
        }
        catch (DebuggerException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        if (UsageTracking.enabled) {
            UsageTracking.readTime((String)"loadprogram", (String)"Load Program", (boolean)true, null, (boolean)true);
        }
    }

    static DebuggerType getDebuggerType(Node node, DataObject d) {
        AbstractDebuggerType dt;
        ServiceType dbg;
        Object handle;
        if (d == null) {
            d = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = LoadProgramAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        }
        if (d == null) {
            return null;
        }
        if (d instanceof DataShadow) {
            d = ((DataShadow)d).getOriginal();
        }
        if ((handle = d.getPrimaryFile().getAttribute("NetBeansAttrDebuggerType")) != null && handle instanceof ServiceType.Handle && (dbg = ((ServiceType.Handle)handle).getServiceType()) instanceof DebuggerType) {
            return (DebuggerType)dbg;
        }
        Lookup l = Lookup.getDefault();
        Iterator it = l.lookup(new Lookup.Template(class$org$netbeans$modules$debugger$AbstractDebuggerType == null ? (class$org$netbeans$modules$debugger$AbstractDebuggerType = LoadProgramAction.class$("org.netbeans.modules.debugger.AbstractDebuggerType")) : class$org$netbeans$modules$debugger$AbstractDebuggerType)).allInstances().iterator();
        while (it.hasNext()) {
            dt = (AbstractDebuggerType)it.next();
            if (!(dt instanceof DbxDebuggerType) || !dt.supportsDebuggingOf(d)) continue;
            return dt;
        }
        dt = (DebuggerType)l.lookup(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = LoadProgramAction.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType);
        if (dt == null) {
            dt = DebuggerType.getDefault();
        }
        return dt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

