/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger.actions;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerInfo;
import com.sun.tools.swdev.common.utils.UsageTracking;
import java.io.File;
import org.netbeans.modules.cpp.loaders.CoreElfObject;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.netbeans.modules.debugger.support.DebuggerModule;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public final class DebugCorefileAction
extends NodeAction {
    static final long serialVersionUID = -6814567172958445516L;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        DataObject dao = (DataObject)activatedNodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DebugCorefileAction.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        return dao != null && dao instanceof CoreElfObject;
    }

    protected void performAction(Node[] activatedNodes) {
        String corefile = null;
        if (activatedNodes != null && activatedNodes.length > 0) {
            for (int i = 0; i < activatedNodes.length; ++i) {
                DataObject dao = (DataObject)activatedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? DebugCorefileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dao == null || !(dao instanceof CoreElfObject)) continue;
                FileObject fo = dao.getPrimaryFile();
                corefile = CppUtils.getPath((FileObject)fo);
            }
        }
        if (corefile != null) {
            this.performAction(null, corefile);
        }
    }

    public void performAction(String executable, String core) {
        if (UsageTracking.enabled) {
            UsageTracking.startTiming((String)"debugcore");
        }
        if (executable == null || executable.equals(DbxDebugger.getText("AutoCoreExe")) || executable.equals("") || executable.equals("-")) {
            executable = "-";
        } else {
            File exeFile = new File(executable);
            if (!exeFile.exists() || exeFile.isDirectory()) {
                StatusDisplayer.getDefault().setStatusText(DbxDebugger.getText("MSG_BadExecutable"));
                this.errorDialog(DbxDebugger.getText("MSG_BadExecutable"));
                return;
            }
        }
        File coreFile = new File(core);
        if (!coreFile.exists() || coreFile.isDirectory()) {
            StatusDisplayer.getDefault().setStatusText(DbxDebugger.getText("MSG_BadCoreFile"));
            this.errorDialog(DbxDebugger.getText("MSG_BadCoreFile"));
            return;
        }
        DbxDebuggerInfo info = new DbxDebuggerInfo(0, null, executable, -1L, core, null, null, null, null, null, null, executable + ": " + core);
        DebuggerModule.changeWorkspace();
        Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DebugCorefileAction.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        try {
            d.startDebugger((DebuggerInfo)info);
        }
        catch (DebuggerException e) {
            // empty catch block
        }
        if (UsageTracking.enabled) {
            UsageTracking.readTime((String)"debugcore", (String)"Debug Corefile", (boolean)true, null, (boolean)true);
        }
    }

    public String getName() {
        return DbxDebugger.getText("CTL_DebugCorefile");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Debugging_corefile");
    }

    protected String iconResource() {
        return "org/netbeans/modules/cpp/loaders/CoreElfIcon.gif";
    }

    private void errorDialog(String txt) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)txt, 0));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

