/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.VDLActions;
import com.sun.tools.debugger.dbxgui.utils.Log;
import com.sun.tools.swdev.lisp.LispBox;
import com.sun.tools.swdev.lisp.LispDocument;
import com.sun.tools.swdev.lisp.LispException;
import com.sun.tools.swdev.lisp.LispVal;

public class VDLParser {
    private static MyLispBox box = new MyLispBox();
    private VDLActions acts;
    private int version;

    public VDLParser(VDLActions acts) {
        this.acts = acts;
    }

    public void parse(String vdl_raw) {
        if (vdl_raw == null || vdl_raw.equals("<not active>")) {
            return;
        }
        LispDocument doc = new LispDocument((LispBox)box);
        try {
            doc.fill(vdl_raw);
        }
        catch (Exception x) {
            System.out.println("Bad Lisp VDL");
        }
        LispVal lv = doc.root();
        if (Log.enabled(1)) {
            LispVal.pp((LispVal)lv);
        }
        try {
            if (lv != null && lv.car() == VDLParser.box.key_vdl) {
                this.version = lv.cdr().car().cadr().numberValue();
                if (this.version == 1) {
                    this.error("Invalid vdl lisp version " + this.version);
                } else if (this.version == 2) {
                    this.parse_vdl2(lv.cdr());
                } else if (this.version == 3) {
                    this.parse_vdl2(lv.cdr());
                } else {
                    this.error("Invalid vdl lisp version " + this.version);
                }
            } else {
                this.error("Expected :vdl but got " + lv.car());
            }
        }
        catch (LispException x) {
            System.out.println("VDLParser.parse(): Couldn't format VDL -- Lisp error -- " + x.getMessage());
        }
        doc.delete();
    }

    private void error(String msg) {
        System.out.println("VDL: " + msg);
    }

    private void parse_vdl2(LispVal vdl) throws LispException {
        while (vdl != null) {
            LispVal item = vdl.car();
            if (item.car() == VDLParser.box.key_version) {
                this.version = item.cadr().numberValue();
            } else if (item.car() == VDLParser.box.key_root) {
                this.parse_root(item.cdr());
            } else {
                this.error("vdl: Expected :version|:root but got " + item.car());
            }
            vdl = vdl.cdr();
        }
    }

    private void parse_root(LispVal root) throws LispException {
        boolean is_const = false;
        while (root != null) {
            LispVal item = root.car();
            if (item.car() == VDLParser.box.key_code) {
                LispVal code = item.cadr();
            } else if (item.car() != VDLParser.box.key_id && item.car() != VDLParser.box.key_ltype && item.car() != VDLParser.box.key_addr) {
                if (item.car() == VDLParser.box.key_lang) {
                    if (item.cadr().displayToString().equals("java")) {
                        this.acts.setJava(true);
                    }
                } else if (item.car() != VDLParser.box.key_pid && item.car() != VDLParser.box.key_time) {
                    if (item.car() == VDLParser.box.key_delta) {
                        if (item.cadr().displayToString().equals("1")) {
                            this.acts.setDelta(true);
                        } else {
                            this.acts.setDelta(false);
                        }
                    } else if (item.car() != VDLParser.box.key_rflg) {
                        if (item.car() == VDLParser.box.key_ch) {
                            this.parse_ch(item.cdr());
                        } else {
                            this.error("root: Expected :code|:id|:ltype|:addr|:lang|:pid|:time|:delta|:rflg|:ch but got " + item.car());
                        }
                    }
                }
            }
            root = root.cdr();
        }
    }

    private void parse_ch(LispVal child) throws LispException {
        while (child != null) {
            LispVal ch = child.car();
            if (ch.car() == VDLParser.box.key_aggr) {
                this.parse_aggr(ch.cdr());
            } else if (ch.car() == VDLParser.box.key_smpl) {
                this.parse_smpl(ch.cdr());
            } else if (ch.car() == VDLParser.box.key_array) {
                this.parse_array(ch.cdr());
            } else {
                this.error("ch: Expected :aggr|:smpl|:array but got " + ch.car());
            }
            child = child.cdr();
        }
    }

    private void parse_c_array(Dimensions dims, long count, LispVal elems) throws LispException {
        boolean scalar = false;
        boolean array = false;
        scalar = elems.car().car() == VDLParser.box.key_smpl;
        boolean bl = array = elems.car().car() == VDLParser.box.key_array;
        while (elems != null) {
            LispVal elem = elems.car();
            if (elem != VDLParser.box.key_sep_comma && elem != VDLParser.box.key_sep_semicolon) {
                if (elem.car() == VDLParser.box.key_aggr) {
                    this.parse_aggr(elem.cdr());
                } else if (elem.car() == VDLParser.box.key_array) {
                    this.parse_array(elem.cdr());
                } else if (elem.car() == VDLParser.box.key_smpl) {
                    Format fmt = new Format();
                    this.parse_smpl(elem.cdr());
                } else {
                    this.error("c_array (regular): Expected :aggr|:array|:smpl but got " + elem.car());
                }
            }
            elems = elems.cdr();
        }
    }

    private void parse_array2(LispVal array, Dimensions dims, String name, String deref_name, String type, String atype) throws LispException {
        int count = 0;
        boolean delta = false;
        try {
            while (array != null) {
                LispVal aitem = array.car();
                if (aitem.car() == VDLParser.box.key_id) {
                    name = aitem.cadr().displayToString();
                } else if (aitem.car() == VDLParser.box.key_derefid) {
                    deref_name = aitem.cadr().displayToString();
                } else if (aitem.car() == VDLParser.box.key_ltype) {
                    type = aitem.cadr().displayToString();
                    atype = aitem.cadr().displayToString();
                } else if (aitem.car() != VDLParser.box.key_offset) {
                    if (aitem.car() == VDLParser.box.key_delta) {
                        delta = aitem.cadr().displayToString().equals("1");
                    } else if (aitem.car() != VDLParser.box.key_size && aitem.car() != VDLParser.box.key_eptr) {
                        if (aitem.car() == VDLParser.box.key_shape) {
                            LispVal dims_info = aitem.cadr();
                            dims.fill(dims_info);
                        } else if (aitem.car() == VDLParser.box.key_count) {
                            count = aitem.cadr().numberValue();
                        } else if (aitem.car() == VDLParser.box.key_ch) {
                            this.acts.startAggregate(name, deref_name, type, atype, delta);
                            this.parse_c_array(dims, count, aitem.cdr());
                            this.acts.endAggregate();
                        } else {
                            this.error("array2: Expected :colm|:id|:ltype|:size|:offset|:shape|:count|:eptr|:ch but got " + aitem.car());
                        }
                    }
                }
                array = array.cdr();
            }
        }
        catch (LispException x) {
            System.out.println("VDLParser.parse_array2(): Couldn't format VDL -- Lisp error -- " + x.getMessage());
        }
    }

    private void parse_array(LispVal array) throws LispException {
        Dimensions dims = new Dimensions();
        String name = null;
        String deref_name = null;
        String type = null;
        String atype = null;
        while (array != null) {
            LispVal aitem = array.car();
            if (aitem.car() == VDLParser.box.key_id) {
                name = aitem.cadr().displayToString();
            } else if (aitem.car() == VDLParser.box.key_derefid) {
                deref_name = aitem.cadr().displayToString();
            } else if (aitem.car() == VDLParser.box.key_ltype) {
                type = aitem.cadr().displayToString();
                atype = aitem.cadr().displayToString();
            } else if (aitem.car() != VDLParser.box.key_offset && aitem.car() != VDLParser.box.key_delta && aitem.car() != VDLParser.box.key_size && aitem.car() != VDLParser.box.key_eptr) {
                if (aitem.car() == VDLParser.box.key_shape) {
                    LispVal dims_info = aitem.cadr();
                    dims.fill(dims_info);
                } else {
                    if (aitem.car() == VDLParser.box.key_count) {
                        this.parse_array2(array, dims, name, deref_name, type, atype);
                        break;
                    }
                    this.error("array: Expected :colm|:id|:ltype|:size|:offset|:shape|:count|:eptr|:ch but got " + aitem.car());
                }
            }
            array = array.cdr();
        }
    }

    private void parse_aggr(LispVal aggr) throws LispException {
        String name = null;
        String deref_name = null;
        String type = null;
        String atype = null;
        boolean delta = false;
        boolean no_ch = true;
        boolean has_inherit = false;
        for (aggr = aggr.cdr(); aggr != null; aggr = aggr.cdr()) {
            LispVal aitem = aggr.car();
            if (aitem.car() == VDLParser.box.key_id) {
                name = aitem.cadr().displayToString();
                continue;
            }
            if (aitem.car() == VDLParser.box.key_derefid) {
                deref_name = aitem.cadr().displayToString();
                continue;
            }
            if (aitem.car() == VDLParser.box.key_ltype) {
                atype = type = aitem.cadr().displayToString();
                continue;
            }
            if (aitem.car() == VDLParser.box.key_flen || aitem.car() == VDLParser.box.key_comment || aitem.car() == VDLParser.box.key_offset) continue;
            if (aitem.car() == VDLParser.box.key_delta) {
                if (aitem.cadr().displayToString().equals("1")) {
                    delta = true;
                    continue;
                }
                delta = false;
                continue;
            }
            if (aitem.car() == VDLParser.box.key_size) continue;
            if (aitem.car() == VDLParser.box.key_ch) {
                no_ch = false;
                if (!has_inherit) {
                    this.acts.startAggregate(name, deref_name, type, atype, delta);
                }
                this.parse_ch(aitem.cdr());
                has_inherit = true;
                continue;
            }
            this.error("aggr: Expected :id|:ltype|:offset|:size|:ch but got " + aitem.car());
        }
        if (no_ch) {
            this.acts.setType(type, atype);
            this.acts.setLeaf(true);
            return;
        }
        this.acts.endAggregate();
    }

    private void parse_smpl(LispVal smpl) throws LispException {
        String hint = null;
        String ptr_type_str = null;
        String set_str = null;
        String name = null;
        String deref_name = null;
        String type = null;
        String atype = null;
        String value = null;
        boolean delta = false;
        while (smpl != null) {
            LispVal item = smpl.car();
            if (item.car() == VDLParser.box.key_hint) {
                hint = item.cadr().displayToString();
            } else if (item.car() == VDLParser.box.key_action) {
                set_str = this.parse_action(item.cdr(), VDLParser.box.key_set);
                ptr_type_str = this.parse_action(item.cdr(), VDLParser.box.key_deref);
            } else if (item.car() == VDLParser.box.key_id) {
                name = item.cadr().displayToString();
            } else if (item.car() == VDLParser.box.key_derefid) {
                deref_name = item.cadr().displayToString();
            } else if (item.car() == VDLParser.box.key_ltype) {
                type = item.cadr().displayToString();
                atype = item.cdr().cadr().displayToString();
            } else if (item.car() == VDLParser.box.key_sval) {
                value = item.cadr().displayToString();
            } else if (item.car() == VDLParser.box.key_delta) {
                delta = item.cadr().displayToString().equals("1");
            }
            smpl = smpl.cdr();
        }
        this.acts.newSmplval(name, deref_name, type, atype, value, set_str, ptr_type_str, delta);
    }

    private String parse_action(LispVal aitem, LispVal action) throws LispException {
        String action_str = null;
        while (aitem != null) {
            LispVal a = aitem.car();
            LispVal action_type = a.cadr();
            if (a.car() == action && a.car() == VDLParser.box.key_set) {
                action_str = action_type.displayToString();
            } else if (a.car() == action && a.car() == VDLParser.box.key_deref) {
                action_str = action_type.displayToString();
            }
            aitem = aitem.cdr();
        }
        return action_str;
    }

    class Dimensions {
        Dim[] dim = new Dim[10];
        int ndim;

        Dimensions() {
            for (int dx = 0; dx < 10; ++dx) {
                this.dim[dx] = new Dim();
            }
            this.ndim = 0;
        }

        void fill(LispVal dinfo) throws LispException {
            this.ndim = dinfo.car().numberValue();
            dinfo = dinfo.cdr();
            for (int dx = 0; dx < this.ndim; ++dx) {
                LispVal rinfo = dinfo.car();
                Dim d = this.dim[dx];
                d.cur = d.lo = rinfo.car().numberValue();
                d.hi = rinfo.cadr().numberValue();
                d.stride = rinfo.cddr() != null ? rinfo.cadr().numberValue() : 0;
                dinfo = dinfo.cdr();
            }
        }

        void inc_index(int i) {
            this.dim[i].cur += this.dim[i].stride;
            if (this.dim[i].stride > 0) {
                if (this.dim[i].cur > this.dim[i].hi) {
                    this.dim[i].cur = this.dim[i].lo;
                    this.inc_index(i + 1);
                }
            } else if (this.dim[i].stride < 0 && this.dim[i].cur < this.dim[i].hi) {
                this.dim[i].cur = this.dim[i].lo;
                this.inc_index(i + 1);
            }
        }
    }

    class Dim {
        String str;
        int lo;
        int hi;
        int stride;
        int cur;

        Dim() {
        }
    }

    class Format {
        int flen = 0;
        boolean f_array_index_id_on = false;

        Format() {
        }
    }

    static class MyLispBox
    extends LispBox {
        final LispVal key_vdl = this.intern(":vdl");
        final LispVal key_version = this.intern(":version");
        final LispVal key_root = this.intern(":root");
        final LispVal key_code = this.intern(":code");
        final LispVal key_id = this.intern(":id");
        final LispVal key_derefid = this.intern(":derefid");
        final LispVal key_ltype = this.intern(":ltype");
        final LispVal key_addr = this.intern(":addr");
        final LispVal key_lang = this.intern(":lang");
        final LispVal key_pid = this.intern(":pid");
        final LispVal key_time = this.intern(":time");
        final LispVal key_delta = this.intern(":delta");
        final LispVal key_rflg = this.intern(":rflg");
        final LispVal key_ch = this.intern(":ch");
        final LispVal key_aggr = this.intern(":aggr");
        final LispVal key_smpl = this.intern(":smpl");
        final LispVal key_array = this.intern(":array");
        final LispVal key_count = this.intern(":count");
        final LispVal key_eptr = this.intern(":eptr");
        final LispVal key_shape = this.intern(":shape");
        final LispVal key_sep_comma = this.intern(":sep,");
        final LispVal key_sep_semicolon = this.intern(":sep-semicolon");
        final LispVal key_action = this.intern(":action");
        final LispVal key_set = this.intern(":set");
        final LispVal key_deref = this.intern(":deref");
        final LispVal key_hint = this.intern(":hint");
        final LispVal key_note = this.intern(":note");
        final LispVal key_member = this.intern(":member");
        final LispVal key_identifier = this.intern(":identifier");
        final LispVal key_value = this.intern(":value");
        final LispVal key_tag = this.intern(":tag");
        final LispVal key_smplval = this.intern(":smplval");
        final LispVal key_flen = this.intern(":flen");
        final LispVal key_comment = this.intern(":comment");
        final LispVal key_offset = this.intern(":offset");
        final LispVal key_size = this.intern(":size");
        final LispVal key_sval = this.intern(":sval");

        MyLispBox() {
        }
    }
}

