/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.RunConfigDialog;
import com.sun.tools.swdev.glue.dbx.DbxSignalInfoInit;
import javax.swing.table.AbstractTableModel;

public final class SignalTableModel
extends AbstractTableModel {
    private RunConfigDialog dialog = null;
    private DbxSignalInfoInit[] signals = null;
    private int rowCount = 0;
    private int colCount = 0;
    private String[] columnName = null;
    private boolean haveSignals = false;
    static /* synthetic */ Class class$java$lang$String;

    public SignalTableModel() {
    }

    public SignalTableModel(RunConfigDialog dialog) {
        this.dialog = dialog;
        this.colCount = 4;
        this.columnName = new String[4];
        this.columnName[0] = DbxDebugger.getText("Signal_Number");
        this.columnName[1] = DbxDebugger.getText("Signal_Signal");
        this.columnName[2] = DbxDebugger.getText("Signal_Desc");
        this.columnName[3] = DbxDebugger.getText("Signal_Handled");
        this.rowCount = 0;
        this.haveSignals = false;
    }

    public int getRowCount() {
        if (this.haveSignals) {
            return this.rowCount;
        }
        return 1;
    }

    public int getColumnCount() {
        return this.colCount;
    }

    public String getColumnName(int columnIndex) {
        return this.columnName[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$String == null ? (class$java$lang$String = SignalTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.haveSignals) {
            return false;
        }
        return columnIndex == 3;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.haveSignals || this.rowCount < 0) {
            if (columnIndex == 2) {
                return DbxDebugger.getText("NoSigsUntilDebug");
            }
            return "";
        }
        if (this.rowCount == 0) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                return new Integer(this.signals[rowIndex].signo);
            }
            case 1: {
                return this.signals[rowIndex].name;
            }
            case 2: {
                return this.signals[rowIndex].description;
            }
            case 3: {
                if (this.signals[rowIndex].caught) {
                    if (this.signals[rowIndex].caught_by_default) {
                        return DbxDebugger.getText("Signal_CaughtDefault");
                    }
                    return DbxDebugger.getText("Signal_Caught");
                }
                if (this.signals[rowIndex].caught_by_default) {
                    return DbxDebugger.getText("Signal_Ignored");
                }
                return DbxDebugger.getText("Signal_IgnoredDefault");
            }
        }
        return "";
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        DbxSignalInfoInit d = new DbxSignalInfoInit();
        d.name = this.signals[rowIndex].name;
        d.signo = this.signals[rowIndex].signo;
        d.description = this.signals[rowIndex].description;
        d.caught_by_default = this.signals[rowIndex].caught_by_default;
        String ignored = DbxDebugger.getText("Signal_Ignored");
        String caught = DbxDebugger.getText("Signal_Caught");
        String val = value.toString();
        d.caught = ignored.equals(val) ? false : (caught.equals(val) ? true : this.signals[rowIndex].caught_by_default);
        this.signals[rowIndex] = d;
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void signalsUpdated(DbxSignalInfoInit[] newsignals) {
        if (this.rowCount != 0) {
            this.fireTableRowsDeleted(0, this.rowCount);
        }
        if (newsignals == null) {
            return;
        }
        int n = newsignals.length - 1;
        this.signals = new DbxSignalInfoInit[n];
        for (int i = 0; i < n; ++i) {
            this.signals[i] = newsignals[i];
        }
        this.rowCount = n;
        this.haveSignals = true;
        this.fireTableRowsInserted(0, this.rowCount);
    }

    public void signalUpdated(int signo, boolean ignore) {
        if (this.signals == null) {
            return;
        }
        int line = signo - 1;
        this.signals[line].caught = !ignore;
        this.fireTableRowsUpdated(line, line);
    }

    public void noSignals() {
        this.haveSignals = false;
    }

    public DbxSignalInfoInit[] getSignals() {
        return this.signals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

