/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugSession;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.options.DebuggingOption;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.swdev.common.base.UnixPtyActivityEvent;
import com.sun.tools.swdev.common.base.UnixPtyActivityListener;
import com.sun.tools.swdev.common.nbtext.UnixTabTerm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.lib.terminalemulator.Term;
import org.openide.actions.CopyAction;
import org.openide.actions.PasteAction;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.PasteType;

public final class ProgramIOWindow
extends UnixTabTerm
implements PropertyChangeListener,
ComponentListener,
ActionListener,
UnixPtyActivityListener {
    static final long serialVersionUID = -3699930963876272495L;
    private transient Term term = null;
    private Dbx dbx = null;
    private boolean firstTime = true;
    private DbxDebugSession lastHiddenSession = null;
    private JTextArea warningText = null;
    private JMenuItem findItem = null;
    private JMenuItem clearItem = null;
    private JMenuItem flushItem = null;
    private ActionPerformer copyActionPerformer = null;
    private static CopyAction copy = null;
    private static PasteAction paste = null;
    private CBListener cblistener;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;

    public ProgramIOWindow(Dbx dbx) {
        super(DbxDebugger.getText("CTL_Process_output"));
        this.term = dbx.getPioTerm();
        this.dbx = dbx;
        this.createComponents();
        this.initializeA11y();
    }

    private void createComponents() {
        this.setLayout(new BorderLayout());
        this.addPopupListener((JComponent)((Object)this));
        if (this.term != null) {
            this.add((Component)this.term, "Center");
            this.addPopupListener(this.term.getCanvas());
        }
    }

    public void componentShown(ComponentEvent e) {
        if (this.firstTime) {
            this.firstTime = false;
            this.setSize(this.getPreferredSize());
            this.validate();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void ptyActivity(UnixPtyActivityEvent unused) {
        if (DebuggingOption.FRONT_PIO.isEnabled() && DebuggingOption.RUN_IO.getCurrValue().equals("window")) {
            this.requestVisible();
        }
    }

    public void setTerm(Term newTerm) {
        if (newTerm == this.term) {
            return;
        }
        if (this.term != null) {
            this.remove((Component)this.term);
            this.removePopupListener(this.term.getCanvas());
        } else if (this.warningText != null) {
            this.remove(this.warningText);
            this.removePopupListener(this.warningText);
        }
        this.term = newTerm;
        if (this.term != null) {
            this.add((Component)this.term, "Center");
            this.addPopupListener(this.term.getCanvas());
        } else {
            if (this.warningText == null) {
                this.warningText = new JTextArea();
                this.warningText.setBackground((Color)UIManager.getDefaults().get("Label.background"));
                this.warningText.setWrapStyleWord(true);
                this.warningText.setLineWrap(true);
                this.warningText.setEditable(false);
                this.warningText.setText(DbxDebugger.getText("MSG_InvalidIO"));
            }
            this.add(this.warningText, "Center");
            this.addPopupListener(this.warningText);
        }
        this.validate();
        this.repaint();
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] termActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ProgramIOWindow.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ProgramIOWindow.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null};
        return termActions;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.clearItem) {
            if (this.term != null) {
                this.term.clearHistory();
                this.term.clear();
            }
        } else if (actionEvent.getSource() == this.flushItem && this.dbx != null) {
            this.dbx.flushInput();
        }
    }

    protected void populateMenu(Object source, int xpos, int ypos, JPopupMenu popup) {
        this.flushItem = new JMenuItem(DbxDebugger.getText("IFlush"));
        popup.add(this.flushItem);
        this.flushItem.addActionListener(this);
        this.clearItem = new JMenuItem(DbxDebugger.getText("TermClear"));
        popup.add(this.clearItem);
        this.clearItem.addActionListener(this);
        popup.addSeparator();
        this.findItem = new JMenuItem(DbxDebugger.getText("Find"));
        this.findItem.setEnabled(false);
        popup.add(this.findItem);
        this.findItem.addActionListener(this);
        popup.addSeparator();
        this.addSystemActionsToMenu(popup);
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.term != null) {
            this.term.getCanvas().requestFocus();
        }
    }

    protected void componentActivated() {
        Clipboard c;
        if (this.cblistener == null) {
            this.cblistener = new CBListener();
        }
        if ((c = IpeUtils.getClipboard()) instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.addClipboardListener((ClipboardListener)this.cblistener);
        }
        this.activateActions();
        super.componentActivated();
    }

    protected void componentDeactivated() {
        Clipboard c = IpeUtils.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.removeClipboardListener((ClipboardListener)this.cblistener);
        }
        this.deactivateActions();
        super.componentDeactivated();
    }

    private void activateActions() {
        this.enableCopy();
        this.updatePasteAction();
    }

    private void deactivateActions() {
        if (this.copyActionPerformer != null) {
            copy.setActionPerformer(null);
        }
        if (paste != null) {
            paste.setPasteTypes(null);
        }
    }

    private void enableCopy() {
        ActionPerformer perf;
        if (this.copyActionPerformer == null) {
            this.copyActionPerformer = new CopyActionPerformer();
            copy = (CopyAction)CopyAction.findObject((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ProgramIOWindow.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction), (boolean)true);
        }
        if ((perf = copy.getActionPerformer()) != this.copyActionPerformer) {
            copy.setActionPerformer(this.copyActionPerformer);
        }
    }

    private void disableCutCopyDelete() {
        if (this.copyActionPerformer != null) {
            copy.setActionPerformer(null);
        }
    }

    private void updatePasteAction() {
        Clipboard clipboard;
        Transferable trans;
        if (paste == null) {
            paste = (PasteAction)PasteAction.findObject((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ProgramIOWindow.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), (boolean)true);
        }
        if ((trans = (clipboard = IpeUtils.getClipboard()).getContents(this)) != null) {
            DataFlavor[] df = trans.getTransferDataFlavors();
            int n = 0;
            if (df != null) {
                n = df.length;
            }
            for (int i = 0; i < n; ++i) {
                if (!df[i].getMimeType().startsWith("text/plain")) continue;
                PasteType[] pasteTypes = new PasteType[]{new Paste()};
                paste.setPasteTypes(pasteTypes);
                return;
            }
        }
        paste.setPasteTypes(null);
    }

    public void topComponentOpened(String tab_name, boolean open) {
        if (this.dbx != null && this.dbx.getDebugger() != null) {
            this.dbx.getDebugger().openOutputTab(this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CBListener
    implements ClipboardListener {
        private CBListener() {
        }

        public void clipboardChanged(ClipboardEvent ev) {
            if (!ev.isConsumed()) {
                ProgramIOWindow.this.updatePasteAction();
            }
        }
    }

    class CopyActionPerformer
    implements ActionPerformer {
        public void performAction(SystemAction action) {
            if (ProgramIOWindow.this.term == null) {
                return;
            }
            String txt = ProgramIOWindow.this.term.getSelectedText();
            if (txt != null) {
                ProgramIOWindow.this.term.copy();
                ProgramIOWindow.this.updatePasteAction();
            }
        }
    }

    private class Paste
    extends PasteType {
        private Paste() {
        }

        public Transferable paste() throws IOException {
            ProgramIOWindow.this.term.paste();
            return null;
        }
    }
}

