/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.BreakpointAnnotation;
import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.AccessBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.ClassMethodBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.CondBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.DebuggerBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.ExceptionBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.FaultBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.FunctionBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.InstructionBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.LineBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.LoadObjBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.ObjectBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.ProcessBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.SignalBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.SysCallBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.TimerBreakpoint;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.VariableBreakpoint;
import com.sun.tools.debugger.dbxgui.props.AccessBA;
import com.sun.tools.debugger.dbxgui.props.Action;
import com.sun.tools.debugger.dbxgui.props.DebuggerEvent;
import com.sun.tools.debugger.dbxgui.props.DlEvent;
import com.sun.tools.debugger.dbxgui.props.ExceptionSpec;
import com.sun.tools.debugger.dbxgui.props.FunctionSubEvent;
import com.sun.tools.debugger.dbxgui.props.ProcessEvent;
import com.sun.tools.debugger.dbxgui.props.SysCallEE;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.swdev.glue.dbx.DbxHandler;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.openide.ErrorManager;
import org.openide.text.Line;

public final class IpeHandler {
    private DbxHandler handler = null;
    private IpeBreakpointEvent event = null;
    private boolean isConditional = false;
    private boolean isFired = false;
    private ArrayList annotations = null;
    private int nextAnnotationId = 0;
    private String summary;
    private DbxDebugger debugger;
    private boolean inProgress;
    private static final String debugger_icon_dir = "org/netbeans/modules/debugger/resources/editor";
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LineBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FunctionBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ClassMethodBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$AccessBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$CondBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ObjectBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$TimerBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FaultBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SignalBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SysCallBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ExceptionBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LoadObjBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$VariableBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$InstructionBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$DebuggerBreakpoint;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ProcessBreakpoint;

    public IpeHandler(DbxDebugger debugger, DbxHandler handler, IpeBreakpointEvent event) {
        this.debugger = debugger;
        this.handler = handler;
        this.event = event;
        event.setHandler(this);
        this.refresh(true);
    }

    public DbxDebugger getDebugger() {
        return this.debugger;
    }

    public Dbx getDbx() {
        return this.debugger.getEngine();
    }

    public DbxHandler getHandler() {
        return this.handler;
    }

    public IpeBreakpointEvent getEvent() {
        return this.event;
    }

    public void setHandler(DbxHandler h) {
        this.handler = h;
        this.refresh(true);
    }

    public void setEnabled(boolean enabled) {
        this.handler.enabled = enabled;
        this.refresh(false);
        this.event.setEnabled(enabled);
    }

    public void postEnabled(boolean enabled) {
        if (this.getDebugger().ignoreUpdates()) {
            return;
        }
        if (this.handler.enabled == enabled) {
            return;
        }
        this.getDbx().setHandlerEnabled(this.handler.id, enabled);
    }

    public int getHid() {
        return this.handler.id;
    }

    public boolean isFired() {
        return this.isFired;
    }

    public void setFired(boolean fired) {
        if (this.isFired == fired) {
            return;
        }
        this.isFired = fired;
        this.summary = null;
        if (this.event != null) {
            this.event.refresh();
        }
    }

    public void addAnnotation(String filename, int line) {
        Line l = DbxDebugger.getLine(filename, line);
        if (l != null) {
            this.addAnnotation(l);
        }
    }

    public void addAnnotation(Line l) {
        MyAnnotation a = new MyAnnotation(l);
        String type = this.getType();
        a.delegate.attachLine(l, type);
        if (this.annotations == null) {
            this.annotations = new ArrayList(1);
        }
        this.annotations.add(a);
    }

    public boolean matchesLine(Line l) {
        if (this.annotations == null) {
            return false;
        }
        int n = this.annotations.size();
        for (int j = 0; j < n; ++j) {
            MyAnnotation ma = (MyAnnotation)this.annotations.get(j);
            BreakpointAnnotation a = ma.delegate;
            if (a.getLine() == null || !a.getLine().equals(l)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnnotations() {
        return this.annotations != null && this.annotations.size() > 0;
    }

    public BreakpointAnnotation getNextAnnotation() {
        if (this.annotations == null) {
            return null;
        }
        int n = this.annotations.size();
        if (n == 0) {
            return null;
        }
        BreakpointAnnotation r = null;
        if (this.nextAnnotationId == n) {
            this.nextAnnotationId = 0;
        }
        MyAnnotation ma = (MyAnnotation)this.annotations.get(this.nextAnnotationId);
        r = ma.delegate;
        ++this.nextAnnotationId;
        return r;
    }

    public void removeAnnotations() {
        if (this.annotations == null) {
            return;
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            MyAnnotation ma = (MyAnnotation)this.annotations.get(i);
            BreakpointAnnotation a = ma.delegate;
            a.detachLine();
        }
    }

    public void reinstateAnnotations() {
        if (this.annotations == null) {
            return;
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            MyAnnotation ma = (MyAnnotation)this.annotations.get(i);
            BreakpointAnnotation a = ma.delegate;
            a.attachLine(ma.line, this.getType());
        }
    }

    public void updateEvent(String newEventSpec) {
        this.handler.qeventspec = newEventSpec;
    }

    public void updateModifier(boolean add, String modifier) {
        if (add) {
            String[] nm = new String[this.handler.nqmodifiers + 1];
            for (int i = 0; i < this.handler.nqmodifiers; ++i) {
                nm[i] = this.handler.qmodifiers[i];
            }
            nm[i] = modifier;
            this.handler.qmodifiers = nm;
            ++this.handler.nqmodifiers;
        } else {
            int i;
            int n = this.handler.nqmodifiers;
            for (i = 0; i < n && !modifier.equals(this.handler.qmodifiers[i]); ++i) {
            }
            if (i == n) {
                return;
            }
            --n;
            while (i < n) {
                this.handler.qmodifiers[i] = this.handler.qmodifiers[i + 1];
                ++i;
            }
            this.handler.nqmodifiers = n;
        }
    }

    public void updateModifier(String modifier, String value) {
        int i;
        if (value != null) {
            value = value.trim();
        }
        int n = this.handler.nqmodifiers;
        for (i = 0; i < n && !this.handler.qmodifiers[i].startsWith(modifier); ++i) {
        }
        if (value == null || value.length() == 0) {
            if (i == n) {
                return;
            }
            --n;
            while (i < n) {
                this.handler.qmodifiers[i] = this.handler.qmodifiers[i + 1];
                ++i;
            }
            this.handler.nqmodifiers = n;
        } else if (i == n) {
            String[] nm = new String[n + 1];
            for (i = 0; i < n; ++i) {
                nm[i] = this.handler.qmodifiers[i];
            }
            nm[i] = modifier + " " + value;
            this.handler.qmodifiers = nm;
            ++this.handler.nqmodifiers;
        } else {
            this.handler.qmodifiers[i] = modifier + " " + value;
        }
    }

    public static IpeBreakpointEvent createIBE(DbxHandler h) {
        IpeBreakpointEvent ibe = null;
        if (h.eventspec != null) {
            if (h.eventspec.startsWith("at ")) {
                ibe = IpeHandler.modifierIsSetIn("-instr", h) ? new InstructionBreakpoint() : new LineBreakpoint();
            } else if (h.eventspec.startsWith("in ")) {
                ibe = new FunctionBreakpoint();
            } else if (h.eventspec.startsWith("returns")) {
                ibe = new FunctionBreakpoint();
            } else if (h.eventspec.startsWith("infunction ")) {
                ibe = new FunctionBreakpoint();
            } else if (h.eventspec.startsWith("infunction ")) {
                ibe = new FunctionBreakpoint();
            } else if (h.eventspec.startsWith("modify ")) {
                ibe = new AccessBreakpoint();
            } else if (h.eventspec.startsWith("access ")) {
                ibe = new AccessBreakpoint();
            } else if (h.eventspec.startsWith("inmember ")) {
                ibe = new ClassMethodBreakpoint();
            } else if (h.eventspec.startsWith("inclass ")) {
                ibe = new ClassMethodBreakpoint();
            } else if (h.eventspec.startsWith("cond ")) {
                ibe = new CondBreakpoint();
            } else if (h.eventspec.startsWith("throw")) {
                ibe = new ExceptionBreakpoint();
            } else if (h.eventspec.startsWith("fault ")) {
                ibe = new FaultBreakpoint();
            } else if (h.eventspec.startsWith("dlopen")) {
                ibe = new LoadObjBreakpoint();
            } else if (h.eventspec.startsWith("dlclose")) {
                ibe = new LoadObjBreakpoint();
            } else if (h.eventspec.startsWith("inobject")) {
                ibe = new ObjectBreakpoint();
            } else if (h.eventspec.startsWith("attach")) {
                ibe = new DebuggerBreakpoint();
            } else if (h.eventspec.startsWith("detach")) {
                ibe = new DebuggerBreakpoint();
            } else if (h.eventspec.startsWith("exit")) {
                ibe = new ProcessBreakpoint();
            } else if (h.eventspec.equals("sync")) {
                ibe = new ProcessBreakpoint();
            } else if (h.eventspec.equals("syncrtld")) {
                ibe = new ProcessBreakpoint();
            } else if (h.eventspec.equals("next")) {
                ibe = new ProcessBreakpoint();
            } else if (h.eventspec.equals("step")) {
                ibe = new ProcessBreakpoint();
            } else if (h.eventspec.equals("stop")) {
                ibe = new ProcessBreakpoint();
            } else if (h.eventspec.equals("lastrites")) {
                ibe = new ProcessBreakpoint();
            } else if (h.eventspec.equals("proc_gone")) {
                ibe = new ProcessBreakpoint();
            } else if (h.eventspec.startsWith("lwp_exit")) {
                ibe = new ProcessBreakpoint();
            } else if (h.eventspec.startsWith("sig ")) {
                ibe = new SignalBreakpoint();
            } else if (h.eventspec.startsWith("sysin")) {
                ibe = new SysCallBreakpoint();
            } else if (h.eventspec.startsWith("sysout")) {
                ibe = new SysCallBreakpoint();
            } else if (h.eventspec.startsWith("change ")) {
                ibe = new VariableBreakpoint();
            } else if (h.eventspec.startsWith("timer ")) {
                ibe = new TimerBreakpoint();
            } else {
                ErrorManager.getDefault().log("unknown handler type" + h.eventspec);
                return null;
            }
        }
        return ibe;
    }

    private void setSpecificProperties(IpeBreakpointEvent ibe, DbxHandler h) {
        if (h.eventspec != null) {
            if (h.eventspec.startsWith("at ")) {
                if (this.modifierIsSet("-instr")) {
                    InstructionBreakpoint ib = (InstructionBreakpoint)ibe;
                    String address = h.eventspec.substring(3);
                    ib.setAddress(address);
                } else {
                    LineBreakpoint lb = (LineBreakpoint)ibe;
                    int fileBegin = h.qeventspec.indexOf(34);
                    int fileEnd = h.qeventspec.indexOf(34, ++fileBegin);
                    String filename = h.qeventspec.substring(fileBegin, fileEnd);
                    int line = Integer.parseInt(h.qeventspec.substring(fileEnd + 2));
                    lb.setFileAndLine(filename, line);
                }
            } else if (h.eventspec.startsWith("in ")) {
                FunctionBreakpoint fb = (FunctionBreakpoint)ibe;
                String function = h.eventspec.substring(3);
                String qfunction = h.qeventspec.substring(3);
                fb.setFunction(function);
                fb.setQfunction(qfunction);
                fb.setSubEvent(FunctionSubEvent.IN);
            } else if (h.eventspec.startsWith("returns")) {
                FunctionBreakpoint fb = (FunctionBreakpoint)ibe;
                if (h.eventspec.length() > 7) {
                    String function = h.eventspec.substring(8);
                    String qfunction = h.qeventspec.substring(8);
                    fb.setFunction(function);
                    fb.setQfunction(qfunction);
                }
                fb.setSubEvent(FunctionSubEvent.RETURNS);
            } else if (h.eventspec.startsWith("infunction ")) {
                FunctionBreakpoint fb = (FunctionBreakpoint)ibe;
                String function = h.eventspec.substring(11);
                String qfunction = h.qeventspec.substring(11);
                fb.setFunction(function);
                fb.setQfunction(qfunction);
                fb.setSubEvent(FunctionSubEvent.INFUNCTION);
            } else if (h.eventspec.startsWith("access ") || h.eventspec.startsWith("modify ")) {
                char c;
                AccessBreakpoint fb = (AccessBreakpoint)ibe;
                boolean is_modify = false;
                fb.setRead(false);
                if (h.eventspec.startsWith("modify ")) {
                    is_modify = true;
                    fb.setWrite(true);
                } else {
                    fb.setWrite(false);
                }
                fb.setExecute(false);
                int index = 7;
                while (!is_modify && (c = h.eventspec.charAt(index++)) != ' ') {
                    switch (c) {
                        case 'a': {
                            fb.setWhen(AccessBA.AFTER);
                            break;
                        }
                        case 'b': {
                            fb.setWhen(AccessBA.BEFORE);
                            break;
                        }
                        case 'r': {
                            fb.setRead(true);
                            break;
                        }
                        case 'w': {
                            fb.setWrite(true);
                            break;
                        }
                        case 'x': {
                            fb.setExecute(true);
                            break;
                        }
                    }
                }
                int lastIndex = h.eventspec.indexOf(44, index);
                if (lastIndex == -1) {
                    lastIndex = h.eventspec.length();
                }
                String address = h.eventspec.substring(index, lastIndex);
                String length = h.eventspec.substring(lastIndex + 2);
                fb.setAddress(address);
                fb.setSize(length);
            } else if (h.eventspec.startsWith("inmember ")) {
                ClassMethodBreakpoint fb = (ClassMethodBreakpoint)ibe;
                String method = h.eventspec.substring(9);
                String qmethod = h.qeventspec.substring(9);
                fb.setMethodName(method.trim());
                fb.setQmethodName(qmethod.trim());
            } else if (h.eventspec.startsWith("inclass ")) {
                ClassMethodBreakpoint fb = (ClassMethodBreakpoint)ibe;
                String cls = h.eventspec.substring(7);
                String qcls = h.qeventspec.substring(7);
                fb.setClassName(cls.trim());
                fb.setQclassName(qcls.trim());
                if (this.modifierIsSet("-recurse")) {
                    fb.setRecurse(true);
                } else if (this.modifierIsSet("-norecurse")) {
                    fb.setRecurse(false);
                } else {
                    fb.setRecurse(false);
                }
            } else if (h.eventspec.startsWith("cond ")) {
                CondBreakpoint cb = (CondBreakpoint)ibe;
                String cond = h.eventspec.substring(5);
                cb.setCond(cond);
            } else if (h.eventspec.startsWith("throw")) {
                ExceptionBreakpoint eb = (ExceptionBreakpoint)ibe;
                if (h.eventspec.length() > 6) {
                    String exc = h.eventspec.substring(6);
                    if (exc.equals("-unhandled")) {
                        eb.setException(ExceptionSpec.UNCAUGHT);
                    } else if (exc.equals("-unexpected")) {
                        eb.setException(ExceptionSpec.UNEXPECTED);
                    } else {
                        eb.setException(ExceptionSpec.byTag(exc));
                    }
                } else {
                    eb.setException(ExceptionSpec.ALL);
                }
            } else if (h.eventspec.startsWith("fault ")) {
                FaultBreakpoint fb = (FaultBreakpoint)ibe;
                String flt = h.eventspec.substring(6);
                fb.setFault(flt);
            } else if (h.eventspec.startsWith("dlopen")) {
                LoadObjBreakpoint lob = (LoadObjBreakpoint)ibe;
                lob.setDlEvent(DlEvent.OPEN);
                if (h.eventspec.length() > 6) {
                    String o = h.eventspec.substring(7);
                    lob.setLoadObj(o);
                } else {
                    lob.setLoadObj(null);
                }
            } else if (h.eventspec.startsWith("dlclose")) {
                LoadObjBreakpoint lob = (LoadObjBreakpoint)ibe;
                lob.setDlEvent(DlEvent.CLOSE);
                if (h.eventspec.length() > 7) {
                    String o = h.eventspec.substring(8);
                    lob.setLoadObj(o);
                } else {
                    lob.setLoadObj(null);
                }
            } else if (h.eventspec.startsWith("inobject")) {
                ObjectBreakpoint ob = (ObjectBreakpoint)ibe;
                String object = h.eventspec.substring(9);
                ob.setObject(object);
                if (this.modifierIsSet("-recurse")) {
                    ob.setRecurse(true);
                } else if (this.modifierIsSet("-norecurse")) {
                    ob.setRecurse(false);
                } else {
                    ob.setRecurse(true);
                }
            } else if (h.eventspec.startsWith("attach")) {
                DebuggerBreakpoint db = (DebuggerBreakpoint)ibe;
                db.setSubEvent(DebuggerEvent.ATTACH);
            } else if (h.eventspec.startsWith("detach")) {
                DebuggerBreakpoint db = (DebuggerBreakpoint)ibe;
                db.setSubEvent(DebuggerEvent.DETACH);
            } else if (h.eventspec.startsWith("exit")) {
                ProcessBreakpoint pb = (ProcessBreakpoint)ibe;
                pb.setSubEvent(ProcessEvent.EXIT);
                if (h.eventspec.length() > 5) {
                    String o = h.eventspec.substring(5);
                    pb.setExitCode(o);
                }
            } else if (h.eventspec.equals("sync")) {
                ProcessBreakpoint pb = (ProcessBreakpoint)ibe;
                pb.setSubEvent(ProcessEvent.SYNC);
            } else if (h.eventspec.equals("syncrtld")) {
                ProcessBreakpoint pb = (ProcessBreakpoint)ibe;
                pb.setSubEvent(ProcessEvent.SYNCRTLD);
            } else if (h.eventspec.equals("next")) {
                ProcessBreakpoint pb = (ProcessBreakpoint)ibe;
                pb.setSubEvent(ProcessEvent.NEXT);
            } else if (h.eventspec.equals("step")) {
                ProcessBreakpoint pb = (ProcessBreakpoint)ibe;
                pb.setSubEvent(ProcessEvent.STEP);
            } else if (h.eventspec.equals("stop")) {
                ProcessBreakpoint pb = (ProcessBreakpoint)ibe;
                pb.setSubEvent(ProcessEvent.STOP);
            } else if (h.eventspec.equals("lastrites")) {
                ProcessBreakpoint pb = (ProcessBreakpoint)ibe;
                pb.setSubEvent(ProcessEvent.LASTRITES);
            } else if (h.eventspec.equals("proc_gone")) {
                ProcessBreakpoint pb = (ProcessBreakpoint)ibe;
                pb.setSubEvent(ProcessEvent.GONE);
            } else if (h.eventspec.equals("lwp_exit")) {
                ProcessBreakpoint pb = (ProcessBreakpoint)ibe;
                pb.setSubEvent(ProcessEvent.LWP_EXIT);
            } else if (h.eventspec.startsWith("sig ")) {
                SignalBreakpoint fb = (SignalBreakpoint)ibe;
                int index = h.eventspec.indexOf(32, 4);
                if (index == -1) {
                    fb.setSignal(h.eventspec.substring(4));
                    fb.setSubcode(null);
                } else {
                    fb.setSignal(h.eventspec.substring(4, index));
                    fb.setSubcode(h.eventspec.substring(index + 1));
                }
            } else if (h.eventspec.startsWith("sysin")) {
                SysCallBreakpoint scb = (SysCallBreakpoint)ibe;
                scb.setEntryExit(SysCallEE.ENTRY);
                if (h.eventspec.length() > 6) {
                    String o = h.eventspec.substring(6);
                    scb.setSysCall(o);
                } else {
                    scb.setSysCall(null);
                }
            } else if (h.eventspec.startsWith("sysout")) {
                SysCallBreakpoint scb = (SysCallBreakpoint)ibe;
                scb.setEntryExit(SysCallEE.EXIT);
                if (h.eventspec.length() > 7) {
                    String o = h.eventspec.substring(7);
                    scb.setSysCall(o);
                } else {
                    scb.setSysCall(null);
                }
            } else if (h.eventspec.startsWith("change ")) {
                VariableBreakpoint vb = (VariableBreakpoint)ibe;
                vb.setVariable(h.eventspec.substring(7));
            } else if (h.eventspec.startsWith("timer ")) {
                TimerBreakpoint tb = (TimerBreakpoint)ibe;
                tb.setSeconds(Float.parseFloat(h.eventspec.substring(6)));
            } else {
                ErrorManager.getDefault().log("generic breakpoint not yet implemented; h.eventspec is " + h.eventspec + " and h.qeventspec is " + h.qeventspec);
                LineBreakpoint fb = new LineBreakpoint();
                ibe = fb;
            }
        }
    }

    public void possiblyDisable() {
        if (!this.handler.enabled) {
            CoreBreakpoint cb = this.event.getBreakpoint();
            cb.setEnabled(false);
        }
    }

    private static String fixBody(String body) {
        if (body == null) {
            return null;
        }
        int n = body.length();
        StringBuffer sb = new StringBuffer(n);
        int lastImportantIndex = 0;
        boolean comment = false;
        boolean escape = false;
        boolean quote = false;
        boolean needSemiColon = false;
        for (int i = 0; i < n; ++i) {
            char c = body.charAt(i);
            if (!comment) {
                if (c == '\\' && !quote) {
                    ++i;
                } else if (c == '\"') {
                    quote = !quote;
                    sb.append(c);
                } else if (c == '#' && !quote) {
                    comment = true;
                } else if (c == '\n') {
                    sb.append(c);
                    lastImportantIndex = sb.length();
                    needSemiColon = false;
                } else if (c == ';') {
                    if (needSemiColon) {
                        sb.append(c);
                        lastImportantIndex = sb.length();
                    }
                    needSemiColon = false;
                } else {
                    sb.append(c);
                    if (!Character.isWhitespace(c) && c != ';') {
                        needSemiColon = true;
                    }
                }
                if (Character.isWhitespace(c) || c == ';') continue;
                lastImportantIndex = sb.length();
                continue;
            }
            if (c != '\n') continue;
            comment = false;
        }
        sb.setLength(lastImportantIndex);
        if (needSemiColon) {
            sb.append(';');
        }
        body = sb.toString();
        return body;
    }

    private void setGenericProperties(IpeBreakpointEvent ibe, DbxHandler h) {
        h.enabled = !this.modifierIsSet("-disable");
        ibe.setId(h.id);
        ibe.setCount(h.count);
        if (this.getModifierValue("-count") != null) {
            ibe.setCountLimit(h.count_limit, true);
        } else {
            ibe.setCountLimit(h.count_limit, false);
        }
        ibe.setScript(h.body);
        Action action = Action.STOPINSTR;
        if (this.modifierIsSet("-instr")) {
            switch (h.action) {
                case 0: {
                    action = Action.STOPINSTR;
                    break;
                }
                case 1: {
                    action = Action.TRACEINSTR;
                    break;
                }
                case 2: {
                    action = Action.WHENINSTR;
                    break;
                }
                default: {
                    action = Action.STOPINSTR;
                    break;
                }
            }
        } else {
            switch (h.action) {
                case 0: {
                    action = Action.STOP;
                    break;
                }
                case 1: {
                    action = Action.TRACE;
                    break;
                }
                case 2: {
                    action = Action.WHEN;
                    break;
                }
                default: {
                    action = Action.STOP;
                }
            }
        }
        ibe.setAction(action);
        String condition = this.getModifierValue("-if");
        ibe.setCondition(condition);
        String qcondition = this.getQmodifierValue("-if");
        ibe.setQcondition(qcondition);
        ibe.setWhileIn(this.getModifierValue("-in"));
        ibe.setQwhileIn(this.getQmodifierValue("-in"));
        String thread = this.getModifierValue("-thread");
        ibe.setThread(thread);
        String lwp = this.getModifierValue("-lwp");
        ibe.setLwp(lwp);
        ibe.setTemp(this.modifierIsSet("-temp"));
        ibe.setPersistent(this.modifierIsSet("-perm"));
    }

    private void possiblyMutate() {
        IpeBreakpointEvent newEvent = this.event;
        if (this.handler.eventspec.startsWith("in ") && this.event instanceof ClassMethodBreakpoint) {
            newEvent = new FunctionBreakpoint();
        }
        if (newEvent != this.event) {
            CoreBreakpoint enclosing = this.event.getBreakpoint();
            if (enclosing == null) {
                return;
            }
            this.event = newEvent;
            Dbx dbx = this.debugger.getEngine();
            dbx.ignoreBreakpoint = true;
            this.debugger.ignoreUpdates(true);
            enclosing.setEvent((CoreBreakpoint.Event)newEvent);
            newEvent.setHandler(this);
            this.debugger.ignoreUpdates(false);
            dbx.ignoreBreakpoint = false;
        }
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void refresh(boolean firstTime) {
        this.inProgress = true;
        try {
            this.possiblyMutate();
            this.summary = null;
            if (firstTime) {
                this.setGenericProperties(this.event, this.handler);
                this.summary = null;
                this.setSpecificProperties(this.event, this.handler);
            }
            this.updateAnnotations();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.inProgress = false;
        this.event.refresh();
    }

    public void updateAnnotations() {
        this.isConditional = false;
        if (this.event == null) {
            return;
        }
        if (this.event.getAction() != Action.STOP) {
            this.isConditional = true;
        } else if (this.event.getCondition() != null) {
            this.isConditional = true;
        }
        if (this.annotations != null) {
            String type = this.getType();
            for (int i = 0; i < this.annotations.size(); ++i) {
                MyAnnotation ma = (MyAnnotation)this.annotations.get(i);
                BreakpointAnnotation a = ma.delegate;
                a.setAnnotationType(type);
            }
        }
    }

    private String getType() {
        String type = this.event != null && this.event.isEnabled() ? (this.isConditional ? BreakpointAnnotation.TYPE_CONDITIONAL : BreakpointAnnotation.TYPE_NORMAL) : (this.isConditional ? BreakpointAnnotation.TYPE_DISABLED_CONDITIONAL : BreakpointAnnotation.TYPE_DISABLED);
        return type;
    }

    public String getTipSummary() {
        String label = this.getSummary();
        if (this.debugger != null && this.debugger.getState() == 4 && this.handler != null && this.handler.count_limit != 1) {
            int count = this.handler.count;
            int limit = this.handler.count_limit;
            return MessageFormat.format(DbxDebugger.getText("CurrCountIs"), label, Integer.toString(count), Long.toString(this.event.getCountLimit()));
        }
        if (this.isConditional) {
            StringBuffer sb = new StringBuffer(label);
            sb.append(": ");
            if (this.handler.action != 0) {
                switch (this.handler.action) {
                    case 1: {
                        sb.append("trace ");
                        break;
                    }
                    case 2: {
                        sb.append("when ");
                        break;
                    }
                }
            }
            if (this.handler.nmodifiers != 0) {
                for (int i = 0; i < this.handler.nmodifiers; ++i) {
                    if (!this.handler.modifiers[i].startsWith("-if")) continue;
                    sb.append(this.handler.modifiers[i]);
                    sb.append(' ');
                }
            }
            return sb.toString();
        }
        return label;
    }

    public String getSummary() {
        if (this.summary == null) {
            String label;
            if (this.event instanceof LineBreakpoint) {
                LineBreakpoint bre = (LineBreakpoint)this.event;
                label = IpeUtils.getBaseName(bre.getFileName()) + ":" + bre.getLineNumber();
            } else if (this.event instanceof AccessBreakpoint) {
                AccessBreakpoint bre = (AccessBreakpoint)this.event;
                StringBuffer sb = new StringBuffer(30);
                if (bre.getWhen() == AccessBA.BEFORE) {
                    sb.append(DbxDebugger.getText("Handler_Before"));
                } else {
                    sb.append(DbxDebugger.getText("Handler_After"));
                }
                if (bre.isRead()) {
                    sb.append(' ');
                    sb.append(DbxDebugger.getText("Handler_read"));
                }
                if (bre.isWrite()) {
                    sb.append(' ');
                    sb.append(DbxDebugger.getText("Handler_write"));
                }
                if (bre.isExecute()) {
                    sb.append(' ');
                    sb.append(DbxDebugger.getText("Handler_execute"));
                }
                sb.append(' ');
                sb.append(bre.getAddress());
                if (bre.getSize() != null) {
                    sb.append(',');
                    sb.append(bre.getSize());
                }
                label = sb.toString();
            } else if (this.event instanceof ClassMethodBreakpoint) {
                ClassMethodBreakpoint bre = (ClassMethodBreakpoint)this.event;
                label = bre.getClassName() != null ? (bre.getMethodName() != null ? bre.getClassName() + "::" + bre.getMethodName() : MessageFormat.format(DbxDebugger.getText("Handler_AllMeth"), bre.getClassName())) : MessageFormat.format(DbxDebugger.getText("Handler_AllClass"), bre.getMethodName());
            } else if (this.event instanceof CondBreakpoint) {
                CondBreakpoint bre = (CondBreakpoint)this.event;
                label = bre.getCond();
            } else if (this.event instanceof ExceptionBreakpoint) {
                ExceptionBreakpoint bre = (ExceptionBreakpoint)this.event;
                label = MessageFormat.format(DbxDebugger.getText("Handler_Thrown"), bre.getException().toString());
            } else if (this.event instanceof FaultBreakpoint) {
                FaultBreakpoint bre = (FaultBreakpoint)this.event;
                label = MessageFormat.format(DbxDebugger.getText("Handler_Fault"), bre.getFault());
            } else if (this.event instanceof FunctionBreakpoint) {
                FunctionBreakpoint fb = (FunctionBreakpoint)this.event;
                FunctionSubEvent se = fb.getSubEvent();
                label = se.equals(FunctionSubEvent.IN) ? fb.getFunction() : (se.equals(FunctionSubEvent.INFUNCTION) ? MessageFormat.format(DbxDebugger.getText("Handler_AllFunc"), fb.getFunction()) : (se.equals(FunctionSubEvent.RETURNS) ? MessageFormat.format(DbxDebugger.getText("Handler_ReturnFrom"), fb.getFunction()) : fb.getFunction()));
            } else if (this.event instanceof InstructionBreakpoint) {
                InstructionBreakpoint ib = (InstructionBreakpoint)this.event;
                label = MessageFormat.format(DbxDebugger.getText("Handler_Instruction"), ib.getAddress());
            } else if (this.event instanceof LoadObjBreakpoint) {
                LoadObjBreakpoint bre = (LoadObjBreakpoint)this.event;
                String obj = bre.getLoadObj();
                label = obj == null ? (bre.getDlEvent() == DlEvent.OPEN ? DbxDebugger.getText("Handler_OpenAllObj") : DbxDebugger.getText("Handler_CloseAllObj")) : (bre.getDlEvent() == DlEvent.OPEN ? MessageFormat.format(DbxDebugger.getText("Handler_OpenObj"), obj) : MessageFormat.format(DbxDebugger.getText("Handler_CloseObj"), obj));
            } else if (this.event instanceof ObjectBreakpoint) {
                ObjectBreakpoint bre = (ObjectBreakpoint)this.event;
                label = MessageFormat.format(DbxDebugger.getText("Handler_Object"), bre.getObject());
            } else if (this.event instanceof ProcessBreakpoint) {
                ProcessBreakpoint bre = (ProcessBreakpoint)this.event;
                label = MessageFormat.format(DbxDebugger.getText("Handler_ProcessEvent"), bre.getSubEvent().toString());
            } else if (this.event instanceof DebuggerBreakpoint) {
                DebuggerBreakpoint bre = (DebuggerBreakpoint)this.event;
                label = MessageFormat.format(DbxDebugger.getText("Handler_DebuggerEvent"), bre.getSubEvent().toString());
            } else if (this.event instanceof SignalBreakpoint) {
                SignalBreakpoint bre = (SignalBreakpoint)this.event;
                label = bre.getSubcode() != null ? MessageFormat.format(DbxDebugger.getText("Handler_Signal_Subcode"), bre.getSignal(), bre.getSubcode()) : MessageFormat.format(DbxDebugger.getText("Handler_Signal"), bre.getSignal());
            } else if (this.event instanceof TimerBreakpoint) {
                TimerBreakpoint bre = (TimerBreakpoint)this.event;
                label = MessageFormat.format(DbxDebugger.getText("Handler_Timer"), Float.toString(bre.getSeconds()));
            } else if (this.event instanceof SysCallBreakpoint) {
                SysCallBreakpoint bre = (SysCallBreakpoint)this.event;
                String call = bre.getSysCall();
                label = call == null ? (bre.getEntryExit() == SysCallEE.EXIT ? DbxDebugger.getText("Handler_SysoutAny") : DbxDebugger.getText("Handler_SysinAny")) : (bre.getEntryExit() == SysCallEE.EXIT ? MessageFormat.format(DbxDebugger.getText("Handler_Sysout"), call) : MessageFormat.format(DbxDebugger.getText("Handler_Sysin"), call));
            } else if (this.event instanceof VariableBreakpoint) {
                VariableBreakpoint bre = (VariableBreakpoint)this.event;
                label = MessageFormat.format(DbxDebugger.getText("Handler_Variable"), bre.getVariable());
            } else {
                label = this.handler.eventspec;
            }
            this.summary = label;
        }
        return this.summary;
    }

    public static boolean modifierIsSetIn(String name, DbxHandler h) {
        for (int i = 0; i < h.nmodifiers; ++i) {
            if (!name.equals(h.modifiers[i])) continue;
            return true;
        }
        return false;
    }

    public boolean modifierIsSet(String name) {
        return IpeHandler.modifierIsSetIn(name, this.handler);
    }

    public String getModifierValue(String modifier) {
        for (int i = 0; i < this.handler.nmodifiers; ++i) {
            if (!this.handler.modifiers[i].startsWith(modifier)) continue;
            return this.handler.modifiers[i].substring(modifier.length() + 1);
        }
        return null;
    }

    public static boolean qmodifierIsSetIn(String name, DbxHandler h) {
        for (int i = 0; i < h.nqmodifiers; ++i) {
            if (!name.equals(h.qmodifiers[i])) continue;
            return true;
        }
        return false;
    }

    public boolean qmodifierIsSet(String name) {
        return IpeHandler.qmodifierIsSetIn(name, this.handler);
    }

    public String getQmodifierValue(String qmodifier) {
        for (int i = 0; i < this.handler.nqmodifiers; ++i) {
            if (!this.handler.qmodifiers[i].startsWith(qmodifier)) continue;
            return this.handler.qmodifiers[i].substring(qmodifier.length() + 1);
        }
        return null;
    }

    public String toString() {
        if (this.handler != null) {
            return this.getSummary();
        }
        return this.event.toString();
    }

    public String getIconBase() {
        if (this.handler == null || !this.handler.enabled) {
            if (this.isConditional) {
                return "org/netbeans/modules/debugger/resources/editor/DisabledConditionalBreakpoint";
            }
            return "org/netbeans/modules/debugger/resources/editor/DisabledBreakpoint";
        }
        if (this.isFired) {
            return "org/netbeans/modules/debugger/resources/editor/Breakpoint+PC";
        }
        if (this.isConditional) {
            return "org/netbeans/modules/debugger/resources/editor/ConditionalBreakpoint";
        }
        return "org/netbeans/modules/debugger/resources/editor/Breakpoint";
    }

    public String toXMLString() {
        if (this.handler == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(200);
        switch (this.handler.action) {
            case 0: {
                sb.append("stop ");
                break;
            }
            case 1: {
                sb.append("trace ");
                break;
            }
            case 2: {
                sb.append("when ");
                break;
            }
            default: {
                Thread.dumpStack();
                return "";
            }
        }
        if (this.handler.qeventspec != null) {
            sb.append(this.handler.qeventspec);
            sb.append(' ');
        }
        if (this.handler.nqmodifiers > 0) {
            for (int i = 0; i < this.handler.nqmodifiers; ++i) {
                if ("-disable".equals(this.handler.qmodifiers[i])) continue;
                if (this.handler.qmodifiers[i].startsWith("-if")) {
                    sb.append(this.handler.modifiers[i]);
                } else {
                    sb.append(this.handler.qmodifiers[i]);
                }
                sb.append(' ');
            }
        }
        if (!this.handler.enabled) {
            sb.append("-disable");
            sb.append(' ');
        }
        if (this.handler.body != null && this.handler.body.length() > 0) {
            sb.append('{');
            sb.append(this.handler.body);
            sb.append(';');
            sb.append('}');
        }
        return IpeUtils.stringToXML(sb.toString());
    }

    private static String actionFor(Action act, boolean alwaysInstr) {
        if (alwaysInstr) {
            if (act == Action.STOPINSTR) {
                return "stopi";
            }
            if (act == Action.TRACE) {
                return "tracei";
            }
            if (act == Action.TRACEINSTR) {
                return "tracei";
            }
            if (act == Action.WHEN) {
                return "wheni";
            }
            if (act == Action.WHENINSTR) {
                return "wheni";
            }
            if (act == Action.STOP) {
                return "stopi";
            }
            return "stopi";
        }
        if (act == Action.STOPINSTR) {
            return "stopi";
        }
        if (act == Action.TRACE) {
            return "trace";
        }
        if (act == Action.TRACEINSTR) {
            return "tracei";
        }
        if (act == Action.WHEN) {
            return "when";
        }
        if (act == Action.WHENINSTR) {
            return "wheni";
        }
        if (act == Action.STOP) {
            return "stop";
        }
        return "stop";
    }

    public static void createHandler(Dbx dbx, IpeBreakpointEvent newEvent, int routingToken) {
        HandlerJig hj = new HandlerJig(newEvent);
        String cmd = hj.generate();
        dbx.createHandlerHelp(routingToken, cmd);
    }

    public void changeCondition(String condition) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.condition = hj.trim(condition);
        hj.qcondition = null;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeCountLimit(boolean enable, long newCount) {
        if (enable) {
            this.getDbx().setHandlerCountLimit(this.handler.id, newCount);
            return;
        }
        HandlerJig hj = new HandlerJig(this.event);
        hj.count = null;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeFunction(String func) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.function = hj.trim(func);
        hj.eventspec.qfunction = null;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeFunctionSubEvent(FunctionSubEvent se) {
        HandlerJig hj = new HandlerJig(this.event);
        if (se.equals(FunctionSubEvent.IN)) {
            hj.eventspec.keyword = " in ";
        } else if (se.equals(FunctionSubEvent.INFUNCTION)) {
            hj.eventspec.keyword = " infunction ";
        } else if (se.equals(FunctionSubEvent.RETURNS)) {
            hj.eventspec.keyword = " returns ";
        }
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeClass(String cls) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.cls = hj.trim(cls);
        hj.eventspec.qcls = null;
        if (hj.eventspec.method != null) {
            hj.eventspec.recurse = null;
        }
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeMethod(String method) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.method = hj.trim(method);
        hj.eventspec.qmethod = null;
        if (hj.eventspec.method != null) {
            hj.eventspec.recurse = null;
        }
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeRecurse(boolean recurse) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.recurse = recurse ? " -recurse " : " -norecurse ";
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeAction(Action a) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.action = IpeHandler.actionFor(a, this.event instanceof InstructionBreakpoint);
        if (a != Action.WHEN && a != Action.WHENINSTR) {
            hj.body = null;
        } else if (hj.body == null) {
            hj.body = "echo " + DbxDebugger.getText("MSG_Script_PLACEHOLDER");
        }
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeScript(String script) {
        HandlerJig hj = new HandlerJig(this.event);
        if ((script = script.trim()).length() == 0) {
            script = null;
        }
        hj.body = script;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeThread(String tid) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.thread = tid;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeLwp(String lid) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.lwp = lid;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeTemp(boolean temp) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.temp = temp;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeAddress(String address) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.address = address;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeSize(String size) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.size = hj.trim(size);
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeWhen(AccessBA ba) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.mode_ba = ba == AccessBA.BEFORE ? "b" : "a";
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    private static String addIfNotPresent(String s, char c) {
        for (int sx = 0; sx < s.length(); ++sx) {
            if (s.charAt(sx) != c) continue;
            return s;
        }
        s = s + c;
        return s;
    }

    private static String removeIfPresent(String s, char c) {
        String retval = "";
        for (int sx = 0; sx < s.length(); ++sx) {
            if (s.charAt(sx) == c) continue;
            retval = retval + s.charAt(sx);
        }
        return retval;
    }

    public void changeRead(boolean read) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.mode_rwx = read ? IpeHandler.addIfNotPresent(hj.eventspec.mode_rwx, 'r') : IpeHandler.removeIfPresent(hj.eventspec.mode_rwx, 'r');
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeWrite(boolean write) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.mode_rwx = write ? IpeHandler.addIfNotPresent(hj.eventspec.mode_rwx, 'w') : IpeHandler.removeIfPresent(hj.eventspec.mode_rwx, 'w');
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeExecute(boolean execute) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.mode_rwx = execute ? IpeHandler.addIfNotPresent(hj.eventspec.mode_rwx, 'x') : IpeHandler.removeIfPresent(hj.eventspec.mode_rwx, 'x');
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeCond(String cond) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.cond = cond;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeVariable(String variable) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.variable = variable;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeObject(String object) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.object = object;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeSeconds(float seconds) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.seconds = "" + seconds;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeFault(String fault) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.fault = fault;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeSignal(String signal) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.signal = signal;
        hj.eventspec.subcode = null;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeSubcode(String subcode) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.subcode = subcode;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeSyscall(String syscall) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.syscall = syscall;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeEntryExit(SysCallEE ee) {
        HandlerJig hj = new HandlerJig(this.event);
        if (ee == SysCallEE.EXIT) {
            hj.eventspec.keyword = " sysout ";
        } else if (ee == SysCallEE.ENTRY) {
            hj.eventspec.keyword = " sysin ";
        }
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeException(ExceptionSpec exception) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.exception = exception == ExceptionSpec.ALL ? null : (exception == ExceptionSpec.UNCAUGHT ? "-unhandled" : (exception == ExceptionSpec.UNEXPECTED ? "-unexpected" : exception.toString()));
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeLoadobj(String loadobj) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.loadobj = loadobj;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeDlEvent(DlEvent dlevent) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.keyword = dlevent == DlEvent.OPEN ? " dlopen " : " dlclose ";
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeDebuggerSubEvent(DebuggerEvent se) {
        HandlerJig hj = new HandlerJig(this.event);
        if (se.equals(DebuggerEvent.ATTACH)) {
            hj.eventspec.keyword = " attach ";
        } else if (se.equals(DebuggerEvent.DETACH)) {
            hj.eventspec.keyword = " detach ";
        }
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeProcessExitCode(String ec) {
        HandlerJig hj = new HandlerJig(this.event);
        hj.eventspec.exitcode = ec;
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    public void changeProcessSubEvent(ProcessEvent se) {
        HandlerJig hj = new HandlerJig(this.event);
        if (se.equals(ProcessEvent.EXIT)) {
            hj.eventspec.keyword = " exit ";
        } else if (se.equals(ProcessEvent.NEXT)) {
            hj.eventspec.keyword = " next ";
        } else if (se.equals(ProcessEvent.STEP)) {
            hj.eventspec.keyword = " step ";
        } else if (se.equals(ProcessEvent.STOP)) {
            hj.eventspec.keyword = " stop ";
        } else if (se.equals(ProcessEvent.LASTRITES)) {
            hj.eventspec.keyword = " lastrites ";
        } else if (se.equals(ProcessEvent.GONE)) {
            hj.eventspec.keyword = " proc_gone ";
        } else if (se.equals(ProcessEvent.LWP_EXIT)) {
            hj.eventspec.keyword = " lwp_exit ";
        } else if (se.equals(ProcessEvent.SYNC)) {
            hj.eventspec.keyword = " sync ";
        } else if (se.equals(ProcessEvent.SYNCRTLD)) {
            hj.eventspec.keyword = " syncrtld ";
        }
        hj.replace(this.handler.id);
        String cmd = hj.generate();
        this.getDbx().createHandlerHelp(this.event.getRoutingToken(), cmd);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HandlerJig {
        public String action;
        public EventspecJig eventspec;
        public String replace;
        public boolean disable;
        public boolean temp;
        public String count;
        public String whileIn;
        public String qwhileIn;
        public String condition;
        public String qcondition;
        public String lwp;
        public String thread;
        public String body;

        public HandlerJig(IpeBreakpointEvent event) {
            Action act = event.getAction();
            this.action = IpeHandler.actionFor(act, event instanceof InstructionBreakpoint);
            this.eventspec = new EventspecJig(event);
            if (event.getAction() == Action.WHEN || event.getAction() == Action.WHENINSTR) {
                this.body = event.getScript();
            }
            this.temp = event.getTemp();
            this.disable = !event.isEnabled();
            this.whileIn = this.trim(event.getWhileIn());
            this.qwhileIn = this.trim(event.getQwhileIn());
            this.condition = this.trim(event.getCondition());
            this.qcondition = this.trim(event.getQcondition());
            this.lwp = this.trim(event.getLwp());
            this.thread = this.trim(event.getThread());
            if (event.hasCountLimit()) {
                long countLimit = event.getCountLimit();
                this.count = countLimit == -1L ? "infinity" : "" + countLimit;
            }
        }

        public String trim(String str) {
            if (str == null) {
                return null;
            }
            if ((str = str.trim()).length() == 0) {
                return null;
            }
            return str;
        }

        public void replace(int id) {
            this.replace = "" + id;
        }

        public String generate() {
            String cmd = this.action + this.eventspec.generate();
            if (this.replace != null) {
                cmd = cmd + " -replace " + this.replace;
            }
            if (this.disable) {
                cmd = cmd + " -disable ";
            }
            if (this.temp) {
                cmd = cmd + " -temp ";
            }
            if (this.qwhileIn != null) {
                cmd = cmd + " -in " + this.qwhileIn;
            } else if (this.whileIn != null) {
                cmd = cmd + " -in " + this.whileIn;
            }
            if (this.qcondition != null) {
                cmd = cmd + " -if " + this.qcondition;
            } else if (this.condition != null) {
                cmd = cmd + " -if " + this.condition;
            }
            if (this.lwp != null) {
                cmd = cmd + " -lwp " + this.lwp;
            }
            if (this.thread != null) {
                cmd = cmd + " -thread " + this.thread;
            }
            if (this.count != null) {
                cmd = cmd + " -count " + this.count;
            }
            if (this.body != null) {
                cmd = cmd + " { " + IpeHandler.fixBody(this.body) + " } ";
            }
            return cmd;
        }
    }

    private static class EventspecJig {
        public String eventspec;
        public Class eventClass;
        public String keyword;
        public String exitcode = null;
        public String fileLine;
        public String function;
        public String qfunction;
        public String cls;
        public String qcls;
        public String method;
        public String qmethod;
        public String recurse;
        public String object;
        public String mode_rwx;
        public String mode_ba;
        public String address;
        public String size;
        public String cond;
        public String seconds;
        public String fault;
        public String signal;
        public String subcode;
        public String syscall;
        public String exception;
        public String loadobj;
        public String variable;

        public EventspecJig(IpeBreakpointEvent event) {
            this.eventClass = event.getClass();
            if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LineBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LineBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.LineBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LineBreakpoint)) {
                LineBreakpoint lb = (LineBreakpoint)event;
                String file = lb.getFileName();
                int line = lb.getLineNumber();
                this.keyword = " at ";
                this.fileLine = file != null && file.length() > 0 ? "\"" + file + "\":" + line : "" + line;
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FunctionBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FunctionBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.FunctionBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FunctionBreakpoint)) {
                FunctionBreakpoint fbr = (FunctionBreakpoint)event;
                FunctionSubEvent se = fbr.getSubEvent();
                if (se.equals(FunctionSubEvent.IN)) {
                    this.keyword = " in ";
                } else if (se.equals(FunctionSubEvent.INFUNCTION)) {
                    this.keyword = " infunction ";
                } else if (se.equals(FunctionSubEvent.RETURNS)) {
                    this.keyword = " returns ";
                }
                this.function = fbr.getFunction();
                this.qfunction = fbr.getQfunction();
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ClassMethodBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ClassMethodBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.ClassMethodBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ClassMethodBreakpoint)) {
                ClassMethodBreakpoint cmb = (ClassMethodBreakpoint)event;
                this.cls = null;
                this.method = null;
                this.recurse = null;
                if (cmb.getClassName() == null) {
                    this.method = cmb.getMethodName();
                    this.qmethod = cmb.getQmethodName();
                } else if (cmb.getMethodName() == null) {
                    this.cls = cmb.getClassName();
                    this.qcls = cmb.getQclassName();
                    this.recurse = cmb.isRecurse() ? " -recurse " : " -norecurse ";
                } else {
                    this.cls = cmb.getClassName();
                    this.qcls = cmb.getQclassName();
                    this.method = cmb.getMethodName();
                    this.qmethod = cmb.getQmethodName();
                }
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$AccessBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$AccessBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.AccessBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$AccessBreakpoint)) {
                AccessBreakpoint ab = (AccessBreakpoint)event;
                this.mode_rwx = "";
                this.mode_ba = "";
                this.address = null;
                this.size = null;
                this.keyword = " access ";
                this.mode_ba = ab.getWhen() == AccessBA.BEFORE ? "b" : "a";
                if (ab.isRead()) {
                    this.mode_rwx = this.mode_rwx + "r";
                }
                if (ab.isWrite()) {
                    this.mode_rwx = this.mode_rwx + "w";
                }
                if (ab.isExecute()) {
                    this.mode_rwx = this.mode_rwx + "x";
                }
                this.address = ab.getAddress();
                this.size = ab.getSize();
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$CondBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$CondBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.CondBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$CondBreakpoint)) {
                CondBreakpoint cb = (CondBreakpoint)event;
                this.keyword = " cond ";
                this.cond = cb.getCond();
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ObjectBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ObjectBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.ObjectBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ObjectBreakpoint)) {
                ObjectBreakpoint ob = (ObjectBreakpoint)event;
                this.keyword = " inobject ";
                this.object = ob.getObject();
                this.recurse = ob.isRecurse() ? " -recurse " : " -norecurse ";
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$TimerBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$TimerBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.TimerBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$TimerBreakpoint)) {
                TimerBreakpoint tb = (TimerBreakpoint)event;
                this.keyword = " timer ";
                this.seconds = "" + tb.getSeconds();
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FaultBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FaultBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.FaultBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FaultBreakpoint)) {
                FaultBreakpoint fb = (FaultBreakpoint)event;
                this.keyword = " fault ";
                this.fault = fb.getFault();
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SignalBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SignalBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.SignalBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SignalBreakpoint)) {
                SignalBreakpoint sb = (SignalBreakpoint)event;
                this.keyword = " sig ";
                this.signal = sb.getSignal();
                this.subcode = sb.getSubcode();
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SysCallBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SysCallBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.SysCallBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SysCallBreakpoint)) {
                SysCallBreakpoint scb = (SysCallBreakpoint)event;
                this.keyword = scb.getEntryExit() == SysCallEE.EXIT ? " sysout " : " sysin ";
                this.syscall = scb.getSysCall();
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ExceptionBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ExceptionBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.ExceptionBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ExceptionBreakpoint)) {
                ExceptionBreakpoint eb = (ExceptionBreakpoint)event;
                ExceptionSpec x = eb.getException();
                this.keyword = " throw ";
                this.exception = x == ExceptionSpec.UNCAUGHT ? "-unhandled" : (x == ExceptionSpec.UNEXPECTED ? "-unexpected" : (x == ExceptionSpec.ALL ? null : x.toString()));
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LoadObjBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LoadObjBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.LoadObjBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LoadObjBreakpoint)) {
                LoadObjBreakpoint lob = (LoadObjBreakpoint)event;
                this.keyword = lob.getDlEvent() == DlEvent.OPEN ? " dlopen " : " dlclose ";
                this.loadobj = lob.getLoadObj();
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$VariableBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$VariableBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.VariableBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$VariableBreakpoint)) {
                VariableBreakpoint vb = (VariableBreakpoint)event;
                this.keyword = " change ";
                this.variable = vb.getVariable();
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$InstructionBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$InstructionBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.InstructionBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$InstructionBreakpoint)) {
                InstructionBreakpoint ib = (InstructionBreakpoint)event;
                this.keyword = " at ";
                this.address = ib.getAddress();
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$DebuggerBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$DebuggerBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.DebuggerBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$DebuggerBreakpoint)) {
                DebuggerBreakpoint db = (DebuggerBreakpoint)event;
                DebuggerEvent de = db.getSubEvent();
                if (de == DebuggerEvent.ATTACH) {
                    this.keyword = " attach ";
                } else if (de == DebuggerEvent.DETACH) {
                    this.keyword = " detach ";
                }
            } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ProcessBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ProcessBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.ProcessBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ProcessBreakpoint)) {
                ProcessBreakpoint pb = (ProcessBreakpoint)event;
                ProcessEvent pe = pb.getSubEvent();
                if (pe == ProcessEvent.EXIT) {
                    this.keyword = " exit ";
                    this.exitcode = pb.getExitCode();
                } else if (pe == ProcessEvent.NEXT) {
                    this.keyword = " next ";
                } else if (pe == ProcessEvent.STEP) {
                    this.keyword = " step ";
                } else if (pe == ProcessEvent.STOP) {
                    this.keyword = " stop ";
                } else if (pe == ProcessEvent.LASTRITES) {
                    this.keyword = " lastrites ";
                } else if (pe == ProcessEvent.GONE) {
                    this.keyword = " proc_gone ";
                } else if (pe == ProcessEvent.LWP_EXIT) {
                    this.keyword = " lwp_exit ";
                } else if (pe == ProcessEvent.SYNC) {
                    this.keyword = " sync ";
                } else if (pe == ProcessEvent.SYNCRTLD) {
                    this.keyword = " syncrtld ";
                }
            } else {
                this.eventspec = "Unrecognized event object" + event.getClass().toString();
            }
        }

        private String massageObjectAddress(String oa) {
            int castx = oa.indexOf(41);
            int addrx = oa.lastIndexOf(40);
            if (castx != -1 && addrx != -1) {
                String castPart = oa.substring(0, castx + 1);
                String addrPart = oa.substring(addrx + 1, oa.length() - 1);
                return castPart + " " + addrPart;
            }
            return oa;
        }

        public String generate() {
            if (this.eventspec == null) {
                if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LineBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LineBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.LineBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LineBreakpoint)) {
                    this.eventspec = this.keyword + this.fileLine;
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FunctionBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FunctionBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.FunctionBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FunctionBreakpoint)) {
                    if (this.qfunction != null) {
                        this.eventspec = this.keyword + this.qfunction;
                    } else if (this.function != null) {
                        this.eventspec = this.keyword + this.function;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ClassMethodBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ClassMethodBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.ClassMethodBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ClassMethodBreakpoint)) {
                    this.keyword = this.cls == null ? " inmember " : (this.method == null ? " inclass " : " in ");
                    this.eventspec = this.keyword;
                    if (this.qcls != null) {
                        this.eventspec = this.eventspec + this.qcls;
                        if (this.method != null) {
                            this.eventspec = this.eventspec + "::";
                        }
                    } else if (this.cls != null) {
                        this.eventspec = this.eventspec + this.cls;
                        if (this.method != null) {
                            this.eventspec = this.eventspec + "::";
                        }
                    }
                    if (this.qmethod != null) {
                        this.eventspec = this.eventspec + this.qmethod;
                    } else if (this.method != null) {
                        this.eventspec = this.eventspec + this.method;
                    }
                    if (this.recurse != null) {
                        this.eventspec = this.eventspec + this.recurse;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$AccessBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$AccessBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.AccessBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$AccessBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.mode_rwx != null) {
                        this.eventspec = this.eventspec + this.mode_rwx;
                    }
                    if (this.mode_ba != null) {
                        this.eventspec = this.eventspec + this.mode_ba;
                    }
                    this.eventspec = this.eventspec + " ";
                    this.eventspec = this.eventspec + this.address;
                    if (this.size != null) {
                        this.eventspec = this.eventspec + ", " + this.size;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$CondBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$CondBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.CondBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$CondBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.cond != null) {
                        this.eventspec = this.eventspec + this.cond;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ObjectBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ObjectBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.ObjectBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ObjectBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.object != null) {
                        this.eventspec = this.eventspec + this.massageObjectAddress(this.object);
                    }
                    if (this.recurse != null) {
                        this.eventspec = this.eventspec + this.recurse;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$TimerBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$TimerBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.TimerBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$TimerBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.seconds != null) {
                        this.eventspec = this.eventspec + this.seconds;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FaultBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FaultBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.FaultBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$FaultBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.fault != null) {
                        this.eventspec = this.eventspec + this.fault;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SignalBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SignalBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.SignalBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SignalBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.signal != null) {
                        this.eventspec = this.eventspec + this.signal;
                    }
                    if (this.subcode != null) {
                        this.eventspec = this.eventspec + " " + this.subcode;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SysCallBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SysCallBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.SysCallBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$SysCallBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.syscall != null) {
                        this.eventspec = this.eventspec + this.syscall;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ExceptionBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ExceptionBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.ExceptionBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ExceptionBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.exception != null) {
                        this.eventspec = this.eventspec + this.exception;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LoadObjBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LoadObjBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.LoadObjBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$LoadObjBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.loadobj != null) {
                        this.eventspec = this.eventspec + this.loadobj;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$VariableBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$VariableBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.VariableBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$VariableBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.variable != null) {
                        this.eventspec = this.eventspec + this.variable;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$InstructionBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$InstructionBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.InstructionBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$InstructionBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.address != null) {
                        this.eventspec = this.eventspec + this.address;
                    }
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$DebuggerBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$DebuggerBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.DebuggerBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$DebuggerBreakpoint)) {
                    this.eventspec = this.keyword;
                } else if (this.eventClass == (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ProcessBreakpoint == null ? (class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ProcessBreakpoint = IpeHandler.class$("com.sun.tools.debugger.dbxgui.debugger.breakpoints.ProcessBreakpoint")) : class$com$sun$tools$debugger$dbxgui$debugger$breakpoints$ProcessBreakpoint)) {
                    this.eventspec = this.keyword;
                    if (this.exitcode != null) {
                        this.eventspec = this.eventspec + this.exitcode;
                    }
                } else {
                    this.eventspec = "<EventspecJig.generate(): bad cls " + this.eventClass + ">";
                }
            }
            return this.eventspec;
        }
    }

    private class MyAnnotation {
        public BreakpointAnnotation delegate;
        public Line line;

        public MyAnnotation(Line l) {
            this.delegate = new BreakpointAnnotation(IpeHandler.this.event);
            this.line = l;
        }
    }
}

