/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.FixLogger;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.netbeans.modules.cpp.builds.BuildCustomizer;
import org.netbeans.modules.cpp.builds.BuildEvent;
import org.netbeans.modules.cpp.builds.BuildListener;
import org.netbeans.modules.cpp.builds.MakeExecSupport;
import org.netbeans.modules.cpp.builds.OutputWindowOutputStream;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class FixExecutor
implements Runnable {
    private String file;
    private String errfile;
    private InputOutput io;
    private BuildCustomizer customizer;
    private ArrayList listeners = new ArrayList(5);
    private String tabName;
    private PrintStream out = null;
    private ResourceBundle bundle;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$FixExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixExecutor() {
        this.customizer = MakeExecSupport.getBuildCustomizer();
        this.bundle = NbBundle.getBundle((Class)(class$com$sun$tools$debugger$dbxgui$debugger$FixExecutor == null ? (class$com$sun$tools$debugger$dbxgui$debugger$FixExecutor = FixExecutor.class$("com.sun.tools.debugger.dbxgui.debugger.FixExecutor")) : class$com$sun$tools$debugger$dbxgui$debugger$FixExecutor));
        this.tabName = this.getString("LBL_FixTab");
        FixExecutor fixExecutor = this;
        synchronized (fixExecutor) {
            this.io = IOProvider.getDefault().getIO(this.tabName, false);
            this.io.setFocusTaken(true);
            this.io.setErrVisible(false);
            this.io.setErrSeparated(false);
            this.customizer.customizeIO(this.io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask compile(String errfile) {
        ExecutorTask task;
        this.errfile = errfile;
        FixExecutor fixExecutor = this;
        synchronized (fixExecutor) {
            if (this.out == null) {
                this.io.select();
                this.reset();
                this.out = new PrintStream((OutputStream)new OutputWindowOutputStream(this.io.getOut()));
            }
            task = ExecutionEngine.getDefault().execute(this.tabName, (Runnable)this, InputOutput.NULL);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        this.addBuildListener(this.customizer.getBuildListener());
        FixLogger logger = new FixLogger();
        logger.setOutputPrintStream(this.out);
        this.addBuildListener(logger);
        this.fireBuildStarted(MessageFormat.format(this.getString("MSG_FixStarted"), this.file));
        PrintStream sysout = System.out;
        PrintStream syserr = System.err;
        try {
            try {
                this.displayFixOutput(this.io);
            }
            catch (Throwable t) {
                this.fireBuildFinished(MessageFormat.format(this.getString("MSG_FixFault"), this.file));
                Object var6_5 = null;
                System.setOut(sysout);
                System.setErr(syserr);
                this.removeBuildListener(logger);
                BuildListener l = this.customizer.getBuildListener();
                if (l != null) {
                    this.removeBuildListener(l);
                }
                if (this.errfile == null) return;
                File f222 = new File(this.errfile);
                if (!f222.exists()) return;
                if (IpeUtils.IfdefDebug) return;
                f222.delete();
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            System.setOut(sysout);
            System.setErr(syserr);
            this.removeBuildListener(logger);
            BuildListener l = this.customizer.getBuildListener();
            if (l != null) {
                this.removeBuildListener(l);
            }
            if (this.errfile == null) throw throwable;
            File f222 = new File(this.errfile);
            if (!f222.exists()) throw throwable;
            if (IpeUtils.IfdefDebug) throw throwable;
            f222.delete();
            throw throwable;
        }
        System.setOut(sysout);
        System.setErr(syserr);
        this.removeBuildListener(logger);
        BuildListener l = this.customizer.getBuildListener();
        if (l != null) {
            this.removeBuildListener(l);
        }
        if (this.errfile == null) return;
        File f222 = new File(this.errfile);
        if (!f222.exists()) return;
        if (IpeUtils.IfdefDebug) return;
        f222.delete();
    }

    private void displayFixOutput(InputOutput io) throws IOException, InterruptedException {
        NbProcessDescriptor desc = new NbProcessDescriptor("/usr/bin/cat", this.errfile, this.getString("HINT_FixProcessDescriptor"));
        Process proc = desc.exec();
        FixReaderThread t = new FixReaderThread(proc.getInputStream());
        t.start();
        proc.waitFor();
        t.join();
    }

    public void setFile(String file) {
        this.file = file;
    }

    private void reset() {
        try {
            this.customizer.reset(this.io);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void done(String msg) {
        if (this.out != null) {
            this.out.println("<B>" + msg + "</B>");
            this.out = null;
        }
    }

    public void addBuildListener(BuildListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeBuildListener(BuildListener l) {
        this.listeners.remove(this.listeners.indexOf(l));
    }

    public void fireBuildStarted(String msg) {
        BuildEvent event = new BuildEvent((Object)this);
        event.setMessage(msg);
        for (int i = 0; i < this.listeners.size(); ++i) {
            BuildListener listener = (BuildListener)this.listeners.get(i);
            listener.buildStarted(event);
        }
    }

    public void fireBuildFinished(String msg) {
        BuildEvent event = new BuildEvent((Object)this);
        event.setMessage(msg);
        for (int i = 0; i < this.listeners.size(); ++i) {
            BuildListener listener = (BuildListener)this.listeners.get(i);
            listener.buildFinished(event);
        }
    }

    public void fireBuildEvent(String msg) {
        BuildEvent event = new BuildEvent((Object)this);
        event.setMessage(msg);
        for (int i = 0; i < this.listeners.size(); ++i) {
            BuildListener listener = (BuildListener)this.listeners.get(i);
            listener.messageLogged(event);
        }
    }

    protected String getString(String s) {
        return this.bundle.getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final class FixReaderThread
    extends Thread {
        private InputStream out;

        public FixReaderThread(InputStream out) {
            this.out = out;
        }

        public void run() {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.out));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    String fmsg = FixExecutor.this.customizer.filterEvent(line);
                    if (fmsg == null) continue;
                    FixExecutor.this.fireBuildEvent(fmsg);
                }
                in.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

