/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerInfo;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import org.netbeans.modules.cpp.loaders.CCFSrcObject;
import org.netbeans.modules.cpp.loaders.CoreElfObject;
import org.netbeans.modules.cpp.utils.CppUtils;
import org.netbeans.modules.debugger.support.ProcessDebuggerType;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.DebuggerType;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public final class DbxDebuggerType
extends ProcessDebuggerType {
    static final long serialVersionUID = 4230558602951232695L;
    public static final String PROP_DEBUGGER_PROCESS = "debuggerProcess";
    public static final NbProcessDescriptor DEFAULT_DEBUGGER_PROCESS = new NbProcessDescriptor(DbxDebuggerType.getDbxPath(), " -g sync,stdio -c \"dbxenv suppress_startup_message 500.0; PS1=\\(dbx\\)\\ \"", DbxDebugger.getText("MSG_DebuggerHint"));
    private NbProcessDescriptor debuggerProcess;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;

    private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
        oos.defaultReadObject();
    }

    static String getDbxPath() {
        String dbxPath = System.getProperty("Env-SPRO_DBX_PATH");
        if (dbxPath != null) {
            return dbxPath;
        }
        File dbx = InstalledFileLocator.getDefault().locate("bin/dbx", null, false);
        if (dbx != null) {
            return dbx.getPath();
        }
        return "dbx";
    }

    public NbProcessDescriptor getDebuggerProcess() {
        if (this.debuggerProcess != null) {
            return this.debuggerProcess;
        }
        return DEFAULT_DEBUGGER_PROCESS;
    }

    public void setDebuggerProcess(NbProcessDescriptor debugger) {
        NbProcessDescriptor oldValue = this.getDebuggerProcess();
        this.debuggerProcess = debugger;
        this.firePropertyChange(PROP_DEBUGGER_PROCESS, oldValue, this.debuggerProcess);
    }

    public String getRepositoryPath() {
        return NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.DEBUG).getClassPath();
    }

    public void setRepositoryPath(String repositoryPath) {
    }

    public String getLibraryPath() {
        return NbClassPath.createLibraryPath().getClassPath();
    }

    public void setLibraryPath(String libraryPath) {
    }

    public String displayName() {
        return DbxDebugger.getText("LAB_CCDebuggerType");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Environment_opt_debug_types_dbx");
    }

    public DbxDebuggerInfo getDbxDebuggerInfo(DataObject dao, int startBehavior) {
        FileObject fo = null;
        if (dao instanceof CCFSrcObject) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DbxDebugger.getText("CantDebugSrcs")));
            return null;
        }
        if (dao != null) {
            fo = dao.getPrimaryFile();
        }
        if (fo == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DbxDebugger.getText("CannotFindFO")));
            return null;
        }
        String binaryName = null;
        try {
            JarFileSystem fs;
            File file;
            if (fo.getFileSystem() instanceof JarFileSystem && (file = (fs = (JarFileSystem)fo.getFileSystem()).getJarFile()) != null) {
                String jar = file.getAbsolutePath();
                binaryName = "jar:" + jar + "!" + fo.getPackageNameExt(File.separatorChar, '.');
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (binaryName == null) {
            binaryName = CppUtils.getPath((FileObject)fo);
        }
        if (binaryName == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DbxDebugger.getText("CTL_LocalFileOnly")));
            return null;
        }
        if (binaryName.endsWith(".java")) {
            binaryName = binaryName.substring(0, binaryName.length() - 5) + ".class";
        }
        String[] argv = null;
        String processName = null;
        if (binaryName != null) {
            int sep = binaryName.lastIndexOf(File.separatorChar);
            processName = sep != -1 ? binaryName.substring(sep + 1) : binaryName;
        }
        String corefile = null;
        if (dao instanceof CoreElfObject) {
            corefile = binaryName;
            binaryName = "-";
        }
        DbxDebuggerInfo ipeinfo = new DbxDebuggerInfo(startBehavior, dao, binaryName, -1L, corefile, binaryName, argv, binaryName, this.getDebuggerProcess(), this.getRepositoryPath(), this.getLibraryPath(), processName);
        return ipeinfo;
    }

    public void startDebugger(DataObject dao, boolean stopOnMain) throws DebuggerException {
        int startBehavior = 2;
        if (stopOnMain) {
            startBehavior = 1;
        }
        DbxDebuggerInfo ipeinfo = this.getDbxDebuggerInfo(dao, startBehavior);
        ((Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DbxDebuggerType.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger)).startDebugger((DebuggerInfo)ipeinfo);
    }

    public void startDebugger(ExecInfo info, boolean stopOnMain) throws DebuggerException {
        System.out.println("INTERNAL ERROR. THIS FUNCTION SHOULD NOT BE CALLED BY THE IDE!");
        Thread.dumpStack();
    }

    public static DebuggerType getDefault() {
        Enumeration enumeration = DbxDebuggerType.debuggerTypes();
        while (enumeration.hasMoreElements()) {
            DebuggerType ret = (DebuggerType)enumeration.nextElement();
            if (!(ret instanceof DbxDebuggerType)) continue;
            return ret;
        }
        return DebuggerType.getDefault();
    }

    public static String[] getArgv() {
        String arguments;
        String processName;
        DebuggerType dt = DbxDebuggerType.getDefault();
        if (dt instanceof DbxDebuggerType) {
            DbxDebuggerType idt = (DbxDebuggerType)dt;
            processName = idt.getDebuggerProcess().getProcessName();
            arguments = idt.getDebuggerProcess().getArguments();
        } else {
            processName = DEFAULT_DEBUGGER_PROCESS.getProcessName();
            arguments = DEFAULT_DEBUGGER_PROCESS.getArguments();
        }
        String[] args = Utilities.parseParameters((String)arguments);
        String[] call = new String[args.length + 1];
        call[0] = processName;
        System.arraycopy(args, 0, call, 1, args.length);
        return call;
    }

    public boolean supportsDebuggingOf(DataObject obj) {
        String mimetype = obj.getPrimaryFile().getMIMEType();
        if (mimetype != null) {
            return mimetype.equals("text/x-c++") || mimetype.equals("text/x-c") || mimetype.equals("text/x-fortran") || mimetype.equals("application/x-executable+elf") || mimetype.equals("application/x-core+elf") || mimetype.equals("elf/generic") || mimetype.equals("text/x-java");
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

