/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerEngine;
import com.sun.tools.debugger.dbxgui.debugger.RoutingToken;
import com.sun.tools.debugger.dbxgui.debugger.RunConfig;
import com.sun.tools.debugger.dbxgui.utils.ImageLabel;
import com.sun.tools.swdev.glue.dbx.DbxDisplayItem;
import com.sun.tools.swdev.glue.dbx.DbxHEvalResult;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;

public final class DbxDebugSession {
    private DbxDebugger debugger = null;
    private DbxDebuggerEngine engine = null;
    private long pid = -1L;
    private String corefile = null;
    private transient RunConfig config;
    private ImageLabel name = null;
    private boolean current = false;
    private int javaMode = 0;
    public static final String PROP_THREADS_CHANGED = "threads-changed";
    public static final String PROP_THREADSELECTION_CHANGED = "threadsel-changed";
    public static final String PROP_STACK_CHANGED = "stack-changed";
    public static final String PROP_STACKFRAME_CHANGED = "sframe-changed";
    public static final String PROP_LOCALS_CHANGED = "locals-changed";
    public static final String PROP_WATCHES_CHANGED = "watches-changed";
    public static final String PROP_EVALUATE_RESULT = "eval-result";
    public static final String PROP_TYPE_RESULT = "type-result";
    public static final String PROP_ASSIGN_RESULT = "assign-result";
    public static final String PROP_DISPLAY_NEW = "display-new";
    public static final String PROP_DISPLAY_DUPLICATE = "display-dup";
    public static final String PROP_DISPLAY_DELETED = "display-del";
    public static final String PROP_DISPLAY_UPDATED = "display-update";
    public static final String PROP_TTY_CHANGED = "tty-changed";
    public static final String PROP_ERROR = "error";
    private Long pidObject = null;
    private transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DbxHEvalResult evaluationResult = null;
    private String typeExpr = null;
    private String staticType = null;
    private String dynamicType = null;
    private String assignValue = null;
    private int routingToken = 0;
    private ImageIcon currentIcon = null;
    private ImageIcon normalIcon = null;
    private transient PropertyChangeSupport displayNewpcs = null;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler;

    DbxDebugSession(DbxDebugger debugger) {
        this.debugger = debugger;
        this.config = null;
    }

    public RunConfig getConfig() {
        return this.config;
    }

    public void setConfig(RunConfig c) {
        this.config = c;
    }

    public long getPid() {
        return this.pid;
    }

    public Long getPidObject() {
        if (this.pidObject == null) {
            this.pidObject = new Long(this.pid);
        }
        return this.pidObject;
    }

    public void setPid(long pid) {
        this.pid = pid;
        this.pidObject = null;
        this.debugger.invalidateSessionData();
    }

    public ImageLabel getName() {
        if (this.name == null) {
            String label = this.config != null && this.config.getProgram() != null && this.config.getProgram().getExecutableBaseName() != null ? this.config.getProgram().getExecutableBaseName() : "";
            ImageIcon icon = null;
            icon = this.current ? this.getCurrentIcon() : this.getNormalIcon();
            this.name = new ImageLabel(label, icon);
        }
        return this.name;
    }

    public void nameUpdated() {
        this.name = null;
    }

    public void setCurrent(boolean curr) {
        if (curr != this.current) {
            this.current = curr;
            this.name = null;
        }
    }

    public boolean isCurrent() {
        return this.current;
    }

    public String getCorefile() {
        return this.corefile;
    }

    public void setCorefile(String corefile) {
        this.corefile = corefile;
    }

    public final DbxDebuggerEngine getEngine() {
        return this.engine;
    }

    public final void setEngine(DbxDebuggerEngine engine) {
        this.engine = engine;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public String toString() {
        return this.getName().getLabel();
    }

    public String getShortName() {
        return this.debugger.getSessionName();
    }

    public void ttyChanged() {
        this.pcs.firePropertyChange(PROP_TTY_CHANGED, null, this);
    }

    public DbxHEvalResult getEvaluationResult() {
        return this.evaluationResult;
    }

    public void evaluationResult(int rt, DbxHEvalResult value) {
        this.routingToken = rt;
        this.evaluationResult = value;
    }

    public String getTypeExpr() {
        return this.typeExpr;
    }

    public String getStaticTypeResult() {
        return this.staticType;
    }

    public String getDynamicTypeResult() {
        return this.dynamicType;
    }

    public void typeResult(String expr, String stype, String dtype) {
        this.typeExpr = expr;
        this.staticType = stype;
        this.dynamicType = dtype;
    }

    public String getAssignedValue() {
        return this.assignValue;
    }

    public int getRoutingToken() {
        return this.routingToken;
    }

    public void assignmentResult(int routingToken, String value) {
        this.assignValue = value;
        this.routingToken = routingToken;
    }

    private final ImageIcon getCurrentIcon() {
        if (this.currentIcon == null) {
            this.currentIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler == null ? (class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler = DbxDebugSession.class$("com.sun.tools.debugger.dbxgui.debugger.IpeHandler")) : class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler).getResource("org/netbeans/modules/debugger/multisession/resources/sessionCurrent.gif"));
        }
        return this.currentIcon;
    }

    private final ImageIcon getNormalIcon() {
        if (this.normalIcon == null) {
            this.normalIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler == null ? (class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler = DbxDebugSession.class$("com.sun.tools.debugger.dbxgui.debugger.IpeHandler")) : class$com$sun$tools$debugger$dbxgui$debugger$IpeHandler).getResource("org/netbeans/modules/debugger/multisession/resources/session.gif"));
        }
        return this.normalIcon;
    }

    public void addDisplayNewListener(PropertyChangeListener l) {
        if (this.displayNewpcs == null) {
            this.displayNewpcs = new PropertyChangeSupport(this);
        }
        this.displayNewpcs.addPropertyChangeListener(l);
    }

    public void removeDisplayNewListener(PropertyChangeListener l) {
        this.displayNewpcs.removePropertyChangeListener(l);
    }

    public boolean isMemuseMode() {
        if (this.engine != null) {
            return ((Dbx)this.engine).isMemuseEnabled();
        }
        return false;
    }

    public boolean isAccessMode() {
        if (this.engine != null) {
            return ((Dbx)this.engine).isAccessCheckingEnabled();
        }
        return false;
    }

    public boolean isProfilingMode() {
        return false;
    }

    public int getJavaMode() {
        return this.javaMode;
    }

    public void setJavaMode(int mode) {
        this.javaMode = mode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DEAD {
        private int displayId = -1;
        private String displayLhs = null;
        private String displayQLhs = null;
        private String displayStaticType = null;
        private boolean displayIsPointer = false;
        private String displayReEval = null;
        private int displayUpdatedCount = 0;
        private DbxDisplayItem[] displayUpdatedList = null;
        private transient PropertyChangeSupport displaypcs = new PropertyChangeSupport(this);
        int displayListenerCount = 0;

        DEAD() {
        }

        public int getDisplayId() {
            return this.displayId;
        }

        public String getDisplayLhs() {
            return this.displayLhs;
        }

        public String getDisplayQLhs() {
            return this.displayQLhs;
        }

        public String getDisplayStaticType() {
            return this.displayStaticType;
        }

        public boolean getDisplayIsPointer() {
            return this.displayIsPointer;
        }

        public String getDisplayReEval() {
            return this.displayReEval;
        }

        public final void newWatchItem(int id, String plain_lhs, int rt, String qualified_lhs, String static_type, int is_a_pointer, String reevaluable_lhs) {
            this.displayId = id;
            this.displayLhs = plain_lhs;
            DbxDebugSession.this.routingToken = rt;
            this.displayQLhs = qualified_lhs;
            this.displayStaticType = static_type;
            this.displayIsPointer = is_a_pointer != 0;
            this.displayReEval = reevaluable_lhs;
            DbxDebugSession.this.displayNewpcs.firePropertyChange(DbxDebugSession.PROP_DISPLAY_NEW, null, this);
        }

        public final void watchError(int id) {
            DbxDebugSession.this.routingToken = RoutingToken.TREETABLE.getAsInt();
            Integer intid = new Integer(id);
            DbxDebugSession.this.displayNewpcs.firePropertyChange(DbxDebugSession.PROP_ERROR, intid, this);
        }

        public final void watchIsDuplicate(int rt, int id) {
            DbxDebugSession.this.routingToken = rt;
            this.displayId = id;
            DbxDebugSession.this.displayNewpcs.firePropertyChange(DbxDebugSession.PROP_DISPLAY_DUPLICATE, null, this);
        }

        public final void watchDeleted(int id) {
            DbxDebugSession.this.routingToken = RoutingToken.TREETABLE.getAsInt();
            this.displayId = id;
            DbxDebugSession.this.displayNewpcs.firePropertyChange(DbxDebugSession.PROP_DISPLAY_DELETED, null, this);
        }

        public int getDisplayUpdatedCount() {
            return this.displayUpdatedCount;
        }

        public DbxDisplayItem[] getDisplayUpdatedList() {
            return this.displayUpdatedList;
        }

        public final void watchChanged(int nitems, DbxDisplayItem[] items) {
            DbxDebugSession.this.routingToken = RoutingToken.TREETABLE.getAsInt();
            this.displayUpdatedCount = nitems;
            this.displayUpdatedList = items;
            this.displaypcs.firePropertyChange(DbxDebugSession.PROP_DISPLAY_UPDATED, null, this);
        }

        public void addDisplayListener(PropertyChangeListener l) {
            this.displaypcs.addPropertyChangeListener(l);
            ++this.displayListenerCount;
            if (this.displayListenerCount == 1 && DbxDebugSession.this.engine != null) {
                DbxDebugSession.this.engine.sendDisplayUpdates(true);
            }
        }

        public void removeDisplayListener(PropertyChangeListener l) {
            this.displaypcs.removePropertyChangeListener(l);
            --this.displayListenerCount;
            if (this.displayListenerCount == 0 && DbxDebugSession.this.engine != null) {
                DbxDebugSession.this.engine.sendDisplayUpdates(false);
            }
        }

        public boolean hasDisplayListeners() {
            return this.displayListenerCount != 0;
        }

        public void watchesUpdated() {
            this.displaypcs.firePropertyChange(DbxDebugSession.PROP_WATCHES_CHANGED, null, this);
        }
    }
}

