/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.capture.CaptureInfo;
import com.sun.tools.debugger.dbxgui.capture.ExternalStart;
import com.sun.tools.debugger.dbxgui.debugger.CollectWindow;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugProgram;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugSession;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerEngine;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerState;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerType;
import com.sun.tools.debugger.dbxgui.debugger.DbxStackFrame;
import com.sun.tools.debugger.dbxgui.debugger.DbxThreadGroup;
import com.sun.tools.debugger.dbxgui.debugger.DbxVariable;
import com.sun.tools.debugger.dbxgui.debugger.DbxWatch;
import com.sun.tools.debugger.dbxgui.debugger.EvalAnnotation;
import com.sun.tools.debugger.dbxgui.debugger.FixExecutor;
import com.sun.tools.debugger.dbxgui.debugger.IpeHandler;
import com.sun.tools.debugger.dbxgui.debugger.IpeThread;
import com.sun.tools.debugger.dbxgui.debugger.RoutingToken;
import com.sun.tools.debugger.dbxgui.debugger.RunConfig;
import com.sun.tools.debugger.dbxgui.debugger.SignalDialog;
import com.sun.tools.debugger.dbxgui.debugger.breakpoints.IpeBreakpointEvent;
import com.sun.tools.debugger.dbxgui.debugger.options.DebuggingOption;
import com.sun.tools.debugger.dbxgui.props.PropUndo;
import com.sun.tools.debugger.dbxgui.utils.ImageLabel;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.debugger.dbxgui.utils.ItemSelectorDialog;
import com.sun.tools.debugger.dbxgui.utils.Log;
import com.sun.tools.swdev.common.base.UnixChildProcess;
import com.sun.tools.swdev.common.base.UnixProcessFactory;
import com.sun.tools.swdev.common.base.UnixPty;
import com.sun.tools.swdev.common.base.UnixTty;
import com.sun.tools.swdev.common.nbtext.UnixTabTerm;
import com.sun.tools.swdev.common.text.UnixTerm;
import com.sun.tools.swdev.common.utils.UsageTracking;
import com.sun.tools.swdev.glue.GStr;
import com.sun.tools.swdev.glue.NetAddr;
import com.sun.tools.swdev.glue.Notifier;
import com.sun.tools.swdev.glue.dbx.DbxCapabilities;
import com.sun.tools.swdev.glue.dbx.DbxDisplayItem;
import com.sun.tools.swdev.glue.dbx.DbxDisplayItem0;
import com.sun.tools.swdev.glue.dbx.DbxError;
import com.sun.tools.swdev.glue.dbx.DbxEventRecord;
import com.sun.tools.swdev.glue.dbx.DbxFrame;
import com.sun.tools.swdev.glue.dbx.DbxHEvalResult;
import com.sun.tools.swdev.glue.dbx.DbxHandler;
import com.sun.tools.swdev.glue.dbx.DbxLocalItem;
import com.sun.tools.swdev.glue.dbx.DbxLocation;
import com.sun.tools.swdev.glue.dbx.DbxMprofHeader;
import com.sun.tools.swdev.glue.dbx.DbxMprofItem;
import com.sun.tools.swdev.glue.dbx.DbxMprofState;
import com.sun.tools.swdev.glue.dbx.DbxPathMap;
import com.sun.tools.swdev.glue.dbx.DbxPerfEventsStatus;
import com.sun.tools.swdev.glue.dbx.DbxPerfOptions;
import com.sun.tools.swdev.glue.dbx.DbxPropDeclaration;
import com.sun.tools.swdev.glue.dbx.DbxRList;
import com.sun.tools.swdev.glue.dbx.DbxRtcItem;
import com.sun.tools.swdev.glue.dbx.DbxRtcState;
import com.sun.tools.swdev.glue.dbx.DbxSignalInfo;
import com.sun.tools.swdev.glue.dbx.DbxSignalInfoInit;
import com.sun.tools.swdev.glue.dbx.DbxSurrogate;
import com.sun.tools.swdev.glue.dbx.DbxThread;
import com.sun.tools.swdev.glue.dbx.DbxThreadCapabilities;
import com.sun.tools.swdev.glue.dbx.DbxVItemDynamic;
import com.sun.tools.swdev.glue.dbx.DbxVItemStatic;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractWatch;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.netbeans.modules.debugger.support.actions.DebuggerWindowPerformer;
import org.netbeans.modules.debugger.support.nodes.DebuggerWindow;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.StatusDisplayer;
import org.openide.debugger.Debugger;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataObject;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.text.Line;
import org.openide.util.Lookup;

public final class Dbx
extends DbxSurrogate
implements DbxDebuggerEngine,
PropertyChangeListener,
ActionListener {
    private DbxDebugger debugger;
    public static final String PROP_ACCESS_ITEM = "access-item";
    public static final String PROP_ACCESS_STATE = "access-state";
    public static final String PROP_ACCESS_ENDED = "access-end";
    public static final String PROP_LEAKS_STARTED = "leaks-start";
    public static final String PROP_LEAKS_FINISHED = "leaks-end";
    public static final String PROP_LEAK_ITEM = "leak-item";
    public static final String PROP_MEMUSE_STARTED = "memuse-start";
    public static final String PROP_MEMUSE_FINISHED = "memuse-end";
    public static final String PROP_MEMUSE_ITEM = "memuse-item";
    public static final String PROP_MEMUSE_STATE = "memuse-state";
    public static final String PROP_OPTION_CHANGED = "option-update";
    public static final String PROP_DBXBUSY_CHANGED = "dbxbusy";
    public static DbxPerfOptions CollectorOpts;
    private boolean collAvailable;
    private boolean rtcAvailable;
    private ResourceBundle bundle = null;
    private int data_model = 32;
    private DbxDebugSession session = null;
    private String corefile = null;
    private int mode = 0;
    private RunConfig config = null;
    private DbxDebuggerState state = null;
    private UnixChildProcess proc = null;
    private UnixTerm term = null;
    private Term pioTerm = null;
    private Term originalPioTerm = null;
    private UnixPty pioPty = null;
    private UnixPty dbxPty = null;
    private DbxThread thread = null;
    private long debugeepid = -1L;
    private long debugeetty = 1L;
    private String previousCorefile = null;
    private boolean firstIOProc = false;
    private boolean firstIO = true;
    private String lastRunCmd = null;
    private ActiveTerm accessTerm = null;
    private ActiveTerm leaksTerm = null;
    private ActiveTerm blocksTerm = null;
    private boolean ignoreClassPath = false;
    private boolean ignoreJavaSrcPath = false;
    private FixExecutor fow;
    private boolean isFinishing = false;
    private boolean fix_trace = false;
    private int usageTrackingStep = 0;
    private boolean sampling = false;
    private int startupBehavior = 2;
    private boolean loading = false;
    private static StatusDisplayer statusDisplayer;
    private HashMap watches = new HashMap();
    private DebuggerSupport mux = (DebuggerSupport)Register.getCoreDebugger();
    private ArrayList func_list = new ArrayList();
    public boolean done = false;
    private Document errorDoc = null;
    private Dialog errorDialog = null;
    private DbxLocation startLoc = null;
    private DbxLocation visitLoc = null;
    private DbxLocation currentLoc = null;
    private boolean supportsSuspend = false;
    private boolean supportsResume = false;
    private boolean blockInput = false;
    private Timer cursorTimer;
    private boolean guiBlocked = false;
    private boolean dbxInitializing = false;
    private DbxEventRecord[] currentEvents = null;
    private HashMap varMap = new HashMap();
    public DbxDisplayItem[] ditem;
    private boolean warnOnlyOnce6 = true;
    private int totalThreads = 0;
    private int shownThreads = 0;
    private DbxThread[] dbxThreads = null;
    private IpeThread[] threads = null;
    private int threadFlags = 0;
    private int dbxNFrames = 0;
    private DbxFrame[] dbxStackFrames = null;
    private DbxStackFrame[] guiStackFrames = null;
    private int[] stackMap = null;
    private boolean memuseOn = false;
    private boolean accessOn = false;
    private IpeHandler[] handlers = null;
    private int handlersSize = 0;
    private int numHandlers = 0;
    static int nextBreakpointToken;
    private LinkedList pendingBreakpoints = null;
    boolean ignoreBreakpoint = false;
    private boolean warnOnlyOnce5 = true;
    private ImageLabel summary = null;
    private int lastStateHash;
    private ImageIcon runningIcon = null;
    private ImageIcon coreIcon = null;
    private ImageIcon stoppedIcon = null;
    private ImageIcon terminatedIcon = null;
    private ImageIcon loadedIcon = null;
    private ImageIcon emptyIcon = null;
    public static final int CaptureState_NONE = 0;
    public static final int CaptureState_INITIAL = 1;
    public static final int CaptureState_FINAL = 2;
    private int captureState;
    private CaptureInfo captureInfo;
    private transient PropertyChangeSupport stackpcs = new PropertyChangeSupport(this);
    private int stackListenerCount = 0;
    private transient PropertyChangeSupport localVarpcs = new PropertyChangeSupport(this);
    private int localVarListenerCount = 0;
    private DbxLocalItem[] localVars = null;
    private int numLocalVars = 0;
    static int local_count;
    private transient PropertyChangeSupport threadspcs = new PropertyChangeSupport(this);
    int threadsListenerCount = 0;
    private transient PropertyChangeSupport memusepcs = new PropertyChangeSupport(this);
    private transient PropertyChangeSupport accesspcs = new PropertyChangeSupport(this);
    boolean accessNew = true;
    boolean blocksNew = true;
    boolean leaksNew = true;
    private int deliverSignal = -1;
    private boolean signalDiscarded = true;
    private boolean warnOnlyOnce1 = true;
    private boolean warnOnlyOnce2 = true;
    private boolean warnOnlyOnce3 = true;
    private transient PropertyChangeSupport dbxBusypcs = new PropertyChangeSupport(this);
    int dbxBusyListenerCount = 0;
    private Object balloonResult = null;
    private static ArrayList startupCommands;
    private transient PropertyChangeSupport debuggerEventpcs = null;
    private transient PropertyChangeSupport debuggerImpEventpcs = null;
    public static final String PROP_DBXSTATE = "dbx-state";
    boolean lastRunning = false;
    private DbxPathMap[] pathmap = null;
    private boolean ignoreConfigChange = false;
    private int dirty = 0;
    public static final int DIRTY_ARGS = 1;
    public static final int DIRTY_DIR = 2;
    public static final int DIRTY_ENVVARS = 4;
    public static final int DIRTY_PRELOAD = 8;
    public static final int DIRTY_PATHMAP = 16;
    public static final int DIRTY_BREAKPOINTS = 32;
    public static final int DIRTY_SIGNALS = 64;
    public static final int DIRTY_EXCEPTIONS = 128;
    public static final int DIRTY_CLASSPATH = 256;
    private static final int DIRTY_PROG_APPLY = -1;
    private static final int DIRTY_COREFILE_APPLY = 18;
    private static final int DIRTY_ATTACH_APPLY = 250;
    private boolean localsMasked = false;
    private boolean threadsMasked = false;
    private boolean stackMasked = false;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$Dbx;

    public Dbx(Notifier n, int flags, DbxDebugger debugger, DbxDebugSession session) {
        super(n, flags);
        this.debugger = debugger;
        this.session = session;
        this.config = session.getConfig();
        this.config = debugger.getConfig();
        this.config.addPropertyChangeListener(this);
        this.state = new DbxDebuggerState();
        this.state.clear();
        statusDisplayer = StatusDisplayer.getDefault();
    }

    public void sendCommand(int routingToken, int flags, String cmd) {
        PropUndo.advance();
        this.ksh_cmd(routingToken, flags, cmd);
    }

    public DbxDebugger getDebugger() {
        return this.debugger;
    }

    public RunConfig getConfig() {
        return this.config;
    }

    public static String[] getArgv() {
        return DbxDebuggerType.getArgv();
    }

    public boolean start(UnixTerm termEmulator, UnixPty pty, UnixTerm pioTermEmulator, UnixPty pioPty, int dbxArgc, String[] dbxArgv) {
        this.term = termEmulator;
        this.pioTerm = pioTermEmulator;
        this.originalPioTerm = pioTermEmulator;
        this.pioPty = pioPty;
        this.dbxPty = pty;
        String[] args = Dbx.getArgv();
        String dbxname = DbxDebuggerType.getDbxPath();
        Object host = null;
        Vector<String> avec = new Vector<String>();
        avec.add(dbxname);
        String startupFile = IpeUtils.getenv("SPRO_DBX_INIT_FILE");
        if (startupFile != null && startupFile.length() > 0) {
            avec.add("-s");
            avec.add(startupFile);
        }
        for (int ix = 1; ix < args.length; ++ix) {
            avec.add(args[ix]);
        }
        for (int i = 1; i < dbxArgc; ++i) {
            avec.add(dbxArgv[i]);
        }
        String[] dbx_argv = new String[avec.size()];
        for (int vx = 0; vx < avec.size(); ++vx) {
            dbx_argv[vx] = (String)avec.elementAt(vx);
        }
        this.ignore_unrecognized_msgs(false);
        UnixProcessFactory factory = new UnixProcessFactory(dbxname);
        factory.setArgv(dbx_argv);
        factory.env().setValueOf("TERM", this.term.getEmulation());
        if (this.callback_path() != null) {
            factory.env().setValueOf("_ST_GLUE_CALLBACK_PATH", this.callback_path());
        }
        this.proc = null;
        try {
            if (UsageTracking.enabled) {
                UsageTracking.startTiming((String)"startingdbx");
            }
            this.proc = factory.spawn(pty);
        }
        catch (Exception x) {
            if (UsageTracking.enabled) {
                UsageTracking.stopTiming((String)"startingdbx");
            }
            if (x.getMessage().indexOf("exec failed") != -1) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(DbxDebugger.getText("MSG_NoDbxFound"), dbxname)));
            } else {
                ErrorManager.getDefault().notify((Throwable)x);
            }
            if (UsageTracking.enabled) {
                UsageTracking.stopTiming((String)"debuggerstartup");
            }
            return false;
        }
        int pid = 0;
        if (this.proc != null) {
            pid = this.proc.pid();
        }
        if (this.term != null) {
            if (this.proc == null) {
                if (UsageTracking.enabled) {
                    UsageTracking.sendFailure((String)"DbxStartup: term but no proc", (boolean)false);
                    UsageTracking.stopTiming((String)"debuggerstartup");
                }
                return false;
            }
            OutputStream pin = this.proc.getOutputStream();
            InputStream pout = this.proc.getInputStream();
            this.term.connect(pin, pout, null);
        }
        if (!this.connect(null, pid)) {
            String msg = this.connect_fail_str();
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout(0, 12));
            p.add((Component)new JLabel(MessageFormat.format(DbxDebugger.getText("DbxStartFailed"), msg)), "North");
            p.add((Component)this.term, "Center");
            this.term.setBackground((Color)UIManager.getDefaults().get("TextPane.background"));
            this.term.setForeground((Color)UIManager.getDefaults().get("TextPane.foreground"));
            this.disconnected();
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)p));
            if (UsageTracking.enabled) {
                UsageTracking.stopTiming((String)"debuggerstartup");
            }
            return false;
        }
        DbxDebugger.runNotifier();
        return true;
    }

    public final void disconnected() {
        this.state.clear();
        this.session.setEngine(null);
        this.busy("", true, false);
        this.term.setCursorVisible(false);
        String warning = DbxDebugger.getText("DbxTerminated");
        for (int i = 0; i < warning.length(); ++i) {
            this.term.putChar(warning.charAt(i));
        }
        this.removeHandlerAnnotations();
        this.debugger.sessionExited(this.session);
    }

    public final void rude_disconnect() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 12));
        panel.add((Component)new JLabel(DbxDebugger.getText("DbxDiedInfo")), "North");
        if (this.term != null) {
            this.term.setBackground((Color)UIManager.getDefaults().get("TextPane.background"));
            this.term.setForeground((Color)UIManager.getDefaults().get("TextPane.foreground"));
            panel.add((Component)this.term, "Center");
            panel.setSize(600, 400);
            this.term.setSize(600, 400);
        }
        String ok = DbxDebugger.getText("DbxDiedOK");
        String details = DbxDebugger.getText("DbxDiedDetails");
        JButton okButton = new JButton(ok);
        okButton.getAccessibleContext().setAccessibleDescription(okButton.getText());
        DialogDescriptor dlg = new DialogDescriptor((Object)panel, DbxDebugger.getText("MSG_DbxDied"), true, (Object[])new JButton[]{okButton}, (Object)ok, 0, null, null);
        dlg.setMessageType(0);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dialog.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_DbxDiedDialog"));
        dialog.show();
        this.disconnected();
    }

    public final void svc_available(boolean success) {
        if (!success) {
            this.debugger.cancelPopup();
            return;
        }
        if (UsageTracking.enabled) {
            UsageTracking.readTime((String)"startingdbx", (String)"Start Dbx", (boolean)false, null, (boolean)true);
        }
        final Dbx dbx = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dbx.this.debugger.finishStartDebugger(dbx);
            }
        });
        this.prop_set("DBX_vdl_mode", "lisp");
        this.prop_set("DBX_vdl_version", "3");
        this.prop_set("DBX_run_autostart", "on");
        this.prop_set("DBX_scope_look_aside", "on");
        this.prop_set("DBX_output_inherited_members", "off");
        if (this.pioPty.getSlaveName() != null && DebuggingOption.RUN_IO.getCurrValue().equals("window")) {
            this.prop_set("DBX_run_io", "pty");
            this.prop_set("DBX_run_pty", this.pioPty.getSlaveName());
        }
        if (this.config.getRunDir() != null) {
            this.sendCommand(0, 0, "cd " + this.config.getRunDir());
        }
        this.sendAccessUpdates(true);
        this.sendMemuseUpdates(true);
        this.sendDisplayUpdates(true);
        String prog = this.config.getProgram().getExecutableName();
        long pid = this.session.getPid();
        String corefile = this.session.getCorefile();
        this.debug(prog, pid, corefile);
        if (UsageTracking.enabled) {
            AbstractDebugger[] debuggers = null;
            debuggers = Register.getCoreDebugger().getDebuggers();
            if (debuggers.length <= 1) {
                UsageTracking.readTime((String)"debuggerstartup", (String)"Debugger Startup", (boolean)false, null, (boolean)true);
            } else {
                UsageTracking.readTime((String)"debuggerstartup", (String)"Debugger Startup (Reusing Existing Windows)", (boolean)false, null, (boolean)true);
            }
        }
        if (startupCommands != null) {
            for (int i = 0; i < startupCommands.size(); ++i) {
                this.sendCommand(0, 0, startupCommands.get(i).toString());
            }
        }
        if (corefile != null || this.debugeepid != -1L) {
            this.startupBehavior = 0;
        }
    }

    private final void dbxDoneInitializing() {
        this.dirty = -1;
        DebuggingOption.markChanges();
        DebuggingOption.applyTo(this.debugger);
    }

    protected final void output(String str, boolean ready) {
        for (int i = 0; i < str.length(); ++i) {
            this.term.putChar(str.charAt(i));
        }
    }

    protected final void error(int rt, int nerr, DbxError[] errors) {
        this.debugger.cancelPopup();
        PropUndo.undo();
        if (nerr > 0 && errors[0].msg != null && errors[0].msg.startsWith("dbx: Already mapping path")) {
            return;
        }
        int severity = 0;
        StringBuffer msg = new StringBuffer(nerr * 40);
        String errorToken = null;
        for (int ex = 0; ex < nerr; ++ex) {
            DbxError err = errors[ex];
            if (err.severity > severity) {
                severity = err.severity;
            }
            if (err.cookie != null) {
                errorToken = err.cookie;
            }
            if (ex > 0) {
                msg.append(" / ");
            }
            msg.append(err.msg);
        }
        this.debugger.error(msg.toString());
        boolean handled = false;
        if (errorToken != null) {
            if ("badcore".equals(errorToken)) {
                this.handleBadCore(DbxDebugger.getText("CoreNameMismatch"), true);
                handled = true;
            } else if ("badcore-timestamp".equals(errorToken)) {
                this.handleBadCore(DbxDebugger.getText("CoreOld"), true);
                handled = true;
            } else if ("badcore-noprog".equals(errorToken)) {
                this.handleBadCore(DbxDebugger.getText("CoreNameExtract"), false);
                handled = true;
            } else if ("source-modified".equals(errorToken)) {
                this.sourceModified();
                handled = true;
            } else if ("run-failed".equals(errorToken)) {
                this.runFailed();
                handled = true;
            }
        }
        if (!handled && severity == 2) {
            JTextArea textArea = null;
            if (this.errorDoc == null) {
                textArea = new JTextArea();
                this.errorDoc = textArea.getDocument();
            }
            try {
                for (int ex = 0; ex < nerr; ++ex) {
                    DbxError err = errors[ex];
                    this.errorDoc.insertString(this.errorDoc.getLength(), err.msg + "\n", null);
                }
            }
            catch (BadLocationException x) {
                // empty catch block
            }
            if (this.errorDialog == null) {
                JPanel ev = new JPanel();
                ev.setLayout(new BorderLayout());
                textArea.setEditable(false);
                textArea.setWrapStyleWord(true);
                textArea.setLineWrap(true);
                textArea.setBackground((Color)UIManager.getDefaults().get("Label.background"));
                textArea.setBorder(BorderFactory.createEmptyBorder());
                JScrollPane scrollPane = new JScrollPane(textArea);
                scrollPane.setVerticalScrollBarPolicy(20);
                scrollPane.setHorizontalScrollBarPolicy(30);
                ev.setPreferredSize(new Dimension(500, 100));
                ev.add((Component)scrollPane, "Center");
                textArea.getAccessibleContext().setAccessibleName(DbxDebugger.getText("ACSN_DebuggerErrorDialogTxt"));
                textArea.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_DebuggerErrorDialogTxt"));
                DialogDescriptor descriptor = new DialogDescriptor((Object)ev, DbxDebugger.getText("DebuggerError"));
                descriptor.setOptionsAlign(0);
                descriptor.setModal(false);
                descriptor.setMessageType(0);
                descriptor.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
                descriptor.setButtonListener((ActionListener)this);
                this.errorDialog = DialogDisplayer.getDefault().createDialog(descriptor);
                this.errorDialog.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_DebuggerErrorDialog"));
                this.errorDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent p1) {
                        Dbx.this.errorDialog = null;
                        Dbx.this.errorDoc = null;
                    }
                });
                this.errorDialog.show();
            }
        }
        if (RoutingToken.BREAKPOINTS.isSameSubsystem(rt)) {
            this.deletePendingBreakpoint(rt);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == DialogDescriptor.OK_OPTION || event.getSource() == NotifyDescriptor.CLOSED_OPTION) {
            this.errorDialog.dispose();
            this.errorDialog = null;
            this.errorDoc = null;
            return;
        }
    }

    public DbxLocation getCurrentLocation() {
        return this.currentLoc;
    }

    public DbxLocation getVisitedLocation() {
        return this.visitLoc;
    }

    public DbxLocation getStartLocation() {
        return this.startLoc;
    }

    protected final void prog_visit(DbxLocation loc) {
        boolean warnAboutNoSource;
        this.startLoc = loc;
        boolean bl = warnAboutNoSource = loc.src == null && !this.state.isLoaded();
        if (!this.loading || this.startupBehavior == 0) {
            if ((loc.flags & 0x20) == 0) {
                this.debugger.makeCurrent(loc.src, loc.line, loc.func, (loc.flags & 2) == 0 && loc.src != null, false, warnAboutNoSource, true);
            }
            this.loading = false;
        }
        this.state.setDbxCall((loc.flags & 0x40) != 0);
        this.state.setUpAllowed(false);
        this.state.setDownAllowed(false);
        this.debugger.setStackState(this);
    }

    protected final void prog_runargs(int argc, String[] argv) {
        if (argc > 0) {
            String[] nargv = new String[argc];
            for (int i = 0; i < argc; ++i) {
                nargv[i] = argv[i];
            }
            argv = nargv;
        } else if (argv.length != 0) {
            argv = new String[]{};
        }
        this.ignoreConfigChange = true;
        this.config.setArgsOnly(argv);
        this.ignoreConfigChange = false;
    }

    protected final void prog_redir(String infile, String outfile, boolean append) {
        this.ignoreConfigChange = true;
        this.config.setRedirection(infile, outfile, append);
        this.ignoreConfigChange = false;
    }

    protected void prog_finished(String progname) {
        this.isFinishing = true;
    }

    protected final void prog_loading(String progname) {
        this.isFinishing = false;
        statusDisplayer.setStatusText(MessageFormat.format(DbxDebugger.getText("Loading"), progname));
        this.debugger.updatePopup(DbxDebugger.getText("LoadProg"), progname, -1);
        if (this.config != null) {
            this.config.save();
        }
        this.loading = true;
    }

    protected final void prog_loaded(String progname, boolean success) {
        DebuggerWindow tc;
        if (success) {
            this.debugger.cancelPopup();
        }
        this.dirty |= 0x100;
        this.state.setLoaded(success);
        if (!success) {
            this.captureState = 0;
            return;
        }
        if (progname.charAt(0) != File.separatorChar && !progname.equals("-") && this.config != null && this.config.getRunDir() != null) {
            progname = this.config.getRunDir() + File.separatorChar + progname;
        }
        this.loading = false;
        RunConfig targetConfig = null;
        DbxDebugProgram program = new DbxDebugProgram(progname, null);
        this.config.save();
        targetConfig = progname.equals("-") ? new RunConfig("-", null, program) : RunConfig.findConfig(program);
        if (targetConfig == null) {
            targetConfig = RunConfig.createConfig(progname, program);
            targetConfig.setSignals(this.config.getSignals());
            targetConfig.setSignalOverrides(this.config.getSignalOverrides());
            this.switchConfig(targetConfig);
        } else {
            targetConfig.setSignals(this.config.getSignals());
            targetConfig.setSignalOverrides(this.config.getSignalOverrides());
            this.switchConfig(targetConfig);
            this.dirty = this.session.getCorefile() != null ? 18 : (this.session.getPid() != -1L ? 250 : -1);
            this.applyEnvironment();
            this.applyConfigurationOptions();
        }
        if (this.captureState == 1) {
            this.captureState = 2;
            this.sendCommand(0, 0, "when exit 127 { quit; }");
            this.sendCommand(0, 0, "cont");
        } else if (this.captureState == 2) {
            this.startUpdates();
            this.sendCommand(0, 0, "cd " + this.captureInfo.workingDirectory);
            this.sendCommand(0, 0, "runargs " + this.captureInfo.quotedArgvString());
        }
        this.session.nameUpdated();
        this.debugger.updateState(this);
        this.debugger.updateActionStates();
        this.debugger.updateLocalViewState();
        statusDisplayer.setStatusText(DbxDebugger.getText("ReadyToRun"));
        this.pioPty.chargeActivityDetector();
        if (DebuggingOption.FRONT_DBGWIN.isEnabled() && (tc = DebuggerWindowPerformer.getDebuggerWindow()) instanceof DebuggerWindow) {
            DebuggerWindow dw = tc;
            dw.requestVisible();
        }
        UnixTabTerm tab = (UnixTabTerm)this.debugger.getDbxTab().get(this.debugger);
        tab.requestVisible();
        if (this.corefile == null && this.debugeepid == -1L) {
            if (this.startupBehavior == 2) {
                this.runProgram("run");
            } else if (this.startupBehavior == 1) {
                this.runProgram("step");
            }
        }
        this.startupBehavior = 0;
    }

    protected final void prog_unloaded() {
    }

    protected final void prog_datamodel(int bit_width) {
        this.data_model = bit_width;
        this.state.set64bit(bit_width == 64);
    }

    public boolean isSuspendSupported() {
        return this.supportsSuspend;
    }

    public boolean isResumeSupported() {
        return this.supportsResume;
    }

    protected final void thread_capabilities(DbxThreadCapabilities cap) {
    }

    protected final void capabilities(DbxCapabilities c) {
        this.state.setMultithreaded(c.multi_threading);
        this.collAvailable = c.mt_collector;
        this.rtcAvailable = c.rtc;
    }

    protected final void loadobj_loading(String loadobj) {
        this.debugger.updatePopup(DbxDebugger.getText("LoadingLib"), loadobj, -1);
    }

    protected final void loadobj_loaded(String loadobj, boolean success) {
        if (success) {
            statusDisplayer.setStatusText(MessageFormat.format(DbxDebugger.getText("Loaded"), loadobj));
        }
    }

    protected final void clone(int argc, String[] argv, boolean cloned_to_follow) {
        RunConfig newConfig;
        DbxDebugProgram program = this.config.getProgram();
        try {
            newConfig = (RunConfig)this.config.clone();
        }
        catch (CloneNotSupportedException e) {
            newConfig = RunConfig.createConfig(this.config.getName() + " (cloned)", null, this.config.getProgram());
        }
        if (argc >= 3 && argv[0].equals("SPRO_GUD_CONNECT")) {
            long pid = Long.parseLong(argv[2]);
            String progname = argv[1];
            Object p = null;
            Object s = null;
            if (progname.equals("-")) {
                program = new DbxDebugProgram(null, null);
                newConfig = RunConfig.createConfig(null, null, program);
            } else {
                FileObject fo = IpeUtils.findFileObject(progname, false);
                MultiDataObject dao = new FileEntry(null, fo).getDataObject();
                program = new DbxDebugProgram(progname, null);
                newConfig = RunConfig.createConfig(null, (DataObject)dao, program);
            }
        }
        Dbx dbx = this.debugger.startDbx(this.debugger.getSession(), argc, argv, null);
        if (cloned_to_follow) {
            dbx.debugeetty = this.debugeetty;
        }
        if (cloned_to_follow) {
            dbx.state.setLoaded(true);
            DebuggingOption.markChanges();
            DebuggingOption.applyTo(this.debugger);
            this.debugger.updateState(this);
        }
    }

    public boolean isDbxBusy() {
        return this.blockInput;
    }

    protected final void busy(String with_what, boolean on_off, boolean block_input) {
        if (with_what != null && with_what.length() == 14 && with_what.charAt(0) == 'i' && "initialization".equals(with_what)) {
            this.dbxInitializing = on_off;
            if (!this.dbxInitializing) {
                this.dbxDoneInitializing();
            }
        }
    }

    private int dbxToGuiFrame(int dbxFrame) {
        if (this.stackMap == null) {
            return 0;
        }
        for (int gfx = 0; gfx < this.stackMap.length; ++gfx) {
            if (!(this.stackMap[gfx] < 0 ? gfx + 1 >= this.stackMap.length || dbxFrame < this.stackMap[gfx + 1] : this.stackMap[gfx] == dbxFrame)) continue;
            return gfx;
        }
        return 0;
    }

    protected final void proc_visit(DbxLocation loc, int vframe) {
        Log.prf(1, loc.src + ", " + loc.line + ", " + loc.func + ", " + vframe + ", flags=" + loc.flags);
        this.visitLoc = loc;
        int guiFrame = this.dbxToGuiFrame(vframe);
        IpeThread currentThread = (IpeThread)this.debugger.getCurrentThread();
        currentThread.changeCurrentCallStackFrameIndex(guiFrame);
        boolean visited = true;
        if (this.visitLoc.src != null && this.currentLoc != null && this.currentLoc.src != null && this.visitLoc.line == this.currentLoc.line) {
            visited = false;
        }
        if ((loc.flags & 0x20) == 0) {
            this.debugger.makeCurrent(loc.src, loc.line, loc.func, (loc.flags & 2) == 0, true, false, visited);
        }
        this.state.setDbxCall((loc.flags & 0x40) != 0);
        this.state.setDownAllowed((loc.flags & 4) == 0);
        this.state.setUpAllowed((loc.flags & 8) == 0);
        this.debugger.setStackState(this);
    }

    protected final void proc_thread(int tid, DbxLocation hloc, DbxLocation vloc) {
        Log.prf(1, "");
        Log.pr(1, "\ttid " + tid);
        if (hloc != null) {
            boolean hasSource;
            this.currentLoc = hloc;
            boolean bl = hasSource = (hloc.flags & 2) == 0;
            if (hloc.src == null) {
                hasSource = false;
            }
            if ((hloc.flags & 0x20) == 0) {
                this.debugger.makeCurrent(hloc.src, hloc.line, hloc.func, hasSource, true, false, false);
            }
        }
        if (vloc != null) {
            this.visitLoc = vloc;
            if ((vloc.flags & 2) != 0 && (vloc.flags & 0x20) == 0) {
                this.debugger.makeCurrent(null, 0, vloc.func, false, false, false, true);
            }
            this.state.setDbxCall((vloc.flags & 0x40) != 0);
            this.state.setDownAllowed((vloc.flags & 4) == 0);
            this.state.setUpAllowed((vloc.flags & 8) == 0);
            this.debugger.setStackState(this);
        }
        IpeThread[] threads = this.getThreads();
        IpeThread newCurrentThread = null;
        for (int tx = 0; tx < threads.length; ++tx) {
            if (threads[tx].getId() != tid) continue;
            newCurrentThread = threads[tx];
            break;
        }
        this.debugger.setCurrentThread(newCurrentThread);
        DbxThreadGroup tg = (DbxThreadGroup)this.debugger.getThreadGroupRoot();
        tg.refresh();
    }

    protected final void proc_about_to_fork(int tid) {
        this.state.setRunning(false);
        this.debugger.updateState(this);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(DbxDebugger.getText("ProcForkQuestion")), "North");
        JCheckBox jc = new JCheckBox(DbxDebugger.getText("ProcForkStop"));
        panel.add((Component)jc, "South");
        jc.setSelected(false);
        JButton parentButton = new JButton();
        Actions.setMenuText((AbstractButton)parentButton, (String)DbxDebugger.getText("ProcForkParent"), (boolean)true);
        JButton childButton = new JButton();
        Actions.setMenuText((AbstractButton)childButton, (String)DbxDebugger.getText("ProcForkChild"), (boolean)true);
        JButton bothButton = new JButton();
        Actions.setMenuText((AbstractButton)bothButton, (String)DbxDebugger.getText("ProcForkBoth"), (boolean)true);
        String title = MessageFormat.format(DbxDebugger.getText("ProcForkHeader"), this.session.getShortName());
        DialogDescriptor dlg = new DialogDescriptor((Object)panel, title, true, (Object[])new JButton[]{parentButton, childButton, bothButton}, (Object)parentButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dlg.setMessageType(1);
        dialog.show();
        Object pressedButton = dlg.getValue();
        if (pressedButton == parentButton) {
            this.prop_set("DBX_follow_fork_mode_inner", "parent");
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"Debugger: Fork Follow Parent", null);
            }
        } else if (pressedButton == childButton) {
            this.prop_set("DBX_follow_fork_mode_inner", "child");
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"Debugger: Fork Follow Child", null);
            }
        } else {
            this.prop_set("DBX_follow_fork_mode_inner", "both");
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"Debugger: Fork Follow Both", null);
            }
        }
        if (jc.isSelected()) {
            this.runProgram("step");
        } else if (this.lastRunCmd == null || "run".equals(this.lastRunCmd)) {
            this.runProgram("cont");
        } else {
            this.runProgram(this.lastRunCmd);
        }
    }

    protected final void proc_modified(DbxLocation hloc) {
        this.currentLoc = hloc;
        if ((hloc.flags & 0x20) == 0) {
            this.debugger.makeCurrent(hloc.src, hloc.line, hloc.func, (hloc.flags & 2) == 0, true, false, false);
        }
        this.state.setDbxCall((hloc.flags & 0x40) != 0);
        this.state.setDownAllowed((hloc.flags & 4) == 0);
        this.state.setUpAllowed((hloc.flags & 8) == 0);
        this.debugger.setStackState(this);
    }

    public DbxEventRecord[] getEvents() {
        return this.currentEvents;
    }

    private void updateFiredEvents(int nevents, DbxEventRecord[] events) {
        int nh = this.getNumHandlers();
        for (int hx = 0; hx < nh; ++hx) {
            IpeHandler h = this.handlers[hx];
            boolean match = false;
            for (int ex = 0; ex < nevents; ++ex) {
                if (h.getHid() != events[ex].hid) continue;
                match = true;
                break;
            }
            h.setFired(match);
        }
    }

    protected final void proc_stopped(DbxLocation hloc, int nevents, DbxEventRecord[] events) {
        boolean hasSource;
        this.state.setRunning(false);
        this.debugger.enableStoppedActions(this);
        this.debugger.updateState(this);
        if ((hloc.flags & 0x20) != 0) {
            return;
        }
        this.currentLoc = hloc;
        boolean bl = hasSource = (hloc.flags & 2) == 0;
        if (hloc.src == null) {
            hasSource = false;
        }
        this.debugger.makeCurrent(hloc.src, hloc.line, hloc.func, hasSource, true, false, false);
        this.currentEvents = events;
        this.updateFiredEvents(nevents, events);
        if (nevents > 0) {
            this.explainStop(nevents, events);
        }
        this.state.setDbxCall((hloc.flags & 0x40) != 0);
        this.state.setDownAllowed((hloc.flags & 4) == 0);
        this.state.setUpAllowed((hloc.flags & 8) == 0);
        this.debugger.setStackState(this);
        if (this.debuggerEventpcs != null) {
            this.debuggerEventpcs.firePropertyChange(PROP_DBXSTATE, null, this.state);
        }
        if (DebuggingOption.FRONT_DBX.isEnabled()) {
            UnixTabTerm tab = (UnixTabTerm)this.debugger.getDbxTab().get(this.debugger);
            tab.requestVisible();
        }
        if (UsageTracking.enabled && this.usageTrackingStep != 0) {
            if (this.usageTrackingStep == 1) {
                UsageTracking.readTime((String)"debuggerstep", (String)"Debugger Step Into - Start Process", (boolean)true, null, (boolean)true);
            } else if (this.usageTrackingStep == 2) {
                UsageTracking.readTime((String)"debuggerstep", (String)"Debugger Step Into", (boolean)true, null, (boolean)true);
            } else if (this.usageTrackingStep == 3) {
                UsageTracking.readTime((String)"debuggerstep", (String)"Debugger Step Over - Start Process", (boolean)true, null, (boolean)true);
            } else if (this.usageTrackingStep == 4) {
                UsageTracking.readTime((String)"debuggerstep", (String)"Debugger Step Over", (boolean)true, null, (boolean)true);
            } else if (this.usageTrackingStep == 5) {
                UsageTracking.readTime((String)"debuggerstep", (String)"Debugger Step Out", (boolean)true, null, (boolean)true);
            } else if (this.usageTrackingStep == 6) {
                UsageTracking.readTime((String)"debuggerstep", (String)"Debugger Step To - Start Process", (boolean)true, null, (boolean)true);
            } else if (this.usageTrackingStep == 7) {
                UsageTracking.readTime((String)"debuggerstep", (String)"Debugger Step To", (boolean)true, null, (boolean)true);
            }
            this.usageTrackingStep = 0;
        }
    }

    protected final void proc_go() {
        this.state.setTerminated(false);
        this.state.setRunning(true);
        this.debugger.disableStoppedActions(this);
        this.debugger.processRunning();
        this.deleteMarkLocations();
        if (UsageTracking.enabled && this.usageTrackingStep != 0) {
            if (this.usageTrackingStep == 1 || this.usageTrackingStep == 3) {
                UsageTracking.readTime((String)"debuggerstep", (String)"Debugger Step - ProcGo Delay (started process)", (boolean)false, null, (boolean)false);
            } else {
                UsageTracking.readTime((String)"debuggerstep", (String)"Debugger Step - ProcGo Delay", (boolean)false, null, (boolean)false);
            }
        }
        this.loading = false;
        this.deliverSignal = -1;
        if (this.debuggerEventpcs != null) {
            this.debuggerEventpcs.firePropertyChange(PROP_DBXSTATE, null, this.state);
        }
    }

    private Term findTerminal(long ttydev) {
        AbstractDebugger[] debuggers = null;
        Dbx dbx = null;
        boolean found = false;
        debuggers = Register.getCoreDebugger().getDebuggers();
        for (int dx = 0; dx < debuggers.length; ++dx) {
            DbxDebugger dbxDebugger = (DbxDebugger)debuggers[dx];
            dbx = dbxDebugger.getEngine();
            if (dbx == null || dbx.debugeetty != ttydev) continue;
            found = true;
            break;
        }
        if (found || ttydev == -1L) {
            if (dbx != this) {
                return dbx.pioTerm;
            }
        } else {
            return null;
        }
        return this.originalPioTerm;
    }

    private void newProcess(long pid, String coref) {
        this.debugeepid = pid;
        this.corefile = coref;
        this.session.setPid(pid);
        this.session.setCorefile(coref);
        this.state.setProcess(true);
        if (coref != null) {
            this.state.setTerminated(true);
            this.state.setCore(true);
        } else {
            this.state.setTerminated(false);
            this.state.setCore(false);
        }
        this.createStackFrames();
        this.createThreads();
        this.debugger.updateState(this);
    }

    protected final void proc_new_from_prog(int pid, long ttydev) {
        this.newProcess(pid, null);
        this.debugeetty = ttydev;
        this.pioTerm = this.originalPioTerm;
        this.session.ttyChanged();
        if (this.firstIOProc) {
            if (this.pioTerm.getCursorCol() != 0) {
                this.pioTerm.putChar('\r');
                this.pioTerm.putChar('\n');
            }
            int width = this.pioTerm.getColumns();
            for (int i = 0; i < width; ++i) {
                this.pioTerm.putChar('_');
            }
            if (this.pioTerm.getCursorCol() != 0) {
                this.pioTerm.putChar('\r');
                this.pioTerm.putChar('\n');
            }
        } else {
            this.firstIOProc = true;
        }
        statusDisplayer.setStatusText(MessageFormat.format(DbxDebugger.getText("ProgStarted"), Integer.toString(pid)));
        this.firstIO = false;
        this.session.setPid(pid);
        this.flushInput();
        if (DebuggingOption.FRONT_PIO.isEnabled() && DebuggingOption.RUN_IO.getCurrValue().equals("window")) {
            this.pioPty.chargeActivityDetector();
        }
    }

    public void flushInput() {
        if (this.pioPty != null) {
            UnixTty tty = this.pioPty.getTty();
            try {
                tty.flushi();
            }
            catch (Exception x) {
                ErrorManager.getDefault().notify(1, (Throwable)x);
            }
        }
    }

    protected final void proc_new_from_pid(int pid, long ttydev) {
        this.newProcess(pid, null);
        this.pioTerm = this.findTerminal(ttydev);
        this.debugeetty = ttydev;
        this.session.ttyChanged();
        statusDisplayer.setStatusText(MessageFormat.format(DbxDebugger.getText("AttachedToProc"), Integer.toString(pid)));
        this.session.setPid(pid);
        if (ExternalStart.attached(pid)) {
            this.prop_set("DBX_run_quick", "off");
        }
    }

    protected final void proc_new_from_core(String corefilename) {
        this.newProcess(-1L, corefilename);
        this.pioTerm = null;
        this.session.ttyChanged();
        statusDisplayer.setStatusText(MessageFormat.format(DbxDebugger.getText("LoadedCore"), corefilename));
    }

    public long getProcessId() {
        return this.debugeepid;
    }

    protected final void proc_gone(String reason, int exitCode) {
        Log.prfa(1, "reason " + reason + ", exitCode " + exitCode);
        if (!this.state.isProcess() && !this.state.isCore()) {
            return;
        }
        this.state.setProcess(false);
        this.state.setRunning(false);
        this.state.setCore(false);
        this.state.setTerminated(true);
        this.state.setLoaded(true);
        this.debugger.updateState(this);
        this.lastRunCmd = null;
        this.debugeepid = -1L;
        this.deleteMarkLocations();
        this.debugger.processTerminated(reason, exitCode);
        this.dbxNFrames = 0;
        this.dbxStackFrames = null;
        this.stackMap = null;
        this.createStackFrames();
        this.stackUpdated();
        this.totalThreads = 0;
        this.shownThreads = 0;
        this.threads = null;
        this.dbxThreads = null;
        this.threadsUpdated();
        this.localVars = null;
        this.numLocalVars = 0;
        this.localVarsUpdated();
        this.currentEvents = null;
        this.updateFiredEvents(0, null);
        if (this.accessOn && this.accesspcs != null) {
            this.accesspcs.firePropertyChange(PROP_ACCESS_ENDED, null, this);
        }
        this.debugger.enableStoppedActions(this);
        this.session.setPid(-1L);
        this.session.setCorefile(null);
        this.debugeepid = -1L;
        this.corefile = null;
        this.dirty |= 0x100;
    }

    protected final void expr_eval_result(int rt, String value) {
    }

    public final void expr_heval(DbxVariable var, String expr) {
        if (expr != null) {
            int hash = var.hashCode();
            this.varMap.put(new Integer(hash), var);
            this.expr_heval(hash, "-r " + expr);
        }
    }

    protected final void expr_heval_result(int rt, DbxHEvalResult result) {
        DbxVariable var = (DbxVariable)this.varMap.remove(new Integer(rt));
        if (result.rhs_vdl != null) {
            var.setChildren(result.rhs_vdl);
        }
    }

    protected final void expr_type_result(int rt, String expr, String stype, String dtype) {
        this.session.typeResult(expr, stype, dtype);
    }

    protected final void expr_set_result(int rt, String value) {
        this.session.assignmentResult(rt, value);
    }

    protected final void type_info_result(int rt, String def) {
    }

    protected final void expr_line_evalall_result(int rt1, int rt2, int flags, String lhs, String rhs, String rhs2, String rhs3) {
        EvalAnnotation.postResult(rt1, rt2, flags, lhs, rhs, rhs2, rhs3);
    }

    protected final void expr_line_eval_result(int rt1, int rt2, int flags, String lhs, String rhs) {
        this.expr_line_evalall_result(rt1, rt2, flags, lhs, rhs, null, null);
    }

    protected final void display_item_new(int id, String plain_lhs, int rt, String qualified_lhs, String static_type, int is_a_pointer, String reevaluable_lhs) {
        Log.prf(1, id + ", " + plain_lhs);
        DbxWatch w = new DbxWatch(this.debugger, id, plain_lhs, static_type);
        if (is_a_pointer != 0) {
            w.setPtr(true);
        } else {
            w.setPtr(false);
        }
        w.setLeaf(false);
        this.watches.put(new Integer(id), w);
        this.mux.addWatch((AbstractWatch)w);
    }

    protected final void display_item_dup(int rt, int id) {
    }

    protected final void display_item_delete(int id) {
        DbxWatch w = (DbxWatch)this.watches.remove(new Integer(id));
        ((DbxVariable)w.getVar()).remove();
        this.mux.removeWatch((AbstractWatch)w);
    }

    protected final void display_update_0(int nitems, DbxDisplayItem0[] items) {
    }

    protected final void display_update(int nitems, DbxDisplayItem[] items) {
        Log.prfa(1, "" + nitems);
        this.ditem = items;
        for (int ix = 0; ix < nitems; ++ix) {
            DbxDisplayItem i = items[ix];
            DbxWatch w = (DbxWatch)this.watches.get(new Integer(i.id));
            if (w == null) continue;
            boolean is_leaf = w.isLeaf();
            if (i.rhs_vdl != null && i.flags == 0) {
                w.setRHS(i.rhs, i.rhs_vdl);
                if (is_leaf != w.isLeaf()) {
                    w.setLeaf(w.isLeaf());
                    this.mux.removeWatch((AbstractWatch)w);
                    this.watches.remove(new Integer(i.id));
                    this.watches.put(new Integer(i.id), w);
                    this.mux.addWatch((AbstractWatch)w);
                }
                this.delayTraverseWatch(w);
                continue;
            }
            w.setLeaf(true);
            this.mux.removeWatch((AbstractWatch)w);
            this.watches.remove(new Integer(i.id));
            this.watches.put(new Integer(i.id), w);
            this.mux.addWatch((AbstractWatch)w);
        }
    }

    private void delayTraverseWatch(final DbxWatch watch) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ArrayList openlist = ((DbxVariable)watch.getVar()).getOpenNode();
                    int size = openlist.size();
                    if (openlist != null && size != 0) {
                        DbxVariable[] ol = new DbxVariable[size];
                        ol = openlist.toArray(ol);
                        for (int j = 0; j < size; ++j) {
                            if (!ol[j].isExpanded() || !ol[j].inOpenList()) continue;
                            ol[j].requestChildren();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected final void vitem_new(int rt, DbxVItemStatic sitem) {
    }

    protected final void vitem_replace(int rt, DbxVItemStatic sitem) {
    }

    protected final void vitem_add(DbxVItemStatic sitem, int id) {
    }

    protected final void vitem_delete(int id) {
    }

    protected final void vitem_update(int nitems, DbxVItemDynamic[] items) {
    }

    protected final void vitem_update_mode(int id, int new_mode) {
    }

    protected final void vitem_timer(float seconds) {
    }

    protected final void stack(int nf, int nv, DbxFrame[] frames, int flags) {
        Log.prf(1, "nf=" + nf + ", nv=" + nv + ", flags=" + flags);
        this.dbxNFrames = nf;
        this.dbxStackFrames = frames;
        this.createStackFrames();
        IpeThread currentThread = (IpeThread)this.debugger.getCurrentThread();
        this.debugger.refreshThread(currentThread);
        if (currentThread != null) {
            int guiFrame = this.dbxToGuiFrame(nv);
            currentThread.changeCurrentCallStackFrameIndex(guiFrame);
        }
        this.stackUpdated();
    }

    protected final void threads(int tot, int shown, DbxThread[] dthreads, int flags) {
        this.totalThreads = tot;
        this.shownThreads = shown;
        this.dbxThreads = dthreads;
        this.threads = this.createThreads();
        this.threadFlags = flags;
        this.threadsUpdated();
    }

    public int getTotalThreads() {
        return this.totalThreads;
    }

    public int getShownThreads() {
        return this.shownThreads;
    }

    public IpeThread[] createThreads() {
        Log.prf(1, "-------- threads = " + this.threads);
        IpeThread currentThread = null;
        DbxThreadGroup tg = (DbxThreadGroup)this.debugger.getThreadGroupRoot();
        tg.removeAll();
        if (this.dbxThreads != null) {
            this.threads = new IpeThread[this.shownThreads];
            for (int i = 0; i < this.shownThreads; ++i) {
                this.threads[i] = new IpeThread(this.debugger, this.dbxThreads[i]);
                if (this.dbxThreads[i].current) {
                    currentThread = this.threads[i];
                }
                tg.addThread(this.threads[i]);
            }
        } else {
            this.threads = new IpeThread[1];
            this.threads[0] = new IpeThread(this.debugger, new DbxThread());
            currentThread = this.threads[0];
        }
        tg.refresh();
        this.debugger.setCurrentThread(currentThread);
        return this.threads;
    }

    public IpeThread[] getThreads() {
        Log.prf(1, "-----------------");
        return this.threads;
    }

    public int getThreadFlags() {
        return this.threadFlags;
    }

    private void createStackFrames() {
        if (this.dbxStackFrames != null) {
            int actualFrames = 0;
            for (int i = 0; i < this.dbxNFrames; ++i) {
                if (this.dbxStackFrames[i].attr_user_call) {
                    ++actualFrames;
                } else if (this.dbxStackFrames[i].attr_sig != 0 && this.dbxStackFrames[i].attr_sig != -1) {
                    ++actualFrames;
                }
                ++actualFrames;
            }
            this.guiStackFrames = new DbxStackFrame[actualFrames];
            this.stackMap = new int[actualFrames];
            int fx = 0;
            for (int i = 0; i < this.dbxNFrames; ++i) {
                DbxFrame dummy;
                DbxFrame f = this.dbxStackFrames[i];
                boolean attr_user_call = f.attr_user_call;
                f.attr_user_call = false;
                int attr_sig = f.attr_sig;
                String attr_signame = f.attr_signame;
                f.attr_sig = 0;
                f.attr_signame = null;
                this.guiStackFrames[fx] = new DbxStackFrame(this.debugger, f);
                this.stackMap[fx] = f.range_of_hidden ? -1 : f.frameno;
                ++fx;
                if (attr_user_call) {
                    dummy = new DbxFrame();
                    dummy.attr_user_call = true;
                    this.guiStackFrames[fx] = new DbxStackFrame(this.debugger, dummy);
                    this.stackMap[fx] = 0;
                    ++fx;
                    continue;
                }
                if (attr_sig == 0 || attr_sig == -1) continue;
                dummy = new DbxFrame();
                dummy.attr_sig = attr_sig;
                dummy.attr_signame = attr_signame;
                this.guiStackFrames[fx] = new DbxStackFrame(this.debugger, dummy);
                this.stackMap[fx] = 0;
                ++fx;
            }
        } else {
            this.guiStackFrames = new DbxStackFrame[1];
            this.stackMap = new int[1];
            this.guiStackFrames[0] = new DbxStackFrame(this.debugger);
            this.stackMap[0] = 0;
        }
    }

    public DbxStackFrame[] getStackFrames() {
        Log.prf(1, "");
        return this.guiStackFrames;
    }

    protected final void button(String label, String cmd, String option) {
        statusDisplayer.setStatusText(DbxDebugger.getText("ButtonIgnored"));
    }

    protected final void unbutton(String label) {
    }

    protected final void manifest_mark(String mark, DbxLocation loc) {
    }

    protected final void perf_file(String dir, String file, String group) {
        CollectWindow win;
        String[] cfiles = new String[]{dir, file, group};
        if (this.session != null && (win = this.config.getCollectorInfo()) != null) {
            win.getDbxCollState(null, cfiles);
        }
    }

    protected final void perf_options(DbxPerfOptions options) {
        CollectWindow win;
        CollectorOpts = options;
        if (this.session != null && (win = this.config.getCollectorInfo()) != null) {
            win.getDbxCollState(options, null);
        }
    }

    protected final void perf_events_status(DbxPerfEventsStatus stat) {
    }

    protected final void perf_open() {
    }

    protected final void perf_close() {
    }

    protected final void rtc_state(DbxRtcState state) {
        this.accessOn = state.ck_access;
        this.accesspcs.firePropertyChange(PROP_ACCESS_STATE, null, this);
    }

    protected final void rtc_access_item(DbxRtcItem item) {
        this.accesspcs.firePropertyChange(PROP_ACCESS_ITEM, this, item);
    }

    protected final void mprof_state(DbxMprofState state) {
        this.memuseOn = state.gather_stacks;
        this.memusepcs.firePropertyChange(PROP_MEMUSE_STATE, null, this);
    }

    public boolean isMemuseEnabled() {
        return this.memuseOn;
    }

    public boolean isAccessCheckingEnabled() {
        return this.accessOn;
    }

    protected final void mprof_leak_report_begin(DbxMprofHeader hdr) {
        this.memusepcs.firePropertyChange(PROP_LEAKS_STARTED, this, hdr);
    }

    protected final void mprof_leak_report_end() {
        this.memusepcs.firePropertyChange(PROP_LEAKS_FINISHED, null, this);
    }

    protected final void mprof_leak_report_stopped() {
    }

    protected final boolean mprof_leak_item(DbxMprofItem item) {
        this.memusepcs.firePropertyChange(PROP_LEAK_ITEM, this, item);
        return true;
    }

    protected final void mprof_use_report_begin(DbxMprofHeader hdr) {
        this.memusepcs.firePropertyChange(PROP_MEMUSE_STARTED, this, hdr);
    }

    protected final void mprof_use_report_end() {
        this.memusepcs.firePropertyChange(PROP_MEMUSE_FINISHED, null, this);
    }

    protected final void mprof_use_report_stopped() {
    }

    protected final boolean mprof_use_item(DbxMprofItem item) {
        this.memusepcs.firePropertyChange(PROP_MEMUSE_ITEM, this, item);
        return true;
    }

    protected final void fix_start(String wd, String cmd, String file) {
        if (this.fix_trace) {
            System.out.println("Dbx.fix_start(" + wd + ", " + cmd + ", " + file + ")");
        }
        if (this.fow == null) {
            this.fow = new FixExecutor();
        }
        this.fow.setFile(file);
        statusDisplayer.setStatusText(MessageFormat.format(DbxDebugger.getText("FixBuildingFile"), file));
    }

    protected final void fix_status(boolean succeeded, String errfile) {
        if (this.fix_trace) {
            System.out.println("Dbx.fix_status(" + succeeded + ", " + errfile + ")");
        }
        this.fow.compile(errfile);
        if (succeeded) {
            statusDisplayer.setStatusText(DbxDebugger.getText("FixSuccess"));
        } else {
            statusDisplayer.setStatusText(DbxDebugger.getText("FixFailed"));
        }
    }

    protected final void fix_done(int attempted, int succeeded) {
        if (this.fix_trace) {
            System.out.println("Dbx.fix_done(" + attempted + ", " + succeeded + ")");
        }
        String msg = MessageFormat.format(DbxDebugger.getText("FixDone"), Integer.toString(succeeded), Integer.toString(attempted));
        this.fow.done(msg);
        statusDisplayer.setStatusText(msg);
    }

    protected final void fix_pending_build(String target, int n, String[] file) {
        if (this.fix_trace) {
            System.out.println("Dbx.fix_pending_build(" + target + ")");
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setRows(8);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(textArea);
        StringBuffer sb = new StringBuffer(n * 100 + 200);
        sb.append(MessageFormat.format(DbxDebugger.getText("FixPendingBuild"), target));
        sb.append('\n');
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
            sb.append(' ');
            sb.append(' ');
            sb.append(file[i]);
            sb.append('\n');
        }
        sb.append('\n');
        sb.append(DbxDebugger.getText("FixPendingBuildWarn"));
        textArea.setText(sb.toString());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)scrollPane, 2));
    }

    protected final void prop_decl(int nprop, DbxPropDeclaration[] prop) {
    }

    protected final void prop_changed(String name, String new_value) {
        DebuggingOption o;
        if (name.startsWith("DBX_")) {
            name = name.substring(4);
        }
        if ((o = DebuggingOption.find(name)) != null) {
            if (o == DebuggingOption.RUN_PTY && new_value.equals(this.pioPty.getSlaveName())) {
                DebuggingOption.RUN_IO.setCurrValue("window");
            } else if (o == DebuggingOption.RUN_IO && new_value.equals("pty") && DebuggingOption.RUN_PTY.getCurrValue().equals(this.pioPty.getSlaveName())) {
                new_value = "window";
            }
            o.setCurrValue(new_value);
        }
    }

    protected final void dir_changed(String dir) {
        this.config.setRunDir(dir);
    }

    protected final void ksh_notify(int argc, String[] argv) {
    }

    protected final void env_changed(String name, String new_value) {
        if (this.dbxInitializing) {
            return;
        }
        if (this.ignoreClassPath && name.equals("CLASSPATH")) {
            this.ignoreClassPath = false;
            return;
        }
        if (this.ignoreJavaSrcPath && name.equals("JAVASRCPATH")) {
            this.ignoreJavaSrcPath = false;
            return;
        }
        if ("_".equals(name)) {
            return;
        }
        if ("LD_LIBRARY_PATH".equals(name)) {
            return;
        }
        if ("LD_PRELOAD".equals(name)) {
            return;
        }
        if ("SPRO_EXPAND_ERRORS".equals(name)) {
            return;
        }
        if ("PWD".equals(name)) {
            return;
        }
        if ("PS1".equals(name)) {
            return;
        }
        if ("SP_COLLECTOR_EXPNAME".equals(name)) {
            return;
        }
        if ("SP_COLLECTOR_PARAMS".equals(name)) {
            return;
        }
        String[] environment = this.config.getEnvVars();
        if (environment != null) {
            if (new_value == null) {
                int i;
                for (i = 0; !(i >= environment.length || environment[i].startsWith(name) && environment[i].charAt(name.length()) == '='); ++i) {
                }
                if (i == environment.length) {
                    return;
                }
                String[] newEnv = new String[environment.length - 1];
                for (int j = 0; j < i; ++j) {
                    newEnv[j] = environment[j];
                }
                ++i;
                while (i < environment.length) {
                    newEnv[j++] = environment[i];
                    ++i;
                }
                environment = newEnv;
            } else {
                int i;
                for (i = 0; i < environment.length; ++i) {
                    if (!environment[i].startsWith(name) || environment[i].charAt(name.length()) != '=') continue;
                    environment[i] = name + '=' + new_value;
                    break;
                }
                if (i == environment.length) {
                    String[] newEnv = new String[environment.length + 1];
                    for (i = 0; i < environment.length; ++i) {
                        newEnv[i] = environment[i];
                    }
                    newEnv[i] = name + '=' + new_value;
                    environment = newEnv;
                }
            }
        } else {
            if (new_value == null) {
                return;
            }
            environment = new String[]{name + '=' + new_value};
        }
        this.ignoreConfigChange = true;
        this.config.setEnvVars(environment);
        this.ignoreConfigChange = false;
    }

    protected final boolean load_symbols(int rt) {
        JButton loadokButton = new JButton();
        Actions.setMenuText((AbstractButton)loadokButton, (String)DbxDebugger.getText("LoadSymbolsOK"), (boolean)true);
        JButton loadcancelButton = new JButton();
        Actions.setMenuText((AbstractButton)loadcancelButton, (String)DbxDebugger.getText("Cancel"), (boolean)true);
        DialogDescriptor dlg = new DialogDescriptor((Object)DbxDebugger.getText("LoadSymbolsQ"), DbxDebugger.getText("LoadSymbolsTitle"), true, (Object[])new JButton[]{loadokButton, loadcancelButton}, (Object)loadokButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dlg.setMessageType(1);
        dialog.show();
        Object pressedButton = dlg.getValue();
        return pressedButton == loadokButton;
    }

    protected final boolean rcmd(String host, int pid, String cmd) {
        return false;
    }

    protected final void rconnect(NetAddr addr, String hostname) {
    }

    protected final void rgrab_attention() {
    }

    protected final void rlist(DbxRList list) {
    }

    protected final boolean rswitch(String host, int pid) {
        return false;
    }

    protected final void rmove(boolean backward) {
    }

    protected final int popup2(int rt, String title, int nitems, String[] item, boolean cancelable, boolean multiple_selections) {
        ItemSelectorDialog isd = new ItemSelectorDialog();
        isd.showWindow(title, nitems, item, cancelable, multiple_selections);
        int selection = -1;
        if (isd.cancelled || isd.selected_item == -1) {
            this.popup2_selection(0, null);
        } else {
            int nselections = isd.selected_indices.length;
            int[] selections = new int[nselections];
            this.popup2_selection(nselections, isd.selected_indices);
        }
        return 0;
    }

    protected final int popup(int rt, String title, int nitems, String[] item, boolean cancelable) {
        ItemSelectorDialog isd = new ItemSelectorDialog();
        isd.showWindow(title, nitems, item, cancelable, false);
        int selection = -1;
        if (!isd.cancelled && isd.selected_item != -1) {
            selection = isd.selected_item;
        }
        this.popup_selection(selection);
        return 0;
    }

    public IpeHandler[] getHandlers() {
        return this.handlers;
    }

    public int getNumHandlers() {
        return this.numHandlers;
    }

    protected final void bpt_set(int id, String filename, int line) {
        IpeHandler h = this.getHandler(id);
        if (h != null) {
            h.addAnnotation(filename, line);
        }
    }

    protected final void bpt_del(int id) {
        IpeHandler h = this.getHandler(id);
        if (h != null) {
            h.removeAnnotations();
        }
    }

    private IpeHandler getHandler(int id) {
        if (this.handlers == null) {
            return null;
        }
        for (int i = 0; i < this.numHandlers; ++i) {
            if (this.handlers[i].getHid() != id) continue;
            return this.handlers[i];
        }
        return null;
    }

    private void removeHandler(int id) {
        if (this.handlers == null) {
            return;
        }
        for (int i = 0; i < this.numHandlers; ++i) {
            if (this.handlers[i].getHid() != id) continue;
            for (int j = i + 1; j < this.numHandlers; ++j) {
                this.handlers[i] = this.handlers[j];
                ++i;
            }
            --this.numHandlers;
            return;
        }
    }

    private void removeHandlerAnnotations() {
        for (int i = 0; i < this.numHandlers; ++i) {
            this.handlers[i].removeAnnotations();
        }
    }

    public IpeBreakpointEvent locateBreakpoint(Line l) {
        if (this.handlers == null) {
            return null;
        }
        for (int i = 0; i < this.numHandlers; ++i) {
            if (!this.handlers[i].matchesLine(l)) continue;
            IpeBreakpointEvent e = this.handlers[i].getEvent();
            if (e != null) {
                return e;
            }
            return null;
        }
        return null;
    }

    protected final void handler_batch_begin() {
    }

    protected final void handler_batch_end() {
    }

    public final void insertBreakpoint(IpeBreakpointEvent be) {
        this.ignoreBreakpoint = true;
        Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = Dbx.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        CoreBreakpoint b = ((BreakpointProducer)d).createBreakpoint(false);
        b.setEvent((CoreBreakpoint.Event)be);
        this.ignoreBreakpoint = false;
    }

    private void removeBreakpoint(IpeBreakpointEvent ibe) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stashBreakpoint(IpeBreakpointEvent b) {
        Dbx dbx = this;
        synchronized (dbx) {
            if (this.pendingBreakpoints == null) {
                this.pendingBreakpoints = new LinkedList();
            }
            this.pendingBreakpoints.addLast(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IpeBreakpointEvent unstashBreakpoint(int id) {
        IpeBreakpointEvent ibe = null;
        Dbx dbx = this;
        synchronized (dbx) {
            if (this.pendingBreakpoints != null && !this.pendingBreakpoints.isEmpty()) {
                int intid;
                if (id != -1 && (ibe = (IpeBreakpointEvent)this.pendingBreakpoints.getFirst()) != null && (intid = ibe.getRoutingToken()) != id) {
                    return null;
                }
                ibe = (IpeBreakpointEvent)this.pendingBreakpoints.removeFirst();
            }
        }
        return ibe;
    }

    private void deletePendingBreakpoint(int id) {
        IpeBreakpointEvent ibe = this.unstashBreakpoint(id);
        if (ibe == null) {
            return;
        }
        this.debugger.ignoreUpdates(true);
        CoreBreakpoint brpt = ibe.getBreakpoint();
        if (brpt != null) {
            brpt.remove();
        }
        this.debugger.ignoreUpdates(false);
    }

    protected final void handler_new(DbxHandler h) {
        IpeBreakpointEvent ibe = this.unstashBreakpoint(-1);
        if (ibe != null) {
            this.debugger.ignoreUpdates(true);
            CoreBreakpoint brpt = ibe.getBreakpoint();
            if (brpt != null) {
                brpt.remove();
            }
            this.debugger.ignoreUpdates(false);
        }
        if ((ibe = IpeHandler.createIBE(h)) == null) {
            return;
        }
        IpeHandler ih = null;
        if (ibe.getHandler() == null) {
            ih = new IpeHandler(this.debugger, h, ibe);
        } else {
            ih = ibe.getHandler();
            ih.setHandler(h);
        }
        this.insertBreakpoint(ibe);
        ih.possiblyDisable();
        if (this.handlers == null) {
            this.handlersSize = 20;
            this.handlers = new IpeHandler[this.handlersSize];
        } else if (this.numHandlers == this.handlersSize) {
            int newSize = 2 * this.handlersSize;
            IpeHandler[] newHandlers = new IpeHandler[newSize];
            for (int i = 0; i < this.handlersSize; ++i) {
                newHandlers[i] = this.handlers[i];
            }
            this.handlers = newHandlers;
            this.handlersSize = newSize;
        }
        this.handlers[this.numHandlers++] = ih;
        this.config.handlerListUpdated(this.numHandlers, this.handlers);
    }

    protected final void handler_replace(DbxHandler dh) {
        IpeHandler h = this.getHandler(dh.id);
        if (h != null) {
            h.setHandler(dh);
        }
    }

    protected final void handler_delete(int hid) {
        IpeHandler h = this.getHandler(hid);
        this.removeHandler(hid);
        h.removeAnnotations();
        if (!this.isFinishing) {
            this.config.handlerListUpdated(this.numHandlers, this.handlers);
        }
        if (h.getEvent() != null && h.getEvent().getBreakpoint() != null) {
            h.getEvent().setHandler(null);
            h.getEvent().getBreakpoint().remove();
        }
    }

    protected final void handler_defunct(int hid) {
        IpeHandler h = this.getHandler(hid);
        if (h != null) {
            DbxHandler dh = h.getHandler();
            dh.defunct = true;
            h.refresh(true);
        }
    }

    protected final void handler_enable(int hid, boolean v) {
        IpeHandler h = this.getHandler(hid);
        if (h != null) {
            h.setEnabled(v);
        }
    }

    protected final void handler_count(int hid, int current, int limit) {
        IpeHandler h = this.getHandler(hid);
        if (h != null) {
            h.getEvent().setCount(current);
            h.getEvent().setCountLimit(limit, true);
        }
    }

    protected final void handler_list(int count, DbxHandler[] ha) {
    }

    public void debug(String program, long pid, String corefile) {
        if (program != null || pid != -1L || corefile != null) {
            String pidOrCore = "";
            if (corefile != null) {
                pidOrCore = corefile;
                this.previousCorefile = corefile;
            } else if (pid != -1L) {
                pidOrCore = Long.toString(pid);
            }
            String cmd = "debug " + (program != null ? program : "-") + " " + pidOrCore;
            if (this.captureState == 1) {
                this.stopUpdates();
                if (IpeUtils.isLinux()) {
                    this.prop_set("DBX_run_quick", "off");
                } else {
                    this.prop_set("DBX_run_quick", "on");
                }
            }
            this.sendCommand(0, 0, cmd);
        }
    }

    public void stopOnReturn(String function) {
        if (UsageTracking.enabled) {
            UsageTracking.sendAction((String)"Stop On Return", null);
        }
        this.sendCommand(RoutingToken.BREAKPOINTS.getAsInt(), 0, "stop returns " + function);
    }

    public void stopIn(String function) {
        if (this.ignoreBreakpoint) {
            return;
        }
        if (function == null) {
            return;
        }
        boolean wasRunning = this.state.isRunning();
        if (wasRunning) {
            this.interruptQuietly();
        }
        this.sendCommand(RoutingToken.BREAKPOINTS.getAsInt(), 0, "stop in " + function);
        if (wasRunning) {
            this.state.setRunning(false);
            this.go();
            this.state.setRunning(true);
        }
    }

    public void clearAt(String file, int startLine, int endLine) {
        if (this.ignoreBreakpoint) {
            return;
        }
        boolean wasRunning = this.state.isRunning();
        if (wasRunning) {
            this.interruptQuietly();
        }
        for (int line = startLine; line <= endLine; ++line) {
            this.sendCommand(RoutingToken.BREAKPOINTS.getAsInt(), 0, "clear \"" + file + "\":" + line);
        }
        if (wasRunning) {
            this.state.setRunning(false);
            this.go();
            this.state.setRunning(true);
        }
    }

    public void deleteHandler(int hid) {
        if (this.ignoreBreakpoint) {
            return;
        }
        boolean wasRunning = this.state.isRunning();
        if (wasRunning) {
            this.interruptQuietly();
        }
        this.sendCommand(0, 0, "delete " + hid);
        if (wasRunning) {
            this.state.setRunning(false);
            this.go();
            this.state.setRunning(true);
        }
    }

    public void createHandlerHelp(int routingToken, String cmd) {
        boolean wasRunning = this.state.isRunning();
        if (wasRunning) {
            this.interruptQuietly();
        }
        this.sendCommand(routingToken, 0, cmd);
        if (wasRunning) {
            this.state.setRunning(false);
            this.go();
            this.state.setRunning(true);
        }
    }

    public void createHandler(IpeBreakpointEvent event, int routingToken) {
        IpeHandler handler = event.getHandler();
        if (this.ignoreBreakpoint) {
            return;
        }
        if (UsageTracking.enabled) {
            UsageTracking.startTiming((String)"createbreakpoint");
        }
        this.stashBreakpoint(event);
        IpeHandler.createHandler(this, event, routingToken);
        if (UsageTracking.enabled) {
            UsageTracking.readTime((String)"createbreakpoint", (String)("Debugger: Create Breakpoint: " + event.getTypeDisplayName()), (boolean)true, null, (boolean)true);
        }
    }

    public void stepInto() {
        if (UsageTracking.enabled) {
            this.usageTrackingStep = this.state.isProcess() ? 2 : 1;
            UsageTracking.startTiming((String)"debuggerstep");
        }
        this.runProgram("step");
    }

    public void stepOver() {
        if (UsageTracking.enabled) {
            this.usageTrackingStep = this.state.isProcess() ? 4 : 3;
            UsageTracking.startTiming((String)"debuggerstep");
        }
        this.runProgram("next");
    }

    public void stepOut() {
        if (this.state.isProcess()) {
            if (UsageTracking.enabled) {
                this.usageTrackingStep = 5;
                UsageTracking.startTiming((String)"debuggerstep");
            }
            this.runProgram("step up");
        }
    }

    public void stepTo() {
        if (UsageTracking.enabled) {
            this.usageTrackingStep = this.state.isProcess() ? 7 : 6;
            UsageTracking.startTiming((String)"debuggerstep");
        }
        this.runProgram("step to");
    }

    public void go() {
        this.runProgram("cont");
    }

    public void goTo(String file, int line) {
        this.sendCommand(RoutingToken.BREAKPOINTS.getAsInt(), 0, "stop at \"" + file + "\":" + line + " -temp -hidden");
        this.runProgram("cont");
    }

    public void restart() {
        if (this.state.isProcess()) {
            this.terminate();
        }
        this.runProgram("run");
    }

    public void terminate() {
        if (this.state.isProcess()) {
            if (this.state.isRunning()) {
                this.interruptQuietly();
            }
            this.sendCommand(0, 0, "kill");
        }
        if (this.state.isCore() && this.warnOnlyOnce5) {
            Log.prf(1, "Do I need to workaround for bug 4187295?");
            this.warnOnlyOnce5 = false;
        }
    }

    public void detach() {
        if (this.state.isProcess()) {
            if (this.state.isRunning()) {
                this.interruptQuietly();
            }
            this.sendCommand(0, 0, "detach");
        }
    }

    public void quit() {
        if (this.state.isRunning()) {
            this.interruptQuietly();
        }
        this.sendCommand(0, 0, "quit");
    }

    public void reload() {
        if (this.state.isLoaded()) {
            if (this.state.isRunning()) {
                this.terminate();
            }
            if (this.state.isCore()) {
                this.proc_gone(null, 0);
            }
            this.sendCommand(0, 0, "debug -r $prog");
        }
    }

    public void applyEnvironment() {
        int i;
        int n;
        String[] envvars;
        if ((this.dirty & 2) != 0 && this.config.getRunDir() != null) {
            this.sendCommand(0, 0, "cd " + this.config.getRunDir());
        }
        if ((this.dirty & 1) != 0 && this.config.getUnparsedArgs() != null) {
            this.sendCommand(0, 0, "runargs " + this.config.getUnparsedArgs());
        }
        if ((this.dirty & 4) != 0 && this.config.getEnvVars() != null && (envvars = this.config.getEnvVars()) != null) {
            for (int i2 = 0; i2 < envvars.length; ++i2) {
                this.sendCommand(0, 0, "export " + envvars[i2].toString());
            }
        }
        if ((this.dirty & 0x100) != 0 && this.session.getJavaMode() != 0 && this.session.getJavaMode() != 0) {
            StringBuffer s = new StringBuffer(1000);
            this.ignoreClassPath = true;
            this.ignoreJavaSrcPath = true;
            s.append("export ");
            s.append("CLASSPATH");
            s.append('=');
            s.append('\"');
            s.append(NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.DEBUG).getClassPath());
            s.append('\"');
            this.sendCommand(0, 0, s.toString());
            this.sendCommand(0, 0, "export JAVASRCPATH=\"$CLASSPATH\"");
        }
        if ((this.dirty & 8) != 0) {
            // empty if block
        }
        if ((this.dirty & 0x10) != 0) {
            this.applyPathmap(this.pathmap, this.config.getPathmap());
        }
        if ((this.dirty & 0x80) != 0) {
            this.applyInterceptList(null, this.config.getInterceptList(), false);
            this.applyInterceptList(null, this.config.getInterceptExceptList(), true);
        }
        if ((this.dirty & 0x20) != 0) {
            ArrayList brkpts;
            if (DebuggingOption.SAVE_BREAKPOINTS.isEnabled() && (brkpts = this.config.getPendingBreakpoints()) != null) {
                n = brkpts.size();
                for (i = 0; i < n; ++i) {
                    String cmd = brkpts.get(i).toString();
                    int rt = RoutingToken.BREAKPOINTS.getAsInt();
                    this.sendCommand(rt, 0, cmd);
                }
                this.config.clearPendingBreakpoints();
            }
            this.debugger.absorbBreakpointsIntoConfig();
        }
        if ((this.dirty & 0x40) != 0) {
            ArrayList overrides = this.config.getSignalOverrides();
            n = 0;
            if (overrides != null) {
                n = overrides.size();
            }
            for (i = 0; i < n; ++i) {
                DbxSignalInfo dsi = (DbxSignalInfo)overrides.get(i);
                if (dsi.caught) {
                    this.sendCommand(0, 0, "catch " + dsi.signo);
                    continue;
                }
                this.sendCommand(0, 0, "ignore " + dsi.signo);
            }
        }
        this.notDirty();
    }

    private void applyPathmap(DbxPathMap[] oldMap, DbxPathMap[] pathmap) {
        int j;
        int i;
        if (oldMap != null) {
            for (i = 0; i < oldMap.length; ++i) {
                if (pathmap != null) {
                    for (j = 0; !(j >= pathmap.length || pathmap[j].from.equals(oldMap[i].from) && IpeUtils.sameString(pathmap[j].to, oldMap[i].to)); ++j) {
                    }
                    if (j < pathmap.length) continue;
                }
                this.sendCommand(0, 0, "pathmap -d " + oldMap[i].from);
            }
        }
        if (pathmap != null) {
            for (i = 0; i < pathmap.length; ++i) {
                if (oldMap != null) {
                    for (j = 0; !(j >= oldMap.length || pathmap[i].from.equals(oldMap[j].from) && IpeUtils.sameString(pathmap[i].to, oldMap[j].to)); ++j) {
                    }
                    if (j < oldMap.length) continue;
                }
                if (pathmap[i].to != null) {
                    this.sendCommand(0, 0, "pathmap " + pathmap[i].from + " " + pathmap[i].to);
                    continue;
                }
                this.sendCommand(0, 0, "pathmap " + pathmap[i].from);
            }
        }
        this.dirty &= 0xFFFFFFEF;
    }

    private void applyInterceptList(String[] oldNames, String[] newNames, boolean except) {
        int j;
        int i;
        if (oldNames != null) {
            for (i = 0; i < oldNames.length; ++i) {
                if (newNames != null) {
                    for (j = 0; j < newNames.length && !newNames[j].equals(oldNames[i]); ++j) {
                    }
                    if (j < newNames.length) continue;
                }
                if (except) {
                    this.sendCommand(0, 0, "unintercept -x " + oldNames[i]);
                    continue;
                }
                this.sendCommand(0, 0, "unintercept " + oldNames[i]);
            }
        }
        if (newNames != null) {
            for (i = 0; i < newNames.length; ++i) {
                if (oldNames != null) {
                    for (j = 0; j < oldNames.length && !newNames[i].equals(oldNames[j]); ++j) {
                    }
                    if (j < newNames.length) continue;
                }
                if (except) {
                    this.sendCommand(0, 0, "intercept -x " + newNames[i]);
                    continue;
                }
                this.sendCommand(0, 0, "intercept " + newNames[i]);
            }
        }
    }

    void applyConfigurationOptions() {
        if (!this.config.isDefaultAllowBreakDuringStep()) {
            this.config.setAllowBreakDuringStep(this.config.getAllowBreakDuringStep());
        }
        if (!this.config.isDefaultQuickMode()) {
            this.config.setQuickMode(this.config.getQuickMode());
        }
        if (!this.config.isDefaultExclusiveAttach()) {
            this.config.setExclusiveAttach(this.config.getExclusiveAttach());
        }
        if (!this.config.isDefaultTradeOffSpeedForResources()) {
            this.config.setTradeOffSpeedForResources(this.config.getTradeOffSpeedForResources());
        }
        if (!this.config.isDefaultShowFirstSourceFunc()) {
            this.config.setShowFirstSourceFunc(this.config.getShowFirstSourceFunc());
        }
        if (!this.config.isDefaultExecuteDestructors()) {
            this.config.setExecuteDestructors(this.config.getExecuteDestructors());
        }
        if (!this.config.isDefaultCheckFortranSubscripts()) {
            this.config.setCheckFortranSubscripts(this.config.getCheckFortranSubscripts());
        }
        if (!this.config.isDefaultInheritBreakpoints()) {
            this.config.setInheritBreakpoints(this.config.getInheritBreakpoints());
        }
        if (!this.config.isDefaultStepGranularity()) {
            this.config.setStepGranularity(this.config.getStepGranularity());
        }
        if (!this.config.isDefaultLanguage()) {
            this.config.setLanguage(this.config.getLanguage());
        }
        if (!this.config.isDefaultForkfollow()) {
            this.config.setForkfollow(this.config.getForkfollow());
        }
    }

    private void runProgram(String cmd) {
        this.lastRunCmd = cmd;
        statusDisplayer.setStatusText(DbxDebugger.getText("Running"));
        this.deleteMarkLocations();
        if (!this.state.isRunning()) {
            if (this.deliverSignal != -1 && (cmd.equals("cont") || cmd.startsWith("step") || cmd.equals("next"))) {
                cmd = cmd + " -sig " + this.deliverSignal;
                this.deliverSignal = -1;
            }
            this.sendCommand(0, 0, cmd);
        }
    }

    public void interrupt() {
        if (this.state.isRunning() && this.state.isProcess()) {
            try {
                this.proc.killgrp(2);
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Sending kill signal to process group failed");
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public void interruptQuietly() {
        if (this.state.isRunning() && this.state.isProcess()) {
            try {
                this.proc.sigqueue(3, 2);
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Sending kill signal to process group failed");
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public void gotoFrame(int guiIndex) {
        if (!this.state.isRunning() && this.state.isProcess()) {
            if (this.stackMap == null) {
                ErrorManager.getDefault().log("gotoFrame() -- null stackMap");
                return;
            }
            if (guiIndex < 0 || guiIndex > this.stackMap.length) {
                ErrorManager.getDefault().log("gotoFrame(" + guiIndex + ") out of range: [" + 0 + "-" + this.stackMap.length + "]");
                return;
            }
            int dbxFrame = this.stackMap[guiIndex];
            if (dbxFrame <= 0) {
                if (dbxFrame == -2) {
                    // empty if block
                }
                return;
            }
            String cmd = "frame " + dbxFrame;
            this.sendCommand(0, 0, cmd);
        }
    }

    public void upStack() {
        if (!this.state.isRunning() && this.state.isProcess()) {
            this.sendCommand(0, 0, "up");
        }
    }

    public void downStack() {
        if (!this.state.isRunning() && this.state.isProcess()) {
            this.sendCommand(0, 0, "down");
        }
    }

    public void pop() {
        if (!this.state.isRunning() && this.state.isProcess()) {
            this.sendCommand(0, 0, "pop");
        }
    }

    public void pop2cur() {
        if (!this.state.isRunning() && this.state.isProcess()) {
            this.sendCommand(0, 0, "pop -f $(builtin frame)");
        }
    }

    public void pop2frame(int frame) {
        if (UsageTracking.enabled) {
            UsageTracking.sendAction((String)"Pop To Frame", null);
        }
        if (!this.state.isRunning() && this.state.isProcess()) {
            this.sendCommand(0, 0, "pop -f " + frame);
        }
    }

    public void popFromCall() {
        if (!this.state.isRunning() && this.state.isProcess()) {
            this.sendCommand(0, 0, "pop -c");
        }
    }

    public void selectThread(int tid) {
        this.sendCommand(0, 0, "thread t@" + tid);
        if (UsageTracking.enabled) {
            UsageTracking.sendAction((String)"Set Thread Context", null);
        }
    }

    public void suspendThread(int tid) {
        this.sendCommand(0, 0, "thread -suspend t@" + tid);
        if (UsageTracking.enabled) {
            UsageTracking.sendAction((String)"Suspend Thread", null);
        }
    }

    public void resumeThread(int tid) {
        this.sendCommand(0, 0, "thread -resume t@" + tid);
        if (UsageTracking.enabled) {
            UsageTracking.sendAction((String)"Resume Thread", null);
        }
    }

    public void selectStackFrame(int frameno) {
        this.sendCommand(0, 0, "frame " + frameno);
        if (UsageTracking.enabled) {
            UsageTracking.sendAction((String)"Set Stack Frame", null);
        }
    }

    public void sendStackUpdates(boolean enable) {
        int max_frames = 40;
        this.stack_notify(0, enable && !this.stackMasked, max_frames, 0);
        if (enable && this.state.isRunning()) {
            statusDisplayer.setStatusText(DbxDebugger.getText("NoStackWhileRunning"));
        }
    }

    public void sendAccessUpdates(boolean enable) {
        this.rtc_notify(0, enable);
        if (enable && this.state.isRunning()) {
            statusDisplayer.setStatusText(DbxDebugger.getText("NoRTCWhileRunning"));
        }
    }

    public void sendMemuseUpdates(boolean enable) {
        this.mprof_notify(0, enable);
        if (enable && this.state.isRunning()) {
            statusDisplayer.setStatusText(DbxDebugger.getText("NoRTCWhileRunning"));
        }
    }

    public final void sendThreadUpdates(boolean enable) {
        this.threads_notify(0, enable && !this.threadsMasked, 0);
        if (enable && this.state.isRunning()) {
            statusDisplayer.setStatusText(DbxDebugger.getText("NoThreadsWhileRunning"));
        }
    }

    public final void sendDisplayUpdates(boolean enable) {
        this.display_notify(0, true);
        if (enable && this.state.isRunning()) {
            statusDisplayer.setStatusText(DbxDebugger.getText("NoDisplayWhileRunning"));
        }
    }

    public final void sendCollectorUpdates(boolean enable) {
        this.perf_notify(0, enable);
        if (enable && this.state.isRunning()) {
            statusDisplayer.setStatusText(DbxDebugger.getText("NoCollectorWhileRunning"));
        }
    }

    public final void sendLocalVarUpdates(boolean enable) {
        this.locals_notify(0, enable && !this.localsMasked);
        if (enable && this.state.isRunning()) {
            statusDisplayer.setStatusText(DbxDebugger.getText("NoLocalsWhileRunning"));
        }
    }

    public ImageLabel getStateDesc() {
        ImageIcon icon;
        String desc;
        if (this.summary != null && this.lastStateHash == this.state.getHashCode()) {
            return this.summary;
        }
        if (this.state.isRunning()) {
            desc = DbxDebugger.getText("Dbx_State_Running");
            icon = this.getRunningIcon();
        } else if (this.state.isCore()) {
            desc = DbxDebugger.getText("Dbx_State_Core");
            icon = this.getCoreIcon();
        } else if (this.state.isProcess()) {
            desc = DbxDebugger.getText("Dbx_State_Stopped");
            icon = this.getStoppedIcon();
        } else if (this.state.isTerminated()) {
            desc = DbxDebugger.getText("Dbx_State_Done");
            icon = this.getTerminatedIcon();
        } else if (this.state.isLoaded()) {
            desc = DbxDebugger.getText("Dbx_State_Loaded");
            icon = this.getLoadedIcon();
        } else {
            desc = DbxDebugger.getText("Dbx_State_Empty");
            icon = this.getEmptyIcon();
        }
        this.summary = new ImageLabel(desc, icon);
        this.lastStateHash = this.state.getHashCode();
        return this.summary;
    }

    private final ImageIcon getRunningIcon() {
        if (this.runningIcon == null) {
            this.runningIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$Dbx == null ? (class$com$sun$tools$debugger$dbxgui$debugger$Dbx = Dbx.class$("com.sun.tools.debugger.dbxgui.debugger.Dbx")) : class$com$sun$tools$debugger$dbxgui$debugger$Dbx).getResource("/com/sun/tools/debugger/dbxgui/icons/running.gif"));
        }
        return this.runningIcon;
    }

    private final ImageIcon getCoreIcon() {
        if (this.coreIcon == null) {
            this.coreIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$Dbx == null ? (class$com$sun$tools$debugger$dbxgui$debugger$Dbx = Dbx.class$("com.sun.tools.debugger.dbxgui.debugger.Dbx")) : class$com$sun$tools$debugger$dbxgui$debugger$Dbx).getResource("/com/sun/tools/debugger/dbxgui/icons/core.gif"));
        }
        return this.coreIcon;
    }

    private final ImageIcon getStoppedIcon() {
        if (this.stoppedIcon == null) {
            this.stoppedIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$Dbx == null ? (class$com$sun$tools$debugger$dbxgui$debugger$Dbx = Dbx.class$("com.sun.tools.debugger.dbxgui.debugger.Dbx")) : class$com$sun$tools$debugger$dbxgui$debugger$Dbx).getResource("/com/sun/tools/debugger/dbxgui/icons/stopped.gif"));
        }
        return this.stoppedIcon;
    }

    private final ImageIcon getTerminatedIcon() {
        if (this.terminatedIcon == null) {
            this.terminatedIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$Dbx == null ? (class$com$sun$tools$debugger$dbxgui$debugger$Dbx = Dbx.class$("com.sun.tools.debugger.dbxgui.debugger.Dbx")) : class$com$sun$tools$debugger$dbxgui$debugger$Dbx).getResource("/com/sun/tools/debugger/dbxgui/icons/terminated.gif"));
        }
        return this.terminatedIcon;
    }

    private final ImageIcon getLoadedIcon() {
        if (this.loadedIcon == null) {
            this.loadedIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$Dbx == null ? (class$com$sun$tools$debugger$dbxgui$debugger$Dbx = Dbx.class$("com.sun.tools.debugger.dbxgui.debugger.Dbx")) : class$com$sun$tools$debugger$dbxgui$debugger$Dbx).getResource("/com/sun/tools/debugger/dbxgui/icons/loaded.gif"));
        }
        return this.loadedIcon;
    }

    private final ImageIcon getEmptyIcon() {
        if (this.emptyIcon == null) {
            this.emptyIcon = new ImageIcon((class$com$sun$tools$debugger$dbxgui$debugger$Dbx == null ? (class$com$sun$tools$debugger$dbxgui$debugger$Dbx = Dbx.class$("com.sun.tools.debugger.dbxgui.debugger.Dbx")) : class$com$sun$tools$debugger$dbxgui$debugger$Dbx).getResource("/com/sun/tools/debugger/dbxgui/icons/empty.gif"));
        }
        return this.emptyIcon;
    }

    public void evaluate(RoutingToken rt, String expr) {
        this.expr_heval(rt.getAsInt(), expr);
    }

    public void assign(String lhs, String rhs) {
        int cookie = RoutingToken.WATCH.getAsInt();
        this.expr_set(cookie, lhs, rhs);
    }

    public void typeof(String expr) {
        this.expr_type(0, expr);
    }

    public void addWatch(String expr, RoutingToken routingToken) {
        this.sendCommand(routingToken.getAsInt(), 0, "display -r " + expr);
    }

    public void removeWatch(int id) {
        boolean routingToken = false;
        this.sendCommand(RoutingToken.WATCH.getAsInt(), 0, "undisplay " + id);
    }

    public DbxDebuggerState getState() {
        return this.state;
    }

    void setCaptureState(int captureState) {
        this.captureState = captureState;
    }

    int captureState() {
        return this.captureState;
    }

    void setCaptureInfo(CaptureInfo captureInfo) {
        this.captureInfo = captureInfo;
    }

    public final void setCollectorEnabled(boolean enabled, boolean allruns) {
        if (enabled) {
            if (allruns) {
                this.sendCommand(0, 0, "collector enable");
            } else {
                this.sendCommand(0, 0, "collector enable");
            }
        } else {
            this.sendCommand(0, 0, "collector disable");
        }
    }

    public final void setPauseCollector(boolean pause) {
        if (pause) {
            this.sendCommand(0, 0, "collector pause");
        } else {
            this.sendCommand(0, 0, "collector resume");
        }
    }

    public final void setCollectorGroupFile(String gname) {
        if (gname != null && !gname.equals("")) {
            this.sendCommand(0, 0, "collector store group " + gname);
        }
    }

    public final void setCollectorStoreLocation(String dir, String file) {
        if (dir != null) {
            this.sendCommand(0, 0, "collector store directory " + dir);
        }
        if (file != null) {
            this.sendCommand(0, 0, "collector store filename " + file);
        }
    }

    public final void setCollectorExpSizeLimit(String limit) {
        this.sendCommand(0, 0, "collector limit " + limit);
    }

    public final void setdbxsampleToggle(boolean enable) {
        this.sendCommand(0, 0, "collector dbxsample " + (enable ? "on" : "off"));
    }

    public final void setCollectorProfiling(boolean enable) {
        this.sendCommand(0, 0, "collector profile " + (enable ? "on" : "off"));
    }

    public final void setProfileTimerPeriod(int period) {
        this.sendCommand(0, 0, "collector profile timer " + period);
    }

    public final void setProfileTimerPeriod(String period) {
        this.sendCommand(0, 0, "collector profile timer " + period);
    }

    public final void setSyncTrace(boolean enable) {
        this.sendCommand(0, 0, "collector synctrace " + (enable ? "on" : "off"));
    }

    public final void calibrateSyncTrace() {
        this.sendCommand(0, 0, "collector synctrace threshold calibrate");
    }

    public final void setSynctraceThreshold(int threshold) {
        this.sendCommand(0, 0, "collector synctrace threshold " + threshold);
    }

    public final void setSynctraceThreshold(String threshold) {
        this.sendCommand(0, 0, "collector synctrace threshold " + threshold);
    }

    public final void setHardwareProfiling(boolean enabled) {
        this.sendCommand(0, 0, "collector hwprofile " + (enabled ? "on" : "off"));
    }

    public final void setHardwareCounter(String hwc) {
        this.sendCommand(0, 0, "collector hwprofile counter " + hwc);
    }

    public final void toggleHeapTrace(boolean enabled) {
        this.sendCommand(0, 0, "collector heaptrace " + (enabled ? "on" : "off"));
    }

    public final void showHWCList(String str) {
        this.sendCommand(0, 0, "collector hwprofile " + str);
    }

    public final String getHWCList() {
        GStr result = null;
        if (this.state.isLoaded() && !this.state.isRunning()) {
            result = new GStr();
            this.ksh_scmd(0, 0, result, "collector hwprofile list ");
        }
        return result != null ? result.value() : null;
    }

    public final boolean isRtcAvailable() {
        return this.rtcAvailable;
    }

    public final boolean isFixAvailable() {
        return !IpeUtils.isLinux();
    }

    public final boolean isCollAvailable() {
        return this.collAvailable;
    }

    public final boolean isCollExptOpen() {
        GStr result = null;
        if (this.state.isLoaded() && !this.state.isRunning()) {
            result = new GStr();
            this.ksh_scmd(0, 0, result, "collector status ");
        }
        return result != null ? !result.value().equals("No opened experiment\n") : false;
    }

    public final void toggleMpiTrace(boolean enabled) {
        this.sendCommand(0, 0, "collector mpitrace " + (enabled ? "on" : "off"));
    }

    public final void toggleFollowDescProcesses(boolean enabled) {
        this.sendCommand(0, 0, "collector follow " + (enabled ? "on" : "off"));
    }

    public final void collectAddressSpace(boolean enabled) {
        this.sendCommand(0, 0, "collector address_space " + (enabled ? "on" : "off"));
    }

    public final void setManualSampling(boolean manual) {
        this.sendCommand(0, 0, "collector sample " + (manual ? "manual" : "periodic"));
    }

    public final void setArchiveExp(String str) {
        this.sendCommand(0, 0, "collector archive " + str);
    }

    public final void recordManualSample(String str) {
        this.sendCommand(0, 0, "collector sample record " + str);
    }

    public final void setSamplePeriod(int period) {
        this.sendCommand(0, 0, "collector sample period " + period);
    }

    public final void setSamplePeriod(String period) {
        this.sendCommand(0, 0, "collector sample period " + period);
    }

    public void addStackListener(PropertyChangeListener l) {
        if (l == null) {
            System.err.println("Dbx.addStackListener: Adding null listener");
        }
        this.stackpcs.addPropertyChangeListener(l);
        ++this.stackListenerCount;
        if (this.stackListenerCount == 1) {
            this.sendStackUpdates(true);
        }
    }

    public void removeStackListener(PropertyChangeListener l) {
        this.stackpcs.removePropertyChangeListener(l);
        --this.stackListenerCount;
        if (this.stackListenerCount == 0) {
            this.sendStackUpdates(false);
        }
    }

    public boolean hasStackListeners() {
        return this.stackListenerCount != 0;
    }

    private void stackUpdated() {
        try {
            this.stackpcs.firePropertyChange("stack-changed", null, this);
        }
        catch (NullPointerException ex) {
            System.err.println("Dbx.stackUpdated: NPE");
        }
    }

    private void stackSelectionUpdated() {
        this.stackpcs.firePropertyChange("sframe-changed", null, this);
    }

    public void addLocalVarListener(PropertyChangeListener l) {
        this.localVarpcs.addPropertyChangeListener(l);
        ++this.localVarListenerCount;
        if (this.localVarListenerCount == 1) {
            this.sendLocalVarUpdates(false);
        }
    }

    public void removeLocalVarListener(PropertyChangeListener l) {
        this.localVarpcs.removePropertyChangeListener(l);
        --this.localVarListenerCount;
        if (this.localVarListenerCount == 0) {
            this.sendLocalVarUpdates(false);
        }
    }

    public boolean hasLocalVarListeners() {
        return this.localVarListenerCount != 0;
    }

    public void localVarsUpdated() {
        IpeThread currentThread = (IpeThread)this.debugger.getCurrentThread();
        this.debugger.refreshThread(currentThread);
    }

    public DbxLocalItem[] getLocalVars() {
        return this.localVars;
    }

    public int getNumLocalVars() {
        return this.numLocalVars;
    }

    protected void locals(int nitems, DbxLocalItem[] items) {
        Log.prfa(1, "" + nitems);
        for (int i = 0; i < nitems; ++i) {
            Log.pr(1, "Local " + i + ": " + items[i]);
        }
        this.localVars = items;
        this.numLocalVars = nitems;
        this.localVarsUpdated();
    }

    public void addThreadsListener(PropertyChangeListener l) {
        this.threadspcs.addPropertyChangeListener(l);
        ++this.threadsListenerCount;
        if (this.threadsListenerCount == 1) {
            this.sendThreadUpdates(true);
        }
    }

    public void removeThreadsListener(PropertyChangeListener l) {
        this.threadspcs.removePropertyChangeListener(l);
        --this.threadsListenerCount;
        if (this.threadsListenerCount == 0) {
            this.sendThreadUpdates(false);
        }
    }

    public boolean hasThreadsListeners() {
        return this.threadsListenerCount != 0;
    }

    public void threadsUpdated() {
        this.threadspcs.firePropertyChange("threads-changed", null, this);
    }

    public DbxDebugSession getSession() {
        return this.session;
    }

    public void setStackVerbosity(int flags) {
        System.out.println("Dbx.setStackVerbosity(" + flags + ")");
        if ((flags & 1) != 0 || (flags & 2) != 0) {
            this.prop_set("DBX_stack_verbose", "on");
        } else {
            this.prop_set("DBX_stack_verbose", "off");
        }
    }

    public void addMemuseListener(PropertyChangeListener l) {
        this.memusepcs.addPropertyChangeListener(l);
    }

    public void removeMemuseListener(PropertyChangeListener l) {
        this.memusepcs.removePropertyChangeListener(l);
    }

    public void addAccessListener(PropertyChangeListener l) {
        this.accesspcs.addPropertyChangeListener(l);
    }

    public void removeAccessListener(PropertyChangeListener l) {
        this.accesspcs.removePropertyChangeListener(l);
    }

    public void setMemuseChecking(boolean enable) {
        if (enable) {
            this.sendCommand(0, 0, "check -memuse");
        } else {
            this.sendCommand(0, 0, "uncheck -memuse");
        }
    }

    public void setLeaksChecking(boolean enable) {
        if (enable) {
            this.sendCommand(0, 0, "check -leaks");
        } else {
            this.sendCommand(0, 0, "uncheck -leaks");
        }
    }

    public void setAccessChecking(boolean enable) {
        if (enable) {
            this.sendCommand(0, 0, "check -access");
        } else {
            this.sendCommand(0, 0, "uncheck -access");
        }
    }

    public void disableChecking() {
        this.sendCommand(0, 0, "uncheck -all");
    }

    public void suppressLastError() {
        this.sendCommand(0, 0, "suppress -last");
    }

    public void showLeaks(boolean all, boolean detailed) {
        this.sendCommand(0, 0, "showleaks" + (all ? " -a" : "") + (detailed ? " -v" : ""));
    }

    public void showBlocks(boolean all, boolean detailed) {
        this.sendCommand(0, 0, "showmemuse" + (all ? " -a" : "") + (detailed ? " -v" : ""));
    }

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        this.term = (UnixTerm)term;
    }

    public Term getPioTerm() {
        return this.pioTerm;
    }

    public void setPioTerm(Term term) {
        this.pioTerm = term;
    }

    public UnixPty getPioPty() {
        return this.pioPty;
    }

    public UnixPty getDbxPty() {
        return this.dbxPty;
    }

    public void setAccessTerm(ActiveTerm term) {
        this.accessTerm = term;
    }

    public void setupTerm(ActiveTerm atTerm, boolean rdonly) {
        if (atTerm != null) {
            this.debugger.setupTerm((Term)atTerm, rdonly);
            atTerm.setAnchored(true);
        }
    }

    public void setupTerm(ActiveTerm atTerm) {
        this.setupTerm(atTerm, false);
    }

    public ActiveTerm getAccessTerm() {
        return this.accessTerm;
    }

    public void setLeaksTerm(ActiveTerm term) {
        this.leaksTerm = term;
    }

    public ActiveTerm getLeaksTerm() {
        return this.leaksTerm;
    }

    public void setBlocksTerm(ActiveTerm term) {
        this.blocksTerm = term;
    }

    public ActiveTerm getBlocksTerm() {
        return this.blocksTerm;
    }

    public void setOption(String name, String value) {
        if ("DBX_run_io".equals(name) && "window".equals(value)) {
            value = "pty";
            this.prop_set("DBX_run_pty", this.pioPty.getSlaveName());
        } else if ("DBX_run_pty".equals(name) && DebuggingOption.RUN_IO.getCurrValue().equals("window")) {
            value = this.pioPty.getSlaveName();
        }
        this.prop_set(name, value);
    }

    void handleBadCore(String explanation, boolean canForce) {
        Object[] options;
        JButton def;
        JButton forceButton = new JButton();
        Actions.setMenuText((AbstractButton)forceButton, (String)DbxDebugger.getText("CoreLoadAnyway"), (boolean)true);
        JButton selectButton = new JButton();
        Actions.setMenuText((AbstractButton)selectButton, (String)DbxDebugger.getText("CoreSelect"), (boolean)true);
        if (canForce) {
            def = forceButton;
            options = new JButton[]{forceButton, selectButton};
        } else {
            def = selectButton;
            options = new JButton[]{selectButton};
        }
        DialogDescriptor dlg = new DialogDescriptor((Object)explanation, DbxDebugger.getText("CorefileError"), true, options, (Object)def, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dlg.setMessageType(0);
        dialog.show();
        Object pressedButton = dlg.getValue();
        if (pressedButton == forceButton) {
            this.askToAttachCorefile(0, this.session, null, true);
        }
    }

    boolean switchConfig(RunConfig newConfig) {
        if (newConfig == this.config) {
            return false;
        }
        RunConfig oldConfig = this.config;
        if (this.config != null) {
            this.deleteMarkLocations();
            this.config.removePropertyChangeListener(this);
        }
        this.config = newConfig;
        this.debugger.setConfig(this.config);
        if (newConfig != null) {
            this.config.addPropertyChangeListener(this);
        }
        return true;
    }

    void switchSession(DbxDebugSession newSession) {
        if (this.session == newSession) {
            return;
        }
        DbxDebugSession oldSession = this.session;
        if (this.session != null) {
            this.deleteMarkLocations();
            this.session = null;
        }
        if (this.config != null) {
            this.config.removePropertyChangeListener(this);
        }
        this.session = newSession;
        if (newSession != null) {
            this.session.setEngine(this);
            this.config = this.session.getConfig();
            this.config.addPropertyChangeListener(this);
        } else {
            this.config = null;
        }
        if (oldSession != null) {
            oldSession.setEngine(null);
        }
    }

    void askToAttachCorefile(int cookie, DbxDebugSession s, String corefileName, boolean force) {
        if (corefileName == null) {
            corefileName = this.previousCorefile;
            if (corefileName == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DbxDebugger.getText("MSG_CorefileUnknown")));
                return;
            }
        } else {
            this.previousCorefile = corefileName;
        }
        this.switchSession(s);
        this.session.setCorefile(corefileName);
        this.state.setCore(true);
        this.state.setTerminated(true);
        DbxDebugProgram program = this.config.getProgram();
        String progName = program.getExecutableName() != null ? program.getExecutableName() : "-";
        this.sendCommand(cookie, 0, "debug " + (force ? "-f " : "") + progName + " " + corefileName);
    }

    public void sourceModified() {
        JButton ignoreButton = new JButton();
        Actions.setMenuText((AbstractButton)ignoreButton, (String)DbxDebugger.getText("SourceOODIgnore"), (boolean)true);
        JButton fixButton = new JButton();
        Actions.setMenuText((AbstractButton)fixButton, (String)DbxDebugger.getText("SourceOODFix"), (boolean)true);
        ignoreButton.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_SourceOODIgnore"));
        fixButton.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_SourceOODFix"));
        DialogDescriptor dlg = new DialogDescriptor((Object)DbxDebugger.getText("SourceOODMesg"), DbxDebugger.getText("SourceOODTitle"), true, (Object[])new JButton[]{ignoreButton, fixButton}, (Object)ignoreButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dlg.setMessageType(2);
        dlg.setClosingOptions(null);
        dialog.show();
        Object pressedButton = dlg.getValue();
        if (pressedButton == fixButton) {
            this.askForFix(0, null);
        }
    }

    private void askForFix(int cookie, String fname) {
        this.fix(cookie, fname);
    }

    public void fix(int cookie, String fname) {
        if (fname == null) {
            this.sendCommand(cookie, 0, "fix -a");
        } else {
            int sep = fname.lastIndexOf(File.separatorChar);
            if (sep != -1) {
                fname = fname.substring(sep + 1);
            }
            this.sendCommand(cookie, 0, "fix " + fname);
        }
    }

    public void runFailed() {
        if (this.state.isRunning()) {
            statusDisplayer.setStatusText(DbxDebugger.getText("RunFailed"));
            this.state.setRunning(false);
            this.debugger.updateState(this);
        }
        this.debugger.enableStoppedActions(this);
    }

    private void showSignalPopup(String description) {
        String signame = "?";
        String signum = "?";
        String usercodename = "?";
        String usercodenum = "?";
        String senderpid = "?";
        StringTokenizer st = new StringTokenizer(description);
        String dummy = st.nextToken();
        signum = st.nextToken();
        signame = st.nextToken();
        dummy = st.nextToken();
        usercodenum = st.nextToken();
        usercodename = st.nextToken();
        dummy = st.nextToken();
        senderpid = st.nextToken();
        SignalDialog sd = new SignalDialog();
        String fmt = DbxDebugger.getText("FMT_SignalInfo");
        String signalInfo = MessageFormat.format(fmt, signame, signum, usercodename, usercodenum);
        sd.setSignalInfo(signalInfo);
        sd.setSenderInfo(senderpid);
        String sessionName = this.session == null ? "" : this.session.getShortName();
        sd.setReceiverInfo(sessionName, this.session == null ? 0L : this.session.getPid());
        DbxSignalInfoInit dsii = null;
        int signo = 0;
        try {
            signo = Integer.parseInt(signum);
            DbxSignalInfoInit[] signals = this.config.getSignals();
            dsii = signals[signo];
        }
        catch (Exception x) {
            // empty catch block
        }
        boolean wasIgnored = false;
        if (dsii != null) {
            wasIgnored = !dsii.caught;
            sd.setIgnore(true, wasIgnored);
        } else {
            sd.setIgnore(false, false);
        }
        sd.show();
        if (dsii != null && sd.isIgnore() != wasIgnored) {
            if (sd.isIgnore()) {
                this.sendCommand(0, 0, "ignore " + dsii.signo);
            } else {
                this.sendCommand(0, 0, "catch " + dsii.signo);
            }
        }
        this.signalDiscarded = sd.discardSignal();
        this.deliverSignal = this.signalDiscarded ? -1 : signo;
        if (sd.shouldContinue()) {
            this.go();
        }
    }

    public void explainStop(int nevents, DbxEventRecord[] events) {
        boolean builtin;
        String desc;
        if (nevents == 0) {
            return;
        }
        String stateMsg = desc = events[0].description;
        if ("stepped".equals(desc)) {
            stateMsg = null;
        } else if ("function returned".equals(desc)) {
            stateMsg = DbxDebugger.getText("Dbx_function_returned");
        } else if (desc.startsWith("throw unhandled ")) {
            stateMsg = DbxDebugger.getText("Dbx_throw_unhandled") + desc.substring(15);
        } else if (desc.startsWith("throw unexpected ")) {
            stateMsg = DbxDebugger.getText("Dbx_throw_unexpected") + desc.substring(16);
        } else if (desc.startsWith("throw caught ")) {
            stateMsg = DbxDebugger.getText("Dbx_throw_caught") + desc.substring(12);
        } else if (desc.startsWith("signal ")) {
            stateMsg = DbxDebugger.getText("Dbx_signal") + desc.substring(6);
        }
        if (stateMsg != null) {
            statusDisplayer.setStatusText(stateMsg);
        }
        if ((builtin = "builtin".equals(events[0].origin)) && events[0].description.startsWith("signal ")) {
            if (this.getPioTerm() != null || !events[0].description.startsWith("signal 2 SIGINT")) {
                this.showSignalPopup(stateMsg);
            }
        } else if (builtin && (events[0].description.startsWith("throw unhandled ") || events[0].description.startsWith("throw unexpected "))) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)events[0].description));
        }
    }

    private void deleteMarkLocations() {
        this.startLoc = null;
        this.visitLoc = null;
        this.currentLoc = null;
    }

    public void addDbxBusyListener(PropertyChangeListener l) {
        this.dbxBusypcs.addPropertyChangeListener(l);
    }

    public void removeDbxBusyListener(PropertyChangeListener l) {
        this.dbxBusypcs.removePropertyChangeListener(l);
    }

    public void dbxBusyChanged() {
        this.dbxBusypcs.firePropertyChange(PROP_DBXBUSY_CHANGED, null, this);
    }

    public void balloonEvaluate(int pos, String expr, Object result) {
        if (DebuggingOption.BALLOON_EVAL.isEnabled()) {
            this.balloonResult = result;
            this.expr_line_eval(0, 0, expr, pos, null, 0, 3);
        }
    }

    public void setStartupBehavior(int newBehavior) {
        this.startupBehavior = newBehavior;
    }

    public void execute(String cmd) {
        this.sendCommand(0, 0, cmd);
    }

    public void setHandlerCountLimit(int hid, long countLimit) {
        this.sendCommand(0, 0, "handler -count " + hid + " " + (countLimit == -1L ? "infinity" : Long.toString(countLimit)));
    }

    public void resetHandlerCount(int hid) {
        this.sendCommand(0, 0, "handler -reset " + hid);
    }

    public void setHandlerEnabled(int hid, boolean enable) {
        if (enable) {
            this.sendCommand(0, 0, "handler -enable " + hid);
        } else {
            this.sendCommand(0, 0, "handler -disable " + hid);
        }
    }

    public void deleteHandlers(int[] hids) {
        StringBuffer sb = new StringBuffer(20);
        sb.append("delete ");
        sb.append(Integer.toString(hids[0]));
        for (int i = 1; i < hids.length; ++i) {
            sb.append(' ');
            sb.append(Integer.toString(hids[i]));
        }
        this.sendCommand(0, 0, sb.toString());
    }

    public String getCurrentFunction() {
        int n;
        String func = null;
        if (this.visitLoc != null && this.visitLoc.func != null) {
            func = this.visitLoc.func;
        } else if (this.currentLoc != null && this.currentLoc.func != null) {
            func = this.currentLoc.func;
        } else if (this.startLoc != null && this.startLoc.func != null) {
            func = this.startLoc.func;
        }
        if (func != null && (n = func.indexOf(40)) != -1) {
            return func.substring(0, n);
        }
        return func;
    }

    public String getCurrentClass() {
        if (this.state.isLoaded() && !this.state.isRunning()) {
            GStr result = new GStr();
            this.ksh_scmd(0, 0, result, "kprint $vclass");
            String c = result.value();
            if (c.charAt(c.length() - 1) == '\n') {
                c = c.substring(0, c.length() - 1);
            }
            if (c.length() == 0) {
                return null;
            }
            return c;
        }
        return null;
    }

    public static void addStartupCommand(String cmd) {
        if (startupCommands == null) {
            startupCommands = new ArrayList(5);
        }
        startupCommands.add(cmd);
    }

    public void addDebuggerEventListener(PropertyChangeListener l) {
        if (this.debuggerEventpcs == null) {
            this.debuggerEventpcs = new PropertyChangeSupport(this);
        }
        this.debuggerEventpcs.addPropertyChangeListener(l);
    }

    public void removeDebuggerEventListener(PropertyChangeListener l) {
        this.debuggerEventpcs.removePropertyChangeListener(l);
    }

    public void addDebuggerImpEventListener(PropertyChangeListener l) {
        if (this.debuggerImpEventpcs == null) {
            this.debuggerImpEventpcs = new PropertyChangeSupport(this);
        }
        this.debuggerImpEventpcs.addPropertyChangeListener(l);
    }

    public void removeDebuggerImpEventListener(PropertyChangeListener l) {
        this.debuggerImpEventpcs.removePropertyChangeListener(l);
    }

    public void impStateChanged() {
        if (this.debuggerImpEventpcs != null) {
            if (this.state.isRunning() == this.lastRunning) {
                return;
            }
            this.lastRunning = !this.lastRunning;
            this.debuggerImpEventpcs.firePropertyChange(PROP_DBXSTATE, null, this.state);
        }
    }

    protected void signal_list(int count, DbxSignalInfoInit[] initial_signal_list) {
        this.ignoreConfigChange = true;
        this.config.setSignals(initial_signal_list);
        this.ignoreConfigChange = false;
    }

    protected void signal_list_state(DbxSignalInfo updated_signal) {
        this.ignoreConfigChange = true;
        this.config.setSignalState(updated_signal);
        this.ignoreConfigChange = false;
    }

    protected void pathmap_list(int count, DbxPathMap[] updated_pathmap) {
        int source = 0;
        if (updated_pathmap[0].from.equals("/tmp_mnt")) {
            ++source;
            --count;
        }
        this.pathmap = new DbxPathMap[count];
        for (int i = 0; i < count; ++i) {
            this.pathmap[i] = updated_pathmap[source++];
        }
        if (!this.dbxInitializing) {
            this.ignoreConfigChange = true;
            this.config.setPathmap(this.pathmap);
            this.dirty &= 0xFFFFFFEF;
            this.ignoreConfigChange = false;
        }
    }

    protected void intercept_list(boolean unhandled, boolean unexpected, int count, String[] typenames) {
        String[] newnames = new String[count];
        for (int i = 0; i < count; ++i) {
            newnames[i] = typenames[i];
        }
        this.ignoreConfigChange = true;
        this.config.setInterceptList(newnames, unhandled, unexpected);
        this.ignoreConfigChange = false;
    }

    protected void intercept_except_list(int count, String[] typenames) {
        String[] newnames = new String[count];
        for (int i = 0; i < count; ++i) {
            newnames[i] = typenames[i];
        }
        this.ignoreConfigChange = true;
        this.config.setInterceptExceptList(newnames);
        this.ignoreConfigChange = false;
    }

    public void notDirty() {
        this.dirty = 0;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.ignoreConfigChange) {
            return;
        }
        String name = evt.getPropertyName();
        if ("runargs-ch" == name) {
            this.dirty |= 1;
        } else if ("rundir-ch" == name) {
            this.dirty |= 2;
        } else if ("envvars-ch" == name) {
            this.dirty |= 4;
        } else if ("pathmap-ch" == name) {
            DbxPathMap[] oldMap = (DbxPathMap[])evt.getOldValue();
            DbxPathMap[] newMap = (DbxPathMap[])evt.getNewValue();
            this.applyPathmap(oldMap, newMap);
        } else if ("signals-ch" == name) {
            ErrorManager.getDefault().log("Dbx.propertyChange(" + name + "): ignore??");
        } else if ("option-ch" == name) {
            String dbxenv = (String)evt.getOldValue();
            String value = (String)evt.getNewValue();
            this.sendCommand(0, 0, "dbxenv " + dbxenv + " " + value);
        } else if ("signal-ch" == name) {
            Integer signal = (Integer)evt.getOldValue();
            Boolean ignore = (Boolean)evt.getNewValue();
            if (ignore.booleanValue()) {
                this.sendCommand(0, 0, "ignore " + signal);
            } else {
                this.sendCommand(0, 0, "catch " + signal);
            }
        } else if ("intrcpt-ch" == name) {
            String[] oldNames = (String[])evt.getOldValue();
            String[] newNames = (String[])evt.getNewValue();
            this.applyInterceptList(oldNames, newNames, false);
        } else if ("exintrcpt-ch" == name) {
            String[] oldNames = (String[])evt.getOldValue();
            String[] newNames = (String[])evt.getNewValue();
            this.applyInterceptList(oldNames, newNames, true);
        } else {
            ErrorManager.getDefault().log("Unhandled Dbx.propertyChange: " + evt.getPropertyName());
        }
    }

    public void jn_mode_update(int mode) {
        this.session.setJavaMode(mode);
        this.dirty |= 0x100;
    }

    public HashMap getwatches() {
        return this.watches;
    }

    public ArrayList getFuncList() {
        return this.func_list;
    }

    private void stopUpdates() {
        this.localsMasked = true;
        this.threadsMasked = true;
        this.stackMasked = true;
        this.sendStackUpdates(false);
        this.sendThreadUpdates(false);
        this.sendLocalVarUpdates(false);
        this.sendDisplayUpdates(false);
    }

    private void startUpdates() {
        this.localsMasked = false;
        this.threadsMasked = false;
        this.stackMasked = false;
        if (this.stackListenerCount > 0) {
            this.sendStackUpdates(true);
        }
        if (this.threadsListenerCount > 0) {
            this.sendThreadUpdates(true);
        }
        if (this.localVarListenerCount > 0) {
            this.sendLocalVarUpdates(true);
        }
        this.sendDisplayUpdates(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        nextBreakpointToken = 1;
        local_count = 0;
        startupCommands = null;
    }
}

