/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerInfo;
import com.sun.tools.debugger.dbxgui.utils.CorefileFilter;
import com.sun.tools.debugger.dbxgui.utils.ExecutableFileFilter;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.debugger.dbxgui.utils.UnixFileSystemView;
import com.sun.tools.swdev.common.utils.UsageTracking;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.netbeans.modules.debugger.support.DebuggerModule;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.awt.StatusDisplayer;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class ChooseCorefileDialog
extends JPanel {
    private String autoText;
    private JLabel exeLabel;
    private JButton browseExeButton;
    private JTextField exeField;
    private JLabel coreLabel;
    private JButton browseCoreButton;
    private JTextField coreField;
    private JPanel mainPanel;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;

    public ChooseCorefileDialog(String initialExecutable, String initialCore) {
        this.initComponents();
        this.additionalInitComponents(initialExecutable, initialCore);
        this.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_CTL_DebugCorefile"));
    }

    private void additionalInitComponents(String initialExecutable, String initialCore) {
        this.exeLabel.setLabelFor(this.exeField);
        this.coreLabel.setLabelFor(this.coreField);
        this.autoText = DbxDebugger.getText("AutoCoreExe");
        if (initialExecutable != null) {
            this.exeField.setText(initialExecutable);
        } else {
            this.exeField.setText(this.autoText);
        }
        if (initialCore != null) {
            this.coreField.setText(initialCore);
        }
        this.coreField.requestFocus();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.exeLabel = new JLabel();
        this.exeField = new JTextField();
        this.browseExeButton = new JButton();
        this.coreLabel = new JLabel();
        this.coreField = new JTextField();
        this.browseCoreButton = new JButton();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        IpeUtils.setLabelText(this.exeLabel, DbxDebugger.getText("Corefile_Executable"), true);
        this.exeLabel.setLabelFor(this.exeField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.exeLabel, gridBagConstraints);
        this.exeField.setEditable(true);
        this.exeField.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.exeField, gridBagConstraints);
        Actions.setMenuText((AbstractButton)this.browseExeButton, (String)DbxDebugger.getText("Browse"), (boolean)true);
        this.browseExeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChooseCorefileDialog.this.onBrowseExecutable(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.mainPanel.add((Component)this.browseExeButton, gridBagConstraints);
        IpeUtils.setLabelText(this.coreLabel, DbxDebugger.getText("Corefile_Corefile"), true);
        this.coreLabel.setLabelFor(this.coreField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.coreLabel, gridBagConstraints);
        this.coreField.setEditable(true);
        this.coreField.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.coreField, gridBagConstraints);
        Actions.setMenuText((AbstractButton)this.browseCoreButton, (String)DbxDebugger.getText("BrowseSecond"), (boolean)true);
        this.browseCoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChooseCorefileDialog.this.onBrowseCore(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.mainPanel.add((Component)this.browseCoreButton, gridBagConstraints);
        this.add((Component)this.mainPanel, "North");
    }

    private void onBrowseCore(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(DbxDebugger.getText("CorefileChooser"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new CorefileFilter());
        chooser.setFileSystemView(new UnixFileSystemView(chooser.getFileSystemView()));
        chooser.setFileHidingEnabled(false);
        int returnVal = chooser.showDialog(null, DbxDebugger.getText("SelectCorefile"));
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            if (f != null && !f.isFile()) {
                return;
            }
            String corefile = null;
            if (f != null) {
                corefile = f.getAbsolutePath();
            } else if (chooser.getUI() instanceof BasicFileChooserUI) {
                BasicFileChooserUI ui = (BasicFileChooserUI)chooser.getUI();
                corefile = ui.getFileName();
            }
            this.coreField.setText(corefile);
        }
    }

    private void onBrowseExecutable(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(DbxDebugger.getText("CoreExeChooser"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new ExecutableFileFilter());
        chooser.setFileSystemView(new UnixFileSystemView(chooser.getFileSystemView()));
        chooser.setFileHidingEnabled(false);
        int returnVal = chooser.showDialog(null, DbxDebugger.getText("SelectExecutable"));
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            if (f != null && !f.isFile()) {
                return;
            }
            String executable = null;
            if (f != null) {
                executable = f.getAbsolutePath();
            } else if (chooser.getUI() instanceof BasicFileChooserUI) {
                BasicFileChooserUI ui = (BasicFileChooserUI)chooser.getUI();
                executable = ui.getFileName();
            }
            this.exeField.setText(executable);
        }
    }

    private void onOk() {
        String executable = this.exeField.getText();
        String core = this.coreField.getText();
        if (this.autoText.equals(executable) || executable.equals("")) {
            executable = "-";
        } else {
            File exeFile = new File(executable);
            if (!exeFile.exists() || exeFile.isDirectory()) {
                StatusDisplayer.getDefault().setStatusText(DbxDebugger.getText("MSG_BadExecutable"));
                return;
            }
        }
        File coreFile = new File(core);
        if (!coreFile.exists() || coreFile.isDirectory()) {
            StatusDisplayer.getDefault().setStatusText(DbxDebugger.getText("MSG_BadCoreFile"));
            return;
        }
        DbxDebuggerInfo info = new DbxDebuggerInfo(0, null, executable, -1L, core, null, null, null, null, null, null, executable + ": " + core);
        DebuggerModule.changeWorkspace();
        Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = ChooseCorefileDialog.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        try {
            d.startDebugger((DebuggerInfo)info);
        }
        catch (DebuggerException e) {
            // empty catch block
        }
    }

    public static void showWindow(String initialExecutable, String initialCore) {
        ChooseCorefileDialog corePanel = new ChooseCorefileDialog(initialExecutable, initialCore);
        String title = Actions.cutAmpersand((String)DbxDebugger.getText("LBL_DebugCorefile"));
        DialogDescriptor dlg = new DialogDescriptor((Object)corePanel, title, true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx("Debugging_corefile"), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dialog.show();
        String answer = dlg.getValue().toString();
        if (dlg.getValue().equals(DialogDescriptor.OK_OPTION)) {
            corePanel.onOk();
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"CorefileDialog: OK", null);
            }
        } else if (UsageTracking.enabled) {
            UsageTracking.sendAction((String)"CorefileDialog: Cancel", null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

