/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.DbxComboBoxModel;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerInfo;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.debugger.support.DebuggerInfoProducer;
import org.netbeans.modules.debugger.support.DebuggerModule;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public final class AttachProcessDialog
extends JPanel
implements DebuggerInfoProducer {
    private static AttachProcessDialog instance = null;
    static final int NUM_COLUMNS = 6;
    private DbxComboBoxModel filterModel;
    private DbxComboBoxModel pathModel;
    private final String[] filters = new String[]{""};
    private final String[] paths = new String[]{"-"};
    private boolean filterReady = false;
    Vector header = null;
    private DefaultTableModel processModel;
    private JTable procTable;
    private JPanel headingPanel;
    private JLabel pathLabel;
    private JComboBox pathComboBox;
    private JComboBox filterCombo;
    private JLabel filterLabel;
    private JLabel tableLabel;
    private JPanel jPanel4;
    private JPanel buttonRowPanel;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;

    public AttachProcessDialog() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_CTL_AttachToProcess"));
    }

    public static AttachProcessDialog getInstance() {
        if (instance == null) {
            instance = new AttachProcessDialog();
            instance.initializeNew();
        }
        instance.initialize();
        return instance;
    }

    public void initializeNew() {
        this.filterCombo.setSelectedItem(this.filters[0]);
        this.pathComboBox.setSelectedItem(this.paths[0]);
    }

    public void initialize() {
        this.doFilter();
    }

    private void initComponents() {
        this.headingPanel = new JPanel();
        this.filterLabel = new JLabel();
        this.filterCombo = new JComboBox();
        this.jPanel4 = new JPanel();
        this.pathLabel = new JLabel();
        this.pathComboBox = new JComboBox();
        this.tableLabel = new JLabel();
        this.setLayout(new BorderLayout());
        IpeUtils.setLabelText(this.filterLabel, DbxDebugger.getText("AttachProcDiag_FilterColon"), true);
        this.filterLabel.setLabelFor(this.filterCombo);
        this.headingPanel.add(this.filterLabel);
        this.filterCombo.setToolTipText(DbxDebugger.getText("RegExp"));
        this.filterCombo.setEditable(true);
        this.filterCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachProcessDialog.this.filterActivated(evt);
            }
        });
        this.headingPanel.add(this.filterCombo);
        this.add((Component)this.headingPanel, "North");
        this.jPanel4.setLayout(new BorderLayout());
        IpeUtils.setLabelText(this.pathLabel, DbxDebugger.getText("AttachProcDiag_Path"), true);
        this.jPanel4.add((Component)this.pathLabel, "West");
        this.pathLabel.setLabelFor(this.pathComboBox);
        this.pathComboBox.setToolTipText(DbxDebugger.getText("ProgramPathname"));
        this.pathComboBox.setEditable(true);
        this.jPanel4.add((Component)this.pathComboBox, "Center");
        this.add((Component)this.jPanel4, "South");
        this.filterReady = false;
        this.filterModel = new DbxComboBoxModel(this.filters);
        this.filterCombo.setModel(this.filterModel);
        this.filterCombo.setSelectedIndex(0);
        this.pathModel = new DbxComboBoxModel(this.paths);
        this.pathComboBox.setModel(this.pathModel);
        this.pathComboBox.setSelectedIndex(0);
        this.processModel = new DefaultTableModel(){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.procTable = new JTable(this.processModel);
        this.procTable.setAutoResizeMode(3);
        this.procTable.setShowVerticalLines(false);
        this.procTable.setShowHorizontalLines(true);
        this.procTable.setSelectionMode(0);
        this.procTable.setIntercellSpacing(new Dimension(0, this.procTable.getRowMargin()));
        this.procTable.setGridColor((Color)UIManager.getDefaults().get("Label.background"));
        this.procTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AttachProcessDialog.this.procTableClicked(evt);
            }
        });
        IpeUtils.correctJTableActionMap(this.procTable);
        JScrollPane jsp = new JScrollPane(this.procTable);
        jsp.setBorder(new EmptyBorder(new Insets(6, 0, 12, 0)));
        IpeUtils.setLabelText(this.tableLabel, DbxDebugger.getText("AttachProcDiag_Table"), true);
        this.tableLabel.setLabelFor(this.procTable);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)this.tableLabel, "North");
        tablePanel.add((Component)jsp, "Center");
        this.procTable.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_AttachProcDiag_Table"));
        this.add((Component)tablePanel, "Center");
        ComboBoxEditor editor = this.filterCombo.getEditor();
        editor.selectAll();
        this.filterCombo.requestDefaultFocus();
        this.filterReady = true;
    }

    private void procTableClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            for (Container c = this; c != null; c = c.getParent()) {
                if (!(c instanceof JDialog)) continue;
                JDialog d = (JDialog)c;
                d.setVisible(false);
                d.dispose();
                break;
            }
            this.doAttach();
        }
    }

    private void filterActivated(ActionEvent evt) {
        this.doFilter();
    }

    private void doAttach() {
        DebuggerInfo info = this.getDebuggerInfo();
        if (info == null) {
            return;
        }
        if (!(info instanceof DbxDebuggerInfo)) {
            return;
        }
        DbxDebuggerInfo dbxinfo = (DbxDebuggerInfo)info;
        DebuggerModule.changeWorkspace();
        Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = AttachProcessDialog.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        try {
            d.startDebugger((DebuggerInfo)dbxinfo);
        }
        catch (DebuggerException e) {
            // empty catch block
        }
    }

    private void doFilter() {
        if (!this.filterReady) {
            return;
        }
        Runtime rt = Runtime.getRuntime();
        String uid = null;
        String[] args = new String[3];
        try {
            args[0] = "/bin/sh";
            args[1] = "-c";
            args[2] = Utilities.getOperatingSystem() == 16 ? "/usr/bin/id -u" : "/usr/xpg4/bin/id -u";
            Process proc = rt.exec(args);
            InputStream procIn = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(procIn));
            uid = br.readLine();
            br.close();
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, "Failed to exec " + args);
            ErrorManager.getDefault().notify((Throwable)e);
        }
        Vector processes = new Vector(50);
        try {
            String str;
            args[0] = "/bin/sh";
            args[1] = "-c";
            args[2] = uid == null || uid.equals("0") ? (Utilities.getOperatingSystem() == 16 ? "LANG=C /bin/ps -www -o pid,tty,time,cmd" : "LANG=C /usr/bin/ps -ef") : (Utilities.getOperatingSystem() == 16 ? "LANG=C /bin/ps -fu " + uid : "LANG=C /usr/bin/ps -fu " + uid);
            String regexp = "";
            Object selected = this.filterCombo.getSelectedItem();
            if (selected != null) {
                regexp = selected.toString();
            }
            if (regexp.equals("")) {
                regexp = ".*";
            }
            RE re = null;
            try {
                re = new RE(regexp);
            }
            catch (RESyntaxException e) {
                if (e.getLocalizedMessage() != null) {
                    StatusDisplayer.getDefault().setStatusText(e.getLocalizedMessage());
                }
                return;
            }
            this.filterModel.add(regexp);
            this.filterCombo.setSelectedItem(selected);
            if (selected != null) {
                ComboBoxEditor editor = this.filterCombo.getEditor();
                this.filterCombo.requestDefaultFocus();
                editor.selectAll();
            }
            int[][] fields_solaris = new int[][]{{0, 8}, {8, 14}, {15, 20}, {24, 32}, {42, 46}, {47, -1}};
            int[][] fields_linux = new int[][]{{0, 8}, {9, 14}, {15, 20}, {24, 29}, {39, 47}, {48, -1}};
            Object fields = null;
            fields = Utilities.getOperatingSystem() == 16 ? (Object)fields_linux : (Object)fields_solaris;
            Process proc = rt.exec(args);
            InputStream procIn = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(procIn));
            int line = 0;
            while ((str = br.readLine()) != null) {
                if (line++ == 0) {
                    if (this.header != null) continue;
                    this.header = new Vector(6);
                    for (int cx = 0; cx < 6; ++cx) {
                        String s = null;
                        s = fields[cx][1] == -1 ? str.substring(fields[cx][0]) : str.substring(fields[cx][0], fields[cx][1]);
                        this.header.add(s.trim());
                    }
                    continue;
                }
                if (!re.match(str)) continue;
                Vector<String> columns = new Vector<String>(6);
                for (int cx = 0; cx < 6; ++cx) {
                    String s = null;
                    s = fields[cx][1] == -1 ? str.substring(fields[cx][0]) : str.substring(fields[cx][0], fields[cx][1]);
                    columns.add(s.trim());
                }
                processes.add(columns);
            }
            br.close();
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, "Failed to exec " + args);
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.processModel.setDataVector(processes, this.header);
        try {
            TableColumn tbc = this.procTable.getColumn("CMD");
            tbc.setPreferredWidth(300);
            tbc.setMinWidth(75);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public DebuggerInfo getDebuggerInfo() {
        int selectedRow = this.procTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        Object pidobj = this.processModel.getValueAt(selectedRow, 1);
        if (pidobj instanceof String) {
            String pidstring = (String)pidobj;
            long pid = Long.parseLong(pidstring);
            String executable = null;
            Object path = this.pathComboBox.getSelectedItem();
            if (path != null) {
                executable = path.toString();
            }
            DbxDebuggerInfo info = new DbxDebuggerInfo(0, null, executable, pid, null, null, null, null, null, null, null, "pid " + pid);
            return info;
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof JDialog)) continue;
            JDialog d = (JDialog)c;
            String title = DbxDebugger.getText("CTL_Attach");
            d.setTitle(title);
            break;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

