/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.debugger;

import com.sun.tools.debugger.dbxgui.debugger.Dbx;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugProgram;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugSession;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.options.DebuggingOption;
import com.sun.tools.debugger.dbxgui.utils.IpeUtils;
import com.sun.tools.debugger.dbxgui.utils.UnixFileSystemView;
import com.sun.tools.swdev.common.nbtext.Hyperlink;
import com.sun.tools.swdev.common.nbtext.UnixTabTerm;
import com.sun.tools.swdev.common.utils.UsageTracking;
import com.sun.tools.swdev.glue.dbx.DbxFrame;
import com.sun.tools.swdev.glue.dbx.DbxRtcItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.lib.terminalemulator.ActiveTermListener;
import org.netbeans.modules.debugger.support.DelegatingView2;
import org.netbeans.modules.debugger.support.View2;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public final class AccessWindow
extends UnixTabTerm
implements PropertyChangeListener,
ComponentListener,
ActionListener,
FocusListener {
    static final long serialVersionUID = 8415779626223096166L;
    private ActiveTerm currentTerm = new ActiveTerm();
    private Dbx dbx = null;
    private StringBuffer saveAsString = null;
    private ActiveTermListener termListener = null;
    private Component lastFocusOwner = null;
    private JPanel jPanel41;
    private JButton suppressButton;
    private ButtonGroup buttonGroup;
    private boolean firstTime = true;
    private JMenuItem clearItem = null;
    private JMenuItem suppressItem = null;
    private JMenuItem saveAsItem = null;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleAccessChecksAction;

    public AccessWindow(Dbx dbx) {
        super(DbxDebugger.getText("CTL_AccessError") + " (OFF)");
        this.currentTerm.getCanvas().addFocusListener(this);
        dbx.setupTerm(this.currentTerm, true);
        this.initComponents();
        this.add("Center", (Component)this.currentTerm);
        this.suppressButton.addFocusListener(this);
        this.initializeA11y();
        this.addPopupListener(this.currentTerm.getCanvas());
        this.addPopupListener((JComponent)((Object)this));
        this.addPopupListener(this.jPanel41);
        this.addPopupListener(this.suppressButton);
        this.termListener = new ActiveTermListener(){

            public void action(ActiveRegion r, InputEvent e) {
                Hyperlink link = (Hyperlink)r.getUserObject();
                if (link != null) {
                    link.activate((Object)this);
                }
            }
        };
        this.currentTerm.setActionListener(this.termListener);
        dbx.setAccessTerm(this.currentTerm);
        this.dbx = dbx;
        this.setupHyperlinkProcessing(this.currentTerm);
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else {
            this.currentTerm.getCanvas().requestFocus();
        }
    }

    public void focusGained(FocusEvent event) {
        this.lastFocusOwner = (Component)event.getSource();
    }

    public void focusLost(FocusEvent event) {
    }

    private void setBold(ActiveTerm term) {
        term.setAttribute(1);
    }

    private void addSeparator(ActiveTerm term) {
        if (term.getCursorCol() != 0) {
            term.putChar('\r');
            term.putChar('\n');
        }
        int width = term.getColumns();
        for (int i = 0; i < width; ++i) {
            term.putChar('_');
        }
        if (this.saveAsString == null) {
            this.saveAsString = new StringBuffer(1000);
        }
        this.saveAsString.append("\n________________________________________________________________________________\n");
    }

    private void setNormal(ActiveTerm term) {
        term.setAttribute(0);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jPanel41 = new JPanel();
        this.suppressButton = new JButton();
        this.setLayout(new BorderLayout());
        this.suppressButton.setText(DbxDebugger.getText("SuppressLast"));
        this.suppressButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AccessWindow.this.suppressLast(evt);
            }
        });
        this.jPanel41.add(this.suppressButton);
        this.add(this.jPanel41, "South");
    }

    private void suppressLast(ActionEvent evt) {
        if (DebuggingOption.RTC_AUTO_SUPPRESS.isEnabled()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DbxDebugger.getText("AlreadySuppressedLast")));
            return;
        }
        DbxDebugSession session = this.dbx.getSession();
        if (session != null && this.dbx != null) {
            this.dbx.suppressLastError();
        }
    }

    private void additionalInitComponents() {
        this.setName(DbxDebugger.getText("TITLE_AccessWindow"));
        this.setIcon(Utilities.loadImage((String)"com/sun/tools/dbxgui/icons/access.gif"));
    }

    public void componentShown(ComponentEvent e) {
        if (this.firstTime) {
            this.firstTime = false;
            this.setSize(this.getPreferredSize());
            this.validate();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    private void append(ActiveTerm term, String str, String saveStr, boolean repaint) {
        term.appendText(str, repaint);
        if (this.saveAsString == null) {
            this.saveAsString = new StringBuffer(1000);
        }
        this.saveAsString.append(saveStr);
    }

    private void append(ActiveTerm term, String str, boolean repaint) {
        this.append(term, str, str, repaint);
    }

    private void append(ActiveTerm term, String str) {
        this.append(term, str, str, true);
    }

    public void accessItem(Dbx dbx, DbxRtcItem item) {
        String var;
        int i;
        ActiveTerm accessTerm = dbx.getAccessTerm();
        if (DebuggingOption.FRONT_ACCESS.isEnabled()) {
            this.requestVisible();
        }
        if (dbx.accessNew) {
            DbxDebugSession session = dbx.getSession();
            if (session != null) {
                DbxDebugProgram program = session.getConfig().getProgram();
                String path = program.getExecutableName();
                if (path == null) {
                    path = MessageFormat.format(DbxDebugger.getText("AttachedProcessPid"), Long.toString(session.getPid()));
                }
                this.append(accessTerm, MessageFormat.format(DbxDebugger.getText("AccessStarted"), path));
            }
            dbx.accessNew = false;
        }
        this.addSeparator(accessTerm);
        this.append(accessTerm, "\n");
        this.append(accessTerm, item.buf);
        boolean sixtyfourbit = false;
        DbxDebugSession session = dbx.getSession();
        if (session != null) {
            sixtyfourbit = dbx.getState().is64bit();
        }
        for (i = 0; i < item.stack.nframes; ++i) {
            if (i > 0) {
                this.append(accessTerm, "<-", "\n\t", false);
            } else {
                this.append(accessTerm, "\t");
            }
            DbxFrame frame = item.stack.frame[i];
            if (frame.source != null) {
                ActiveRegion region = accessTerm.beginRegion(true);
                region.setFeedbackEnabled(false);
                region.setSelectable(false);
                String text = null;
                String st = null;
                String saveText = null;
                if (frame.func != null) {
                    text = frame.func;
                    st = text + "()";
                } else {
                    st = sixtyfourbit ? (text = Long.toHexString(frame.pc)) : (text = Integer.toHexString((int)frame.pc));
                }
                saveText = MessageFormat.format(DbxDebugger.getText("RtcStackDesc"), Integer.toString(frame.frameno), st, Integer.toString(frame.lineno), IpeUtils.getBaseName(frame.source));
                this.append(accessTerm, text, saveText, false);
                Hyperlink link = new Hyperlink(text, "editor:" + frame.source + ":" + frame.lineno + "::");
                region.setUserObject((Object)link);
                accessTerm.endRegion();
                continue;
            }
            String text = null;
            String st = null;
            String saveText = null;
            if (frame.func != null) {
                text = frame.func;
                st = text + "()";
            } else {
                st = sixtyfourbit ? (text = Long.toHexString(frame.pc)) : (text = Integer.toHexString((int)frame.pc));
            }
            saveText = "[" + frame.frameno + "] " + st;
            this.append(accessTerm, text, saveText, false);
        }
        if (i > 0) {
            this.append(accessTerm, "\n");
        }
        if ((var = item.var_name) != null && var.length() > 0) {
            this.setBold(accessTerm);
            this.append(accessTerm, MessageFormat.format(DbxDebugger.getText("VariableIs"), var));
            this.setNormal(accessTerm);
        }
        if (item.err_location.src == null) {
            this.append(accessTerm, "", true);
            return;
        }
        this.append(accessTerm, DbxDebugger.getText("ErrorLoc"));
        String fileName = IpeUtils.getBaseName(item.err_location.src);
        ActiveRegion region = accessTerm.beginRegion(true);
        region.setFeedbackEnabled(false);
        region.setSelectable(false);
        String text = MessageFormat.format(DbxDebugger.getText("RtcFileLine"), fileName, Integer.toString(item.err_location.line));
        this.append(accessTerm, text);
        Hyperlink link = new Hyperlink(text, "editor:" + item.err_location.src + ":" + item.err_location.line + "::");
        region.setUserObject((Object)link);
        accessTerm.endRegion();
        if (item.err_location.func != null && item.err_location.func.length() > 0) {
            this.append(accessTerm, ", " + item.err_location.func + "()");
        }
        this.append(accessTerm, "\n\n", true);
    }

    public void checkEnd(Dbx dbx) {
        if (dbx.accessNew) {
            return;
        }
        ActiveTerm accessTerm = dbx.getAccessTerm();
        if (accessTerm != null) {
            this.append(accessTerm, DbxDebugger.getText("AccessEnded"), true);
            this.addSeparator(accessTerm);
        }
        dbx.accessNew = true;
    }

    public void show(Object foo) {
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] rtcActions = new SystemAction[]{null};
        return rtcActions;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("access-item" == evt.getPropertyName()) {
            Dbx dbx = (Dbx)evt.getOldValue();
            DbxRtcItem item = (DbxRtcItem)evt.getNewValue();
            this.accessItem(dbx, item);
        } else if ("access-state" == evt.getPropertyName()) {
            Dbx dbx = (Dbx)evt.getNewValue();
            if (!dbx.isAccessCheckingEnabled()) {
                this.checkEnd(dbx);
                this.setName(DbxDebugger.getText("CTL_AccessError") + " (OFF)");
            } else {
                this.setName(DbxDebugger.getText("CTL_AccessError") + " (ON)");
            }
        } else if ("access-end" == evt.getPropertyName()) {
            Dbx dbx = (Dbx)evt.getNewValue();
            this.checkEnd(dbx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs() {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(DbxDebugger.getText("Rtc_SaveAsText"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSystemView(new UnixFileSystemView(chooser.getFileSystemView()));
        chooser.setFileHidingEnabled(false);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
            try {
                FileWriter fw = new FileWriter(f);
                try {
                    if (this.saveAsString != null) {
                        fw.write(this.saveAsString.toString());
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.currentTerm == null) {
            return;
        }
        if (actionEvent.getSource() == this.clearItem) {
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"Access Check: Clear", null);
            }
            this.currentTerm.clearHistory();
            this.currentTerm.clear();
        } else if (actionEvent.getSource() == this.suppressItem) {
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"Access Check: Supress Last", null);
            }
            this.suppressLast(null);
        } else if (actionEvent.getSource() == this.saveAsItem) {
            if (UsageTracking.enabled) {
                UsageTracking.sendAction((String)"Access Check: Save As", null);
            }
            this.saveAs();
        }
    }

    protected void populateMenu(Object source, int xpos, int ypos, JPopupMenu popup) {
        CallableSystemAction tmca = (CallableSystemAction)SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleAccessChecksAction == null ? (class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleAccessChecksAction = AccessWindow.class$("com.sun.tools.debugger.dbxgui.debugger.actions.ToggleAccessChecksAction")) : class$com$sun$tools$debugger$dbxgui$debugger$actions$ToggleAccessChecksAction));
        JMenuItem jmi = tmca.getPopupPresenter();
        popup.add(jmi);
        popup.addSeparator();
        this.suppressItem = new JMenuItem(DbxDebugger.getText("Rtc_Suppress"));
        popup.add(this.suppressItem);
        this.suppressItem.addActionListener(this);
        popup.addSeparator();
        this.saveAsItem = new JMenuItem(DbxDebugger.getText("Rtc_SaveAsText"));
        popup.add(this.saveAsItem);
        this.saveAsItem.addActionListener(this);
        this.clearItem = new JMenuItem(DbxDebugger.getText("Rtc_Clear"));
        popup.add(this.clearItem);
        this.clearItem.addActionListener(this);
        boolean enabled = false;
        if (this.dbx != null && this.dbx.isAccessCheckingEnabled()) {
            enabled = true;
        }
        if (!enabled) {
            this.clearItem.setEnabled(false);
            this.suppressItem.setEnabled(false);
            this.saveAsItem.setEnabled(false);
        }
        this.addSystemActionsToMenu(popup);
    }

    public void topComponentOpened(String tab_name, boolean open) {
        if (this.dbx != null && this.dbx.getDebugger() != null) {
            this.dbx.getDebugger().openOutputTab(this);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Debugging_RTC");
    }

    public View2 getView() {
        return null;
    }

    public DelegatingView2 getDelegatingView() {
        return null;
    }

    public void initializeA11y() {
        super.initializeA11y();
        this.suppressButton.getAccessibleContext().setAccessibleDescription(DbxDebugger.getText("ACSD_SuppressLast"));
        this.suppressButton.setMnemonic(DbxDebugger.getText("SuppressLastMnemonic").charAt(0));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

