/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.capture;

import com.sun.tools.debugger.dbxgui.capture.CaptureInfo;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebugger;
import com.sun.tools.debugger.dbxgui.debugger.DbxDebuggerInfo;
import com.sun.tools.swdev.glue.Notifier;
import com.sun.tools.swdev.glue.Servant;
import com.sun.tools.swdev.glue.Service;
import com.sun.tools.swdev.glue.xstart.ExternalStartServant;
import com.sun.tools.swdev.glue.xstart.ExternalStartService;
import java.util.LinkedList;
import org.netbeans.modules.debugger.support.DebuggerModule;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.SystemAction;

public class ExternalStart {
    private static ExternalStartService svc = null;
    private static LinkedList queue = new LinkedList();
    private static Job pendingJob;
    private static boolean debuggerStarted;
    private static int maxRequests;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$capture$ExternalStart;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;
    static /* synthetic */ Class class$com$sun$tools$debugger$dbxgui$capture$CaptureListenAction;

    public static void debuggerStarted() {
        debuggerStarted = true;
    }

    static String getText(String key) {
        return NbBundle.getMessage((Class)(class$com$sun$tools$debugger$dbxgui$capture$ExternalStart == null ? (class$com$sun$tools$debugger$dbxgui$capture$ExternalStart = ExternalStart.class$("com.sun.tools.debugger.dbxgui.capture.ExternalStart")) : class$com$sun$tools$debugger$dbxgui$capture$ExternalStart), (String)key);
    }

    private static void status(String msg) {
        StatusDisplayer.getDefault().setStatusText(msg);
    }

    private static int getMaxRequests() {
        if (maxRequests == -1) {
            maxRequests = 10;
            String s = System.getProperty("spro.ss_attach.maxrequests");
            if (s != null) {
                try {
                    maxRequests = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return maxRequests;
    }

    private static void enqueue(Job job) {
        queue.add(job);
        ExternalStart.runJob();
    }

    private static void fail(String label) {
        ExternalStart.pendingJob.servant.failed(ExternalStart.getText(label));
        pendingJob = null;
        ExternalStart.runJob();
    }

    private static void runJob() {
        if (queue.isEmpty()) {
            return;
        }
        if (pendingJob != null) {
            return;
        }
        pendingJob = (Job)queue.removeFirst();
        NotifyDescriptor.Confirmation dlg = new NotifyDescriptor.Confirmation((Object)ExternalStart.pendingJob.captureInfo.messageString(), ExternalStart.getText("LBL_dialogName"), 0);
        Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
        if (answer == NotifyDescriptor.NO_OPTION) {
            ExternalStart.fail("LBL_UserDeniedRequest");
            return;
        }
        DbxDebuggerInfo info = new DbxDebuggerInfo(0, null, "-", ExternalStart.pendingJob.captureInfo.pid, null, null, null, null, null, null, null, "pid " + ExternalStart.pendingJob.captureInfo.pid);
        info.setCaptureInfo(ExternalStart.pendingJob.captureInfo);
        DebuggerModule.changeWorkspace();
        Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = ExternalStart.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        try {
            debuggerStarted = false;
            d.startDebugger((DebuggerInfo)info);
        }
        catch (DebuggerException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            ExternalStart.fail("LBL_IDEError");
            return;
        }
        if (!debuggerStarted) {
            ExternalStart.fail("LBL_CancelledByUser");
        }
    }

    public static boolean attached(int pid) {
        if (svc == null) {
            return false;
        }
        if (pendingJob == null) {
            return false;
        }
        ExternalStart.pendingJob.servant.proceed();
        pendingJob = null;
        ExternalStart.runJob();
        return true;
    }

    public static boolean start() {
        Notifier notifier = DbxDebugger.getNotifier();
        svc = new MyExternalStartService(notifier);
        svc.limit_hard(ExternalStart.getMaxRequests());
        boolean success = svc.svc_register(null);
        if (success) {
            DbxDebugger.runNotifier();
            ExternalStart.status(ExternalStart.getText("LBL_enable_ss_attach"));
        }
        return success;
    }

    public static boolean stop() {
        if (svc == null) {
            return false;
        }
        svc.stop();
        BooleanStateAction act = (BooleanStateAction)SystemAction.get((Class)(class$com$sun$tools$debugger$dbxgui$capture$CaptureListenAction == null ? (class$com$sun$tools$debugger$dbxgui$capture$CaptureListenAction = ExternalStart.class$("com.sun.tools.debugger.dbxgui.capture.CaptureListenAction")) : class$com$sun$tools$debugger$dbxgui$capture$CaptureListenAction));
        act.setBooleanState(false);
        ExternalStart.status(ExternalStart.getText("LBL_disable_ss_attach"));
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        maxRequests = -1;
    }

    private static class MyExternalStartService
    extends ExternalStartService {
        MyExternalStartService(Notifier notifier) {
            super(notifier);
        }

        public Servant Servant_new() {
            return new MyExternalStartServant((Service)this);
        }

        protected void hard_limit_exceeded() {
            ExternalStart.stop();
            String message = ExternalStart.getText("LBL_TooMany");
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)message, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        }
    }

    private static class MyExternalStartServant
    extends ExternalStartServant {
        MyExternalStartServant(Service svc) {
            super(svc);
        }

        protected void startSession(String executable, int argc, String[] argv, String workingDirectory, int pid) {
            CaptureInfo ci = new CaptureInfo(executable, argc, argv, workingDirectory, pid);
            Job j = new Job(ci, this);
            ExternalStart.enqueue(j);
        }
    }

    private static class Job {
        public CaptureInfo captureInfo;
        public ExternalStartServant servant;

        Job(CaptureInfo captureInfo, ExternalStartServant servant) {
            this.captureInfo = captureInfo;
            this.servant = servant;
        }
    }
}

