/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.debugger.dbxgui.capture;

import com.sun.tools.debugger.dbxgui.capture.ExternalStart;
import java.text.MessageFormat;

public class CaptureInfo {
    public String executable;
    public int argc;
    public String[] argv;
    public String workingDirectory;
    public int pid;

    public CaptureInfo(String executable, int argc, String[] argv, String wd, int pid) {
        this.executable = executable;
        this.argc = argc;
        this.argv = argv;
        this.workingDirectory = wd;
        this.pid = pid;
    }

    public String quotedArgvString() {
        String string = "";
        for (int cx = 1; cx < this.argc; ++cx) {
            string = string + this.argv[cx] + " ";
        }
        string = string.trim();
        return string;
    }

    public String argvString() {
        String string = "";
        for (int cx = 1; cx < this.argc; ++cx) {
            string = string + this.argv[cx] + " ";
        }
        String sub = string = string.trim();
        try {
            sub = string.substring(0, 50);
        }
        catch (StringIndexOutOfBoundsException x) {
            return sub;
        }
        sub = sub + " ...";
        return sub;
    }

    public String truncate(String str) {
        String sub = str;
        try {
            int len = str.length();
            sub = str.substring(len - 50, len);
        }
        catch (StringIndexOutOfBoundsException x) {
            return sub;
        }
        return "... " + sub;
    }

    public String messageString() {
        String fmt = ExternalStart.getText("FMT_CaughtMessage");
        String msg = MessageFormat.format(fmt, this.truncate(this.executable), this.argvString(), this.truncate(this.workingDirectory));
        return msg;
    }
}

