/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionCertStore
extends CertStoreSpi {
    private Collection coll;

    public CollectionCertStore(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be CollectionCertStoreParameters");
        }
        this.coll = ((CollectionCertStoreParameters)certStoreParameters).getCollection();
    }

    public Collection<Certificate> engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        if (this.coll == null) {
            throw new CertStoreException("Collection is null");
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            try {
                HashSet<Certificate> hashSet = new HashSet<Certificate>();
                Iterator iterator = this.coll.iterator();
                if (certSelector != null) {
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        if (!(e2 instanceof Certificate) || !certSelector.match((Certificate)e2)) continue;
                        hashSet.add((Certificate)e2);
                    }
                } else {
                    while (iterator.hasNext()) {
                        Object e3 = iterator.next();
                        if (!(e3 instanceof Certificate)) continue;
                        hashSet.add((Certificate)e3);
                    }
                }
                return hashSet;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        throw new ConcurrentModificationException("Too many ConcurrentModificationExceptions");
    }

    public Collection<CRL> engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        if (this.coll == null) {
            throw new CertStoreException("Collection is null");
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            try {
                HashSet<CRL> hashSet = new HashSet<CRL>();
                Iterator iterator = this.coll.iterator();
                if (cRLSelector != null) {
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        if (!(e2 instanceof CRL) || !cRLSelector.match((CRL)e2)) continue;
                        hashSet.add((CRL)e2);
                    }
                } else {
                    while (iterator.hasNext()) {
                        Object e3 = iterator.next();
                        if (!(e3 instanceof CRL)) continue;
                        hashSet.add((CRL)e3);
                    }
                }
                return hashSet;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        throw new ConcurrentModificationException("Too many ConcurrentModificationExceptions");
    }
}

