/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.ProviderException;

abstract class DigestBase
extends MessageDigestSpi
implements Cloneable {
    private final byte[] oneByte = new byte[1];
    private final String algorithm;
    private final int digestLength;
    private final int blockSize;
    private final byte[] buffer;
    private int bufOfs;
    long bytesProcessed;
    static final byte[] padding = new byte[136];

    DigestBase(String string, int n2, int n3) {
        this.algorithm = string;
        this.digestLength = n2;
        this.blockSize = n3;
        this.buffer = new byte[n3];
    }

    DigestBase(DigestBase digestBase) {
        this.algorithm = digestBase.algorithm;
        this.digestLength = digestBase.digestLength;
        this.blockSize = digestBase.blockSize;
        this.buffer = (byte[])digestBase.buffer.clone();
        this.bufOfs = digestBase.bufOfs;
        this.bytesProcessed = digestBase.bytesProcessed;
    }

    protected final int engineGetDigestLength() {
        return this.digestLength;
    }

    protected final void engineUpdate(byte by) {
        this.oneByte[0] = by;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    protected final void engineUpdate(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.bytesProcessed += (long)n3;
        if (this.bufOfs != 0) {
            int n4 = Math.min(n3, this.blockSize - this.bufOfs);
            System.arraycopy(byArray, n2, this.buffer, this.bufOfs, n4);
            this.bufOfs += n4;
            n2 += n4;
            n3 -= n4;
            if (this.bufOfs >= this.blockSize) {
                this.implCompress(this.buffer, 0);
                this.bufOfs = 0;
            }
        }
        while (n3 >= this.blockSize) {
            this.implCompress(byArray, n2);
            n3 -= this.blockSize;
            n2 += this.blockSize;
        }
        if (n3 > 0) {
            System.arraycopy(byArray, n2, this.buffer, 0, n3);
            this.bufOfs = n3;
        }
    }

    protected final void engineReset() {
        if (this.bytesProcessed == 0L) {
            return;
        }
        this.implReset();
        this.bufOfs = 0;
        this.bytesProcessed = 0L;
    }

    protected final byte[] engineDigest() {
        byte[] byArray = new byte[this.digestLength];
        try {
            this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw (ProviderException)new ProviderException("Internal error").initCause(digestException);
        }
        return byArray;
    }

    protected final int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        if (n3 < this.digestLength) {
            throw new DigestException("Length must be at least " + this.digestLength + " for " + this.algorithm + "digests");
        }
        if (n2 + n3 > byArray.length) {
            throw new DigestException("Buffer too short to store digest");
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.implDigest(byArray, n2);
        this.bytesProcessed = -1L;
        return this.digestLength;
    }

    abstract void implCompress(byte[] var1, int var2);

    abstract void implDigest(byte[] var1, int var2);

    abstract void implReset();

    public abstract Object clone();

    static void b2iLittle(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        while (n4 > 0) {
            int n5 = byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | byArray[n2 + 3] << 24;
            nArray[n3++] = n5;
            n2 += 4;
            n4 -= 4;
        }
    }

    static void i2bLittle(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        while (n4 > 0) {
            int n5 = nArray[n2++];
            byArray[n3++] = (byte)n5;
            byArray[n3++] = (byte)(n5 >> 8);
            byArray[n3++] = (byte)(n5 >> 16);
            byArray[n3++] = (byte)(n5 >> 24);
            n4 -= 4;
        }
    }

    static void b2iBig(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        while (n4 > 0) {
            int n5 = byArray[n2 + 3] & 0xFF | (byArray[n2 + 2] & 0xFF) << 8 | (byArray[n2 + 1] & 0xFF) << 16 | byArray[n2] << 24;
            nArray[n3++] = n5;
            n2 += 4;
            n4 -= 4;
        }
    }

    static void i2bBig(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        while (n4 > 0) {
            int n5 = nArray[n2++];
            byArray[n3++] = (byte)(n5 >> 24);
            byArray[n3++] = (byte)(n5 >> 16);
            byArray[n3++] = (byte)(n5 >> 8);
            byArray[n3++] = (byte)n5;
            n4 -= 4;
        }
    }

    static void b2lBig(byte[] byArray, int n2, long[] lArray, int n3, int n4) {
        while (n4 > 0) {
            int n5 = byArray[n2 + 3] & 0xFF | (byArray[n2 + 2] & 0xFF) << 8 | (byArray[n2 + 1] & 0xFF) << 16 | byArray[n2] << 24;
            int n6 = byArray[(n2 += 4) + 3] & 0xFF | (byArray[n2 + 2] & 0xFF) << 8 | (byArray[n2 + 1] & 0xFF) << 16 | byArray[n2] << 24;
            lArray[n3++] = (long)n5 << 32 | (long)n6 & 0xFFFFFFFFL;
            n2 += 4;
            n4 -= 8;
        }
    }

    static void l2bBig(long[] lArray, int n2, byte[] byArray, int n3, int n4) {
        while (n4 > 0) {
            long l2 = lArray[n2++];
            byArray[n3++] = (byte)(l2 >> 56);
            byArray[n3++] = (byte)(l2 >> 48);
            byArray[n3++] = (byte)(l2 >> 40);
            byArray[n3++] = (byte)(l2 >> 32);
            byArray[n3++] = (byte)(l2 >> 24);
            byArray[n3++] = (byte)(l2 >> 16);
            byArray[n3++] = (byte)(l2 >> 8);
            byArray[n3++] = (byte)l2;
            n4 -= 8;
        }
    }

    static {
        DigestBase.padding[0] = -128;
    }
}

