/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sun.font.CompositeFont;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.FontStrikeDisposer;
import sun.font.PhysicalStrike;
import sun.font.StrikeMetrics;

public final class CompositeStrike
extends FontStrike {
    static final int SLOTMASK = 0xFFFFFF;
    private CompositeFont compFont;
    private PhysicalStrike[] strikes;
    int numGlyphs = 0;

    CompositeStrike(CompositeFont compositeFont, FontStrikeDesc fontStrikeDesc) {
        this.compFont = compositeFont;
        this.desc = fontStrikeDesc;
        this.disposer = new FontStrikeDisposer(this.compFont, fontStrikeDesc);
        if (fontStrikeDesc.style != this.compFont.style) {
            this.algoStyle = true;
            if ((fontStrikeDesc.style & 1) == 1 && (this.compFont.style & 1) == 0) {
                this.boldness = 1.33f;
            }
            if ((fontStrikeDesc.style & 2) == 1 && (this.compFont.style & 2) == 0) {
                this.italic = 0.7f;
            }
        }
        this.strikes = new PhysicalStrike[this.compFont.numSlots];
    }

    PhysicalStrike getStrikeForGlyph(int n2) {
        return this.getStrikeForSlot(n2 >>> 24);
    }

    PhysicalStrike getStrikeForSlot(int n2) {
        PhysicalStrike physicalStrike = this.strikes[n2];
        if (physicalStrike == null) {
            this.strikes[n2] = physicalStrike = (PhysicalStrike)this.compFont.getSlotFont(n2).getStrike(this.desc);
        }
        return physicalStrike;
    }

    public int getNumGlyphs() {
        return this.compFont.getNumGlyphs();
    }

    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            StrikeMetrics strikeMetrics = new StrikeMetrics();
            for (int i2 = 0; i2 < this.compFont.numMetricsSlots; ++i2) {
                strikeMetrics.merge(this.getStrikeForSlot(i2).getFontMetrics());
            }
            this.strikeMetrics = strikeMetrics;
        }
        return this.strikeMetrics;
    }

    void getGlyphImagePtrs(int[] nArray, long[] lArray, int n2) {
        PhysicalStrike physicalStrike = this.getStrikeForSlot(0);
        int n3 = physicalStrike.getSlot0GlyphImagePtrs(nArray, lArray, n2);
        if (n3 == n2) {
            return;
        }
        for (int i2 = n3; i2 < n2; ++i2) {
            physicalStrike = this.getStrikeForGlyph(nArray[i2]);
            lArray[i2] = physicalStrike.getGlyphImagePtr(nArray[i2] & 0xFFFFFF);
        }
    }

    long getGlyphImagePtr(int n2) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n2);
        return physicalStrike.getGlyphImagePtr(n2 & 0xFFFFFF);
    }

    void getGlyphImageBounds(int n2, Point2D.Float float_, Rectangle rectangle) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n2);
        physicalStrike.getGlyphImageBounds(n2 & 0xFFFFFF, float_, rectangle);
    }

    Point2D.Float getGlyphMetrics(int n2) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n2);
        return physicalStrike.getGlyphMetrics(n2 & 0xFFFFFF);
    }

    Point2D.Float getCharMetrics(char c2) {
        return this.getGlyphMetrics(this.compFont.getMapper().charToGlyph(c2));
    }

    float getGlyphAdvance(int n2) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n2);
        return physicalStrike.getGlyphAdvance(n2 & 0xFFFFFF);
    }

    float getCodePointAdvance(int n2) {
        return this.getGlyphAdvance(this.compFont.getMapper().charToGlyph(n2));
    }

    Rectangle2D.Float getGlyphOutlineBounds(int n2) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n2);
        return physicalStrike.getGlyphOutlineBounds(n2 & 0xFFFFFF);
    }

    GeneralPath getGlyphOutline(int n2, float f2, float f3) {
        PhysicalStrike physicalStrike = this.getStrikeForGlyph(n2);
        GeneralPath generalPath = physicalStrike.getGlyphOutline(n2 & 0xFFFFFF, f2, f3);
        if (generalPath == null) {
            return new GeneralPath();
        }
        return generalPath;
    }

    GeneralPath getGlyphVectorOutline(int[] nArray, float f2, float f3) {
        GeneralPath generalPath = null;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2;
            int n4 = nArray[n2] >>> 24;
            while (n2 < nArray.length && nArray[n2 + 1] >>> 24 == n4) {
                ++n2;
            }
            int n5 = n2 - n3 + 1;
            int[] nArray2 = new int[n5];
            for (int i2 = 0; i2 < n5; ++i2) {
                nArray2[i2] = nArray[i2] & 0xFFFFFF;
            }
            GeneralPath generalPath2 = this.getStrikeForSlot(n4).getGlyphVectorOutline(nArray2, f2, f3);
            if (generalPath == null) {
                generalPath = generalPath2;
                continue;
            }
            if (generalPath2 == null) continue;
            generalPath.append(generalPath2, false);
        }
        if (generalPath == null) {
            return new GeneralPath();
        }
        return generalPath;
    }
}

