/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthProgressBarUI
extends BasicProgressBarUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;
    private int progressPadding;

    SynthProgressBarUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthProgressBarUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.progressBar.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this);
    }

    protected void installDefaults() {
        this.updateStyle(this.progressBar);
    }

    private void updateStyle(JProgressBar jProgressBar) {
        SynthContext synthContext = this.getContext(jProgressBar, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.setCellLength(this.style.getInt(synthContext, "ProgressBar.cellLength", 1));
            this.setCellSpacing(this.style.getInt(synthContext, "ProgressBar.cellSpacing", 0));
            this.progressPadding = this.style.getInt(synthContext, "ProgressBar.progressPadding", 0);
        }
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.progressBar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintProgressBarBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (!jProgressBar.isIndeterminate()) {
            Insets insets = jProgressBar.getInsets();
            double d2 = jProgressBar.getPercentComplete();
            if (d2 != 0.0) {
                if (jProgressBar.getOrientation() == 0) {
                    n2 = insets.left + this.progressPadding;
                    n3 = insets.top + this.progressPadding;
                    n4 = (int)(d2 * (double)(jProgressBar.getWidth() - (insets.left + this.progressPadding + insets.right + this.progressPadding)));
                    n5 = jProgressBar.getHeight() - (insets.top + this.progressPadding + insets.bottom + this.progressPadding);
                    if (!SynthLookAndFeel.isLeftToRight(jProgressBar)) {
                        n2 = jProgressBar.getWidth() - insets.right - n4 - this.progressPadding;
                    }
                } else {
                    n2 = insets.left + this.progressPadding;
                    n4 = jProgressBar.getWidth() - (insets.left + this.progressPadding + insets.right + this.progressPadding);
                    n5 = (int)(d2 * (double)(jProgressBar.getHeight() - (insets.top + this.progressPadding + insets.bottom + this.progressPadding)));
                    n3 = jProgressBar.getHeight() - insets.bottom - n5 - this.progressPadding;
                }
            }
        } else {
            this.boxRect = this.getBox(this.boxRect);
            n2 = this.boxRect.x + this.progressPadding;
            n3 = this.boxRect.y + this.progressPadding;
            n4 = this.boxRect.width - this.progressPadding - this.progressPadding;
            n5 = this.boxRect.height - this.progressPadding - this.progressPadding;
        }
        synthContext.getPainter().paintProgressBarForeground(synthContext, graphics, n2, n3, n4, n5, jProgressBar.getOrientation());
        if (jProgressBar.isStringPainted() && !jProgressBar.isIndeterminate()) {
            this.paintText(synthContext, graphics, jProgressBar.getString());
        }
    }

    protected void paintText(SynthContext synthContext, Graphics graphics, String string) {
        Font font = synthContext.getStyle().getFont(synthContext);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.progressBar, graphics, font);
        if (this.progressBar.isStringPainted()) {
            String string2 = this.progressBar.getString();
            Rectangle rectangle = this.progressBar.getBounds();
            int n2 = synthContext.getStyle().getGraphicsUtils(synthContext).computeStringWidth(synthContext, font, fontMetrics, string2);
            Rectangle rectangle2 = new Rectangle(rectangle.width / 2 - n2 / 2, (rectangle.height - (fontMetrics.getAscent() + fontMetrics.getDescent())) / 2, 0, 0);
            if (rectangle2.y < 0) {
                return;
            }
            SynthStyle synthStyle = synthContext.getStyle();
            graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            graphics.setFont(synthStyle.getFont(synthContext));
            synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string, rectangle2.x, rectangle2.y, -1);
        }
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintProgressBarBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JProgressBar)propertyChangeEvent.getSource());
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = this.progressBar.getInsets();
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        Dimension dimension = this.progressBar.getOrientation() == 0 ? new Dimension(this.getPreferredInnerHorizontal()) : new Dimension(this.getPreferredInnerVertical());
        if (this.progressBar.isStringPainted()) {
            int n2;
            String string = this.progressBar.getString();
            int n3 = fontMetrics.getHeight() + fontMetrics.getDescent();
            if (n3 > dimension.height) {
                dimension.height = n3;
            }
            if ((n2 = SwingUtilities2.stringWidth(this.progressBar, fontMetrics, string)) > dimension.width) {
                dimension.width = n2;
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }
}

