/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuBarUI;
import javax.swing.plaf.synth.DefaultMenuLayout;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthMenuBarUI
extends BasicMenuBarUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthMenuBarUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthMenuBarUI();
    }

    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            this.menuBar.setLayout(new DefaultMenuLayout(this.menuBar, 2));
        }
        this.updateStyle(this.menuBar);
    }

    protected void installListeners() {
        super.installListeners();
        this.menuBar.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuBar jMenuBar) {
        SynthContext synthContext = this.getContext(jMenuBar, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle && synthStyle != null) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
        synthContext.dispose();
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.menuBar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuBar.removePropertyChangeListener(this);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintMenuBarBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintMenuBarBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JMenuBar)propertyChangeEvent.getSource());
        }
    }
}

