/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Font;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalFontDesktopProperty;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import sun.security.action.GetPropertyAction;

public class DefaultMetalTheme
extends MetalTheme {
    private static final boolean PLAIN_FONTS;
    private static final String[] fontNames;
    private static final int[] fontStyles;
    private static final int[] fontSizes;
    private static final String[] defaultNames;
    private static final ColorUIResource primary1;
    private static final ColorUIResource primary2;
    private static final ColorUIResource primary3;
    private static final ColorUIResource secondary1;
    private static final ColorUIResource secondary2;
    private static final ColorUIResource secondary3;
    private FontDelegate fontDelegate;

    static String getDefaultFontName(int n2) {
        return fontNames[n2];
    }

    static int getDefaultFontSize(int n2) {
        return fontSizes[n2];
    }

    static int getDefaultFontStyle(int n2) {
        Object object;
        if (n2 != 4 && ((object = UIManager.get("swing.boldMetal")) != null ? Boolean.FALSE.equals(object) : PLAIN_FONTS)) {
            return 0;
        }
        return fontStyles[n2];
    }

    static String getDefaultPropertyName(int n2) {
        return defaultNames[n2];
    }

    public String getName() {
        return "Steel";
    }

    public DefaultMetalTheme() {
        this.install();
    }

    protected ColorUIResource getPrimary1() {
        return primary1;
    }

    protected ColorUIResource getPrimary2() {
        return primary2;
    }

    protected ColorUIResource getPrimary3() {
        return primary3;
    }

    protected ColorUIResource getSecondary1() {
        return secondary1;
    }

    protected ColorUIResource getSecondary2() {
        return secondary2;
    }

    protected ColorUIResource getSecondary3() {
        return secondary3;
    }

    public FontUIResource getControlTextFont() {
        return this.getFont(0);
    }

    public FontUIResource getSystemTextFont() {
        return this.getFont(1);
    }

    public FontUIResource getUserTextFont() {
        return this.getFont(2);
    }

    public FontUIResource getMenuTextFont() {
        return this.getFont(3);
    }

    public FontUIResource getWindowTitleFont() {
        return this.getFont(4);
    }

    public FontUIResource getSubTextFont() {
        return this.getFont(5);
    }

    private FontUIResource getFont(int n2) {
        return this.fontDelegate.getFont(n2);
    }

    void install() {
        this.fontDelegate = MetalLookAndFeel.isWindows() && MetalLookAndFeel.useSystemFonts() ? new WindowsFontDelegate() : new FontDelegate();
    }

    boolean isSystemTheme() {
        return this.getClass() == DefaultMetalTheme.class;
    }

    static {
        fontNames = new String[]{"Dialog", "Dialog", "Dialog", "Dialog", "Dialog", "Dialog"};
        fontStyles = new int[]{1, 0, 0, 1, 1, 0};
        fontSizes = new int[]{12, 12, 12, 12, 12, 10};
        defaultNames = new String[]{"swing.plaf.metal.controlFont", "swing.plaf.metal.systemFont", "swing.plaf.metal.userFont", "swing.plaf.metal.controlFont", "swing.plaf.metal.controlFont", "swing.plaf.metal.smallFont"};
        Object t2 = AccessController.doPrivileged(new GetPropertyAction("swing.boldMetal"));
        PLAIN_FONTS = t2 != null && "false".equals(t2);
        primary1 = new ColorUIResource(102, 102, 153);
        primary2 = new ColorUIResource(153, 153, 204);
        primary3 = new ColorUIResource(204, 204, 255);
        secondary1 = new ColorUIResource(102, 102, 102);
        secondary2 = new ColorUIResource(153, 153, 153);
        secondary3 = new ColorUIResource(204, 204, 204);
    }

    private static class FontDelegate {
        private static int[] defaultMapping = new int[]{0, 1, 2, 0, 0, 5};
        FontUIResource[] fonts = new FontUIResource[6];

        public FontUIResource getFont(int n2) {
            int n3 = defaultMapping[n2];
            if (this.fonts[n2] == null) {
                Font font = this.getPrivilegedFont(n3);
                if (font == null) {
                    font = new Font(DefaultMetalTheme.getDefaultFontName(n2), DefaultMetalTheme.getDefaultFontStyle(n2), DefaultMetalTheme.getDefaultFontSize(n2));
                }
                this.fonts[n2] = new FontUIResource(font);
            }
            return this.fonts[n2];
        }

        protected Font getPrivilegedFont(final int n2) {
            return (Font)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Font.getFont(DefaultMetalTheme.getDefaultPropertyName(n2));
                }
            });
        }
    }

    private static class WindowsFontDelegate
    extends FontDelegate {
        private MetalFontDesktopProperty[] props = new MetalFontDesktopProperty[6];
        private boolean[] checkedPriviledged = new boolean[6];

        public FontUIResource getFont(int n2) {
            if (this.fonts[n2] != null) {
                return this.fonts[n2];
            }
            if (!this.checkedPriviledged[n2]) {
                Font font = this.getPrivilegedFont(n2);
                this.checkedPriviledged[n2] = true;
                if (font != null) {
                    this.fonts[n2] = new FontUIResource(font);
                    return this.fonts[n2];
                }
            }
            if (this.props[n2] == null) {
                this.props[n2] = new MetalFontDesktopProperty(n2);
            }
            return (FontUIResource)this.props[n2].createValue(null);
        }
    }
}

