/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private static final AtomicLong sequencer = new AtomicLong(0L);
    private static final long NANO_ORIGIN = System.nanoTime();

    final long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    private void delayedExecute(Runnable runnable) {
        if (this.isShutdown()) {
            this.reject(runnable);
            return;
        }
        if (this.getPoolSize() < this.getCorePoolSize()) {
            this.prestartCoreThread();
        }
        super.getQueue().add(runnable);
    }

    private void cancelUnwantedTasks() {
        boolean bl2 = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean bl3 = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!bl2 && !bl3) {
            super.getQueue().clear();
        } else if (bl2 || bl3) {
            Object[] objectArray = super.getQueue().toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ScheduledFutureTask scheduledFutureTask;
                Object object = objectArray[i2];
                if (!(object instanceof ScheduledFutureTask) || !((scheduledFutureTask = (ScheduledFutureTask)object).isPeriodic() ? !bl3 : !bl2)) continue;
                scheduledFutureTask.cancel(false);
            }
            objectArray = null;
            this.purge();
        }
    }

    @Override
    public boolean remove(Runnable runnable) {
        if (!(runnable instanceof ScheduledFutureTask)) {
            return false;
        }
        return this.getQueue().remove(runnable);
    }

    public ScheduledThreadPoolExecutor(int n2) {
        super(n2, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue());
    }

    public ScheduledThreadPoolExecutor(int n2, ThreadFactory threadFactory) {
        super(n2, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), threadFactory);
    }

    public ScheduledThreadPoolExecutor(int n2, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n2, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)new DelayedWorkQueue(), rejectedExecutionHandler);
    }

    public ScheduledThreadPoolExecutor(int n2, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n2, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, rejectedExecutionHandler);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        long l3 = this.now() + timeUnit.toNanos(l2);
        ScheduledFutureTask<Object> scheduledFutureTask = new ScheduledFutureTask<Object>(runnable, null, l3);
        this.delayedExecute(scheduledFutureTask);
        return scheduledFutureTask;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l2, TimeUnit timeUnit) {
        if (callable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        long l3 = this.now() + timeUnit.toNanos(l2);
        ScheduledFutureTask<V> scheduledFutureTask = new ScheduledFutureTask<V>(callable, l3);
        this.delayedExecute(scheduledFutureTask);
        return scheduledFutureTask;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException();
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        long l4 = this.now() + timeUnit.toNanos(l2);
        ScheduledFutureTask<Object> scheduledFutureTask = new ScheduledFutureTask<Object>(runnable, null, l4, timeUnit.toNanos(l3));
        this.delayedExecute(scheduledFutureTask);
        return scheduledFutureTask;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        if (runnable == null || timeUnit == null) {
            throw new NullPointerException();
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException();
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        long l4 = this.now() + timeUnit.toNanos(l2);
        ScheduledFutureTask<Object> scheduledFutureTask = new ScheduledFutureTask<Object>(runnable, null, l4, timeUnit.toNanos(-l3));
        this.delayedExecute(scheduledFutureTask);
        return scheduledFutureTask;
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t2) {
        return this.schedule(Executors.callable(runnable, t2), 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.schedule(callable, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean bl2) {
        this.continueExistingPeriodicTasksAfterShutdown = bl2;
        if (!bl2 && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean bl2) {
        this.executeExistingDelayedTasksAfterShutdown = bl2;
        if (!bl2 && this.isShutdown()) {
            this.cancelUnwantedTasks();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    @Override
    public void shutdown() {
        this.cancelUnwantedTasks();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return super.getQueue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelayedWorkQueue
    extends AbstractCollection<Runnable>
    implements BlockingQueue<Runnable> {
        private final DelayQueue<ScheduledFutureTask> dq = new DelayQueue();

        private DelayedWorkQueue() {
        }

        @Override
        public Runnable poll() {
            return (Runnable)this.dq.poll();
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.dq.peek();
        }

        @Override
        public Runnable take() throws InterruptedException {
            return (Runnable)this.dq.take();
        }

        @Override
        public Runnable poll(long l2, TimeUnit timeUnit) throws InterruptedException {
            return (Runnable)this.dq.poll(l2, timeUnit);
        }

        @Override
        public boolean add(Runnable runnable) {
            return this.dq.add((ScheduledFutureTask)runnable);
        }

        @Override
        public boolean offer(Runnable runnable) {
            return this.dq.offer((ScheduledFutureTask)runnable);
        }

        @Override
        public void put(Runnable runnable) {
            this.dq.put((ScheduledFutureTask)runnable);
        }

        @Override
        public boolean offer(Runnable runnable, long l2, TimeUnit timeUnit) {
            return this.dq.offer((ScheduledFutureTask)runnable, l2, timeUnit);
        }

        @Override
        public Runnable remove() {
            return (Runnable)this.dq.remove();
        }

        @Override
        public Runnable element() {
            return (Runnable)this.dq.element();
        }

        @Override
        public void clear() {
            this.dq.clear();
        }

        @Override
        public int drainTo(Collection<? super Runnable> collection) {
            return this.dq.drainTo(collection);
        }

        @Override
        public int drainTo(Collection<? super Runnable> collection, int n2) {
            return this.dq.drainTo(collection, n2);
        }

        @Override
        public int remainingCapacity() {
            return this.dq.remainingCapacity();
        }

        @Override
        public boolean remove(Object object) {
            return this.dq.remove(object);
        }

        @Override
        public boolean contains(Object object) {
            return this.dq.contains(object);
        }

        @Override
        public int size() {
            return this.dq.size();
        }

        @Override
        public boolean isEmpty() {
            return this.dq.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.dq.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.dq.toArray(TArray);
        }

        @Override
        public Iterator<Runnable> iterator() {
            return new Iterator<Runnable>(){
                private Iterator<ScheduledFutureTask> it;
                {
                    this.it = DelayedWorkQueue.this.dq.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Runnable next() {
                    return this.it.next();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements ScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;

        ScheduledFutureTask(Runnable runnable, V v2, long l2) {
            super(runnable, v2);
            this.time = l2;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable runnable, V v2, long l2, long l3) {
            super(runnable, v2);
            this.time = l2;
            this.period = l3;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long l2) {
            super(callable);
            this.time = l2;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            long l2 = timeUnit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
            return l2;
        }

        @Override
        public int compareTo(Delayed delayed) {
            if (delayed == this) {
                return 0;
            }
            ScheduledFutureTask scheduledFutureTask = (ScheduledFutureTask)delayed;
            long l2 = this.time - scheduledFutureTask.time;
            if (l2 < 0L) {
                return -1;
            }
            if (l2 > 0L) {
                return 1;
            }
            if (this.sequenceNumber < scheduledFutureTask.sequenceNumber) {
                return -1;
            }
            return 1;
        }

        boolean isPeriodic() {
            return this.period != 0L;
        }

        private void runPeriodic() {
            boolean bl2 = ScheduledFutureTask.super.runAndReset();
            boolean bl3 = ScheduledThreadPoolExecutor.this.isShutdown();
            if (bl2 && (!bl3 || ScheduledThreadPoolExecutor.this.getContinueExistingPeriodicTasksAfterShutdownPolicy() && !ScheduledThreadPoolExecutor.this.isTerminating())) {
                long l2 = this.period;
                this.time = l2 > 0L ? (this.time += l2) : ScheduledThreadPoolExecutor.this.now() - l2;
                ScheduledThreadPoolExecutor.super.getQueue().add(this);
            } else if (bl3) {
                ScheduledThreadPoolExecutor.this.interruptIdleWorkers();
            }
        }

        @Override
        public void run() {
            if (this.isPeriodic()) {
                this.runPeriodic();
            } else {
                ScheduledFutureTask.super.run();
            }
        }
    }
}

