/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.util.Map;
import sun.misc.SharedSecrets;
import sun.reflect.MethodAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.ExceptionProxy;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.MethodScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Method
extends AccessibleObject
implements GenericDeclaration,
Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;
    private transient String signature;
    private transient MethodRepository genericInfo;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private byte[] annotationDefault;
    private volatile MethodAccessor methodAccessor;
    private Method root;
    private volatile Class securityCheckTargetClassCache;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private transient Map<Class, Annotation> declaredAnnotations;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, MethodScope.make(this));
    }

    private MethodRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = MethodRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Method(Class clazz, String string, Class[] classArray, Class clazz2, Class[] classArray2, int n2, int n3, String string2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.clazz = clazz;
        this.name = string;
        this.parameterTypes = classArray;
        this.returnType = clazz2;
        this.exceptionTypes = classArray2;
        this.modifiers = n2;
        this.slot = n3;
        this.signature = string2;
        this.annotations = byArray;
        this.parameterAnnotations = byArray2;
        this.annotationDefault = byArray3;
    }

    Method copy() {
        Method method = new Method(this.clazz, this.name, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.slot, this.signature, this.annotations, this.parameterAnnotations, this.annotationDefault);
        method.root = this;
        method.methodAccessor = this.methodAccessor;
        return method;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public TypeVariable<Method>[] getTypeParameters() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Type getGenericReturnType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getReturnType();
        }
        return this.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    public Type[] getGenericParameterTypes() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getParameterTypes();
        }
        return this.getParameterTypes();
    }

    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    public Type[] getGenericExceptionTypes() {
        Type[] typeArray;
        if (this.getGenericSignature() != null && (typeArray = this.getGenericInfo().getExceptionTypes()).length > 0) {
            return typeArray;
        }
        return this.getExceptionTypes();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Method) {
            Method method = (Method)object;
            if (this.getDeclaringClass() == method.getDeclaringClass() && this.getName() == method.getName()) {
                if (!this.returnType.equals(method.getReturnType())) {
                    return false;
                }
                Class[] classArray = this.parameterTypes;
                Class[] classArray2 = method.parameterTypes;
                if (classArray.length == classArray2.length) {
                    for (int i2 = 0; i2 < classArray.length; ++i2) {
                        if (classArray[i2] == classArray2[i2]) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.getModifiers();
            if (n2 != 0) {
                stringBuffer.append(Modifier.toString(n2) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getReturnType()) + " ");
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            stringBuffer.append(this.getName() + "(");
            Class[] classArray = this.parameterTypes;
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                stringBuffer.append(Field.getTypeName(classArray[i2]));
                if (i2 >= classArray.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                for (int i3 = 0; i3 < classArray2.length; ++i3) {
                    stringBuffer.append(classArray2[i3].getName());
                    if (i3 >= classArray2.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public String toGenericString() {
        try {
            TypeVariable<Method>[] typeVariableArray;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = this.getModifiers();
            if (n2 != 0) {
                stringBuilder.append(Modifier.toString(n2) + " ");
            }
            if ((typeVariableArray = this.getTypeParameters()).length > 0) {
                boolean bl2 = true;
                stringBuilder.append("<");
                for (TypeVariable<Method> typeVariable : typeVariableArray) {
                    if (!bl2) {
                        stringBuilder.append(",");
                    }
                    if (typeVariable instanceof Class) {
                        stringBuilder.append(((Class)((Object)typeVariable)).getName());
                    } else {
                        stringBuilder.append(typeVariable.toString());
                    }
                    bl2 = false;
                }
                stringBuilder.append("> ");
            }
            Type type = this.getGenericReturnType();
            stringBuilder.append((type instanceof Class ? Field.getTypeName((Class)type) : type.toString()) + " ");
            stringBuilder.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            stringBuilder.append(this.getName() + "(");
            Type[] typeArray = this.getGenericParameterTypes();
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                stringBuilder.append(typeArray[i2] instanceof Class ? Field.getTypeName((Class)typeArray[i2]) : typeArray[i2].toString());
                if (i2 >= typeArray.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
            Type[] typeArray2 = this.getGenericExceptionTypes();
            if (typeArray2.length > 0) {
                stringBuilder.append(" throws ");
                for (int i3 = 0; i3 < typeArray2.length; ++i3) {
                    stringBuilder.append(typeArray2[i3] instanceof Class ? ((Class)typeArray2[i3]).getName() : typeArray2[i3].toString());
                    if (i3 >= typeArray2.length - 1) continue;
                    stringBuilder.append(",");
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public Object invoke(Object object, Object ... objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class<? extends Object> clazz;
            Class clazz2 = Reflection.getCallerClass(1);
            Class<? extends Object> clazz3 = clazz = object == null || !Modifier.isProtected(this.modifiers) ? this.clazz : object.getClass();
            if (this.securityCheckCache != clazz2 || clazz != this.securityCheckTargetClassCache) {
                Reflection.ensureMemberAccess(clazz2, this.clazz, object, this.modifiers);
                this.securityCheckCache = clazz2;
                this.securityCheckTargetClassCache = clazz;
            }
        }
        if (this.methodAccessor == null) {
            this.acquireMethodAccessor();
        }
        return this.methodAccessor.invoke(object, objectArray);
    }

    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    private void acquireMethodAccessor() {
        MethodAccessor methodAccessor = null;
        if (this.root != null) {
            methodAccessor = this.root.getMethodAccessor();
        }
        if (methodAccessor != null) {
            this.methodAccessor = methodAccessor;
            return;
        }
        methodAccessor = reflectionFactory.newMethodAccessor(this);
        this.setMethodAccessor(methodAccessor);
    }

    MethodAccessor getMethodAccessor() {
        return this.methodAccessor;
    }

    void setMethodAccessor(MethodAccessor methodAccessor) {
        this.methodAccessor = methodAccessor;
        if (this.root != null) {
            this.root.setMethodAccessor(methodAccessor);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return (T)this.declaredAnnotations().get(clazz);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations().values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    private synchronized Map<Class, Annotation> declaredAnnotations() {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = AnnotationParser.parseAnnotations(this.annotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        }
        return this.declaredAnnotations;
    }

    public Object getDefaultValue() {
        if (this.annotationDefault == null) {
            return null;
        }
        Class clazz = AnnotationType.invocationHandlerReturnType(this.getReturnType());
        Object object = AnnotationParser.parseMemberValue(clazz, ByteBuffer.wrap(this.annotationDefault), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (object instanceof ExceptionProxy) {
            throw new AnnotationFormatError("Invalid default: " + this);
        }
        return object;
    }

    public Annotation[][] getParameterAnnotations() {
        int n2 = this.parameterTypes.length;
        if (this.parameterAnnotations == null) {
            return new Annotation[n2][0];
        }
        Annotation[][] annotationArray = AnnotationParser.parseParameterAnnotations(this.parameterAnnotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (annotationArray.length != n2) {
            throw new AnnotationFormatError("Parameter annotations don't match number of parameters");
        }
        return annotationArray;
    }
}

