/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.SampleModel;

public class PixelInterleavedSampleModel
extends ComponentSampleModel {
    public PixelInterleavedSampleModel(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        super(n2, n3, n4, n5, n6, nArray);
        int n7 = nArray[0];
        int n8 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            n7 = Math.min(n7, nArray[i2]);
            n8 = Math.max(n8, nArray[i2]);
        }
        if ((n8 -= n7) > n6) {
            throw new IllegalArgumentException("Offsets between bands must be less than the scanline  stride");
        }
        if (n5 * n3 > n6) {
            throw new IllegalArgumentException("Pixel stride times width must be less than or equal to the scanline stride");
        }
        if (n5 < n8) {
            throw new IllegalArgumentException("Pixel stride must be greater than or equal to the offsets between bands");
        }
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        int[] nArray;
        int n4 = this.bandOffsets[0];
        int n5 = this.bandOffsets.length;
        for (int i2 = 1; i2 < n5; ++i2) {
            if (this.bandOffsets[i2] >= n4) continue;
            n4 = this.bandOffsets[i2];
        }
        if (n4 > 0) {
            nArray = new int[n5];
            for (int i3 = 0; i3 < n5; ++i3) {
                nArray[i3] = this.bandOffsets[i3] - n4;
            }
        } else {
            nArray = this.bandOffsets;
        }
        return new PixelInterleavedSampleModel(this.dataType, n2, n3, this.pixelStride, this.pixelStride * n2, nArray);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = this.bandOffsets[nArray[i2]];
        }
        return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2);
    }

    public int hashCode() {
        return super.hashCode() ^ 1;
    }
}

