/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import com.sun.org.apache.xml.internal.res.XMLMessages;
import com.sun.org.apache.xml.internal.utils.ObjectFactory;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import java.io.Serializable;
import java.util.Vector;

public class ObjectPool
implements Serializable {
    private final Class objectType;
    private final Vector freeStack;

    public ObjectPool(Class clazz) {
        this.objectType = clazz;
        this.freeStack = new Vector();
    }

    public ObjectPool(String string) {
        try {
            this.objectType = ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrappedRuntimeException(classNotFoundException);
        }
        this.freeStack = new Vector();
    }

    public ObjectPool(Class clazz, int n2) {
        this.objectType = clazz;
        this.freeStack = new Vector(n2);
    }

    public ObjectPool() {
        this.objectType = null;
        this.freeStack = new Vector();
    }

    public synchronized Object getInstanceIfFree() {
        if (!this.freeStack.isEmpty()) {
            Object e2 = this.freeStack.lastElement();
            this.freeStack.setSize(this.freeStack.size() - 1);
            return e2;
        }
        return null;
    }

    public synchronized Object getInstance() {
        if (this.freeStack.isEmpty()) {
            try {
                return this.objectType.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_EXCEPTION_CREATING_POOL", null));
        }
        Object e2 = this.freeStack.lastElement();
        this.freeStack.setSize(this.freeStack.size() - 1);
        return e2;
    }

    public synchronized void freeInstance(Object object) {
        this.freeStack.addElement(object);
    }
}

