/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.CoreDocumentImpl;
import com.sun.org.apache.xerces.internal.dom.DOMInputImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.DOMOutputImpl;
import com.sun.org.apache.xerces.internal.dom.DocumentTypeImpl;
import com.sun.org.apache.xerces.internal.dom.ObjectFactory;
import com.sun.org.apache.xerces.internal.impl.RevalidationHandler;
import com.sun.org.apache.xerces.internal.parsers.DOMParserImpl;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xml.internal.serialize.DOMSerializerImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class CoreDOMImplementationImpl
implements DOMImplementation,
DOMImplementationLS {
    private static final int SIZE = 2;
    private RevalidationHandler[] validators = new RevalidationHandler[2];
    private int freeValidatorIndex = -1;
    private int currentSize = 2;
    private int docAndDoctypeCounter = 0;
    static CoreDOMImplementationImpl singleton = new CoreDOMImplementationImpl();

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    public boolean hasFeature(String string, String string2) {
        boolean bl2;
        boolean bl3 = bl2 = string2 == null || string2.length() == 0;
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        if ((string.equalsIgnoreCase("XPath") || string.equalsIgnoreCase("+XPath")) && (bl2 || string2.equals("3.0"))) {
            try {
                Class clazz = ObjectFactory.findProviderClass("com.sun.org.apache.xpath.internal.domapi.XPathEvaluatorImpl", ObjectFactory.findClassLoader(), true);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return string.equalsIgnoreCase("Core") && (bl2 || string2.equals("1.0") || string2.equals("2.0") || string2.equals("3.0")) || string.equalsIgnoreCase("XML") && (bl2 || string2.equals("1.0") || string2.equals("2.0") || string2.equals("3.0")) || string.equalsIgnoreCase("LS") && (bl2 || string2.equals("3.0"));
    }

    public DocumentType createDocumentType(String string, String string2, String string3) {
        this.checkQName(string);
        return new DocumentTypeImpl(null, string, string2, string3);
    }

    final void checkQName(String string) {
        int n2;
        int n3 = string.indexOf(58);
        int n4 = string.lastIndexOf(58);
        int n5 = string.length();
        if (n3 == 0 || n3 == n5 - 1 || n4 != n3) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
            throw new DOMException(14, string2);
        }
        int n6 = 0;
        if (n3 > 0) {
            if (!XMLChar.isNCNameStart(string.charAt(n6))) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, string3);
            }
            for (n2 = 1; n2 < n3; ++n2) {
                if (XMLChar.isNCName(string.charAt(n2))) continue;
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, string4);
            }
            n6 = n3 + 1;
        }
        if (!XMLChar.isNCNameStart(string.charAt(n6))) {
            String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string5);
        }
        for (n2 = n6 + 1; n2 < n5; ++n2) {
            if (XMLChar.isNCName(string.charAt(n2))) continue;
            String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string6);
        }
    }

    public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        if (documentType != null && documentType.getOwnerDocument() != null) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, string3);
        }
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl(documentType);
        Element element = coreDocumentImpl.createElementNS(string, string2);
        coreDocumentImpl.appendChild(element);
        return coreDocumentImpl;
    }

    public Object getFeature(String string, String string2) {
        if (singleton.hasFeature(string, string2)) {
            return singleton;
        }
        return null;
    }

    public LSParser createLSParser(short s2, String string) throws DOMException {
        if (s2 != 1 || string != null && !"http://www.w3.org/2001/XMLSchema".equals(string) && !"http://www.w3.org/TR/REC-xml".equals(string)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, string2);
        }
        if (string != null && string.equals("http://www.w3.org/TR/REC-xml")) {
            return new DOMParserImpl("com.sun.org.apache.xerces.internal.parsers.XML11Configuration", string);
        }
        return new DOMParserImpl("com.sun.org.apache.xerces.internal.parsers.XML11Configuration", string);
    }

    public LSSerializer createLSSerializer() {
        return new DOMSerializerImpl();
    }

    public LSInput createLSInput() {
        return new DOMInputImpl();
    }

    synchronized Object getDTDValidator() {
        return ObjectFactory.newInstance("com.sun.org.apache.xerces.internal.impl.dtd.XMLDTDValidator", ObjectFactory.findClassLoader(), true);
    }

    synchronized RevalidationHandler getValidator(String string) {
        if (this.freeValidatorIndex < 0) {
            return (RevalidationHandler)ObjectFactory.newInstance("com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaValidator", ObjectFactory.findClassLoader(), true);
        }
        RevalidationHandler revalidationHandler = this.validators[this.freeValidatorIndex];
        this.validators[this.freeValidatorIndex--] = null;
        return revalidationHandler;
    }

    synchronized void releaseValidator(String string, RevalidationHandler revalidationHandler) {
        ++this.freeValidatorIndex;
        if (this.validators.length == this.freeValidatorIndex) {
            this.currentSize += 2;
            RevalidationHandler[] revalidationHandlerArray = new RevalidationHandler[this.currentSize];
            System.arraycopy(this.validators, 0, revalidationHandlerArray, 0, this.validators.length);
            this.validators = revalidationHandlerArray;
        }
        this.validators[this.freeValidatorIndex] = revalidationHandler;
    }

    protected synchronized int assignDocumentNumber() {
        return ++this.docAndDoctypeCounter;
    }

    protected synchronized int assignDocTypeNumber() {
        return ++this.docAndDoctypeCounter;
    }

    public LSOutput createLSOutput() {
        return new DOMOutputImpl();
    }
}

