/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier;

import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.verifier.VerificationResult;
import com.sun.org.apache.bcel.internal.verifier.Verifier;
import com.sun.org.apache.bcel.internal.verifier.VerifierFactory;
import com.sun.org.apache.bcel.internal.verifier.VerifierFactoryObserver;

public class TransitiveHull
implements VerifierFactoryObserver {
    private int indent = 0;

    private TransitiveHull() {
    }

    public void update(String string) {
        System.gc();
        for (int i2 = 0; i2 < this.indent; ++i2) {
            System.out.print(" ");
        }
        System.out.println(string);
        ++this.indent;
        Verifier verifier = VerifierFactory.getVerifier(string);
        VerificationResult verificationResult = verifier.doPass1();
        if (verificationResult != VerificationResult.VR_OK) {
            System.out.println("Pass 1:\n" + verificationResult);
        }
        if ((verificationResult = verifier.doPass2()) != VerificationResult.VR_OK) {
            System.out.println("Pass 2:\n" + verificationResult);
        }
        if (verificationResult == VerificationResult.VR_OK) {
            JavaClass javaClass = Repository.lookupClass(verifier.getClassName());
            for (int i3 = 0; i3 < javaClass.getMethods().length; ++i3) {
                verificationResult = verifier.doPass3a(i3);
                if (verificationResult != VerificationResult.VR_OK) {
                    System.out.println(verifier.getClassName() + ", Pass 3a, method " + i3 + " ['" + javaClass.getMethods()[i3] + "']:\n" + verificationResult);
                }
                if ((verificationResult = verifier.doPass3b(i3)) == VerificationResult.VR_OK) continue;
                System.out.println(verifier.getClassName() + ", Pass 3b, method " + i3 + " ['" + javaClass.getMethods()[i3] + "']:\n" + verificationResult);
            }
        }
        --this.indent;
    }

    public static void _main(String[] stringArray) {
        int n2;
        if (stringArray.length != 1) {
            System.out.println("Need exactly one argument: The root class to verify.");
            System.exit(1);
        }
        if ((n2 = stringArray[0].lastIndexOf(".class")) != -1) {
            stringArray[0] = stringArray[0].substring(0, n2);
        }
        stringArray[0] = stringArray[0].replace('/', '.');
        TransitiveHull transitiveHull = new TransitiveHull();
        VerifierFactory.attach(transitiveHull);
        VerifierFactory.getVerifier(stringArray[0]);
        VerifierFactory.detach(transitiveHull);
    }
}

