/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.CircularBuffer;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Toolkit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class MixerSourceLine
extends AbstractDataLine
implements SourceDataLine {
    private CircularBuffer circularBuffer = null;
    private byte[] dataBuffer = null;
    private long id;
    private long finalPosition = 0L;
    private boolean implStarted = false;
    MixerSourceLineGainControl gainControl = new MixerSourceLineGainControl();

    MixerSourceLine(DataLine.Info info, HeadspaceMixer headspaceMixer, AudioFormat audioFormat, int n2) throws LineUnavailableException {
        super(info, headspaceMixer, new Control[4], audioFormat, n2);
        this.controls[0] = this.gainControl;
        this.controls[1] = new MixerSourceLineMuteControl();
        this.controls[2] = new MixerSourceLinePanControl();
        this.controls[3] = new MixerSourceLineSampleRateControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            if (this.circularBuffer != null) {
                this.circularBuffer.markEnd();
            }
            return 0;
        }
        int n4 = n3;
        if (n3 % this.getFormat().getFrameSize() != 0) {
            throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + n3 + " bytes )");
        }
        int n5 = 0;
        int n6 = 0;
        while (this.isOpen() && this.isStartedRunning() && n5 < n4) {
            n6 = this.circularBuffer.write(byArray, n2, n4 - n5);
            n2 += n6;
            if ((n5 += n6) >= n4) continue;
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return n5;
    }

    public int available() {
        if (this.circularBuffer != null) {
            return this.circularBuffer.bytesAvailableToWrite();
        }
        return 0;
    }

    void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
        if (audioFormat.getSampleRate() == -1.0f) {
            float f2;
            float f3 = 44100.0f;
            if (this.mixer instanceof HeadspaceMixer) {
                f3 = ((HeadspaceMixer)this.mixer).getDefaultFormat().getSampleRate();
            }
            if ((f2 = audioFormat.getFrameRate()) == -1.0f || audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) || audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW) || audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
                f2 = f3;
            }
            audioFormat = new AudioFormat(audioFormat.getEncoding(), f3, audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), f2, audioFormat.isBigEndian());
        }
        Toolkit.isFullySpecifiedAudioFormat(audioFormat);
        if (n2 == -1 || n2 < audioFormat.getFrameSize()) {
            n2 = MixerSourceLine.calculateBufferSizeInBytes(audioFormat);
        }
        HeadspaceMixer cfr_ignored_0 = (HeadspaceMixer)this.mixer;
        int n3 = 0x100000 * audioFormat.getFrameSize() * 2;
        while (n2 > n3) {
            n2 /= 2;
        }
        n2 -= n2 % audioFormat.getFrameSize();
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.getFormat().getSampleSizeInBits() == 8 && AudioFormat.Encoding.PCM_SIGNED.equals(this.getFormat().getEncoding())) {
            bl2 = true;
        }
        if (this.getFormat().getSampleSizeInBits() > 8 && this.getFormat().isBigEndian() != Platform.isBigEndian()) {
            bl3 = true;
        }
        if (this.circularBuffer == null || this.circularBuffer.getByteLength() != n2) {
            this.circularBuffer = new CircularBuffer(n2, bl2, bl3);
        }
        if (this.dataBuffer == null || this.dataBuffer.length != n2) {
            this.dataBuffer = new byte[n2];
        }
        this.id = this.nOpen(this.getFormat().getSampleSizeInBits(), this.getFormat().getChannels(), this.getFormat().getSampleRate(), n2);
        this.format = audioFormat;
        this.bufferSize = n2;
        if (this.id == 0L) {
            throw new LineUnavailableException("Failed to allocate native stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implClose() {
        this.nClose(this.id);
        while (this.id != 0L) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.implStarted = false;
    }

    void implStart() {
        if (!this.implStarted) {
            this.nStart(this.id);
            this.implStarted = true;
        } else {
            this.nResume(this.id);
        }
    }

    void implStop() {
        this.nPause(this.id);
    }

    public float getLevel() {
        return this.id != 0L ? this.nGetLevel(this.id) : -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        if (this.circularBuffer != null) {
            this.circularBuffer.drain();
        }
        if (!this.isActive()) {
            this.nDrain(this.id);
        }
        int n2 = 40;
        while (this.isActive() && n2-- > 0) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void flush() {
        if (this.circularBuffer != null) {
            this.circularBuffer.flush();
        }
        this.nFlush(this.id);
    }

    public long getLongFramePosition() {
        return this.id != 0L ? this.nGetPosition(this.id) : this.finalPosition;
    }

    long getId() {
        return this.id;
    }

    private static int calculateBufferSizeInBytes(AudioFormat audioFormat) {
        int n2;
        int n3 = (int)audioFormat.getFrameRate() / 2;
        for (n2 = 1; n3 > n2; n2 *= 2) {
        }
        return n2 * audioFormat.getFrameSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int callbackStreamGetData(byte[] byArray, int n2) {
        int n3 = this.getFormat().getFrameSize();
        int n4 = n2 * n3;
        int n5 = this.circularBuffer.read(byArray, 0, n4 = Math.min(n4, byArray.length));
        n5 = n5 > 0 ? n5 / n3 : n5;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamDestroy() {
        this.finalPosition = this.getLongFramePosition();
        this.id = 0L;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    private void callbackStreamStart() {
        this.setActive(true);
        this.setStarted(true);
    }

    private void callbackStreamStop() {
        this.setActive(false);
        this.setStarted(false);
    }

    private void callbackStreamEOM() {
        this.setActive(false);
        this.setEOM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamActive() {
        Object object = this;
        synchronized (object) {
            this.setActive(true);
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamInactive() {
        Object object = this;
        synchronized (object) {
            this.setActive(false);
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    private native void nDrain(long var1);

    private native void nFlush(long var1);

    private native long nGetPosition(long var1);

    private native float nGetLevel(long var1);

    private native long nOpen(int var1, int var2, float var3, int var4) throws LineUnavailableException;

    private native void nStart(long var1);

    private native void nResume(long var1);

    private native void nPause(long var1);

    private native void nClose(long var1);

    protected native float nSetLinearGain(long var1, float var3);

    protected native float nSetPan(long var1, float var3);

    protected native int nSetSampleRate(long var1, int var3);

    private class MixerSourceLineApplyReverbControl
    extends BooleanControl {
        private MixerSourceLineApplyReverbControl() {
            super(BooleanControl.Type.APPLY_REVERB, false, "Yes", "No");
        }

        public void setValue(boolean bl2) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            if (bl2 == this.getValue() || MixerSourceLine.this.id != 0L) {
                // empty if block
            }
            super.setValue(bl2);
        }
    }

    private class MixerSourceLineGainControl
    extends FloatControl {
        private float linearGain;

        private MixerSourceLineGainControl() {
            super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(5.0f), Math.abs(Toolkit.linearToDB(5.0f) - Toolkit.linearToDB(0.0f)) / 128.0f, -1, 0.0f, "dB", "Minimum", "", "Maximum");
            this.linearGain = 1.0f;
        }

        public void setValue(float f2) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            float f3 = Toolkit.dBToLinear(f2 = Math.max(f2, this.getMinimum()));
            if (f3 != this.linearGain && MixerSourceLine.this.id != 0L) {
                f3 = MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, f3);
            }
            this.linearGain = f3;
            super.setValue(Toolkit.linearToDB(this.linearGain));
        }
    }

    private class MixerSourceLineMuteControl
    extends BooleanControl {
        private MixerSourceLineMuteControl() {
            super(BooleanControl.Type.MUTE, false, "True", "False");
        }

        public void setValue(boolean bl2) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            if (bl2 && !this.getValue() && MixerSourceLine.this.id != 0L) {
                MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, 0.0f);
            } else if (!bl2 && this.getValue() && MixerSourceLine.this.id != 0L) {
                float f2 = Toolkit.dBToLinear(MixerSourceLine.this.gainControl.getValue());
                MixerSourceLine.this.nSetLinearGain(MixerSourceLine.this.id, f2);
            }
            super.setValue(bl2);
        }
    }

    private class MixerSourceLinePanControl
    extends FloatControl {
        private MixerSourceLinePanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.015625f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        public void setValue(float f2) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            if ((f2 = Math.max(f2, this.getMinimum())) != this.getValue() && MixerSourceLine.this.id != 0L) {
                f2 = -1.0f * MixerSourceLine.this.nSetPan(MixerSourceLine.this.id, -1.0f * f2);
            }
            super.setValue(f2);
        }
    }

    private class MixerSourceLineSampleRateControl
    extends FloatControl {
        private MixerSourceLineSampleRateControl() {
            super(FloatControl.Type.SAMPLE_RATE, 0.0f, 48000.0f, 1.0f, -1, MixerSourceLine.this.getFormat().getFrameRate(), "FPS", "Minimum", "", "Maximum");
        }

        public void setValue(float f2) {
            if (!MixerSourceLine.this.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            if ((f2 = Math.max(f2, this.getMinimum())) != this.getValue() && MixerSourceLine.this.id != 0L) {
                f2 = MixerSourceLine.this.nSetSampleRate(MixerSourceLine.this.id, (int)f2);
            }
            super.setValue(f2);
        }

        private void update() {
            super.setValue(MixerSourceLine.this.getFormat().getFrameRate());
        }
    }
}

