/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.NameNode;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import java.lang.ref.SoftReference;
import java.util.Date;

class ZoneNode
extends NameNode {
    private SoftReference contentsRef = null;
    private long serialNumber = -1L;
    private Date expiration = null;

    ZoneNode(String string) {
        super(string);
    }

    protected NameNode newNameNode(String string) {
        return new ZoneNode(string);
    }

    synchronized void depopulate() {
        this.contentsRef = null;
        this.serialNumber = -1L;
    }

    synchronized boolean isPopulated() {
        return this.getContents() != null;
    }

    synchronized NameNode getContents() {
        return this.contentsRef != null ? (NameNode)this.contentsRef.get() : null;
    }

    synchronized boolean isExpired() {
        return this.expiration != null && this.expiration.before(new Date());
    }

    ZoneNode getDeepestPopulated(DnsName dnsName) {
        ZoneNode zoneNode = this;
        ZoneNode zoneNode2 = this.isPopulated() ? this : null;
        for (int i2 = 1; i2 < dnsName.size() && (zoneNode = (ZoneNode)zoneNode.get(dnsName.getKey(i2))) != null; ++i2) {
            if (!zoneNode.isPopulated()) continue;
            zoneNode2 = zoneNode;
        }
        return zoneNode2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NameNode populate(DnsName dnsName, ResourceRecords resourceRecords) {
        Object object;
        NameNode nameNode = new NameNode(null);
        for (int i2 = 0; i2 < resourceRecords.answer.size(); ++i2) {
            object = (ResourceRecord)resourceRecords.answer.elementAt(i2);
            DnsName dnsName2 = ((ResourceRecord)object).getName();
            if (dnsName2.size() <= dnsName.size() || !dnsName2.startsWith(dnsName)) continue;
            NameNode nameNode2 = nameNode.add(dnsName2, dnsName.size());
            if (((ResourceRecord)object).getType() != 2) continue;
            nameNode2.setZoneCut(true);
        }
        ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.answer.firstElement();
        object = this;
        synchronized (object) {
            this.contentsRef = new SoftReference<NameNode>(nameNode);
            this.serialNumber = ZoneNode.getSerialNumber(resourceRecord);
            this.setExpiration(ZoneNode.getMinimumTtl(resourceRecord));
            return nameNode;
        }
    }

    private void setExpiration(long l2) {
        this.expiration = new Date(System.currentTimeMillis() + 1000L * l2);
    }

    private static long getMinimumTtl(ResourceRecord resourceRecord) {
        String string = (String)resourceRecord.getRdata();
        int n2 = string.lastIndexOf(32) + 1;
        return Long.parseLong(string.substring(n2));
    }

    int compareSerialNumberTo(ResourceRecord resourceRecord) {
        return ResourceRecord.compareSerialNumbers(this.serialNumber, ZoneNode.getSerialNumber(resourceRecord));
    }

    private static long getSerialNumber(ResourceRecord resourceRecord) {
        String string = (String)resourceRecord.getRdata();
        int n2 = string.length();
        int n3 = -1;
        for (int i2 = 0; i2 < 5; ++i2) {
            n3 = n2;
            n2 = string.lastIndexOf(32, n3 - 1);
        }
        return Long.parseLong(string.substring(n2 + 1, n3));
    }
}

